/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ccaas;

import com.ibm.commoncomponents.ccaas.core.http.request.HttpClient;
import com.ibm.commoncomponents.ccaas.core.json.CCResultEntrySerializable;
import com.ibm.commoncomponents.ccaas.core.repo.ICCResultEntry;
import com.ibm.debug.pdt.codecoverage.core.results.CCResultException;
import com.ibm.debug.pdt.codecoverage.core.results.CCResultsFactory;
import com.ibm.debug.pdt.codecoverage.core.results.ICCResult;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ResultsViewPlugin;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ccaas.ICCaasResultLocation;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.AbstractResultAdapter;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.CCResultEvent;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.CCResultEventManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import java.util.HashMap;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public class CCaasResultAdapter
extends AbstractResultAdapter {
    private ICCResultEntry fEntry;
    private Date fDate;
    private String fLocationPath;

    public CCaasResultAdapter(ICCResultEntry entry, String locationPath) {
        super(CCaasResultAdapter.generateFileLocation(locationPath, entry));
        this.fEntry = entry;
        this.fLocationPath = locationPath;
        this.setResultError(entry.getAdditionalInformation());
    }

    private static String generateFileLocation(String locationPath, ICCResultEntry entry) {
        Path p = Paths.get(entry.getName(), new String[0]);
        if (p.getNameCount() == 1) {
            return locationPath + File.separator + entry.getName() + ".cczip";
        }
        return null;
    }

    @Override
    public boolean isAnalyzed() {
        return true;
    }

    @Override
    public String getName() {
        return this.fEntry.getName();
    }

    @Override
    public String rename(String newResultName) {
        try {
            HashMap<String, String> paramsMap = new HashMap<String, String>();
            paramsMap.put("name", newResultName);
            CCResultEntrySerializable modifiedEntry = this.getHttpClient().modifyResult(this.getId(), paramsMap);
            this.modifyEntry((ICCResultEntry)modifiedEntry);
        }
        catch (IOException e) {
            ResultsViewPlugin.log(e);
            return e.getMessage();
        }
        CCResultEventManager.getDefault().fireResultLocationEvent(new CCResultEvent(this.getResultLocation(), 3));
        return null;
    }

    private void modifyEntry(ICCResultEntry modifiedEntry) {
        CCaasResultAdapter newAdapter = new CCaasResultAdapter(modifiedEntry, this.fLocationPath);
        newAdapter.setResultLocation(this.getResultLocation());
        this.getResultLocation().replaceResult(this, newAdapter);
    }

    @Override
    public Image getImage() {
        return ResultsViewPlugin.getDefault().getImageRegistry().get("icons/obj16/cc_zip_obj.png");
    }

    @Override
    public boolean copyTo(File directory, boolean unpack) {
        return false;
    }

    @Override
    public String getTestcaseID() {
        return String.valueOf(this.fEntry.getTestIds());
    }

    @Override
    public long getElapsedTime() {
        return this.fEntry.getElapsedTime();
    }

    @Override
    public String getTags() {
        return String.valueOf(this.fEntry.getTags());
    }

    @Override
    public String getBaselineFileName() {
        return null;
    }

    @Override
    public void open(String mode, Shell activeShell) {
    }

    @Override
    public int getPercentCoverage() {
        return this.fEntry.getCoverage();
    }

    @Override
    public String getResultError() {
        return this.fEntry.getAdditionalInformation();
    }

    @Override
    public Date getAnalyzedDate() {
        if (this.fDate == null) {
            this.fDate = new Date(this.fEntry.getAnalyzedDate());
        }
        return new Date(this.fDate.getTime());
    }

    @Override
    protected void doAnalysis(boolean useResultAPI) {
    }

    @Override
    public boolean exists() {
        return this.getResultPath() != null && new File(this.getResultPath()).exists();
    }

    public String getId() {
        return this.fEntry.getId();
    }

    @Override
    public ICCResult getResult() {
        if (!this.isResultAvailable() && this.downloadResult() && this.getResultPath() != null) {
            try {
                ICCResult result = CCResultsFactory.getInstance().createResult(this.getResultPath());
                result.setName(this.getName());
                this.setResult(result);
            }
            catch (CCResultException e) {
                ResultsViewPlugin.log(e);
            }
        }
        return super.getResult();
    }

    @Override
    public String getLevel() {
        return super.getLevelLabel(this.fEntry.getLevel(), this.fEntry.getEngineKey());
    }

    private boolean downloadResult() {
        if (this.exists()) {
            return true;
        }
        if (this.getResultPath() != null) {
            try {
                File downloadedFile = this.getHttpClient().downloadResult(this.getId(), this.getResultPath());
                return downloadedFile.exists();
            }
            catch (IOException e) {
                ResultsViewPlugin.log(e);
                return false;
            }
        }
        return false;
    }

    private HttpClient getHttpClient() {
        return ((ICCaasResultLocation)this.getResultLocation()).getHttpClient();
    }

    @Override
    public void cleanup(boolean deleteDataFiles) {
        super.cleanup(true);
    }
}

