/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.ui.resultsview;

import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.DefaultContentProvider;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ResultsViewPlugin;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IRemoteResultContentProvider;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IRemoteResultLocationDialogContentProvider;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultContentProvider;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultContentProviderWithStatusConfig;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultSource;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IUtilContentProvider;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IUtilitiesContentProvider;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class ResultsViewContentProviders {
    private static List<IResultContentProvider> fContentProviders;
    private static Object fSourceProvidersLock;
    private static List<IResultSource> fSourceProviders;
    private static List<IRemoteResultLocationDialogContentProvider> fDialogProviders;
    private static List<IUtilitiesContentProvider> fProviders;
    private static boolean fIsDefaultOpenInitialized;
    private static String fDefaultOpenId;
    private static String fDefaultMode;
    private static boolean fIsStatusVisible;

    static {
        fSourceProvidersLock = new Object();
        fIsDefaultOpenInitialized = false;
        fDefaultOpenId = null;
        fDefaultMode = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IResultSource[] getSourceProviders() {
        Object object = fSourceProvidersLock;
        synchronized (object) {
            if (fSourceProviders == null) {
                fSourceProviders = new ArrayList<IResultSource>();
                IResultContentProvider[] iResultContentProviderArray = ResultsViewContentProviders.getContentProviders();
                int n = iResultContentProviderArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResultContentProvider provider = iResultContentProviderArray[n2];
                    if (provider instanceof IResultSource) {
                        fSourceProviders.add((IResultSource)((Object)provider));
                    }
                    ++n2;
                }
            }
            return fSourceProviders.toArray(new IResultSource[fSourceProviders.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IResultContentProvider[] getContentProviders() {
        Object object = fSourceProvidersLock;
        synchronized (object) {
            if (fContentProviders == null) {
                ResultsViewContentProviders.intializeOpenDefaults();
                fContentProviders = new ArrayList<IResultContentProvider>();
                fContentProviders.add(new DefaultContentProvider());
                IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.debug.pdt.codecoverage.ui.view.contentProvider");
                if (ep != null) {
                    IConfigurationElement[] elements;
                    IConfigurationElement[] iConfigurationElementArray = elements = ep.getConfigurationElements();
                    int n = elements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IConfigurationElement config = iConfigurationElementArray[n2];
                        try {
                            IResultContentProvider provider = (IResultContentProvider)config.createExecutableExtension("class");
                            if (provider.getPluginId() == null || provider.getPluginId().isEmpty()) {
                                ResultsViewPlugin.log(4, "Plugin id must be provided by class:" + provider.getClass().getName());
                            } else {
                                provider.setDefaultOpenMode(fDefaultOpenId, fDefaultMode);
                                fContentProviders.add(provider);
                            }
                            fIsStatusVisible = fIsStatusVisible || provider instanceof IResultContentProviderWithStatusConfig && ((IResultContentProviderWithStatusConfig)provider).isStatusColumnSupported();
                        }
                        catch (CoreException e) {
                            ResultsViewPlugin.log(e);
                        }
                        catch (ClassCastException e) {
                            ResultsViewPlugin.log(e);
                        }
                        ++n2;
                    }
                }
            }
            return fContentProviders.toArray(new IResultContentProvider[fContentProviders.size()]);
        }
    }

    private static void intializeOpenDefaults() {
        if (!fIsDefaultOpenInitialized) {
            IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.debug.pdt.codecoverage.ui.view.defaultOpen");
            if (ep != null) {
                IConfigurationElement[] elements;
                IConfigurationElement[] iConfigurationElementArray = elements = ep.getConfigurationElements();
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement config = iConfigurationElementArray[n2];
                    fDefaultOpenId = config.getAttribute("openCommandId");
                    fDefaultMode = config.getAttribute("mode");
                    ++n2;
                }
            }
            fIsDefaultOpenInitialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRemoteResultLocationDialogContentProvider[] getRemoteDialogContentProviders() {
        Object object = fSourceProvidersLock;
        synchronized (object) {
            if (fDialogProviders == null) {
                fDialogProviders = new ArrayList<IRemoteResultLocationDialogContentProvider>();
                IResultContentProvider[] iResultContentProviderArray = ResultsViewContentProviders.getContentProviders();
                int n = iResultContentProviderArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IRemoteResultLocationDialogContentProvider dialogContentProvider;
                    IResultContentProvider provider = iResultContentProviderArray[n2];
                    if (provider instanceof IRemoteResultContentProvider && (dialogContentProvider = ((IRemoteResultContentProvider)provider).getDialogContentProvider()) != null) {
                        fDialogProviders.add(dialogContentProvider);
                    }
                    ++n2;
                }
            }
            return fDialogProviders.toArray(new IRemoteResultLocationDialogContentProvider[fDialogProviders.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IUtilitiesContentProvider[] getUtilContentProviders() {
        Object object = fSourceProvidersLock;
        synchronized (object) {
            if (fProviders == null) {
                fProviders = new ArrayList<IUtilitiesContentProvider>();
                IResultContentProvider[] iResultContentProviderArray = ResultsViewContentProviders.getContentProviders();
                int n = iResultContentProviderArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IUtilitiesContentProvider utilProvider;
                    IResultContentProvider provider = iResultContentProviderArray[n2];
                    if (provider instanceof IUtilContentProvider && (utilProvider = ((IUtilContentProvider)provider).getUtilContentProvider()) != null) {
                        fProviders.add(utilProvider);
                    }
                    ++n2;
                }
            }
            return fProviders.toArray(new IUtilitiesContentProvider[fProviders.size()]);
        }
    }

    public static boolean isStatusVisible() {
        ResultsViewContentProviders.getContentProviders();
        return fIsStatusVisible;
    }
}

