/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.ui.resultsview;

import com.ibm.debug.pdt.codecoverage.core.results.ICCPercentItem;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.Labels;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ResultsViewPlugin;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.preferences.ThresholdPreferencePage;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IRemoteResultLocation;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultAdapter;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultDateItem;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultLocation;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IStatusProvider;
import java.text.DateFormat;
import java.util.Date;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

class ResultsLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private static final Image IMAGE_PASSED = ResultsLabelProvider.getImage("icons/obj16/state_passed.png");
    private static final Image IMAGE_FAILED = ResultsLabelProvider.getImage("icons/obj16/state_failed.png");
    private static final Image IMAGE_WARNING = ResultsLabelProvider.getImage("icons/obj16/state_warning.png");
    private static final Image IMAGE_ERROR = ResultsLabelProvider.getImage("icons/obj16/error_obj.png");
    private static final Image IMAGE_UNKNOWN = ResultsLabelProvider.getImage("icons/obj16/state_unknown.png");

    ResultsLabelProvider() {
    }

    public Image getColumnImage(Object object, int columnIndex) {
        if (object instanceof IResultAdapter) {
            if (columnIndex == 1) {
                IResultAdapter adapter = (IResultAdapter)object;
                return this.getStatusIcon(ResultsLabelProvider.getStatus(adapter));
            }
        } else {
            IResultLocation location;
            if (object instanceof IStatusProvider && columnIndex == 1) {
                return this.getStatusIcon(((IStatusProvider)object).getStatus());
            }
            if (object instanceof IResultLocation && columnIndex == 1 && (location = (IResultLocation)object).getErrorMessage() != null) {
                return ResultsLabelProvider.getImage("icons/obj16/error_obj.png");
            }
        }
        return null;
    }

    static int getStatus(IResultAdapter adapter) {
        int coverage = adapter.getPercentCoverage();
        if (!adapter.isAnalyzed() && coverage <= 0) {
            return 0;
        }
        if (coverage >= ThresholdPreferencePage.getThreshold() && coverage < ThresholdPreferencePage.getWarningThreshold()) {
            return 5;
        }
        if (coverage >= ThresholdPreferencePage.getWarningThreshold()) {
            return 1;
        }
        if (coverage < ThresholdPreferencePage.getThreshold()) {
            return 2;
        }
        return 4;
    }

    private Image getStatusIcon(int status) {
        switch (status) {
            case 1: {
                return IMAGE_PASSED;
            }
            case 2: {
                return IMAGE_FAILED;
            }
            case 3: {
                return IMAGE_ERROR;
            }
            case 5: {
                return IMAGE_WARNING;
            }
            case 4: {
                return null;
            }
        }
        return IMAGE_UNKNOWN;
    }

    public String getColumnText(Object object, int column) {
        if (object instanceof IResultAdapter) {
            return this.getResultColumnText((IResultAdapter)object, column);
        }
        if (object instanceof IResultLocation) {
            if (column == 5) {
                String locationError = ((IResultLocation)object).getErrorMessage();
                return locationError != null ? locationError : "";
            }
            if (column == 2 && object instanceof ICCPercentItem) {
                return this.convertPercentage((ICCPercentItem)object);
            }
            if (column == 4 && object instanceof IResultDateItem) {
                Date date = ((IResultDateItem)object).getAnalyzedDate();
                if (date != null) {
                    return DateFormat.getDateTimeInstance().format(date);
                }
                return Labels.NOT_APPLICABLE;
            }
            if (object instanceof IRemoteResultLocation) {
                return ((IRemoteResultLocation)object).getColumnText(column);
            }
        }
        return "";
    }

    private String convertPercentage(ICCPercentItem item) {
        int coverage = item.getPercentCoverage();
        return coverage > -1 ? " " + Integer.toString(coverage) : "";
    }

    private String getResultColumnText(IResultAdapter resultAdapter, int column) {
        switch (column) {
            case 1: {
                return this.getStatusText(ResultsLabelProvider.getStatus(resultAdapter));
            }
            case 2: {
                return resultAdapter.isAnalyzed() ? this.convertPercentage(resultAdapter) : Labels.NOT_APPLICABLE;
            }
            case 3: {
                String level = resultAdapter.getLevel();
                return level != null && !level.isEmpty() ? level : Labels.NOT_APPLICABLE;
            }
            case 4: {
                Date date = resultAdapter.getAnalyzedDate();
                if (date != null) {
                    return DateFormat.getDateTimeInstance().format(date);
                }
                return Labels.NOT_APPLICABLE;
            }
            case 5: {
                return resultAdapter.getResultError();
            }
        }
        return "";
    }

    private String getStatusText(int status) {
        switch (status) {
            case 1: {
                return Labels.STATUS_PASSED;
            }
            case 2: {
                return Labels.STATUS_FAILED;
            }
            case 5: {
                return Labels.STATUS_WARNING;
            }
            case 3: {
                return Labels.STATUS_ERROR;
            }
            case 0: {
                return Labels.STATUS_UNKNOWN;
            }
        }
        return "";
    }

    private static Image getImage(String key) {
        return ResultsViewPlugin.getDefault().getImageRegistry().get(key);
    }
}

