/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.ui.resultsview;

import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ResultsViewContentProviders;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.handlers.LinkWithEditorHandler;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.ICCResultsView;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultAdapter;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultContentProvider;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.ResultsViewUtilities;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;

public class LinkWithEditorListener
implements ISelectionChangedListener,
IPartListener {
    private ICCResultsView fView;
    private Set<IWorkbenchPart> fIgnoreList = new HashSet<IWorkbenchPart>();

    public LinkWithEditorListener(ICCResultsView view) {
        this.fView = view;
    }

    public void partActivated(IWorkbenchPart part) {
        if (this.fIgnoreList.contains(part)) {
            this.fIgnoreList.remove(part);
        } else if (LinkWithEditorHandler.isChecked()) {
            ISelection s;
            ICCResultsView view = ResultsViewUtilities.getResultsView();
            if (view == null) {
                return;
            }
            IResultAdapter result = null;
            IResultContentProvider[] iResultContentProviderArray = ResultsViewContentProviders.getContentProviders();
            int n = iResultContentProviderArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResultContentProvider provider = iResultContentProviderArray[n2];
                result = provider.getResultAdapter(part);
                if (result != null) break;
                ++n2;
            }
            if (result != null && !this.isSelectionValid(s = this.fView.getSite().getSelectionProvider().getSelection(), result)) {
                this.select(result);
            }
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    private void select(IResultAdapter result) {
        this.fView.setSelection(new StructuredSelection((Object)result), true);
    }

    private boolean isSelectionValid(ISelection s, IResultAdapter launch) {
        return s instanceof StructuredSelection && ((StructuredSelection)s).size() == 1 && this.matches(((StructuredSelection)s).getFirstElement(), launch);
    }

    private boolean matches(Object item, IResultAdapter launch) {
        if (item instanceof IResultAdapter) {
            return item.equals(launch);
        }
        return false;
    }

    public void partClosed(IWorkbenchPart part) {
        if (this.fIgnoreList.contains(part)) {
            this.fIgnoreList.remove(part);
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
        this.fIgnoreList.add(part);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IResultAdapter adapter;
        IEditorPart viewer;
        ISelection s;
        if (LinkWithEditorHandler.isChecked() && (s = event.getSelection()) instanceof StructuredSelection && ((StructuredSelection)s).size() == 1 && ((StructuredSelection)s).getFirstElement() instanceof IResultAdapter && (viewer = (adapter = (IResultAdapter)((StructuredSelection)s).getFirstElement()).getOpenEditor()) != null) {
            viewer.getSite().getPage().bringToTop((IWorkbenchPart)viewer);
        }
    }
}

