/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.ui.resultsview;

import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.CCResultSource;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.CCResultsViewSorter;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.Labels;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.LinkWithEditorListener;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ResultColumnLabelProvider;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ResultsContentProvider;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ResultsLabelProvider;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ResultsViewContentProviders;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ResultsViewListener;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ResultsViewPlugin;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.migration.JavaCCResultsMigration;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.util.ResultViewImportExportUtils;
import com.ibm.debug.pdt.codecoverage.ui.percentPainter.CCPercentangePaintListener;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.CCResultEvent;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.CCResultEventManager;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.ICCResultListener;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.ICCResultsView;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IRemoteResultLocation;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultAdapter;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultContentProvider;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultLocation;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IUtilitiesContentProvider;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.ResultsViewUtilities;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DecorationContext;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.views.properties.IPropertySource;
import org.osgi.service.prefs.BackingStoreException;

public class CCResultsView
extends ViewPart
implements ICCResultsView {
    public static final String LAUNCH_HISTORY_VIEW_ID = "com.ibm.debug.pdt.codecoverage.ui.results.views.statistics.history";
    public static final String RESULTVIEW_THRESHOLD_PREF = "com.ibm.debug.pdt.tatt.threshold";
    private static final String OLD_PREF_PLUGIN = "com.ibm.debug.pdt.codecoverage.ui";
    private static final IEclipsePreferences preferenceNode = CCResultsView.getPreferenceNode();
    private static final String RESULT_LOCATIONS_STR = "RESULT_LOCATIONS_STR";
    public static final String RESULTS_VIEW_SECTION = "ResultsView";
    private Tree fTree;
    private TreeViewer fTreeViewer;
    private TreeColumn fResultColumn;
    private TreeColumn fStatusColumn;
    private TreeColumn fCoveragePercentageColumn;
    private TreeColumn fLevelColumn;
    private TreeColumn fDateColumn;
    private TreeColumn fAdditionalInfoColumn;
    private ResultsContentProvider fContentProvider;
    private ResultsLabelProvider fLabelProvider;
    private final List<IResultLocation> fResultLocations = new ArrayList<IResultLocation>();
    private final CCResultsViewSorter fViewSorter = new CCResultsViewSorter();
    private LinkWithEditorListener fLinkWithEditorListener;
    private final ICCResultListener fListener = new ResultsViewListener(this);
    private static final Object fProviderLock = new Object();
    private static IUtilitiesContentProvider fProvider = null;

    static {
        IAdapterManager manager = Platform.getAdapterManager();
        manager.registerAdapters(new IAdapterFactory(){

            public Class<?>[] getAdapterList() {
                return new Class[]{IPropertySource.class};
            }

            public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
                if (adaptableObject instanceof IResultAdapter && adapterType == IPropertySource.class) {
                    return (T)new CCResultSource((IResultAdapter)adaptableObject);
                }
                return null;
            }
        }, IResultAdapter.class);
    }

    private static IEclipsePreferences getPreferenceNode() {
        IEclipsePreferences oldPrefs = InstanceScope.INSTANCE.getNode(OLD_PREF_PLUGIN);
        String resultLocationStr = oldPrefs == null ? null : oldPrefs.get(RESULT_LOCATIONS_STR, null);
        IEclipsePreferences newPrefs = InstanceScope.INSTANCE.getNode("com.ibm.debug.pdt.codecoverage.ui.view");
        if (resultLocationStr != null && !resultLocationStr.isEmpty()) {
            String newResultLocationStr;
            String string = newResultLocationStr = oldPrefs == null ? null : newPrefs.get(RESULT_LOCATIONS_STR, null);
            if (newResultLocationStr == null || newResultLocationStr.isEmpty()) {
                newPrefs.put(RESULT_LOCATIONS_STR, resultLocationStr);
                try {
                    newPrefs.flush();
                }
                catch (BackingStoreException backingStoreException) {
                    // empty catch block
                }
            }
            if (oldPrefs != null) {
                oldPrefs.remove(RESULT_LOCATIONS_STR);
                try {
                    oldPrefs.flush();
                }
                catch (BackingStoreException backingStoreException) {
                    // empty catch block
                }
            }
        }
        return newPrefs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CCResultsView() {
        CCResultEventManager.getDefault().addListener(this.fListener);
        ScopedPreferenceStore prefStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "com.ibm.debug.pdt.codecoverage.ui.view");
        prefStore.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals(CCResultsView.RESULTVIEW_THRESHOLD_PREF) || event.getProperty().equals("com.ibm.debug.pdt.tatt.threshold.warning")) {
                    CCResultsView.this.refresh();
                }
            }
        });
        IResultContentProvider[] iResultContentProviderArray = ResultsViewContentProviders.getContentProviders();
        int n = iResultContentProviderArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResultContentProvider provider = iResultContentProviderArray[n2];
            provider.initialize(this);
            ++n2;
        }
        Object object = fProviderLock;
        synchronized (object) {
            fProvider = ResultViewImportExportUtils.getContentProvider();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IUtilitiesContentProvider getProvider() {
        Object object = fProviderLock;
        synchronized (object) {
            return fProvider;
        }
    }

    @Override
    public IResultLocation[] getResultLocations() {
        return this.fResultLocations.toArray(new IResultLocation[this.fResultLocations.size()]);
    }

    public void addResultLocation(IResultLocation location, boolean refresh) {
        this.fResultLocations.add(location);
        if (location.isSaveRestoreable()) {
            this.updatePreferenceNode();
        }
        if (refresh) {
            this.refresh(false);
        }
    }

    public void updatePreferenceNode() {
        String resultLocationStr = ResultsViewUtilities.getSaveLocationsString(this.fResultLocations, true);
        preferenceNode.put(RESULT_LOCATIONS_STR, resultLocationStr);
        try {
            preferenceNode.flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    @Override
    public boolean isExistingResultLocation(String locationPath) {
        for (IResultLocation location : this.fResultLocations) {
            if (!location.getPath().equals(locationPath)) continue;
            return true;
        }
        return false;
    }

    public void removeResultLocation(IResultLocation location) {
        location.cleanup();
        this.fResultLocations.remove(location);
        this.updatePreferenceNode();
    }

    public void dispose() {
        IPartService partService;
        super.dispose();
        CCResultEventManager.getDefault().removeListener(this.fListener);
        if (this.fTreeViewer != null) {
            this.fTreeViewer.removeSelectionChangedListener((ISelectionChangedListener)this.fLinkWithEditorListener);
        }
        if ((partService = (IPartService)this.getSite().getService(IPartService.class)) != null) {
            partService.removePartListener((IPartListener)this.fLinkWithEditorListener);
        }
        IResultContentProvider[] iResultContentProviderArray = ResultsViewContentProviders.getContentProviders();
        int n = iResultContentProviderArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResultContentProvider provider = iResultContentProviderArray[n2];
            provider.dispose();
            ++n2;
        }
    }

    public void createPartControl(Composite parent) {
        this.createControls(parent);
        this.createToolbar();
        this.createContextMenu();
        this.initializeResultLocations();
    }

    private void createControls(Composite parent) {
        this.fTreeViewer = this.createTreeViewer(parent);
        this.fTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection extended = (IStructuredSelection)selection;
                    if (extended.size() == 1 && extended.getFirstElement() instanceof IResultAdapter) {
                        Command command;
                        ICommandService commandService = (ICommandService)CCResultsView.this.getSite().getService(ICommandService.class);
                        if (commandService != null && (command = commandService.getCommand("com.ibm.debug.pdt.codecoverage.internal.ui.view.web.open")) != null && command.isEnabled()) {
                            IHandlerService handlerService = (IHandlerService)CCResultsView.this.getSite().getService(IHandlerService.class);
                            try {
                                IParameter modeParm = command.getParameter("com.ibm.debug.pdt.codecoverage.ui.commandParameter.mode");
                                Parameterization parm = new Parameterization(modeParm, "default");
                                ParameterizedCommand parmCommand = new ParameterizedCommand(command, new Parameterization[]{parm});
                                handlerService.executeCommand(parmCommand, null);
                            }
                            catch (Exception e) {
                                ResultsViewPlugin.log(e);
                            }
                        }
                    } else if (extended.size() == 1 && extended.getFirstElement() instanceof IResultLocation) {
                        IResultLocation location = (IResultLocation)extended.getFirstElement();
                        if (CCResultsView.this.fTreeViewer.getExpandedState((Object)location)) {
                            CCResultsView.this.fTreeViewer.collapseToLevel((Object)location, 1);
                        } else {
                            CCResultsView.this.fTreeViewer.expandToLevel((Object)location, 1);
                        }
                    }
                }
            }
        });
        this.fTreeViewer.setComparator((ViewerComparator)this.fViewSorter);
        this.fTree.setSortDirection(1024);
        this.fTree.setSortColumn(this.fDateColumn);
        this.fViewSorter.setSortColumn(4);
        this.getSite().setSelectionProvider((ISelectionProvider)this.fTreeViewer);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fTree, "com.ibm.debug.pdt.codecoverage.ui.view.cc_results_view");
        this.fLinkWithEditorListener = new LinkWithEditorListener(this);
        this.fTreeViewer.addSelectionChangedListener((ISelectionChangedListener)this.fLinkWithEditorListener);
        IPartService partService = (IPartService)this.getSite().getService(IPartService.class);
        if (partService != null) {
            partService.addPartListener((IPartListener)this.fLinkWithEditorListener);
        }
    }

    private TreeViewer createTreeViewer(Composite parent) {
        Composite immediateTreeParent = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().margins(0, 0).applyTo(immediateTreeParent);
        TreeViewer treeViewer = new TreeViewer(immediateTreeParent, 68354);
        this.fContentProvider = new ResultsContentProvider(this);
        treeViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fLabelProvider = new ResultsLabelProvider();
        IDecoratorManager mgr = PlatformUI.getWorkbench().getDecoratorManager();
        treeViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
        treeViewer.setUseHashlookup(false);
        this.fTree = treeViewer.getTree();
        this.fTree.setHeaderVisible(true);
        this.fTree.setLinesVisible(true);
        TreeColumnLayout layout = new TreeColumnLayout();
        immediateTreeParent.setLayout((Layout)layout);
        this.fResultColumn = this.createColumn(Labels.NAME_NO_COLON, 0);
        TreeViewerColumn resultViewerColumn = new TreeViewerColumn(treeViewer, this.fResultColumn);
        final ResultColumnLabelProvider labelProvider = new ResultColumnLabelProvider();
        DecoratingStyledCellLabelProvider dLabelProvider = new DecoratingStyledCellLabelProvider(labelProvider, mgr.getLabelDecorator(), (IDecorationContext)new DecorationContext()){

            public Image getToolTipImage(Object object) {
                Image image = super.getToolTipImage(object);
                return image != null ? image : labelProvider.getToolTipImage(object);
            }

            public String getToolTipText(Object element) {
                String text = super.getToolTipText(element);
                return text != null ? text : labelProvider.getToolTipText(element);
            }

            public Color getToolTipBackgroundColor(Object object) {
                Color color = super.getToolTipBackgroundColor(object);
                return color != null ? color : labelProvider.getToolTipBackgroundColor(object);
            }

            public Color getToolTipForegroundColor(Object object) {
                Color color = super.getToolTipForegroundColor(object);
                return color != null ? color : labelProvider.getToolTipForegroundColor(object);
            }

            public Font getToolTipFont(Object object) {
                Font font = super.getToolTipFont(object);
                return font != null ? font : labelProvider.getToolTipFont(object);
            }

            public Point getToolTipShift(Object object) {
                Point shift = super.getToolTipShift(object);
                return shift != null ? shift : labelProvider.getToolTipShift(object);
            }

            public int getToolTipTimeDisplayed(Object object) {
                int time = super.getToolTipTimeDisplayed(object);
                return time != 0 ? time : labelProvider.getToolTipTimeDisplayed(object);
            }

            public int getToolTipDisplayDelayTime(Object object) {
                int time = super.getToolTipDisplayDelayTime(object);
                return time != 0 ? time : labelProvider.getToolTipDisplayDelayTime(object);
            }

            public int getToolTipStyle(Object object) {
                int style = super.getToolTipStyle(object);
                return style != 32 ? style : labelProvider.getToolTipStyle(object);
            }

            protected void fireLabelProviderChanged(LabelProviderChangedEvent event) {
                if (event.getSource() instanceof IDecoratorManager) {
                    super.fireLabelProviderChanged(event);
                }
            }
        };
        resultViewerColumn.setLabelProvider((CellLabelProvider)dLabelProvider);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)treeViewer);
        this.fViewSorter.setNameLabelProvider(dLabelProvider);
        this.fStatusColumn = this.createColumn(Labels.STATUS, 1);
        if (ResultsViewContentProviders.isStatusVisible()) {
            layout.setColumnData((Widget)this.fResultColumn, (ColumnLayoutData)new ColumnWeightData(35, 200, true));
            layout.setColumnData((Widget)this.fStatusColumn, (ColumnLayoutData)new ColumnWeightData(7, true));
        } else {
            layout.setColumnData((Widget)this.fResultColumn, (ColumnLayoutData)new ColumnWeightData(42, 200, true));
            this.fStatusColumn.setResizable(false);
            layout.setColumnData((Widget)this.fStatusColumn, (ColumnLayoutData)new ColumnPixelData(0, false));
        }
        this.fCoveragePercentageColumn = this.createColumn(Labels.COVERAGE, 2);
        layout.setColumnData((Widget)this.fCoveragePercentageColumn, (ColumnLayoutData)new ColumnWeightData(8, 30, true));
        CCPercentangePaintListener.addPaintListener(2, (Viewer)treeViewer);
        this.fLevelColumn = this.createColumn(Labels.LEVEL, 3);
        layout.setColumnData((Widget)this.fLevelColumn, (ColumnLayoutData)new ColumnWeightData(10, 45, true));
        this.fDateColumn = this.createColumn(Labels.ANALYZED_DATE, 4);
        layout.setColumnData((Widget)this.fDateColumn, (ColumnLayoutData)new ColumnWeightData(17, 73, true));
        this.fAdditionalInfoColumn = this.createColumn(Labels.ADDITIONAL_INFORMATION, 5);
        layout.setColumnData((Widget)this.fAdditionalInfoColumn, (ColumnLayoutData)new ColumnWeightData(23, true));
        treeViewer.setInput(this.fResultLocations);
        treeViewer.refresh();
        treeViewer.getTree().layout(true);
        return treeViewer;
    }

    private void createToolbar() {
        IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
        mgr.add((IContributionItem)new GroupMarker("additions"));
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.add((IContributionItem)new GroupMarker("additions"));
        Menu menu = menuMgr.createContextMenu(this.fTreeViewer.getControl());
        this.fTreeViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.fTreeViewer);
    }

    private void initializeResultLocations() {
        this.addDefaultLocalLocation();
        new JavaCCResultsMigration();
        this.refresh(true);
        String resultLocationStr = preferenceNode.get(RESULT_LOCATIONS_STR, "");
        if (resultLocationStr.trim().length() > 0) {
            final List<IResultLocation> locations = ResultsViewUtilities.restoreLocationsFromString(resultLocationStr);
            for (IResultLocation location : locations) {
                this.addResultLocation(location, false);
            }
            Job j = new Job("Refreshing Code Coverage locations"){

                protected IStatus run(IProgressMonitor monitor) {
                    for (IResultLocation location : locations) {
                        if (location.isRemote() && !((IRemoteResultLocation)location).isConnected()) continue;
                        location.refreshResults();
                    }
                    CCResultsView.this.refresh(false);
                    return Status.OK_STATUS;
                }
            };
            j.setSystem(true);
            j.schedule();
        }
    }

    private void addDefaultLocalLocation() {
        IResultContentProvider[] iResultContentProviderArray = ResultsViewContentProviders.getContentProviders();
        int n = iResultContentProviderArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResultContentProvider provider = iResultContentProviderArray[n2];
            IResultLocation[] locations = provider.getDefaultLocations();
            if (locations != null) {
                IResultLocation[] iResultLocationArray = locations;
                int n3 = locations.length;
                int n4 = 0;
                while (n4 < n3) {
                    IResultLocation location = iResultLocationArray[n4];
                    this.fResultLocations.add(location);
                    ++n4;
                }
            }
            ++n2;
        }
    }

    @Override
    public void refresh() {
        this.refresh(false);
    }

    public void refresh(final boolean expandDefaultLocation) {
        UIJob refreshJob = new UIJob("Refresh CC Results view"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                monitor.beginTask("Begin refresh", 10);
                CCResultsView.this.fTreeViewer.refresh();
                monitor.done();
                if (expandDefaultLocation) {
                    for (IResultLocation location : CCResultsView.this.fResultLocations) {
                        if (!location.isDefaultLocation() || !location.expandLocationOnRestart()) continue;
                        CCResultsView.this.fTreeViewer.expandToLevel((Object)location, 1);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        refreshJob.setSystem(true);
        refreshJob.schedule();
    }

    void update(final Object element) {
        if (this.fTreeViewer != null && this.fTreeViewer.getControl() != null && !this.fTreeViewer.getControl().isDisposed()) {
            this.fTreeViewer.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    CCResultsView.this.fTreeViewer.update(element, null);
                    CCResultsView.this.fTreeViewer.refresh(element, true);
                }
            });
        }
    }

    void update(final Object[] elements) {
        UIJob updateJob = new UIJob("Update elements"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                monitor.beginTask("Begin update", 10);
                CCResultsView.this.fTreeViewer.update(elements, null);
                CCResultsView.this.fTreeViewer.refresh((Object)elements, true);
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        updateJob.setSystem(true);
        updateJob.schedule();
    }

    public void refreshResultLocation(IResultLocation location) {
        this.refreshResultLocation(location, null);
    }

    public void refreshResultLocation(final IResultLocation location, final IResultAdapter resultToSelect) {
        UIJob updateJob = new UIJob("Refresh element"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                monitor.beginTask("Begin refresh", 10);
                CCResultsView.this.fTreeViewer.refresh((Object)location);
                if (resultToSelect != null) {
                    CCResultsView.this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)resultToSelect));
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        updateJob.setSystem(true);
        updateJob.schedule();
    }

    private TreeColumn createColumn(String name, int index) {
        int alignment = index == 2 ? 0x1000000 : 16384;
        TreeColumn column = new TreeColumn(this.fTree, alignment, index);
        column.setText(name);
        column.setResizable(true);
        column.setMoveable(false);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (event.getSource() instanceof TreeColumn) {
                    TreeColumn extended = (TreeColumn)event.getSource();
                    if (CCResultsView.this.fTree.getSortDirection() == 1024) {
                        CCResultsView.this.fTree.setSortDirection(128);
                    } else {
                        CCResultsView.this.fTree.setSortDirection(1024);
                    }
                    CCResultsView.this.fTree.setSortColumn(extended);
                    int column = -1;
                    if (extended == CCResultsView.this.fResultColumn) {
                        column = 0;
                    } else if (extended == CCResultsView.this.fStatusColumn) {
                        column = 1;
                    } else if (extended == CCResultsView.this.fCoveragePercentageColumn) {
                        column = 2;
                    } else if (extended == CCResultsView.this.fLevelColumn) {
                        column = 3;
                    } else if (extended == CCResultsView.this.fDateColumn) {
                        column = 4;
                    } else if (extended == CCResultsView.this.fAdditionalInfoColumn) {
                        column = 5;
                    }
                    CCResultsView.this.fViewSorter.setSortColumn(column);
                    CCResultsView.this.fTreeViewer.refresh();
                }
            }
        });
        return column;
    }

    public void setFocus() {
        this.fTree.setFocus();
    }

    @Override
    public void collapseAll() {
        if (this.fTreeViewer != null) {
            this.fTreeViewer.collapseAll();
        }
    }

    @Override
    public void setSelection(final StructuredSelection structuredSelection, final boolean reveal) {
        if (this.fTreeViewer != null) {
            Job setSelectionJob = new Job("Setting selection for Code Coverage Results View"){

                public boolean belongsTo(Object family) {
                    return family == CCResultsView.this;
                }

                protected IStatus run(IProgressMonitor monitor) {
                    Object[] selectionItems;
                    final ArrayList<IResultAdapter> adapters = new ArrayList<IResultAdapter>();
                    Object[] objectArray = selectionItems = structuredSelection.toArray();
                    int n = selectionItems.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object item = objectArray[n2];
                        if (monitor.isCanceled()) break;
                        if (item instanceof IResultAdapter) {
                            adapters.add((IResultAdapter)item);
                        }
                        ++n2;
                    }
                    if (!monitor.isCanceled() && adapters.size() > 0) {
                        ResultViewImportExportUtils.getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!(this).CCResultsView.this.fTreeViewer.getTree().isDisposed()) {
                                    (this).CCResultsView.this.fTreeViewer.setSelection((ISelection)new StructuredSelection(adapters.toArray()), reveal);
                                }
                            }
                        });
                    }
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    return Status.OK_STATUS;
                }
            };
            setSelectionJob.setSystem(true);
            Job.getJobManager().cancel((Object)this);
            setSelectionJob.schedule();
        }
    }

    public void refreshResultLocations() {
        for (IResultLocation location : this.fResultLocations) {
            location.refreshResults();
            CCResultEventManager.getDefault().fireResultLocationEvent(new CCResultEvent(location, 4));
        }
        this.refresh();
    }

    @Override
    public boolean isInitilized() {
        return this.fTreeViewer != null;
    }

    @Override
    public void expandLocation(final IResultLocation location) {
        this.fTreeViewer.getControl().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                CCResultsView.this.fTreeViewer.expandToLevel((Object)location, -1);
            }
        });
    }
}

