/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.ui.resultsview;

import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.Labels;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ResultsViewContentProviders;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultAdapter;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultSource;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class CCResultSource
implements IPropertySource {
    private static final String NAME_ID = "CCResultSource.name";
    private static final String TESTCASE_ID = "CCResultSource.testcaseid";
    private static final String COVERAGE_ID = "CCResultSource.coverage";
    private static final String DATE_ID = "CLCoverageLaunchSource.date";
    private static final String ELAPSED_TIME_ID = "CLCoverageLaunchSource.elapsedTime";
    private static final String DATAFILE_ID = "CCResultSource.resultfile";
    private static final String TAGS = "CCResultSource.tags";
    private static final String METADATAFILE_ID = "CCResultSource.metadata";
    private static final String LEVEL_ID = "CCResultSource.cclevel";
    private IResultAdapter fAdapter;

    public CCResultSource(IResultAdapter adapter) {
        this.fAdapter = adapter;
    }

    public Object getEditableValue() {
        return this;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<Object> descriptors = new ArrayList<Object>();
        PropertyDescriptor name = new PropertyDescriptor((Object)NAME_ID, Labels.NAME_NO_COLON);
        name.setAlwaysIncompatible(true);
        name.setCategory(Labels.CoverageStatisticsFormPage_name);
        descriptors.add(name);
        PropertyDescriptor testcaseId = new PropertyDescriptor((Object)TESTCASE_ID, Labels.TESTCASEID);
        testcaseId.setAlwaysIncompatible(true);
        testcaseId.setCategory(Labels.CoverageStatisticsFormPage_name);
        descriptors.add(testcaseId);
        PropertyDescriptor coverage = new PropertyDescriptor((Object)COVERAGE_ID, Labels.COVERAGE);
        coverage.setAlwaysIncompatible(true);
        coverage.setCategory(Labels.CoverageStatisticsFormPage_name);
        descriptors.add(coverage);
        PropertyDescriptor cclevel = new PropertyDescriptor((Object)LEVEL_ID, Labels.LEVEL);
        cclevel.setAlwaysIncompatible(true);
        cclevel.setCategory(Labels.CoverageStatisticsFormPage_name);
        descriptors.add(cclevel);
        PropertyDescriptor date = new PropertyDescriptor((Object)DATE_ID, Labels.ANALYZED_DATE);
        date.setAlwaysIncompatible(true);
        date.setCategory(Labels.CoverageStatisticsFormPage_name);
        descriptors.add(date);
        PropertyDescriptor metadata = new PropertyDescriptor((Object)METADATAFILE_ID, Labels.BASELINE_FILE);
        metadata.setAlwaysIncompatible(true);
        descriptors.add(metadata);
        PropertyDescriptor elapsedTime = new PropertyDescriptor((Object)ELAPSED_TIME_ID, Labels.ELAPSED_TIME);
        elapsedTime.setAlwaysIncompatible(true);
        elapsedTime.setCategory(Labels.CoverageStatisticsFormPage_name);
        descriptors.add(elapsedTime);
        PropertyDescriptor dataFile = new PropertyDescriptor((Object)DATAFILE_ID, Labels.CoverageLaunch_datafile);
        dataFile.setAlwaysIncompatible(true);
        descriptors.add(dataFile);
        PropertyDescriptor tags = new PropertyDescriptor((Object)TAGS, Labels.CoverageLaunch_tags);
        tags.setAlwaysIncompatible(true);
        tags.setCategory(Labels.CoverageStatisticsFormPage_name);
        descriptors.add(tags);
        IResultSource[] iResultSourceArray = ResultsViewContentProviders.getSourceProviders();
        int n = iResultSourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResultSource source = iResultSourceArray[n2];
            IPropertyDescriptor[] iPropertyDescriptorArray = source.getPropertyDescriptors(this.fAdapter);
            int n3 = iPropertyDescriptorArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IPropertyDescriptor d = iPropertyDescriptorArray[n4];
                descriptors.add(d);
                ++n4;
            }
            ++n2;
        }
        return descriptors.toArray(new IPropertyDescriptor[descriptors.size()]);
    }

    public Object getPropertyValue(Object id) {
        if (id.equals(NAME_ID)) {
            return this.fAdapter.getName();
        }
        if (id.equals(TESTCASE_ID)) {
            return this.fAdapter.getTestcaseID();
        }
        if (id.equals(COVERAGE_ID)) {
            int coverage = this.fAdapter.getPercentCoverage();
            return coverage >= 0 ? String.valueOf(coverage) : null;
        }
        if (id.equals(DATE_ID)) {
            Date date = this.fAdapter.getAnalyzedDate();
            if (date != null) {
                return DateFormat.getDateTimeInstance().format(date);
            }
            return null;
        }
        if (id.equals(ELAPSED_TIME_ID)) {
            long elapsedTime = this.fAdapter.getElapsedTime();
            if (elapsedTime >= 0L) {
                return String.valueOf(elapsedTime);
            }
            return null;
        }
        if (id.equals(DATAFILE_ID)) {
            return this.fAdapter.getDataFileName();
        }
        if (id.equals(METADATAFILE_ID)) {
            return this.fAdapter.getBaselineFileName();
        }
        if (id.equals(TAGS)) {
            return this.fAdapter.getTags();
        }
        if (id.equals(LEVEL_ID)) {
            return this.fAdapter.getLevel();
        }
        Object value = null;
        IResultSource[] iResultSourceArray = ResultsViewContentProviders.getSourceProviders();
        int n = iResultSourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResultSource source = iResultSourceArray[n2];
            value = source.getPropertyValue(this.fAdapter, id);
            if (value != null) {
                return value;
            }
            ++n2;
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

