/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.ui.profile.internal.view;

import com.ibm.debug.pdt.profile.internal.cc.CodeCoverageUtils;
import com.ibm.debug.pdt.profile.internal.model.DebugProfile;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileDTCN;
import com.ibm.debug.pdt.profile.internal.model.IDebugProfileConstants;
import com.ibm.debug.pdt.ui.profile.internal.ProfileLabels;
import com.ibm.debug.pdt.ui.profile.internal.handlers.AbstractProfileHandler;
import com.ibm.debug.pdt.ui.profile.internal.handlers.DebugProfilePropertyTester;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;

public class ProfileModeEditingSupport
extends EditingSupport
implements IDebugProfileConstants,
DisposeListener {
    static final String[] MODE_LABELS = new String[]{ProfileLabels.profile_deactivate_name, ProfileLabels.profile_activate_debug_name, ProfileLabels.profile_activate_cc_name};
    static final String[] MODE_LABELS_CC_DEBUG = new String[]{ProfileLabels.profile_deactivate_name, ProfileLabels.profile_activate_cc_name};
    static final String[] MODE_LABELS_CC_CODECOV = new String[]{ProfileLabels.profile_deactivate_name, ProfileLabels.profile_activate_debug_name};
    static final String[] MODE_LABELS_CC_INACTIVE = new String[]{ProfileLabels.profile_activate_debug_name, ProfileLabels.profile_activate_cc_name};
    static final String[] MODE_LABELS_DEBUG = new String[]{ProfileLabels.profile_deactivate_name};
    static final String[] MODE_LABELS_INACTIVE = new String[]{ProfileLabels.profile_activate_debug_name};
    private String[] fLabels;
    private Map<String[], CellEditor> fEditors = new HashMap<String[], CellEditor>();

    public ProfileModeEditingSupport(ColumnViewer viewer) {
        super(viewer);
        viewer.getControl().addDisposeListener((DisposeListener)this);
    }

    protected CellEditor getCellEditor(Object element) {
        Composite parent = (Composite)this.getViewer().getControl();
        this.fLabels = MODE_LABELS;
        if (element instanceof DebugProfile) {
            DebugProfile profile = (DebugProfile)element;
            this.fLabels = CodeCoverageUtils.isCodeCoverageClient() && this.isCCSupported(profile) ? (profile.getState() == 1 ? (profile.getMode() == 1 ? MODE_LABELS_CC_DEBUG : MODE_LABELS_CC_CODECOV) : MODE_LABELS_CC_INACTIVE) : (profile.getState() == 1 ? MODE_LABELS_DEBUG : MODE_LABELS_INACTIVE);
        }
        if (!this.fEditors.containsKey(this.fLabels)) {
            this.fEditors.put(this.fLabels, (CellEditor)new ComboBoxCellEditor(parent, this.fLabels, 8));
        }
        return this.fEditors.get(this.fLabels);
    }

    private boolean isCCSupported(DebugProfile profile) {
        boolean isCICS = profile instanceof DebugProfileDTCN;
        return isCICS || DebugProfilePropertyTester.isConnectionSupportsDebugProfileServiceAPI(profile);
    }

    protected boolean canEdit(Object element) {
        return element instanceof DebugProfile && ((DebugProfile)element).isValid();
    }

    protected Object getValue(Object element) {
        return -1;
    }

    protected void setValue(final Object element, Object value) {
        int iVal;
        if (element instanceof DebugProfile && value instanceof Integer && (iVal = ((Integer)value).intValue()) > -1 && iVal < this.fLabels.length) {
            final String action = this.fLabels[iVal];
            Job j = new Job("Profile updated"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        if (action.equals(ProfileLabels.profile_deactivate_name)) {
                            ((DebugProfile)element).deactivate();
                        } else if (action.equals(ProfileLabels.profile_activate_debug_name)) {
                            ((DebugProfile)element).activate(1);
                        } else if (action.equals(ProfileLabels.profile_activate_cc_name)) {
                            ((DebugProfile)element).activate(2);
                        }
                    }
                    catch (Exception e) {
                        AbstractProfileHandler.handleException(e);
                    }
                    return Status.OK_STATUS;
                }
            };
            j.setSystem(true);
            j.schedule();
        }
    }

    public void widgetDisposed(DisposeEvent arg0) {
        for (CellEditor e : this.fEditors.values()) {
            e.dispose();
        }
        this.fEditors.clear();
    }
}

