/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.ui.profile.internal.view;

import com.ibm.debug.pdt.profile.internal.ProfileMessages;
import com.ibm.debug.pdt.profile.internal.model.DebugProfile;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileRoot;
import com.ibm.debug.pdt.ui.profile.internal.ProfileLabels;
import com.ibm.debug.pdt.ui.profile.internal.view.ConnectionDebugProfileContentProvider;
import com.ibm.debug.pdt.ui.profile.internal.view.DebugProfileLabelProvider;
import com.ibm.debug.pdt.ui.profile.internal.view.DebugProfileLocationDecorator;
import com.ibm.debug.pdt.ui.profile.internal.view.DebugProfileTableComparator;
import com.ibm.debug.pdt.ui.profile.internal.view.DebugProfileViewToolTipSupport;
import com.ibm.debug.pdt.ui.profile.internal.view.FilterLabelProvider;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class DebugProfileCheckboxFilteredTree
extends FilteredTree
implements ModifyListener,
ICheckStateListener {
    CheckboxTreeViewer fTreeViewer;
    private ConnectionDebugProfileContentProvider fContentProvider;
    private boolean fHandlingChange;

    public DebugProfileCheckboxFilteredTree(Composite parent, CCombo combo, boolean cics, boolean imsIso) {
        super(parent, 2848, new PatternFilter(), true, false);
        GridLayoutFactory.fillDefaults().margins(0, 0).applyTo((Composite)this);
        combo.addModifyListener((ModifyListener)this);
        TreeColumnLayout layout = new TreeColumnLayout(false);
        TreeViewer viewer = this.getViewer();
        viewer.setLabelProvider((IBaseLabelProvider)new FilterLabelProvider((TreeViewer)this.fTreeViewer));
        Tree tree = viewer.getTree();
        tree.getParent().setLayout((Layout)layout);
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        viewer.setComparator((ViewerComparator)new DebugProfileTableComparator());
        TreeViewerColumn nameColumn = new TreeViewerColumn((TreeViewer)this.fTreeViewer, 0, 0);
        layout.setColumnData((Widget)nameColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(40, 200, true));
        nameColumn.getColumn().setText(ProfileLabels.profile_table_column_name);
        nameColumn.getColumn().setMoveable(false);
        DebugProfileLabelProvider labelProvider = new DebugProfileLabelProvider(0, this);
        nameColumn.setLabelProvider((CellLabelProvider)labelProvider);
        DebugProfileTableComparator c = (DebugProfileTableComparator)this.fTreeViewer.getComparator();
        c.setDefaultLabelProvider((CellLabelProvider)labelProvider);
        TreeViewerColumn locationColumn = new TreeViewerColumn((TreeViewer)this.fTreeViewer, 0, 1);
        layout.setColumnData((Widget)locationColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(60, 300, true));
        locationColumn.getColumn().setText(ProfileLabels.profile_table_column_location);
        locationColumn.getColumn().setMoveable(false);
        labelProvider = new DecoratingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new DebugProfileLabelProvider(3, this), (ILabelDecorator)new DebugProfileLocationDecorator(), null);
        locationColumn.setLabelProvider((CellLabelProvider)labelProvider);
        tree.setItemCount(10);
        Point size = tree.computeSize(-1, -1);
        Object data = parent.getParent().getLayoutData();
        if (data instanceof GridData) {
            ((GridData)data).heightHint = size.y + tree.getHeaderHeight();
            ((GridData)data).grabExcessVerticalSpace = true;
        }
        tree.setItemCount(0);
        this.fContentProvider = new ConnectionDebugProfileContentProvider(combo.getText(), cics, imsIso);
        this.fTreeViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fTreeViewer.setInput((Object)DebugProfileRoot.getInstance());
        new DebugProfileViewToolTipSupport((ColumnViewer)this.fTreeViewer, false);
        this.fTreeViewer.addCheckStateListener((ICheckStateListener)this);
        this.fTreeViewer.refresh(true);
    }

    public void addCheckStateListener(ICheckStateListener listener) {
        if (this.fTreeViewer != null) {
            this.fTreeViewer.addCheckStateListener(listener);
        }
    }

    protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
        this.fTreeViewer = new CheckboxTreeViewer(parent, style);
        return this.fTreeViewer;
    }

    public void modifyText(ModifyEvent event) {
        if (event.getSource() instanceof Combo) {
            this.setConnection(((Combo)event.getSource()).getText());
        }
    }

    public void setConnection(String connection) {
        this.fContentProvider.setConection(connection);
        this.fTreeViewer.refresh(true);
        if (this.getTreeChildrenCount() == 1) {
            this.fTreeViewer.setCheckedElements(this.fContentProvider.getElements(DebugProfileRoot.getInstance()));
        }
    }

    public String getMessage() {
        if (this.getTreeChildrenCount() == 0) {
            return ProfileMessages.CRRDG9184;
        }
        if (this.fTreeViewer.getCheckedElements().length == 0) {
            return ProfileMessages.CRRDG9185;
        }
        return null;
    }

    private int getTreeChildrenCount() {
        return this.fContentProvider == null ? 0 : this.fContentProvider.getElements(DebugProfileRoot.getInstance()).length;
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        if (!this.fHandlingChange) {
            this.fHandlingChange = true;
            Object checkedItem = event.getElement();
            boolean isChecked = event.getChecked();
            if (isChecked) {
                this.fTreeViewer.setCheckedElements(new Object[]{checkedItem});
            }
            this.fHandlingChange = false;
        }
    }

    public DebugProfile getProfile() {
        Object[] items = this.fTreeViewer.getCheckedElements();
        if (items.length == 1 && items[0] instanceof DebugProfile) {
            return (DebugProfile)items[0];
        }
        return null;
    }
}

