/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.ui.profile.internal.outline;

import com.ibm.debug.pdt.profile.internal.model.IDebugProfileConstants;
import com.ibm.ftt.debug.ui.composites.dlydbg.DelayDebugComposite;
import java.util.List;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.widgets.Section;

public class DebugProfileOutlineUtils
implements IDebugProfileConstants {
    public static void itemSelectedAction(SelectionEvent e) {
        if (e.item instanceof TreeItem) {
            TreeItem item = (TreeItem)e.item;
            DebugProfileOutlineUtils.itemSelectedAction((Control)item.getData());
        }
    }

    protected static void itemSelectedAction(Control item) {
        DebugProfileOutlineUtils.setAncestorExpanded(item);
        if (item instanceof Text) {
            Text textItem = (Text)item;
            String textContent = ((Text)item).getText();
            textItem.setSelection(0, textContent.length());
            textItem.showSelection();
            textItem.forceFocus();
        } else if (item instanceof CCombo) {
            CCombo comboItem = (CCombo)item;
            comboItem.setFocus();
            comboItem.setSelection(comboItem.getSelection());
            comboItem.forceFocus();
        } else if (item instanceof Button || item instanceof org.eclipse.swt.widgets.List || item instanceof DelayDebugComposite) {
            item.forceFocus();
        } else {
            DebugProfileOutlineUtils.focusOnFirstChild(item);
        }
    }

    private static void focusOnFirstChild(Control item) {
        if (DebugProfileOutlineUtils.hasOutlineChildren(item)) {
            List children = (List)item.getData("outlineChildren");
            if (children.get(0) instanceof Control) {
                DebugProfileOutlineUtils.focusOnFirstChild((Control)children.get(0));
            }
        } else {
            DebugProfileOutlineUtils.itemSelectedAction(item);
        }
    }

    private static boolean hasOutlineChildren(Control item) {
        return item.getData("outlineChildren") != null && item.getData("outlineChildren") instanceof List && ((List)item.getData("outlineChildren")).size() > 0;
    }

    protected static void setAncestorExpanded(Control item) {
        if (item.getData("outlineParent") == null) {
            item.forceFocus();
            return;
        }
        Control parent = (Control)item.getData("outlineParent");
        DebugProfileOutlineUtils.setAncestorExpanded(parent);
        if (parent instanceof Section) {
            ((Section)parent).setExpanded(true);
        }
    }
}

