/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.ui.profile.internal.migration;

import com.ibm.debug.pdt.profile.internal.LogUtils;
import com.ibm.debug.pdt.profile.internal.ProfileMessages;
import com.ibm.debug.pdt.ui.profile.internal.ProfileLabels;
import com.ibm.debug.pdt.ui.profile.internal.migration.IDebugProfileImsIsolationMigrator;
import com.ibm.debug.pdt.ui.profile.internal.migration.IDebugProfileMigrationListener;
import com.ibm.debug.pdt.ui.profile.internal.migration.IDebugProfileMigrator;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;

public class DebugProfileMigrationUtils {
    private static IDebugProfileMigrator[] fMigrators = null;
    private static int fNumProfiles = -1;
    private static int fNumMigratedProfiles = 0;
    private static int fNumImportedProfiles = 0;
    private static Exception fImportException = null;

    private static synchronized IDebugProfileMigrator[] getDebugMigrators(boolean isImport) {
        if (fMigrators == null || isImport) {
            ArrayList<IDebugProfileMigrator> migrators = new ArrayList<IDebugProfileMigrator>();
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.debug.pdt.ui.profile.eclipse.zdebugProfileMigration");
            if (extensionPoint != null) {
                IConfigurationElement[] iConfigurationElementArray = extensionPoint.getConfigurationElements();
                int n = iConfigurationElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement config = iConfigurationElementArray[n2];
                    try {
                        migrators.add((IDebugProfileMigrator)config.createExecutableExtension("class"));
                    }
                    catch (CoreException e) {
                        LogUtils.log((Throwable)e);
                    }
                    catch (ClassCastException e) {
                        LogUtils.log((Throwable)e);
                    }
                    ++n2;
                }
            }
            IDebugProfileMigrator[] result = migrators.toArray(new IDebugProfileMigrator[migrators.size()]);
            if (isImport) {
                return result;
            }
            fMigrators = result;
        }
        return fMigrators;
    }

    public static int getNumberOfProfilesToMigrate() {
        if (fNumProfiles < 0) {
            fNumProfiles = 0;
            IDebugProfileMigrator[] iDebugProfileMigratorArray = DebugProfileMigrationUtils.getDebugMigrators(false);
            int n = iDebugProfileMigratorArray.length;
            int n2 = 0;
            while (n2 < n) {
                IDebugProfileMigrator m = iDebugProfileMigratorArray[n2];
                fNumProfiles += m.getNumberOfProfilesToMigrate();
                ++n2;
            }
        }
        return fNumProfiles;
    }

    public static int getNumberOfProfilesToImport(String workspace, IDebugProfileMigrator[] migrators) throws Exception {
        int result = 0;
        IDebugProfileMigrator[] iDebugProfileMigratorArray = migrators;
        int n = migrators.length;
        int n2 = 0;
        while (n2 < n) {
            IDebugProfileMigrator m = iDebugProfileMigratorArray[n2];
            m.setImportDirectory(workspace);
            result += m.getNumberOfProfilesToImport();
            ++n2;
        }
        return result;
    }

    public static void migrate(IProgressMonitor monitor, IDebugProfileMigrationListener listener) {
        try {
            DebugProfileMigrationUtils.migrateOrImport(monitor, listener, null);
        }
        catch (Exception e) {
            LogUtils.log((String)e.getMessage());
        }
    }

    public static int migrateAndImport(IProgressMonitor monitor, String workspace) throws Exception {
        try {
            return DebugProfileMigrationUtils.migrateOrImport(monitor, null, workspace);
        }
        catch (Exception e) {
            LogUtils.log((Throwable)e);
            throw new Exception(NLS.bind((String)ProfileMessages.CRRDG9139, (Object)workspace));
        }
    }

    private static int migrateOrImport(final IProgressMonitor monitor, final IDebugProfileMigrationListener listener, String workspace) throws Exception {
        int numProfiles;
        final boolean isImporting = workspace != null;
        final IDebugProfileMigrator[] migrators = isImporting ? DebugProfileMigrationUtils.getDebugMigrators(true) : DebugProfileMigrationUtils.getDebugMigrators(false);
        int n = numProfiles = isImporting ? DebugProfileMigrationUtils.getNumberOfProfilesToImport(workspace, migrators) : DebugProfileMigrationUtils.getNumberOfProfilesToMigrate();
        if (numProfiles > 0) {
            Job j = new Job(isImporting ? "Migrating and importing debug profiles" : "Migrating debug profiles"){
                SubMonitor progress;

                protected IStatus run(final IProgressMonitor jobMonitor) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            progress = SubMonitor.convert((IProgressMonitor)(monitor == null ? jobMonitor : monitor), (int)numProfiles);
                        }
                    });
                    fNumMigratedProfiles = 0;
                    fNumImportedProfiles = 0;
                    fImportException = null;
                    IDebugProfileMigrator[] iDebugProfileMigratorArray = migrators;
                    int n = migrators.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IDebugProfileMigrator m = iDebugProfileMigratorArray[n2];
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                progress.beginTask(isImporting ? ProfileLabels.IMPORT_PROFILES : ProfileLabels.MIGRATE_PROFILES, numProfiles);
                            }
                        });
                        SubMonitor sub = this.progress.newChild(numProfiles);
                        if (isImporting) {
                            try {
                                m.importProfiles((IProgressMonitor)sub);
                            }
                            catch (Exception e) {
                                fImportException = e;
                            }
                            fNumImportedProfiles += m.getNumberOfProfilesSuccessfullyImported();
                        } else {
                            m.migrateProfiles((IProgressMonitor)sub);
                            fNumMigratedProfiles += m.getNumberOfProfilesSuccessfullyMigrated();
                        }
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                progress.worked(numProfiles);
                            }
                        });
                        ++n2;
                    }
                    this.progress.done();
                    if (monitor != null) {
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                monitor.done();
                            }
                        });
                    }
                    if (!isImporting) {
                        if (listener != null) {
                            listener.migrationComplete(DebugProfileMigrationUtils.getNumberOfProfilesToMigrate(), fNumMigratedProfiles);
                        }
                        fNumProfiles = 0;
                    }
                    return Status.OK_STATUS;
                }
            };
            j.setSystem(true);
            j.schedule();
            if (isImporting) {
                try {
                    j.join();
                }
                catch (InterruptedException e) {
                    LogUtils.log((Throwable)e);
                }
                if (fImportException != null) {
                    throw fImportException;
                }
                return fNumImportedProfiles;
            }
            return -1;
        }
        return 0;
    }

    public static int getNumberOfIMSIsolationProfilesToMigrate() {
        int numProfiles = 0;
        IDebugProfileMigrator[] iDebugProfileMigratorArray = DebugProfileMigrationUtils.getDebugMigrators(false);
        int n = iDebugProfileMigratorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDebugProfileMigrator m = iDebugProfileMigratorArray[n2];
            if (m instanceof IDebugProfileImsIsolationMigrator && ((IDebugProfileImsIsolationMigrator)((Object)m)).isMigrationNeeded()) {
                numProfiles += m.getNumberOfProfilesToMigrate();
            }
            ++n2;
        }
        return numProfiles;
    }

    public static int doIMSIsolationMigration() {
        int profilesMigrated = 0;
        NullProgressMonitor monitor = new NullProgressMonitor();
        IDebugProfileMigrator[] iDebugProfileMigratorArray = DebugProfileMigrationUtils.getDebugMigrators(false);
        int n = iDebugProfileMigratorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDebugProfileMigrator m = iDebugProfileMigratorArray[n2];
            if (m instanceof IDebugProfileImsIsolationMigrator) {
                m.migrateProfiles((IProgressMonitor)monitor);
                profilesMigrated += m.getNumberOfProfilesSuccessfullyMigrated();
            }
            ++n2;
        }
        return profilesMigrated;
    }
}

