/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.ui.profile.internal.handlers;

import com.ibm.debug.pdt.profile.internal.model.DebugProfile;
import com.ibm.debug.pdt.ui.profile.internal.Activator;
import com.ibm.debug.pdt.ui.profile.internal.ProfileLabels;
import com.ibm.debug.pdt.ui.profile.internal.handlers.AbstractProfileHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public class InactivateProfileHandler
extends AbstractProfileHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = this.getSelection(event);
        if (selection instanceof IStructuredSelection) {
            Object[] profiles;
            Object[] objectArray = profiles = ((IStructuredSelection)selection).toArray();
            int n = profiles.length;
            int n2 = 0;
            while (n2 < n) {
                Object prof = objectArray[n2];
                final DebugProfile p = (DebugProfile)prof;
                Job j = new Job(ProfileLabels.inactivate_debug_profile){

                    protected IStatus run(IProgressMonitor monitor) {
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        monitor.beginTask("", -1);
                        try {
                            p.deactivate();
                        }
                        catch (Exception e) {
                            InactivateProfileHandler.handleException(e);
                        }
                        monitor.done();
                        return Status.OK_STATUS;
                    }

                    public boolean belongsTo(Object family) {
                        if (p == family) {
                            return true;
                        }
                        return super.belongsTo(family);
                    }
                };
                Job[] jobs = Job.getJobManager().find((Object)p);
                if (jobs.length == 0) {
                    j.schedule();
                } else {
                    Activator.log(1, String.format("Request to inactivate profile (%s) ignored as a request is already being processed", p.getName()));
                }
                ++n2;
            }
        }
        return null;
    }
}

