/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.ui.profile.internal.handlers;

import com.ibm.debug.pdt.ui.profile.internal.view.DebugProfileView;
import com.ibm.debug.pdt.ui.profile.internal.view.DebugProfileViewToolTipSupport;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.PlatformUI;

abstract class AbstractTooltipHandler
extends AbstractHandler {
    private boolean fNeedsOffset;
    protected Point fOffset = null;

    AbstractTooltipHandler(boolean needsOffset) {
        this.fNeedsOffset = needsOffset;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IViewReference[] viewReferences;
        IViewReference[] iViewReferenceArray = viewReferences = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getViewReferences();
        int n = viewReferences.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference viewReference = iViewReferenceArray[n2];
            IViewPart viewPart = viewReference.getView(false);
            if (viewPart instanceof DebugProfileView) {
                DebugProfileView view = (DebugProfileView)viewPart;
                DebugProfileViewToolTipSupport tooltip = view.getTooltipSupport();
                if (this.fNeedsOffset) {
                    this.fOffset = this.getOffset(view);
                }
                this.handleTooltip(tooltip);
            }
            ++n2;
        }
        return null;
    }

    protected abstract void handleTooltip(DebugProfileViewToolTipSupport var1);

    private Point getOffset(DebugProfileView view) {
        TreeItem treeItem;
        TreeItem[] items;
        if (view.getViewer() instanceof TreeViewer && ((TreeViewer)view.getViewer()).getTree() != null && (items = ((TreeViewer)view.getViewer()).getTree().getSelection()) != null && items.length > 0 && (treeItem = items[0]) != null) {
            Rectangle bounds = treeItem.getBounds();
            return new Point(bounds.x, bounds.y);
        }
        return null;
    }
}

