/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.ui.profile.internal.handlers;

import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.profile.internal.ProfileMessages;
import com.ibm.debug.pdt.profile.internal.compatibility.BackLevelAPIServerException;
import com.ibm.debug.pdt.profile.internal.model.DebugProfile;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileException;
import com.ibm.debug.pdt.profile.internal.rest.APIServerException;
import com.ibm.debug.pdt.ui.profile.internal.Activator;
import com.ibm.debug.pdt.ui.profile.internal.ProfileLabels;
import com.ibm.debug.pdt.ui.profile.internal.ProfileUtils;
import com.ibm.debug.pdt.ui.profile.internal.editor.DebugProfileEditor;
import com.ibm.debug.pdt.ui.profile.internal.editor.ProfileEditorInput;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class AbstractProfileHandler
extends AbstractHandler {
    private static final String TAB = "\t";

    public static void handleException(final Exception e) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (e instanceof APIServerException) {
                    Activator.log(e);
                    APIServerException ase = (APIServerException)e;
                    String messageText = e instanceof BackLevelAPIServerException ? ProfileMessages.CRRDG9148 : ProfileMessages.CRRDG9116;
                    String eol = System.getProperty("line.separator");
                    String message = NLS.bind((String)messageText, (Object)(eol + AbstractProfileHandler.TAB + ase.getTarget() + eol), (Object)(eol + AbstractProfileHandler.TAB + ase.getResult()));
                    PICLDebugPlugin.showMessageDialog((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (int)1, (String)ProfileLabels.api_server_error, (String)message, (boolean)false);
                } else if (e instanceof DebugProfileException) {
                    String message = e.getMessage();
                    int level = AbstractProfileHandler.getErrorLevel(message);
                    if (level == 1) {
                        Activator.log(e);
                    }
                    String title = level == 1 ? ProfileLabels.debug_profile_error : ProfileLabels.debug_profile_message;
                    PICLDebugPlugin.showMessageDialog((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (int)level, (String)title, (String)message, (boolean)false);
                } else {
                    Activator.log(e);
                }
            }
        });
    }

    protected static int getErrorLevel(String message) {
        int idx;
        if (message.startsWith("CRRDG") && (idx = message.indexOf(32)) > 0) {
            char indicator = (message = message.substring(0, idx).trim()).charAt(message.length() - 1);
            if (indicator == 'E') {
                return 1;
            }
            if (indicator == 'I') {
                return 2;
            }
            if (indicator == 'W') {
                return 4;
            }
        }
        return 1;
    }

    protected ISelection getSelection(ExecutionEvent event) {
        ISelection selection = HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
        if (selection == null) {
            selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        }
        return selection;
    }

    protected Set<IEditorReference> getOpenEditorsForSelection(IStructuredSelection selection) {
        Object[] profiles = selection.toArray();
        HashSet<IEditorReference> references = new HashSet<IEditorReference>();
        Object[] objectArray = profiles;
        int n = profiles.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference editorRef;
            Object p = objectArray[n2];
            if (p instanceof DebugProfile && (editorRef = ProfileUtils.findOpenedEditorForProfile((DebugProfile)p)) != null) {
                references.add(editorRef);
            }
            ++n2;
        }
        return references;
    }

    protected DebugProfile[] saveOpenEditors(ISelection selection) {
        Set<IEditorReference> references;
        ArrayList<DebugProfile> results = new ArrayList<DebugProfile>();
        if (selection instanceof IStructuredSelection && (references = this.getOpenEditorsForSelection((IStructuredSelection)selection)).size() > 0) {
            HashSet<DebugProfileEditor> dirty = new HashSet<DebugProfileEditor>();
            for (IEditorReference r : references) {
                IEditorPart part = r.getEditor(true);
                if (!part.isDirty() || !(part instanceof DebugProfileEditor)) continue;
                dirty.add((DebugProfileEditor)part);
            }
            if (dirty.size() > 0 && this.showSaveEditorMessage()) {
                for (DebugProfileEditor editor : dirty) {
                    DebugProfile profile = editor.saveProfile();
                    if (profile != null) continue;
                    results.add(((ProfileEditorInput)editor.getEditorInput()).getDebugProfile());
                }
            }
        }
        return results.toArray(new DebugProfile[results.size()]);
    }

    protected boolean showSaveEditorMessage() {
        return PICLDebugPlugin.showQuestionDialog((String)ProfileLabels.profile_activate_title, (String)ProfileMessages.CRRDG9140);
    }
}

