/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.ui.profile.internal.handlers;

import com.ibm.debug.pdt.profile.internal.model.DebugProfile;
import com.ibm.debug.pdt.ui.profile.internal.Activator;
import com.ibm.debug.pdt.ui.profile.internal.IDebugProfileViewConstants;
import com.ibm.debug.pdt.ui.profile.internal.ProfileLabels;
import com.ibm.debug.pdt.ui.profile.internal.editor.DebugProfileEditor;
import com.ibm.debug.pdt.ui.profile.internal.editor.ProfileEditorInput;
import com.ibm.debug.pdt.ui.profile.internal.handlers.AbstractProfileHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

abstract class AbstractActivateProfileHandler
extends AbstractProfileHandler
implements IDebugProfileViewConstants {
    AbstractActivateProfileHandler() {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (HandlerUtil.getActivePartId((ExecutionEvent)event).equals("com.ibm.debug.pdt.idz.launches.common.profile.editor.DebugProfileEditor")) {
            this.executeEditorToolbar(event);
        } else {
            this.executeViewContextMenu(event);
        }
        return null;
    }

    private void executeEditorToolbar(ExecutionEvent event) {
        DebugProfileEditor profileEditor = (DebugProfileEditor)HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (profileEditor.saveProfile() != null) {
            DebugProfile p = profileEditor.getProfileEditorInput().getDebugProfile();
            this.activateProfile(p, profileEditor);
        }
    }

    private void executeViewContextMenu(ExecutionEvent event) {
        ISelection selection = this.getSelection(event);
        if (this.saveOpenEditors(selection).length == 0) {
            Object[] profiles;
            Object[] objectArray = profiles = ((IStructuredSelection)selection).toArray();
            int n = profiles.length;
            int n2 = 0;
            while (n2 < n) {
                Object p = objectArray[n2];
                if (p instanceof DebugProfile) {
                    DebugProfileEditor editor = this.findEditor((DebugProfile)p);
                    this.activateProfile((DebugProfile)p, editor);
                }
                ++n2;
            }
        }
    }

    private DebugProfileEditor findEditor(DebugProfile p) {
        IEditorReference[] refs = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        if (refs != null) {
            IEditorReference[] iEditorReferenceArray = refs;
            int n = refs.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference ref = iEditorReferenceArray[n2];
                try {
                    IEditorInput input = ref.getEditorInput();
                    if (input instanceof ProfileEditorInput && ((ProfileEditorInput)input).getDebugProfile().equals(p)) {
                        return (DebugProfileEditor)ref.getEditor(false);
                    }
                }
                catch (PartInitException e) {
                    Activator.log(e);
                }
                ++n2;
            }
        }
        return null;
    }

    protected abstract int getMode();

    protected void activateProfile(final DebugProfile p, final DebugProfileEditor editor) {
        String jobName = this.getMode() == 2 ? ProfileLabels.profile_activate_cc_name : ProfileLabels.profile_activate_title;
        Job j = new Job(jobName){

            protected IStatus run(IProgressMonitor monitor) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                monitor.beginTask("", -1);
                try {
                    p.activate(AbstractActivateProfileHandler.this.getMode());
                }
                catch (Exception e) {
                    AbstractActivateProfileHandler.handleException(e);
                }
                if (editor != null) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            editor.refresh();
                        }
                    });
                }
                monitor.done();
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                if (p == family) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        Job[] jobs = Job.getJobManager().find((Object)p);
        if (jobs.length == 0) {
            j.schedule();
        } else {
            Activator.log(1, String.format("Request to activate profile %s (mode:%d) ignored as a request is already being processed", p.getName(), this.getMode()));
        }
    }
}

