/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.ui.profile.internal.extensions;

import com.ibm.cics.core.comm.ExplorerSecurityHelper;
import com.ibm.debug.pdt.engine.internal.dt.Messages;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.profile.internal.LogUtils;
import com.ibm.debug.pdt.profile.internal.ProfileMessages;
import com.ibm.debug.pdt.profile.internal.compatibility.BackLevelDebugProfileClient;
import com.ibm.debug.pdt.profile.internal.compatibility.BackLevelDebugProfile_DTSP_XML;
import com.ibm.debug.pdt.profile.internal.compatibility.DebugCompatibilityMessages;
import com.ibm.debug.pdt.profile.internal.compatibility.IBackLevelProvider;
import com.ibm.debug.pdt.profile.internal.connection.Connection;
import com.ibm.debug.pdt.profile.internal.connection.ConnectionUtilities;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileDTCN;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileDTSP;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileException;
import com.ibm.debug.pdt.profile.internal.model.IDebugProfileConstants;
import com.ibm.debug.pdt.ui.profile.internal.extensions.BackLevelDebugProfile_DTCN_XML;
import com.ibm.ftt.resources.core.physical.IOSImage;
import com.ibm.ftt.resources.core.physical.IPhysicalResource;
import com.ibm.ftt.resources.core.physical.util.OperationFailedException;
import com.ibm.ftt.resources.core.physicalfactory.PhysicalSystemRegistryFactory;
import com.ibm.ftt.resources.zos.PBResourceMvsUtils;
import com.ibm.ftt.resources.zos.filesystem.MVSResource;
import com.ibm.ftt.resources.zos.zosphysical.DataSetCharacteristics;
import com.ibm.ftt.resources.zos.zosphysical.DataSetType;
import com.ibm.ftt.resources.zos.zosphysical.IDataSetCharacteristics;
import com.ibm.ftt.resources.zos.zosphysical.IZOSCatalog;
import com.ibm.ftt.resources.zos.zosphysical.IZOSDataSet;
import com.ibm.ftt.resources.zos.zosphysical.IZOSSystemImage;
import com.ibm.ftt.resources.zos.zosphysical.RecordFormat;
import com.ibm.ftt.resources.zos.zosphysical.SpaceUnits;
import com.ibm.ftt.resources.zos.zosphysical.ZOSSystemImage;
import com.ibm.ftt.resources.zos.zosphysical.impl.ZOSPhysicalResourceUtility;
import com.ibm.ftt.resources.zos.zosphysical.impl.ZOSSequentialDataSet;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.nio.charset.Charset;
import java.util.Vector;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocketFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.services.files.RemoteFileException;

public class RSEBackLevelSupport
implements IDebugProfileConstants,
IBackLevelProvider {
    private static final String GET = "GET";
    private static final String MESSAGE_PROFILE_NOT_FOUND = "Profile_Not_Found";
    private static final String MESSAGE_OK = "OK";

    private static String getValue(String fieldValue) {
        if (fieldValue == null || fieldValue.trim().equalsIgnoreCase("")) {
            return null;
        }
        return fieldValue;
    }

    private static String getEqauoptsDSN(String connectionName, String file) {
        IOSImage system;
        if (connectionName != null && (system = RSEBackLevelSupport.findSystem(connectionName)) != null && file != null) {
            String userId = ConnectionUtilities.uppercaseUserID((String)system.getUserId());
            return file.replace("&USERID", userId);
        }
        return file;
    }

    private static boolean writeOutEqauoptsFileViaRSE(DebugProfileDTSP profile) throws DebugProfileException {
        block30: {
            String systemName = RSEBackLevelSupport.getValue(profile.getConnectionName());
            String dataset = RSEBackLevelSupport.getEqauoptsDSN(systemName, RSEBackLevelSupport.getValue(profile.getLocation()));
            ZOSSequentialDataSet xmlSeqDS = null;
            IOSImage systemImage = RSEBackLevelSupport.findSystem(systemName);
            if (systemImage != null && systemImage instanceof IZOSSystemImage) {
                IZOSSystemImage zosImage = (IZOSSystemImage)systemImage;
                IZOSCatalog root = null;
                root = (IZOSCatalog)zosImage.getRoot();
                xmlSeqDS = (ZOSSequentialDataSet)root.findMember(dataset, (IProgressMonitor)new NullProgressMonitor());
                if (xmlSeqDS != null) {
                    MVSResource mvsResource = xmlSeqDS.getMvsResource();
                    IFile file = null;
                    try {
                        file = mvsResource.getFile((IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (Exception e) {
                        LogUtils.log((String)("Initial downloading to write " + mvsResource.getName() + " failed. " + e.getMessage()));
                        return false;
                    }
                    String parmFile = file.getLocation().toString();
                    BufferedWriter bufferedWriter = null;
                    FileInputStream inputStream = null;
                    try {
                        try {
                            Vector vContents = BackLevelDebugProfile_DTSP_XML.getConfigurationContents((DebugProfileDTSP)profile);
                            if (vContents.size() > 0) {
                                bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(parmFile), Charset.defaultCharset()));
                                String contents = "";
                                int i = 0;
                                while (i < vContents.size()) {
                                    if (i > 0) {
                                        bufferedWriter.newLine();
                                    }
                                    contents = (String)vContents.elementAt(i);
                                    bufferedWriter.write(contents);
                                    ++i;
                                }
                                bufferedWriter.close();
                                bufferedWriter = null;
                                inputStream = new FileInputStream(parmFile);
                                try {
                                    xmlSeqDS.create((InputStream)inputStream, true, null);
                                    break block30;
                                }
                                catch (OperationFailedException e) {
                                    LogUtils.log((String)("Creating " + xmlSeqDS.getNameWithoutExtension() + " failed. " + e.getMessage()));
                                    throw new DebugProfileException(e.getMessage());
                                }
                            }
                            throw new DebugProfileException(DebugCompatibilityMessages.CRRDG8034);
                        }
                        catch (IOException e) {
                            LogUtils.log((String)("Writing to " + xmlSeqDS.getNameWithoutExtension() + " failed. " + e.getMessage()));
                            if (bufferedWriter != null) {
                                try {
                                    bufferedWriter.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            return false;
                        }
                    }
                    finally {
                        if (bufferedWriter != null) {
                            try {
                                bufferedWriter.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
            }
        }
        return true;
    }

    public boolean backLevelWriteDebugProfile(DebugProfileDTSP profile) throws DebugProfileException {
        if (RSEBackLevelSupport.optionsFileDatasetExists(profile)) {
            if (!RSEBackLevelSupport.optionsFileIsSEQ(profile)) {
                throw new DebugProfileException(DebugCompatibilityMessages.CRRDG8011);
            }
            if (RSEBackLevelSupport.optionsFileIsMigrated(profile)) {
                throw new DebugProfileException(DebugCompatibilityMessages.CRRDG8012);
            }
        } else {
            String allocRC = RSEBackLevelSupport.allocateOptionsDataset(profile);
            if (allocRC == null || !allocRC.isEmpty() || !RSEBackLevelSupport.optionsFileDatasetExists(profile)) {
                String systemName = RSEBackLevelSupport.getValue(profile.getConnectionName());
                String eqauopts = RSEBackLevelSupport.getEqauoptsDSN(systemName, RSEBackLevelSupport.getValue(profile.getLocation()));
                throw new DebugProfileException(NLS.bind((String)DebugCompatibilityMessages.CRRDG8010, (Object[])new Object[]{eqauopts, allocRC}));
            }
        }
        return RSEBackLevelSupport.writeOutEqauoptsFileViaRSE(profile);
    }

    private static boolean optionsFileDatasetExists(DebugProfileDTSP localProfile) {
        return RSEBackLevelSupport.getOptionsFileDataset(localProfile) != null;
    }

    private static IZOSDataSet getOptionsFileDataset(DebugProfileDTSP localProfile) {
        return RSEBackLevelSupport.getOptionsFileDataset(localProfile.getConnectionName(), localProfile.getLocation());
    }

    private static IZOSDataSet getOptionsFileDataset(String connection, String location) {
        IZOSSystemImage system;
        String profileDSN;
        IZOSDataSet xmlSeqDS;
        block4: {
            xmlSeqDS = null;
            String systemName = RSEBackLevelSupport.getValue(connection);
            profileDSN = RSEBackLevelSupport.getEqauoptsDSN(systemName, RSEBackLevelSupport.getValue(location));
            IOSImage image = RSEBackLevelSupport.findSystem(systemName);
            system = (IZOSSystemImage)image;
            if (system != null && profileDSN != null) break block4;
            return null;
        }
        try {
            IZOSCatalog root = null;
            root = (IZOSCatalog)system.getRoot();
            if (root != null && (xmlSeqDS = (IZOSDataSet)root.findMember(profileDSN, (IProgressMonitor)new NullProgressMonitor())) != null) {
                return xmlSeqDS;
            }
        }
        catch (Exception e) {
            LogUtils.log((Throwable)e);
        }
        return null;
    }

    private static boolean optionsFileIsSEQ(DebugProfileDTSP localProfile) {
        IZOSDataSet xmlSeqDS = RSEBackLevelSupport.getOptionsFileDataset(localProfile);
        return xmlSeqDS instanceof ZOSSequentialDataSet;
    }

    private static boolean optionsFileIsMigrated(DebugProfileDTSP localProfile) {
        IZOSDataSet xmlSeqDS = RSEBackLevelSupport.getOptionsFileDataset(localProfile);
        return xmlSeqDS.isMigrated();
    }

    private static String allocateOptionsDataset(DebugProfileDTSP localProfile) {
        return RSEBackLevelSupport.allocateOptionsDataset(localProfile.getConnectionName(), localProfile.getLocation());
    }

    public static String allocateOptionsDataset(String connection, String location) {
        try {
            String systemName = RSEBackLevelSupport.getValue(connection);
            String dsn = RSEBackLevelSupport.getEqauoptsDSN(systemName, RSEBackLevelSupport.getValue(location));
            Path path = new Path(dsn);
            ZOSSystemImage system = PBResourceMvsUtils.findSystem((String)systemName);
            IZOSDataSet ds = (IZOSDataSet)PBResourceMvsUtils.getResource((IZOSSystemImage)system, (IPath)path, (boolean)false);
            DataSetCharacteristics characteristics = ZOSPhysicalResourceUtility.createDataSetCharacteristics();
            characteristics.setBlockSize(0);
            characteristics.setDirectoryBlocks(0);
            characteristics.setDSNType(DataSetType.get((String)"SEQ"));
            characteristics.setDSOrg("PS");
            characteristics.setRecordLength(80);
            characteristics.setVolumeSerial("");
            characteristics.setRecordFormat(RecordFormat.get((int)0));
            characteristics.setPrimaryQuantity(300);
            characteristics.setSecondaryQuantity(100);
            characteristics.setSpaceUnits(SpaceUnits.get((int)0));
            characteristics.setGenericUnit("");
            characteristics.setExpirationDate(null);
            characteristics.setManagementClass("");
            characteristics.setStorageClass("");
            characteristics.setDataClass("");
            characteristics.setExtendedAttribute("");
            characteristics.setMaxgens(0);
            ds.setCharacteristics((IDataSetCharacteristics)characteristics);
            ds.setName(dsn);
            ds.allocate((IProgressMonitor)new NullProgressMonitor());
            IZOSCatalog zosCatalog = ds.getCatalog();
            if (zosCatalog != null) {
                ds.refresh(0, (IProgressMonitor)new NullProgressMonitor());
                IPhysicalResource zRes = (IPhysicalResource)zosCatalog.findMember(ds.getFullPath());
                if (zRes != null) {
                    return "";
                }
            }
            return "rc=999";
        }
        catch (Exception e) {
            LogUtils.log((Throwable)e);
            return e.getMessage();
        }
    }

    private static IOSImage findSystem(String systemName) {
        Object[] systems = PhysicalSystemRegistryFactory.getSingleton().getSystems(2);
        IOSImage system = null;
        int i = 0;
        while (i < systems.length) {
            if (systems[i] instanceof IOSImage && ((IOSImage)systems[i]).getName().equalsIgnoreCase(systemName)) {
                return (IOSImage)systems[i];
            }
            ++i;
        }
        return system;
    }

    static boolean deleteEqauoptsFile(DebugProfileDTSP profile) throws DebugProfileException {
        String systemName = RSEBackLevelSupport.getValue(profile.getConnectionName());
        String dataset = RSEBackLevelSupport.getEqauoptsDSN(systemName, RSEBackLevelSupport.getValue(profile.getLocation()));
        ZOSSequentialDataSet xmlSeqDS = null;
        IOSImage systemImage = RSEBackLevelSupport.findSystem(systemName);
        if (systemImage != null && systemImage instanceof IZOSSystemImage) {
            IZOSSystemImage zosImage = (IZOSSystemImage)systemImage;
            IZOSCatalog root = null;
            root = (IZOSCatalog)zosImage.getRoot();
            xmlSeqDS = (ZOSSequentialDataSet)root.findMember(dataset, (IProgressMonitor)new NullProgressMonitor());
            if (xmlSeqDS != null) {
                MVSResource mvsResource = xmlSeqDS.getMvsResource();
                try {
                    mvsResource.delete(null);
                }
                catch (InterruptedException | RemoteFileException e) {
                    throw new DebugProfileException(ProfileMessages.CRRDG9152);
                }
            }
        }
        return true;
    }

    public BackLevelDebugProfileClient.Status backLevelCheckPortandSecureMode(Connection connection, Integer port) {
        HttpURLConnection httpURLConnection = null;
        if (port >= 1 && port <= 65535) {
            try {
                connection.setSecured(true);
                httpURLConnection = BackLevelDebugProfileClient.request((Connection)connection, (String)GET, null, (Integer)port);
                if (httpURLConnection.getResponseCode() == 200 && httpURLConnection.getResponseMessage().equals(MESSAGE_OK)) {
                    return BackLevelDebugProfileClient.Status.SUCCESS;
                }
                if (httpURLConnection.getResponseCode() == 404 && httpURLConnection.getResponseMessage().equals(MESSAGE_PROFILE_NOT_FOUND)) {
                    return BackLevelDebugProfileClient.Status.SUCCESS;
                }
                return BackLevelDebugProfileClient.Status.INVALID_PORT;
            }
            catch (SSLException e) {
                if (PICLDebugPlugin.showQuestionDialog((String)Messages.WARNING, (String)NLS.bind((String)ProfileMessages.CRRDG9149, (Object)connection.getHostName()))) {
                    connection.setSecured(false);
                    return BackLevelDebugProfileClient.Status.UNSECURE_MODE;
                }
                return BackLevelDebugProfileClient.Status.ERROR_SECURE_MODE;
            }
            catch (Exception e) {
                LogUtils.log((Throwable)e);
                return BackLevelDebugProfileClient.Status.INVALID_PORT;
            }
        }
        LogUtils.log((String)"port is not in the valid range or not specified.");
        return BackLevelDebugProfileClient.Status.INVALID_PORT;
    }

    public SSLSocketFactory getBacklevelSSLSocketFactory(String connectionName, String hostName) throws IOException {
        return ExplorerSecurityHelper.getSSLSocketFactory((String)connectionName, (String)hostName);
    }

    public String backLevelGetDTCNXML(DebugProfileDTCN profile) throws IOException {
        return BackLevelDebugProfile_DTCN_XML.getDTCNXML(profile);
    }

    public boolean backLevelDeleteEqauoptsFile(DebugProfileDTSP localProfile) throws DebugProfileException {
        String systemName = RSEBackLevelSupport.getValue(localProfile.getConnectionName());
        String dataset = RSEBackLevelSupport.getEqauoptsDSN(systemName, RSEBackLevelSupport.getValue(localProfile.getLocation()));
        ZOSSequentialDataSet xmlSeqDS = null;
        IOSImage systemImage = RSEBackLevelSupport.findSystem(systemName);
        if (systemImage != null && systemImage instanceof IZOSSystemImage) {
            IZOSSystemImage zosImage = (IZOSSystemImage)systemImage;
            IZOSCatalog root = null;
            root = (IZOSCatalog)zosImage.getRoot();
            xmlSeqDS = (ZOSSequentialDataSet)root.findMember(dataset, (IProgressMonitor)new NullProgressMonitor());
            if (xmlSeqDS != null) {
                MVSResource mvsResource = xmlSeqDS.getMvsResource();
                try {
                    mvsResource.delete(null);
                }
                catch (InterruptedException | RemoteFileException e) {
                    throw new DebugProfileException(ProfileMessages.CRRDG9152);
                }
            }
        }
        return true;
    }
}

