/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.ui.profile.internal.extensions;

import com.ibm.debug.daemon.CoreDaemon;
import com.ibm.debug.daemon.internal.core.DaemonCore;
import com.ibm.debug.daemon.internal.ui.PortUtility;
import com.ibm.debug.pdt.engine.internal.dt.DebugTrustManager;
import com.ibm.debug.pdt.engine.internal.dt.Messages;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.profile.internal.Labels;
import com.ibm.debug.pdt.profile.internal.LogUtils;
import com.ibm.debug.pdt.profile.internal.ProfileMessages;
import com.ibm.debug.pdt.profile.internal.configuration.IDebugProfileExtendedSupport;
import com.ibm.debug.pdt.profile.internal.connection.Connection;
import com.ibm.debug.pdt.profile.internal.connection.IConnectionInfo;
import com.ibm.debug.pdt.profile.internal.ims.IMSIsolationProfileUtils;
import com.ibm.debug.pdt.profile.internal.model.DebugProfile;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileRoot;
import com.ibm.debug.pdt.profile.internal.model.IDebugProfileConstants;
import com.ibm.debug.pdt.ui.profile.internal.extensions.DebugProfileRSEUtils;
import com.ibm.debug.pdt.ui.profile.internal.extensions.DebugProfileSynchronizer;
import com.ibm.debug.pdt.ui.profile.internal.extensions.RSEConnectionInfo;
import com.ibm.debug.pdt.ui.profile.internal.extensions.RSEEventListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.SSLException;
import javax.net.ssl.X509TrustManager;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.core.comm.ISystemKeystoreProvider;
import org.eclipse.rse.core.comm.SystemKeystoreProviderManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.PlatformUI;

public class DebugProfileUISupport
implements IDebugProfileExtendedSupport,
IDebugProfileConstants {
    private static final String DEFAULT = "DEFAULT";
    private final RSEEventListener fRSEEventListener = new RSEEventListener(){

        @Override
        public void handleEvent(Connection source, int eventType, String oldName) {
            if (eventType == 2) {
                for (DebugProfile profile : DebugProfileRoot.getInstance().getDebugProfiles()) {
                    if (!profile.getConnectionName().equalsIgnoreCase(oldName)) continue;
                    profile.setConnectionName(source.getConnectionName());
                }
            } else if (eventType == 4) {
                if (IMSIsolationProfileUtils.getIMSIsolationAPIProvider() != null) {
                    IMSIsolationProfileUtils.getIMSIsolationAPIProvider().removeConnection(source);
                }
                if (DebugProfileRoot.isDeleteProfilesRequired()) {
                    ArrayList<DebugProfile> profilesToInactivate = new ArrayList<DebugProfile>();
                    for (DebugProfile profile : DebugProfileRoot.getInstance().getDebugProfiles()) {
                        if (profile.getConnectionName() == null || !profile.getConnectionName().equalsIgnoreCase(source.getConnectionName()) || profile.getState() != 1) continue;
                        profilesToInactivate.add(profile);
                    }
                    DebugProfileRoot.deleteProfiles(profilesToInactivate);
                }
                source.clearAuthInvalidCicsRegions();
                IConnectionInfo info = source.getConnectionInfo();
                if (info instanceof RSEConnectionInfo) {
                    ((RSEConnectionInfo)info).clearJwtToken();
                }
            }
        }
    };

    public X509TrustManager getTrustManager() {
        return new DebugTrustManager();
    }

    public boolean handleSSLException(SSLException hse, X509TrustManager trustManager, Connection connection) {
        ISystemKeystoreProvider provider;
        List certs;
        if (trustManager instanceof DebugTrustManager && (certs = ((DebugTrustManager)trustManager).getUntrustedCerts()) != null && certs.size() > 0 && (provider = SystemKeystoreProviderManager.getInstance().getDefaultProvider()) != null && provider.importCertificates(certs, connection.getHostName())) {
            return true;
        }
        LogUtils.log((String)hse.getMessage());
        return false;
    }

    public boolean isDarkTheme() {
        IEclipsePreferences themePrefs = InstanceScope.INSTANCE.getNode("org.eclipse.e4.ui.css.swt.theme");
        String curTheme = themePrefs.get("themeid", DEFAULT);
        return curTheme.equals(DEFAULT) ? Display.isSystemDarkTheme() : curTheme.contains("dark");
    }

    public void profileRootStartup() {
        DebugProfileRSEUtils.getInstance().addRSEEventListener(this.fRSEEventListener);
        new DebugProfileSynchronizer();
        PlatformUI.getWorkbench().addWorkbenchListener(new IWorkbenchListener(){

            public boolean preShutdown(IWorkbench arg0, boolean arg1) {
                DebugProfileUISupport.this.dispose();
                if (DebugProfileRoot.isDeleteProfilesRequired()) {
                    DebugProfileRoot.deleteProfiles((Collection)DebugProfileRoot.getInstance().getDebugProfiles());
                }
                return true;
            }

            public void postShutdown(IWorkbench arg0) {
            }
        });
    }

    private void dispose() {
        DebugProfileRSEUtils.getInstance().removeRSEEventListener(this.fRSEEventListener);
    }

    public boolean enableSecuredDebugDaemon() {
        boolean result = false;
        if (PortUtility.secureDaemonEnabled() && !CoreDaemon.startListeningSecure()) {
            LogUtils.log((String)CoreDaemon.getErrorMessage());
        } else {
            result = DaemonCore.isListeningSecure();
        }
        if (PortUtility.uiDaemonEnabled() && !CoreDaemon.startListening()) {
            LogUtils.log((String)CoreDaemon.getErrorMessage());
        }
        return result;
    }

    public int getDaemonPort(boolean profileMode) {
        String message;
        String title = profileMode ? Labels.DEBUG_PROFILE_MESSAGE : Labels.DAEMON_PORT_MSG_TITLE;
        String string = message = profileMode ? ProfileMessages.CRRDG9145 : ProfileMessages.CRRDG9170;
        if (PICLDebugPlugin.showQuestionDialog((String)title, (String)message)) {
            return DaemonCore.getCurrentPortSecure();
        }
        return DaemonCore.getCurrentPort();
    }

    public boolean isNonSecuredAllowed(Connection connection) {
        return PICLDebugPlugin.showQuestionDialog((String)Messages.WARNING, (String)NLS.bind((String)ProfileMessages.CRRDG9141, (Object)connection.getAPIServerURL().toString()));
    }

    public boolean checkForDTCNGenericProfile(boolean isUserIDGeneric, boolean isTransactionGeneric, boolean isIPGeneric, boolean isTerminalGeneric, boolean isLoadModuleProgramGeneric) {
        if (isUserIDGeneric && isTerminalGeneric && isIPGeneric) {
            if (!isTransactionGeneric || !isLoadModuleProgramGeneric) {
                return PICLDebugPlugin.showQuestionDialog((String)Messages.WARNING, (String)ProfileMessages.CRRDG9158);
            }
            return PICLDebugPlugin.showQuestionDialog((String)Messages.WARNING, (String)ProfileMessages.CRRDG9162);
        }
        if (isLoadModuleProgramGeneric && isTransactionGeneric) {
            return PICLDebugPlugin.showQuestionDialog((String)Messages.WARNING, (String)ProfileMessages.CRRDG9160);
        }
        return true;
    }

    public boolean checkForGenericDTSPProfile(boolean isJobNameGeneric, boolean isStepNameGeneric, boolean isSubsystemNameGeneric, boolean isTransactionGeneric, boolean isGenericLoadModulePairs) {
        if (isJobNameGeneric && isStepNameGeneric && isSubsystemNameGeneric && isTransactionGeneric && isGenericLoadModulePairs) {
            return PICLDebugPlugin.showQuestionDialog((String)Messages.WARNING, (String)ProfileMessages.CRRDG9156);
        }
        return true;
    }
}

