/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.ui.profile.internal.extensions;

import com.ibm.debug.pdt.profile.internal.connection.Connection;
import com.ibm.debug.pdt.profile.internal.connection.ConnectionUtilities;
import com.ibm.debug.pdt.profile.internal.model.DebugProfile;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileDTCN;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileUtils;
import com.ibm.debug.pdt.profile.internal.model.IDebugProfileConstants;
import com.ibm.debug.pdt.profile.internal.rest.client.DebugProfileRestClientV1_DTCN_JSON;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.List;
import org.eclipse.ui.XMLMemento;

public class BackLevelDebugProfile_DTCN_XML
implements IDebugProfileConstants {
    private static final String ACTIVATION = "activation";
    private static final String CLIENTIP = "clientip";
    private static final String COMMANDFILE = "commandfile";
    private static final String COMMAREADATA = "commareadata";
    private static final String COMMAREAOFFSET = "commareaoffset";
    private static final String CONTAINERDATA = "containerdata";
    private static final String CONTAINERNAME = "containername";
    private static final String CONTAINEROFFSET = "containeroffset";
    private static final String EQAOPTSFILE = "eqaoptsfile";
    private static final String LEVEL = "level";
    private static final String LOADNAME = "loadname";
    private static final String NETNAME = "netname";
    private static final String OTHEROPTS = "otheropts";
    private static final String PGMNAME = "pgmname";
    private static final String PREFERENCEFILE = "preferencefile";
    private static final String PROFILE = "profile";
    private static final String PROFILERECORD = "profilerecord";
    private static final String PROGRAM = "program";
    private static final String PROMPTLEVEL = "promptlevel";
    private static final String PMSYSID = "pmsysid";
    private static final String PMPLATFORM = "pmplatform";
    private static final String PMAPPLICATION = "pmapplication";
    private static final String PMOPERATION = "pmoperation";
    private static final String PMAPPVERMAJ = "pmappvermaj";
    private static final String PMAPPVERMIN = "pmappvermin";
    private static final String PMAPPVERMIC = "pmappvermic";
    private static final String SESSADDR = "sessaddr";
    private static final String SESSPORT = "sessport";
    private static final String SESSTYPE = "sesstype";
    private static final String TERMINALID = "terminalid";
    private static final String TRANSACTIONID = "transactionid";
    private static final String TRIGGER = "trigger";
    private static final String URMDEB = "urmdeb";
    private static final String USERID = "userid";
    private static final String ACTIVATED = "A";
    private static final String INACTIVATED = "I";
    private static final String URM_YES = "Y";
    private static final String URM_NO = "N";
    private static final String DBM_MODE = "DBMDT";
    private static final String TCP_MODE = "TCP";
    private static final String ENCODING_UTF_8 = " encoding=\"UTF-8\"";
    private static final String UTF_8 = "UTF-8";

    public static String getDTCNXML(DebugProfileDTCN localProfile) throws IOException {
        XMLMemento profileMemento = XMLMemento.createWriteRoot((String)PROFILE);
        XMLMemento profileRecordMemento = (XMLMemento)profileMemento.createChild(PROFILERECORD);
        XMLMemento activationMemento = (XMLMemento)profileRecordMemento.createChild(ACTIVATION);
        activationMemento.putTextData(localProfile.getState() == 1 || localProfile.getState() == 4 ? ACTIVATED : INACTIVATED);
        List loadModules = localProfile.getLoadModulePairs();
        if (loadModules != null && !loadModules.isEmpty()) {
            for (DebugProfile.LoadModulePair l : loadModules) {
                XMLMemento programMemento = (XMLMemento)profileRecordMemento.createChild(PROGRAM);
                XMLMemento loadNameMemento = (XMLMemento)programMemento.createChild(LOADNAME);
                loadNameMemento.putTextData(l.getLoadModule());
                XMLMemento programNameMemento = (XMLMemento)programMemento.createChild(PGMNAME);
                programNameMemento.putTextData(l.getCompilationUnit());
            }
        } else {
            XMLMemento programMemento = (XMLMemento)profileRecordMemento.createChild(PROGRAM);
            programMemento.putTextData("");
        }
        XMLMemento transactionMemento = (XMLMemento)profileRecordMemento.createChild(TRANSACTIONID);
        transactionMemento.putTextData(BackLevelDebugProfile_DTCN_XML.getValue(localProfile.getTransaction()));
        if (localProfile.getAdditionalCICSFilters() != null) {
            XMLMemento terminalIdMemento = (XMLMemento)profileRecordMemento.createChild(TERMINALID);
            terminalIdMemento.putTextData(BackLevelDebugProfile_DTCN_XML.getValue(localProfile.getAdditionalCICSFilters().getTerminalID()));
            XMLMemento useridMemento = (XMLMemento)profileRecordMemento.createChild(USERID);
            useridMemento.putTextData(BackLevelDebugProfile_DTCN_XML.getValue(localProfile.getAdditionalCICSFilters().getUserID()));
            XMLMemento netNameMemento = (XMLMemento)profileRecordMemento.createChild(NETNAME);
            netNameMemento.putTextData(BackLevelDebugProfile_DTCN_XML.getValue(localProfile.getAdditionalCICSFilters().getNetName()));
            XMLMemento clientipMemento = (XMLMemento)profileRecordMemento.createChild(CLIENTIP);
            clientipMemento.putTextData(BackLevelDebugProfile_DTCN_XML.getValue(localProfile.getAdditionalCICSFilters().getIP()));
            XMLMemento sysidMemento = (XMLMemento)profileRecordMemento.createChild(PMSYSID);
            sysidMemento.putTextData(BackLevelDebugProfile_DTCN_XML.getValue(localProfile.getAdditionalCICSFilters().getCICSSysID()));
        }
        if (localProfile.getAdvancedProgramInterruptionCriteria() != null) {
            XMLMemento commareaOffsetMemento = (XMLMemento)profileRecordMemento.createChild(COMMAREAOFFSET);
            commareaOffsetMemento.putTextData(BackLevelDebugProfile_DTCN_XML.getValue(localProfile.getAdvancedProgramInterruptionCriteria().getCommAreaInfo().getOffset()));
            XMLMemento commareaDataMemento = (XMLMemento)profileRecordMemento.createChild(COMMAREADATA);
            commareaDataMemento.putTextData(BackLevelDebugProfile_DTCN_XML.getValue(localProfile.getAdvancedProgramInterruptionCriteria().getCommAreaInfo().getData()));
            XMLMemento containerNameMemento = (XMLMemento)profileRecordMemento.createChild(CONTAINERNAME);
            containerNameMemento.putTextData(BackLevelDebugProfile_DTCN_XML.getValue(localProfile.getAdvancedProgramInterruptionCriteria().getContainerInfo().getName()));
            XMLMemento containerOffsetMemento = (XMLMemento)profileRecordMemento.createChild(CONTAINEROFFSET);
            containerOffsetMemento.putTextData(BackLevelDebugProfile_DTCN_XML.getValue(localProfile.getAdvancedProgramInterruptionCriteria().getContainerInfo().getOffset()));
            XMLMemento containerDataMemento = (XMLMemento)profileRecordMemento.createChild(CONTAINERDATA);
            containerDataMemento.putTextData(BackLevelDebugProfile_DTCN_XML.getValue(localProfile.getAdvancedProgramInterruptionCriteria().getContainerInfo().getData()));
            XMLMemento PlatformNameMemento = (XMLMemento)profileRecordMemento.createChild(PMPLATFORM);
            PlatformNameMemento.putTextData(BackLevelDebugProfile_DTCN_XML.getValue(localProfile.getAdvancedProgramInterruptionCriteria().getApplicationInfo().getPlatformName()));
            XMLMemento ApplicationNameMemento = (XMLMemento)profileRecordMemento.createChild(PMAPPLICATION);
            ApplicationNameMemento.putTextData(BackLevelDebugProfile_DTCN_XML.getValue(localProfile.getAdvancedProgramInterruptionCriteria().getApplicationInfo().getApplicationName()));
            XMLMemento OperationNameMemento = (XMLMemento)profileRecordMemento.createChild(PMOPERATION);
            OperationNameMemento.putTextData(BackLevelDebugProfile_DTCN_XML.getValue(localProfile.getAdvancedProgramInterruptionCriteria().getApplicationInfo().getOperationName()));
            String appversion = localProfile.getAdvancedProgramInterruptionCriteria().getApplicationInfo().getApplicationVersion();
            String[] tokens = appversion.split("\\.");
            if (tokens != null && tokens.length == 3) {
                XMLMemento applicationVersionMajor = (XMLMemento)profileRecordMemento.createChild(PMAPPVERMAJ);
                applicationVersionMajor.putTextData(DebugProfileRestClientV1_DTCN_JSON.padVersion((String)tokens[0]));
                XMLMemento applicationVersionMinor = (XMLMemento)profileRecordMemento.createChild(PMAPPVERMIN);
                applicationVersionMinor.putTextData(DebugProfileRestClientV1_DTCN_JSON.padVersion((String)tokens[1]));
                XMLMemento applicationVersionMicro = (XMLMemento)profileRecordMemento.createChild(PMAPPVERMIC);
                applicationVersionMicro.putTextData(DebugProfileRestClientV1_DTCN_JSON.padVersion((String)tokens[2]));
            }
            XMLMemento URMDebuggingMemento = (XMLMemento)profileRecordMemento.createChild(URMDEB);
            URMDebuggingMemento.putTextData(localProfile.getAdvancedProgramInterruptionCriteria().isUserReplaceableModules() ? URM_YES : URM_NO);
        }
        if (localProfile.getDebuggerOptions() != null) {
            XMLMemento triggerMemento = (XMLMemento)profileRecordMemento.createChild(TRIGGER);
            triggerMemento.putTextData(BackLevelDebugProfile_DTCN_XML.getValue(localProfile.getDebuggerOptions().getTestLevel()));
            XMLMemento levelMemento = (XMLMemento)profileRecordMemento.createChild(LEVEL);
            levelMemento.putTextData(BackLevelDebugProfile_DTCN_XML.getValue(localProfile.getDebuggerOptions().getErrorLevel()));
            XMLMemento commandfileMemento = (XMLMemento)profileRecordMemento.createChild(COMMANDFILE);
            commandfileMemento.putTextData(BackLevelDebugProfile_DTCN_XML.getValue(localProfile.getDebuggerOptions().getCommandDataSet()));
            XMLMemento preferencefileMemento = (XMLMemento)profileRecordMemento.createChild(PREFERENCEFILE);
            preferencefileMemento.putTextData(BackLevelDebugProfile_DTCN_XML.getValue(localProfile.getDebuggerOptions().getPreferenceDataSet()));
            XMLMemento promptlevelMemento = (XMLMemento)profileRecordMemento.createChild(PROMPTLEVEL);
            promptlevelMemento.putTextData(BackLevelDebugProfile_DTCN_XML.getValue(localProfile.getDebuggerOptions().getPromptLevel()));
            XMLMemento eqaoptsfileMemento = (XMLMemento)profileRecordMemento.createChild(EQAOPTSFILE);
            eqaoptsfileMemento.putTextData(BackLevelDebugProfile_DTCN_XML.getValue(localProfile.getDebuggerOptions().getEqaOptsFile()));
            XMLMemento otheroptsMemento = (XMLMemento)profileRecordMemento.createChild(OTHEROPTS);
            otheroptsMemento.putTextData(DebugProfileUtils.getUpdatedLEOptions((DebugProfile)localProfile, (boolean)true));
        }
        XMLMemento sesstypeMemento = (XMLMemento)profileRecordMemento.createChild(SESSTYPE);
        XMLMemento sessaddrMemento = (XMLMemento)profileRecordMemento.createChild(SESSADDR);
        XMLMemento sessportMemento = (XMLMemento)profileRecordMemento.createChild(SESSPORT);
        if (localProfile.getAdvancedConnectionOptions() != null) {
            String userField = BackLevelDebugProfile_DTCN_XML.getValue(localProfile.getAdvancedConnectionOptions().getUserID());
            String ipField = BackLevelDebugProfile_DTCN_XML.getValue(localProfile.getAdvancedConnectionOptions().getIP());
            String portField = BackLevelDebugProfile_DTCN_XML.getValue(localProfile.getAdvancedConnectionOptions().getPort());
            if (userField != null && !userField.isEmpty()) {
                sesstypeMemento.putTextData(DBM_MODE);
                sessaddrMemento.putTextData(userField);
                sessportMemento.putTextData("");
            } else if (ipField != null && !ipField.isEmpty() || portField != null && !portField.isEmpty()) {
                sesstypeMemento.putTextData(TCP_MODE);
                sessaddrMemento.putTextData(ipField);
                sessportMemento.putTextData(portField);
            }
        }
        if (sesstypeMemento.getTextData() == null) {
            Connection connection = ConnectionUtilities.getConnection((String)localProfile.getConnectionName(), (boolean)true);
            if (connection.isUsingDBM()) {
                connection.getLocalClientPort();
                sesstypeMemento.putTextData(DBM_MODE);
                sessaddrMemento.putTextData(connection.getUserId());
                sessportMemento.putTextData("");
            } else {
                sesstypeMemento.putTextData(TCP_MODE);
                sessaddrMemento.putTextData(connection.getLocalClientIP());
                sessportMemento.putTextData(connection.getLocalClientPort());
            }
        }
        StringWriter writer = new StringWriter();
        profileMemento.save((Writer)writer);
        String profileString = writer.toString();
        profileString = profileString.replaceFirst(ENCODING_UTF_8, "");
        profileString = URLEncoder.encode(profileString, UTF_8);
        return profileString;
    }

    public static String getValue(String fieldValue) {
        if (fieldValue == null || fieldValue.trim().isEmpty()) {
            return "";
        }
        return fieldValue;
    }
}

