/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.ui.profile.internal.editor;

import com.ibm.debug.pdt.profile.internal.model.IDebugProfileConstants;
import com.ibm.debug.pdt.ui.profile.internal.editor.IDebugProfileEditorConstants;
import com.ibm.debug.pdt.ui.profile.internal.editor.SessionSourceProvider;
import com.ibm.ftt.debug.ui.composites.dlydbg.DelayDebugComposite;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.IMessagePrefixProvider;
import org.eclipse.ui.services.ISourceProviderService;

public class MessageManagerHelper
implements IDebugProfileEditorConstants,
IDebugProfileConstants {
    private static final String ERROR = "PROFILE_ERROR";
    private static final String INFO = "PROFILE_INFO";
    private static final String MESSAGE_KEY_PREFIX = "";
    private static final String MSG_NEWLINE = "\n";
    private static final int NEW_LINE_LOCATION = 80;
    private static final String ACCESSIBLE_KEY = "accessible";
    private int messageCount;
    private IMessageManager manager;

    public MessageManagerHelper(IMessageManager manager) {
        this.manager = manager;
        this.manager.setMessagePrefixProvider(new IMessagePrefixProvider(){

            public String getPrefix(Control c) {
                Object prefix = (String)c.getData("profile_editor_message_prefix");
                if (prefix != null) {
                    if (!((String)prefix).endsWith(":")) {
                        prefix = (String)prefix + ":";
                    }
                    return (String)prefix + " ";
                }
                Composite parent = c.getParent();
                Control[] siblings = parent.getChildren();
                int i = 0;
                while (i < siblings.length) {
                    if (siblings[i] == c) {
                        int j = i - 1;
                        while (j >= 0) {
                            Control label = siblings[j];
                            Object ltext = null;
                            if (label instanceof Label) {
                                ltext = ((Label)label).getText();
                            }
                            if (ltext != null) {
                                if (!((String)ltext).endsWith(":")) {
                                    ltext = (String)ltext + ":";
                                }
                                return (String)ltext + " ";
                            }
                            --j;
                        }
                        break;
                    }
                    ++i;
                }
                return null;
            }
        });
    }

    public void displayErrorMessage(String message, Control control) {
        if (control instanceof DelayDebugComposite) {
            control = ((DelayDebugComposite)control).getTableControl();
        }
        message = this.clean(message);
        this.manager.addMessage((Object)this.getMessageKey(), message, null, 3, control);
        control.setData(ERROR, (Object)true);
        this.setAccessibleMessage(control, message);
    }

    public void displayWarningMessage(String message, Control control) {
        if (control instanceof DelayDebugComposite) {
            control = ((DelayDebugComposite)control).getTableControl();
        }
        message = this.clean(message);
        this.manager.addMessage((Object)this.getMessageKey(), message, null, 2, control);
        this.setAccessibleMessage(control, message);
    }

    public void displayInfoMessage(String message, Control control) {
        if (control instanceof DelayDebugComposite) {
            control = ((DelayDebugComposite)control).getTableControl();
        }
        message = this.clean(message);
        this.manager.addMessage((Object)this.getMessageKey(), message, null, 1, control);
        control.setData(INFO, (Object)true);
        this.setAccessibleMessage(control, message);
    }

    public boolean hasErrorMessage(Control control) {
        return control.getData(ERROR) == null ? false : (Boolean)control.getData(ERROR);
    }

    public boolean hasInfoMessage(Control control) {
        return control.getData(INFO) == null ? false : (Boolean)control.getData(INFO);
    }

    protected String getMessageKey() {
        return MESSAGE_KEY_PREFIX + ++this.messageCount;
    }

    public void clearMessages(Control control) {
        if (control instanceof DelayDebugComposite) {
            control = ((DelayDebugComposite)control).getTableControl();
        }
        this.manager.removeMessages(control);
        control.setData(ERROR, (Object)false);
        control.setData(INFO, (Object)false);
        this.setAccessibleMessage(control, null);
    }

    public void updateSessionState(int messageType) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null) {
            IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
            IWorkbench serviceLocator = PlatformUI.getWorkbench();
            ISourceProviderService service = (ISourceProviderService)serviceLocator.getService(ISourceProviderService.class);
            SessionSourceProvider sessionProvider = (SessionSourceProvider)service.getSourceProvider("sessionState");
            sessionProvider.setEnabled(messageType != 3);
            ICommandService commandService = (ICommandService)window.getService(ICommandService.class);
            if (commandService != null) {
                commandService.refreshElements("com.ibm.debug.pdt.ui.profile.eclipse.command.saveAndActivateDebugProfile", null);
                commandService.refreshElements("com.ibm.debug.pdt.ui.profile.eclipse.command.saveAndActivateCCProfile", null);
            }
        }
    }

    protected void updateCCSessionState(boolean state) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null) {
            IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
            IWorkbench serviceLocator = PlatformUI.getWorkbench();
            ISourceProviderService service = (ISourceProviderService)serviceLocator.getService(ISourceProviderService.class);
            SessionSourceProvider sessionProvider = (SessionSourceProvider)service.getSourceProvider("cc_sessionState");
            sessionProvider.setCCEnabled(state);
            ICommandService commandService = (ICommandService)window.getService(ICommandService.class);
            if (commandService != null) {
                commandService.refreshElements("com.ibm.debug.pdt.ui.profile.eclipse.command.saveAndActivateDebugProfile", null);
                commandService.refreshElements("com.ibm.debug.pdt.ui.profile.eclipse.command.saveAndActivateCCProfile", null);
            }
        }
    }

    private String clean(String message) {
        StringBuilder cleanmsg = new StringBuilder(message);
        int i = 80;
        while (i < cleanmsg.length()) {
            int newLine = cleanmsg.lastIndexOf(MSG_NEWLINE, i);
            if (newLine >= i - 80 && newLine > i - 80) {
                i = newLine + MSG_NEWLINE.length();
            } else {
                int blank = cleanmsg.lastIndexOf(" ", i);
                if (blank >= i - 80) {
                    cleanmsg.insert(blank + 1, MSG_NEWLINE);
                    i = blank + 1 + MSG_NEWLINE.length();
                } else {
                    blank = cleanmsg.indexOf(" ", i);
                    if (blank >= -1) {
                        cleanmsg.insert(blank + 1, MSG_NEWLINE);
                        i = blank + 1 + MSG_NEWLINE.length();
                    }
                }
            }
            i += 80;
        }
        return cleanmsg.toString();
    }

    private void setAccessibleMessage(Control control, String message) {
        AccessibleMessages listener = (AccessibleMessages)control.getData(ACCESSIBLE_KEY);
        if (listener == null) {
            listener = new AccessibleMessages();
            control.setData(ACCESSIBLE_KEY, (Object)listener);
            control.getAccessible().addAccessibleListener((AccessibleListener)listener);
        }
        listener.fMessage = message;
    }

    private static class AccessibleMessages
    implements AccessibleListener {
        String fMessage = null;

        private AccessibleMessages() {
        }

        public void getName(AccessibleEvent e) {
            if (this.fMessage != null) {
                e.result = this.fMessage + " " + e.result;
            }
        }

        public void getHelp(AccessibleEvent e) {
        }

        public void getKeyboardShortcut(AccessibleEvent e) {
        }

        public void getDescription(AccessibleEvent e) {
        }
    }
}

