/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.ui.profile.internal.dialogs;

import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.profile.internal.ProfileMessages;
import com.ibm.debug.pdt.ui.profile.internal.ProfileLabels;
import com.ibm.debug.pdt.ui.profile.internal.editor.ims.IMSIsolationProfileUtils;
import java.io.File;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

class ImportProfilesWizardPage
extends WizardPage
implements SelectionListener,
ModifyListener {
    private Button fJsonFormat;
    private Label fJsonLabel;
    private Text fJsonText;
    private Button fJsonBrowse;
    private Button fWorkspaceFormat;
    private Label fWorkspaceLabel;
    private Text fWorkspaceText;
    private Button fWorkspaceBrowse;
    private String fDefaultJsonPath;
    private String fDefaultWorkspacePath;

    ImportProfilesWizardPage(String defaultJsonPath, String defaultWorkspacePath) {
        super(ProfileLabels.import_debug_profiles, ProfileLabels.import_debug_profiles, PICLUtils.getImageDescriptor((String)"PICL_ICON_BREAKPOINT_WIZARD"));
        this.setDescription(ProfileLabels.import_description);
        this.fDefaultJsonPath = defaultJsonPath;
        this.fDefaultWorkspacePath = defaultWorkspacePath;
    }

    public void createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().numColumns(4).applyTo(main);
        this.setControl((Control)main);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)main, "com.ibm.debug.pdt.ui.profile.eclipse.import_profiles");
        this.fJsonFormat = new Button(main, 16);
        boolean isIMS = IMSIsolationProfileUtils.getIMSIsolationUIProvider() != null;
        this.fJsonFormat.setText(isIMS ? ProfileLabels.import_new_profiles_IMS : ProfileLabels.import_new_profiles);
        GridDataFactory.fillDefaults().span(4, 1).applyTo((Control)this.fJsonFormat);
        this.fJsonFormat.addSelectionListener((SelectionListener)this);
        new Label(main, 0);
        this.fJsonLabel = new Label(main, 0);
        this.fJsonLabel.setText(ProfileLabels.export_file);
        GridDataFactory.fillDefaults().indent(15, 0).align(1, 0x1000000).applyTo((Control)this.fJsonLabel);
        this.fJsonText = new Text(main, 2048);
        this.fJsonText.addModifyListener((ModifyListener)this);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fJsonText);
        this.fJsonBrowse = new Button(main, 0);
        this.fJsonBrowse.setText(ProfileLabels.editor_browse_button_label);
        this.fJsonBrowse.addSelectionListener((SelectionListener)this);
        GridDataFactory.fillDefaults().span(4, 1).applyTo((Control)new Label(main, 0));
        this.fWorkspaceFormat = new Button(main, 16);
        this.fWorkspaceFormat.setText(ProfileLabels.import_old_configs);
        GridDataFactory.fillDefaults().span(4, 1).applyTo((Control)this.fWorkspaceFormat);
        this.fWorkspaceFormat.addSelectionListener((SelectionListener)this);
        new Label(main, 0);
        this.fWorkspaceLabel = new Label(main, 0);
        this.fWorkspaceLabel.setText(ProfileLabels.import_workspace);
        GridDataFactory.fillDefaults().indent(15, 0).align(1, 0x1000000).applyTo((Control)this.fWorkspaceLabel);
        this.fWorkspaceText = new Text(main, 2048);
        this.fWorkspaceText.addModifyListener((ModifyListener)this);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fWorkspaceText);
        this.fWorkspaceBrowse = new Button(main, 0);
        this.fWorkspaceBrowse.setText(ProfileLabels.editor_browse_button_label);
        this.fWorkspaceBrowse.addSelectionListener((SelectionListener)this);
        if (this.fDefaultJsonPath != null) {
            this.fJsonText.setText(this.fDefaultJsonPath);
        }
        if (this.fDefaultWorkspacePath != null) {
            this.fWorkspaceText.setText(this.fDefaultWorkspacePath);
        }
        this.fJsonFormat.setSelection(true);
        this.fJsonText.setFocus();
        if (this.fDefaultJsonPath != null) {
            this.validateJsonFile();
        }
        this.updateFields();
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.widget == this.fJsonBrowse) {
            this.handleBrowseExportFile();
        }
        if (event.widget == this.fWorkspaceBrowse) {
            this.handleBrowseWorkspace();
        } else {
            this.updateFields();
            if (this.fJsonFormat.getSelection()) {
                this.validateJsonFile();
            } else {
                this.validateWorkspaceDirectory();
            }
        }
    }

    private void handleBrowseWorkspace() {
        String result;
        DirectoryDialog dialog = new DirectoryDialog(this.getShell(), 4096);
        dialog.setMessage(ProfileLabels.import_browse_ws_prompt);
        dialog.setText(ProfileLabels.import_browse_ws_title);
        if (!this.fWorkspaceText.getText().isEmpty()) {
            dialog.setFilterPath(this.fWorkspaceText.getText());
        }
        if ((result = dialog.open()) != null) {
            this.fWorkspaceText.setText(result);
        }
    }

    private void handleBrowseExportFile() {
        String result;
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        dialog.setFilterExtensions(new String[]{"*.json"});
        dialog.setFilterNames(new String[]{NLS.bind((String)"DebugProfiles{0}.json", (Object)"*")});
        dialog.setText(ProfileLabels.import_browse_json_title);
        if (!this.fJsonText.getText().isEmpty()) {
            dialog.setFilterPath(this.fJsonText.getText());
        }
        if ((result = dialog.open()) != null) {
            this.fJsonText.setText(result);
        }
    }

    private void updateFields() {
        this.fJsonLabel.setEnabled(this.fJsonFormat.getSelection());
        this.fJsonText.setEnabled(this.fJsonFormat.getSelection());
        this.fJsonBrowse.setEnabled(this.fJsonFormat.getSelection());
        this.fWorkspaceLabel.setEnabled(this.fWorkspaceFormat.getSelection());
        this.fWorkspaceText.setEnabled(this.fWorkspaceFormat.getSelection());
        this.fWorkspaceBrowse.setEnabled(this.fWorkspaceFormat.getSelection());
    }

    public void modifyText(ModifyEvent event) {
        if (event.widget == this.fJsonText) {
            this.validateJsonFile();
        } else if (event.widget == this.fWorkspaceText) {
            this.validateWorkspaceDirectory();
        }
    }

    private void validateWorkspaceDirectory() {
        this.setErrorMessage(null);
        String directory = this.fWorkspaceText.getText();
        if (!directory.trim().isEmpty()) {
            File f = new File(directory.trim());
            if (!f.exists() || !f.isDirectory()) {
                this.setErrorMessage(NLS.bind((String)ProfileMessages.CRRDG9138, (Object)directory));
            } else {
                this.setPageComplete(true);
                return;
            }
        }
        this.setPageComplete(false);
    }

    private void validateJsonFile() {
        this.setErrorMessage(null);
        String fileName = this.fJsonText.getText();
        if (!fileName.trim().isEmpty()) {
            File f = new File(fileName.trim());
            if (!f.exists() || f.isDirectory()) {
                this.setErrorMessage(NLS.bind((String)ProfileMessages.CRRDG9136, (Object)fileName));
            } else {
                this.setPageComplete(true);
                return;
            }
        }
        this.setPageComplete(false);
    }

    public boolean isDebugProfileFile() {
        return this.fJsonFormat.getSelection();
    }

    public String getImportLocation() {
        return this.fJsonFormat.getSelection() ? this.fJsonText.getText() : this.fWorkspaceText.getText();
    }
}

