/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.ui.profile.internal.dialogs;

import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.profile.internal.ProfileMessages;
import com.ibm.debug.pdt.ui.profile.internal.ProfileLabels;
import java.io.File;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

class ExportProfilesWizardPage
extends WizardPage {
    private Text fText;
    private Button fBrowse;
    private String fDefaultDirectory;

    ExportProfilesWizardPage(String defaultDirectory) {
        super(ProfileLabels.export_debug_profiles, ProfileLabels.export_debug_profiles, PICLUtils.getImageDescriptor((String)"PICL_ICON_BREAKPOINT_WIZARD"));
        this.setDescription(ProfileLabels.export_description);
        this.fDefaultDirectory = defaultDirectory;
    }

    public void createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)main, "com.ibm.debug.pdt.ui.profile.eclipse.export_profiles");
        GridLayoutFactory.swtDefaults().numColumns(3).applyTo(main);
        this.setControl((Control)main);
        Label l = new Label(main, 0);
        l.setText(ProfileLabels.export_directory);
        this.fText = new Text(main, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fText);
        this.fText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                ExportProfilesWizardPage.this.validateDirectory();
            }
        });
        this.fBrowse = new Button(main, 8);
        this.fBrowse.setText(ProfileLabels.editor_browse_button_label);
        this.fBrowse.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                ExportProfilesWizardPage.this.handleBrowsePressed();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                ExportProfilesWizardPage.this.handleBrowsePressed();
            }
        });
        if (this.fDefaultDirectory != null) {
            this.fText.setText(this.fDefaultDirectory);
        }
        this.validateDirectory();
    }

    protected void validateDirectory() {
        this.setErrorMessage(null);
        String fileName = this.fText.getText();
        if (!fileName.trim().isEmpty()) {
            File f = new File(fileName.trim());
            if (!f.exists() || !f.isDirectory()) {
                this.setErrorMessage(NLS.bind((String)ProfileMessages.CRRDG9130, (Object)fileName));
            } else {
                this.setPageComplete(true);
                return;
            }
        }
        this.setPageComplete(false);
    }

    protected void handleBrowsePressed() {
        String result;
        DirectoryDialog dialog = new DirectoryDialog(this.getShell(), 4096);
        dialog.setMessage(ProfileLabels.export_browse_prompt);
        dialog.setText(ProfileLabels.export_browse_title);
        if (!this.fText.getText().isEmpty()) {
            dialog.setFilterPath(this.fText.getText());
        }
        if ((result = dialog.open()) != null) {
            this.fText.setText(result);
        }
    }

    public String getExportDirectory() {
        return this.fText.getText();
    }
}

