/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.ui.profile.internal.dialogs;

import com.ibm.debug.pdt.ui.profile.internal.ProfileLabels;
import com.ibm.debug.pdt.ui.profile.internal.extensions.RSEConnectionInfo;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ConfigureAPIServerConnectionDialog
extends StatusDialog {
    private static final String SLASH = "/";
    protected RSEConnectionInfo connection;
    protected Text contextRootText;
    protected Text portText;
    protected Button securedButton;
    protected Text urlText;

    public ConfigureAPIServerConnectionDialog(Shell parent, RSEConnectionInfo connection) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setTitle(ProfileLabels.api_server_manual_config_dialog_title);
        this.connection = connection;
    }

    protected Control createDialogArea(Composite ancestor) {
        Composite parent = new Composite(ancestor, 0);
        parent.setLayout((Layout)new GridLayout(3, false));
        GridData parentSpec = new GridData();
        parentSpec.grabExcessVerticalSpace = false;
        parentSpec.grabExcessHorizontalSpace = true;
        parentSpec.horizontalAlignment = 4;
        parentSpec.verticalAlignment = 2;
        parent.setLayoutData((Object)parentSpec);
        GridData spec1 = new GridData();
        spec1.grabExcessVerticalSpace = false;
        spec1.grabExcessHorizontalSpace = true;
        spec1.horizontalAlignment = 4;
        spec1.verticalAlignment = 1;
        spec1.horizontalSpan = 2;
        ModifyListener l = new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                ConfigureAPIServerConnectionDialog.this.urlText.setText(ConfigureAPIServerConnectionDialog.this.constructURL());
            }
        };
        Label contextRootLabel = new Label(parent, 0);
        contextRootLabel.setText(ProfileLabels.api_server_manual_config_dialog_contextroot);
        this.contextRootText = new Text(parent, 2048);
        this.contextRootText.setLayoutData((Object)spec1);
        this.contextRootText.addModifyListener(l);
        Label portLabel = new Label(parent, 0);
        portLabel.setText(ProfileLabels.api_server_manual_config_dialog_port);
        this.portText = new Text(parent, 2048);
        this.portText.setLayoutData((Object)spec1);
        this.portText.addModifyListener(l);
        GridData spec2 = new GridData();
        spec2.grabExcessVerticalSpace = false;
        spec2.grabExcessHorizontalSpace = true;
        spec2.horizontalAlignment = 4;
        spec2.verticalAlignment = 1;
        spec2.horizontalSpan = 3;
        this.securedButton = new Button(parent, 32);
        this.securedButton.setText(ProfileLabels.api_server_manual_config_dialog_secure);
        this.securedButton.setLayoutData((Object)spec2);
        this.securedButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                ConfigureAPIServerConnectionDialog.this.urlText.setText(ConfigureAPIServerConnectionDialog.this.constructURL());
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        new Label(parent, 0).setLayoutData((Object)spec2);
        this.urlText = new Text(parent, 2056);
        this.urlText.setLayoutData((Object)spec2);
        this.urlText.setText(this.constructURL());
        ConfigureAPIServerConnectionDialog.applyDialogFont((Control)parent);
        return parent;
    }

    private String constructURL() {
        try {
            Object http_context_root;
            int port = -1;
            try {
                port = Integer.parseInt(this.portText.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            String scheme = "http";
            if (this.securedButton.getSelection()) {
                scheme = "https";
            }
            if (!((String)(http_context_root = this.contextRootText.getText())).startsWith(SLASH)) {
                http_context_root = SLASH + (String)http_context_root;
            }
            return new URI(scheme, null, this.connection.getHostName(), port, (String)http_context_root, null, null).toASCIIString();
        }
        catch (URISyntaxException e) {
            return "";
        }
    }

    protected void okPressed() {
        super.okPressed();
    }
}

