/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.ui.resultsview;

import com.ibm.debug.pdt.codecoverage.internal.ui.CLCoverageUIPlugin;
import com.ibm.debug.pdt.codecoverage.internal.ui.Labels;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.CLCoverageZip;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.ICCResultsView;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultAdapter;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultCCZipContentProvider;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultContentProvider;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultContentProviderWithStatusConfig;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultLocation;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultSource;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.LocalResultLocation;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.ResultAdapter;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.ZipResultAdapter;
import com.ibm.debug.pdt.internal.ui.EditorMapping;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipFile;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.osgi.framework.Bundle;

public class ResultsViewContentProvider
implements IResultCCZipContentProvider,
IResultContentProviderWithStatusConfig,
IResultSource,
IAdaptable {
    private static final String COMPONENT_ID = "CCResultSource.componentfile";
    private static final IPropertyDescriptor[] EMPTY_PROPERTIES = new IPropertyDescriptor[0];
    private static final Object fLocationLock = new Object();
    private static IResultLocation fDefaultLocation = null;

    public boolean isResultHandled(String locationPath) {
        if (locationPath.endsWith(".zip")) {
            return this.checkZip(locationPath);
        }
        return this.isSupportedFileName(locationPath);
    }

    private boolean checkZip(String locationPath) {
        File file = new File(locationPath);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (ZipFile zFile = new ZipFile(file);){
                return CLCoverageZip.isValidCoverageZip((ZipFile)zFile);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            CLCoverageUIPlugin.log(e);
            return false;
        }
    }

    public boolean isSupportedFileName(String fileName) {
        Path p = new Path(fileName);
        String extension = p.getFileExtension();
        return extension != null && (extension.equalsIgnoreCase("clcoveragedata") || extension.equalsIgnoreCase("zip"));
    }

    public IResultAdapter getResultAdapter(String locationPath) {
        Path path = new Path(locationPath);
        String extension = path.getFileExtension();
        if (extension.equalsIgnoreCase("clcoveragedata")) {
            return new ResultAdapter(this.getLocationPath(locationPath));
        }
        if (extension.equalsIgnoreCase("zip")) {
            return new ZipResultAdapter(locationPath);
        }
        return null;
    }

    private String getLocationPath(String resultFilePath) {
        if (resultFilePath != null) {
            File result = new File(resultFilePath);
            String parentName = result.getParentFile().getName();
            String resultName = result.getName();
            if (resultName.toLowerCase().endsWith("clcoveragedata".toLowerCase())) {
                resultName = resultName.substring(0, resultName.length() - ".clcoveragedata".length());
            }
            if (resultName.equalsIgnoreCase(parentName)) {
                return result.getParent();
            }
        }
        return resultFilePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IResultLocation[] getDefaultLocations() {
        Object object = fLocationLock;
        synchronized (object) {
            if (fDefaultLocation == null) {
                Bundle bundle = Platform.getBundle((String)"com.ibm.debug.pdt.codecoverage.core");
                if (bundle == null) {
                    return new IResultLocation[0];
                }
                IPath localResultFolder = Platform.getStateLocation((Bundle)bundle);
                fDefaultLocation = new LocalResultLocation(localResultFolder.toOSString(), Labels.LOCAL_DEFAULT, true, (IResultContentProvider)this){

                    public Image getImage() {
                        return CLCoverageUIPlugin.getImage("icons/obj16/workspace.png");
                    }

                    public int getPriority() {
                        return 1;
                    }
                };
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        fDefaultLocation.refreshResults();
                    }
                });
            }
        }
        return new IResultLocation[]{fDefaultLocation};
    }

    public IResultAdapter getResultAdapter(IWorkbenchPart part) {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors(IResultAdapter fAdapter) {
        return EMPTY_PROPERTIES;
    }

    public Object getPropertyValue(IResultAdapter adapter, Object id) {
        if (adapter instanceof ResultAdapter) {
            ResultAdapter rAdapter = (ResultAdapter)adapter;
            if (id.equals(COMPONENT_ID)) {
                return rAdapter.getComponentMapFileName();
            }
        }
        return null;
    }

    public void initialize(ICCResultsView view) {
    }

    public void dispose() {
    }

    public Map<String, IPreferencePage> getPreferencePages() {
        HashMap<String, IPreferencePage> preferencesMap = new HashMap<String, IPreferencePage>();
        return preferencesMap;
    }

    public IHandler getImportHandler(IResultLocation resultLocation) {
        return null;
    }

    public boolean isEngineHandled(String engineKey) {
        return engineKey != null && engineKey.length() == 3;
    }

    public String getEditorId(String file, String engineKey) {
        String editorId = null;
        try {
            editorId = IDE.getEditorDescriptor((String)file, (boolean)true, (boolean)false).getId();
            if (engineKey != null) {
                editorId = EditorMapping.getMappedEditorId((String)editorId, (String)engineKey);
            }
        }
        catch (PartInitException e) {
            CLCoverageUIPlugin.log(e);
        }
        return editorId;
    }

    public void setDefaultOpenMode(String commandId, String mode) {
    }

    public String getPluginId() {
        return "com.ibm.debug.pdt.codecoverage.ui.view.compiled";
    }

    public boolean isStatusColumnSupported() {
        return true;
    }

    public Object getAdapter(Class classObj) {
        Object result = Platform.getAdapterManager().getAdapter((Object)this, classObj);
        if (result == null) {
            result = Platform.getAdapterManager().loadAdapter((Object)this, classObj.getName());
        }
        return result;
    }

    public boolean isCCZipResultHandled(String locationPath) {
        return this.checkZip(locationPath);
    }

    public IResultAdapter getCCZipResult(String locationPath) {
        return new ZipResultAdapter(locationPath);
    }
}

