/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.samples;

import com.ibm.lpex.core.LpexCommand;
import com.ibm.lpex.core.LpexResources;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.LpexView;
import com.ibm.lpex.core.LpexWindow;
import com.ibm.lpex.samples.Syncher;
import java.util.ArrayList;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class SyncCommand
implements LpexCommand {
    static LpexView[] _lpexViews;
    static String[] _lpexViewNames;
    static LpexCommand doSyncCommand;

    static {
        doSyncCommand = new LpexCommand(){

            @Override
            public boolean doCommand(LpexView lpexView, String parameters) {
                LpexView selectedView = SyncCommand.getSelectedView(parameters);
                if (selectedView == null) {
                    lpexView.doCommand("set messageText Selected view not found.");
                } else if (selectedView == lpexView) {
                    lpexView.doCommand("set messageText Current view is already sync-ed to itself.");
                } else if (selectedView.isDisposed()) {
                    lpexView.doCommand("set messageText Selected view has been meanwhile disposed.");
                    if (SyncCommand.findLpexViews()) {
                        SyncCommand.prompt(lpexView);
                        return false;
                    }
                } else {
                    Syncher.install(lpexView, selectedView);
                }
                _lpexViews = null;
                _lpexViewNames = null;
                return true;
            }
        };
    }

    @Override
    public boolean doCommand(LpexView lpexView, String parameters) {
        if (lpexView != null) {
            if ((parameters = parameters.trim()).length() != 0) {
                if ("off".equals(parameters)) {
                    Syncher.uninstall(lpexView);
                    return true;
                }
                if ("?".equals(parameters)) {
                    lpexView.doCommand("set messageText Syntax: sync [on | off]");
                    return true;
                }
                if (!"on".equals(parameters)) {
                    lpexView.doCommand("set messageText " + parameters + " is not a valid parameter for the \"sync\" command.");
                    return false;
                }
            }
            if (!SyncCommand.findLpexViews()) {
                lpexView.doCommand("set messageText There are no views to sync.");
                return true;
            }
            if (lpexView.command("doSync") != doSyncCommand) {
                lpexView.defineCommand("doSync", doSyncCommand);
            }
            SyncCommand.prompt(lpexView);
        }
        return true;
    }

    static void prompt(LpexView currentLpexView) {
        StringBuilder selections = new StringBuilder(512);
        int i = 0;
        while (i < _lpexViews.length) {
            if (_lpexViews[i] != currentLpexView) {
                if (selections.length() != 0) {
                    selections.append('\u0000');
                }
                selections.append(_lpexViewNames[i]);
            }
            ++i;
        }
        StringBuilder cmd = new StringBuilder(512);
        cmd.append("input ").append(LpexStringTokenizer.addQuotes("Select (up/down) a view to sync:")).append(' ').append(LpexStringTokenizer.addQuotes(selections.toString())).append(' ').append(LpexStringTokenizer.addQuotes("doSync "));
        LpexView.doGlobalCommand("set status");
        currentLpexView.doCommand(cmd.toString());
    }

    static boolean findLpexViews() {
        Display display = Display.getCurrent();
        if (display == null) {
            return false;
        }
        ArrayList<LpexView> views = new ArrayList<LpexView>();
        SyncCommand.addLpexViews((Control[])display.getShells(), views);
        int viewsCount = views.size();
        if (viewsCount <= 1) {
            return false;
        }
        _lpexViews = views.toArray(new LpexView[viewsCount]);
        _lpexViewNames = new String[viewsCount];
        int i = 0;
        while (i < viewsCount) {
            SyncCommand._lpexViewNames[i] = SyncCommand.getViewName(_lpexViews[i]);
            ++i;
        }
        return true;
    }

    static void addLpexViews(Control[] controls, ArrayList<LpexView> views) {
        int i = 0;
        while (i < controls.length) {
            if (controls[i] instanceof LpexWindow) {
                LpexView lpexView = ((LpexWindow)controls[i]).getLpexView();
                if (lpexView != null) {
                    views.add(lpexView);
                }
            } else if (controls[i] instanceof Composite) {
                SyncCommand.addLpexViews(((Composite)controls[i]).getChildren(), views);
            }
            ++i;
        }
    }

    static String getViewName(LpexView lpexView) {
        Object name = lpexView.query("sourceName");
        if (name == null && (name = lpexView.query("name")) == null) {
            name = LpexResources.message("untitledDocument", lpexView.query("documentId"));
        }
        if (lpexView.queryInt("documentViews") > 1) {
            name = (String)name + " : " + lpexView.query("viewId");
        }
        return name;
    }

    static LpexView getSelectedView(String selection) {
        if (_lpexViews == null) {
            SyncCommand.findLpexViews();
        }
        int i = 0;
        while (i < _lpexViewNames.length) {
            if (selection.equals(_lpexViewNames[i])) {
                return _lpexViews[i];
            }
            ++i;
        }
        return null;
    }
}

