/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.samples;

import com.ibm.lpex.core.LpexAction;
import com.ibm.lpex.core.LpexCommand;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.LpexView;
import java.text.SimpleDateFormat;
import java.util.Date;

public class SetDateAction
implements LpexAction {
    public static LpexAction setDateAction = new LpexAction(){

        @Override
        public void doAction(LpexView lpexView) {
            LpexView.doGlobalCommand("set status");
            lpexView.doDefaultCommand(SetDateAction.getInputCommandString(lpexView));
        }

        @Override
        public boolean available(LpexView lpexView) {
            return SetDateAction.canSetSequenceNumbersText(lpexView);
        }
    };
    public static final LpexCommand doSetDateCommand = new LpexCommand(){

        @Override
        public boolean doCommand(LpexView lpexView, String parameters) {
            int lastElement;
            int firstElement;
            if (lpexView.queryOn("block.inView") && lpexView.queryOn("block.anythingSelected")) {
                int linesBeforeStart = lpexView.queryInt("lines.beforeStart");
                firstElement = lpexView.queryInt("block.topElement") - linesBeforeStart;
                lastElement = lpexView.queryInt("block.bottomElement") - linesBeforeStart;
            } else {
                firstElement = lastElement = lpexView.currentElement();
            }
            boolean dirty = false;
            LpexDocumentLocation loc = new LpexDocumentLocation(1, 1);
            int i = firstElement;
            while (i <= lastElement) {
                if (!lpexView.show(i)) {
                    loc.element = i;
                    if (lpexView.queryOn("visible", loc)) {
                        if (!dirty) {
                            dirty = !parameters.equals(lpexView.query("sequenceText"));
                        }
                        lpexView.doCommand(loc, "set sequenceText " + parameters);
                    }
                }
                ++i;
            }
            if (dirty) {
                lpexView.doCommand("set dirty on");
            }
            return true;
        }
    };

    @Override
    public void doAction(LpexView lpexView) {
        SetDateAction.internalDoAction(lpexView);
    }

    @Override
    public boolean available(LpexView lpexView) {
        return SetDateAction.canSetSequenceNumbersText(lpexView);
    }

    private static boolean internalDoAction(LpexView lpexView) {
        if (lpexView.command("doSetDate") != doSetDateCommand) {
            lpexView.defineCommand("doSetDate", doSetDateCommand);
        }
        LpexView.doGlobalCommand("set status");
        return lpexView.doDefaultCommand(SetDateAction.getInputCommandString(lpexView));
    }

    private static String getInputCommandString(LpexView lpexView) {
        int sequenceNumbersTextLength = SetDateAction.sequenceNumbersTextLength(lpexView);
        String prompt = sequenceNumbersTextLength == 6 ? "New date (YYMMDD):" : "New date:";
        prompt = LpexStringTokenizer.addQuotes(prompt);
        StringBuilder initialText = new StringBuilder();
        String sequenceDefaultText = lpexView.query("current.sequenceDefaultText");
        if (sequenceDefaultText == null || sequenceDefaultText.trim().length() == 0) {
            if (sequenceNumbersTextLength == 6) {
                initialText.append(new SimpleDateFormat("yyMMdd").format(new Date()));
            } else {
                initialText.append("0");
                while (initialText.length() < sequenceNumbersTextLength) {
                    initialText.append('0');
                }
            }
        }
        String initialTextWithQuotes = LpexStringTokenizer.addQuotes(initialText.toString());
        return "input " + prompt + " " + initialTextWithQuotes + " \"doSetDate \"";
    }

    private static boolean canSetSequenceNumbersText(LpexView lpexView) {
        return lpexView.currentElement() != 0 && !lpexView.queryOn("readonly") && SetDateAction.sequenceNumbersTextLength(lpexView) != 0;
    }

    private static int sequenceNumbersTextLength(LpexView lpexView) {
        return Integer.parseInt(lpexView.query("current.sequenceNumbers").split(" ")[3]);
    }

    public static class SetDate
    implements LpexCommand {
        @Override
        public boolean doCommand(LpexView lpexView, String parameters) {
            if (lpexView != null) {
                if ("?".equals(parameters.trim())) {
                    lpexView.doCommand("set messageText Syntax: setDate [<new date>]");
                    return true;
                }
                if (lpexView.queryOn("readonly")) {
                    lpexView.doDefaultCommand("set messageText Document is read only.");
                } else if (SetDateAction.sequenceNumbersTextLength(lpexView) == 0) {
                    lpexView.doDefaultCommand("set messageText Document has no sequence-numbers text part.");
                } else if (lpexView.currentElement() == 0) {
                    lpexView.doDefaultCommand("set messageText No visible elements.");
                } else {
                    if (parameters.length() != 0) {
                        return doSetDateCommand.doCommand(lpexView, parameters);
                    }
                    return SetDateAction.internalDoAction(lpexView);
                }
            }
            return true;
        }
    }
}

