/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.samples;

import com.ibm.lpex.core.LpexView;
import com.ibm.lpex.core.LpexViewAdapter;
import com.ibm.lpex.core.LpexWindow;
import java.util.HashMap;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;

public class MouseReselect
extends LpexViewAdapter
implements MouseListener,
MouseMoveListener,
DisposeListener {
    private static HashMap<LpexView, MouseReselect> _mouseReselects = new HashMap();
    private LpexView _lpexView;
    private LpexWindow _lpexWindow;
    private boolean _button1PressedLast;

    private MouseReselect(LpexView lpexView) {
        this._lpexView = lpexView;
        this._lpexView.addLpexViewListener(this);
        _mouseReselects.put(lpexView, this);
    }

    public static void install(LpexView lpexView) {
        if (lpexView != null && _mouseReselects.get(lpexView) == null) {
            new MouseReselect(lpexView);
        }
    }

    private void uninstall() {
        if (this._lpexView != null) {
            this._lpexView.removeLpexViewListener(this);
            if (this._lpexWindow != null) {
                this._lpexWindow.textWindow().removeDisposeListener((DisposeListener)this);
                this._lpexWindow.textWindow().removeMouseListener((MouseListener)this);
                this._lpexWindow.textWindow().removeMouseMoveListener((MouseMoveListener)this);
                this._lpexWindow = null;
            }
            _mouseReselects.remove(this._lpexView);
            this._lpexView = null;
        }
    }

    @Override
    public void shown(LpexView lpexView) {
        if (this._lpexWindow == null) {
            this._lpexWindow = this._lpexView.window();
            if (this._lpexWindow != null) {
                this._lpexWindow.textWindow().addDisposeListener((DisposeListener)this);
                this._lpexWindow.textWindow().addMouseListener((MouseListener)this);
                this._lpexWindow.textWindow().addMouseMoveListener((MouseMoveListener)this);
            }
        }
    }

    @Override
    public void disposed(LpexView lpexView) {
        this.uninstall();
    }

    public void widgetDisposed(DisposeEvent e) {
        this.uninstall();
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
        this._button1PressedLast = false;
    }

    public void mouseDown(MouseEvent e) {
        this._button1PressedLast = this.button1Pressed(e);
    }

    public void mouseMove(MouseEvent e) {
        if (this._button1PressedLast && this.button1Dragged(e) && this._lpexWindow == this._lpexView.window()) {
            this._button1PressedLast = false;
            this._lpexView.triggerAction(this._lpexView.actionId("blockUnmark"));
        }
    }

    private boolean button1Pressed(MouseEvent e) {
        return e.button == 1 && (e.stateMask & SWT.MODIFIER_MASK) == 0;
    }

    private boolean button1Dragged(MouseEvent e) {
        return (e.stateMask & (SWT.BUTTON_MASK | SWT.MODIFIER_MASK)) == 524288;
    }
}

