/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.samples;

import com.ibm.lpex.core.LpexCommand;
import com.ibm.lpex.core.LpexResources;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.LpexView;

public class HtmlSource
implements LpexCommand {
    public static void main(String[] args) {
        System.exit(HtmlSource.generateListing(args, null) ? 0 : 1);
    }

    @Override
    public boolean doCommand(LpexView lpexView, String parameters) {
        return HtmlSource.generateListing(LpexStringTokenizer.split(parameters), lpexView);
    }

    private static boolean generateListing(String[] args, LpexView runFromView) {
        if (args.length == 0 || args.length > 2 || args[0].length() == 0) {
            if (runFromView == null) {
                System.err.println("ERROR HtmlSource.  Usage:");
                System.err.println(" java com.ibm.lpex.samples.HtmlSource inputFile [outputFile]");
            } else {
                runFromView.doCommand("set messageText Error. Command parameters: inputFile [outputFile]");
            }
            return false;
        }
        String inputFile = LpexStringTokenizer.trimQuotes(args[0]);
        String outputFile = args.length == 2 ? LpexStringTokenizer.trimQuotes(args[1]) : inputFile + ".html";
        LpexView lpexView = new LpexView(inputFile, false);
        String status = lpexView.query("status");
        if (status == null) {
            lpexView.doCommand("set updateProfile.paletteAttributes.default._blue 0 0 0 248 248 254");
            lpexView.doCommand("set updateProfile.palette _blue");
            lpexView.doCommand("updateProfile");
            String parser = lpexView.query("parser");
            if ("java".equals(parser)) {
                style = lpexView.query("styleAttributes.c");
                lpexView.doCommand("set styleAttributes.c " + style + " italic");
                style = lpexView.query("styleAttributes.C");
                lpexView.doCommand("set styleAttributes.C " + style + " italic");
                style = lpexView.query("styleAttributes.k");
                lpexView.doCommand("set styleAttributes.k " + style + " bold");
                style = lpexView.query("styleAttributes.r");
                lpexView.doCommand("set styleAttributes.r " + style + " bold");
                style = lpexView.query("styleAttributes.t");
                lpexView.doCommand("set styleAttributes.t " + style + " bold italic");
            } else if ("prop".equals(parser)) {
                style = lpexView.query("styleAttributes.c");
                lpexView.doCommand("set styleAttributes.c " + style + " italic");
                style = lpexView.query("styleAttributes.k");
                lpexView.doCommand("set styleAttributes.k " + style + " bold");
            }
            lpexView.doCommand("saveAsHtml \"" + outputFile + "\"");
            status = lpexView.query("status");
        }
        if (status != null) {
            Object message;
            String error = status.equals("file.notFound") ? LpexResources.message(status, inputFile) : LpexResources.message(status);
            Object object = message = error != null ? error : "LPEX status=\"" + status + "\".";
            if (runFromView == null) {
                String command = "ERROR HtmlSource " + inputFile + (String)(args.length == 2 ? " " + outputFile : "");
                System.err.println(command + ": " + (String)message);
            } else {
                runFromView.doCommand("set messageText " + (String)message);
            }
        }
        lpexView.dispose();
        return status == null;
    }
}

