/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.samples;

import com.ibm.lpex.core.LpexCommand;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.LpexView;

public class FindsCommand
implements LpexCommand {
    @Override
    public boolean doCommand(LpexView lpexView, String parameters) {
        if (lpexView == null) {
            return true;
        }
        if ("?".equals(parameters.trim())) {
            lpexView.doCommand("set messageText Syntax: finds [<text>]");
            return true;
        }
        this.doFinds(lpexView, parameters);
        return true;
    }

    void doFinds(LpexView lpexView, String parameters) {
        String text;
        StringBuilder findTextParms = new StringBuilder(64);
        StringBuilder options = new StringBuilder(64);
        findTextParms.append(this.basicFindTextParms());
        if (lpexView.queryOn("current.findText.columns")) {
            String startColumn = lpexView.query("current.findText.startColumn");
            String endColumn = lpexView.query("current.findText.endColumn");
            findTextParms.append("columns ").append(startColumn).append(' ').append(endColumn).append(' ');
            FindsCommand.setOption(options, "in columns " + startColumn + ".." + endColumn);
        }
        if (lpexView.queryOn("current.findText.block")) {
            findTextParms.append("block ");
            FindsCommand.setOption(options, "in selection");
        }
        if (lpexView.queryOn("current.findText.wholeWord")) {
            findTextParms.append("wholeWord ");
            FindsCommand.setOption(options, "whole word");
        }
        if (lpexView.queryOn("current.findText.asis")) {
            findTextParms.append("asis ");
            FindsCommand.setOption(options, "case sensitive");
        }
        if (((String)parameters).length() != 0) {
            if ("\\?".equals(((String)parameters).trim())) {
                int i = ((String)parameters).indexOf(92);
                parameters = ((String)parameters).substring(0, i) + ((String)parameters).substring(i + 1);
            }
            text = parameters;
            findTextParms.append(LpexStringTokenizer.addQuotes((String)parameters));
        } else {
            if (lpexView.queryOn("current.findText.regularExpression")) {
                findTextParms.append("regularExpression ");
                FindsCommand.setOption(options, "regular expression");
            }
            text = lpexView.query("current.findText.findText");
            findTextParms.append(text);
            text = LpexStringTokenizer.removeQuotes(text);
        }
        FindsCommand.setOption(options, null);
        String oldFindTextContext = lpexView.query("userParameter.view.findTextContext");
        lpexView.doCommand("set userParameter.view.findTextContext off");
        String findTextParmsString = findTextParms.toString();
        String cmd0 = "findText checkStart " + findTextParmsString;
        String cmd = "findText " + findTextParmsString;
        int count = 0;
        LpexDocumentLocation loc = new LpexDocumentLocation(1, 1);
        while (true) {
            lpexView.doCommand(loc, count == 0 ? cmd0 : cmd);
            if (lpexView.query("status") != null) break;
            this.found(lpexView, loc);
            ++count;
        }
        lpexView.doCommand("set userParameter.view.findTextContext " + (oldFindTextContext == null ? "" : oldFindTextContext));
        lpexView.doCommand("set status");
        lpexView.doCommand("set messageText " + text + ": " + (String)(switch (count) {
            case 0 -> "not found";
            case 1 -> "1 occurrence";
            default -> count + " occurrences";
        }) + options.toString() + ".");
    }

    String basicFindTextParms() {
        return "quiet noBeep noWrap noEmphasis ";
    }

    void found(LpexView lpexView, LpexDocumentLocation loc) {
    }

    private static void setOption(StringBuilder sb, String option) {
        if (sb.length() == 0) {
            if (option != null) {
                sb.append(option);
            }
        } else if (option != null) {
            sb.append(", ").append(option);
        } else {
            sb.insert(0, " (").append(')');
        }
    }
}

