/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.samples;

import com.ibm.lpex.core.LpexCommand;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.LpexView;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;

public class ExecCommand
implements LpexCommand {
    boolean _inExec;

    @Override
    public boolean doCommand(LpexView lpexView, String fileName) {
        if ("?".equals(fileName.trim())) {
            lpexView.doCommand("set messageText Syntax: exec [<file name>]");
            return true;
        }
        if (this._inExec) {
            if (lpexView != null) {
                lpexView.doCommand("set messageText Command \"exec\" already in progress, canceled.");
            }
            return true;
        }
        this._inExec = true;
        if ((fileName = LpexStringTokenizer.trimQuotes(fileName.trim())).length() != 0) {
            this.exec(lpexView, fileName);
        } else {
            this.exec(lpexView);
        }
        this._inExec = false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void exec(LpexView lpexView, String fileName) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                FileInputStream fis = new FileInputStream(fileName);
                try {
                    block21: {
                        InputStreamReader isr = new InputStreamReader((InputStream)fis, Charset.defaultCharset());
                        try {
                            try (BufferedReader br = new BufferedReader(isr);){
                                String line;
                                while ((line = br.readLine()) != null) {
                                    this.execOneLine(lpexView, line);
                                }
                            }
                            if (isr == null) break block21;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (isr == null) throw throwable;
                            isr.close();
                            throw throwable;
                        }
                        isr.close();
                    }
                    if (fis == null) return;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    if (fis == null) throw throwable;
                    fis.close();
                    throw throwable;
                }
                fis.close();
                return;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        catch (IOException e) {
            if (lpexView == null) return;
            lpexView.doCommand("set messageText Cannot read file \"" + fileName + "\".");
        }
    }

    private void exec(LpexView lpexView) {
        if (lpexView != null) {
            String commands = lpexView.query("block.text");
            if (commands == null) {
                commands = lpexView.query("text");
            }
            if (commands != null) {
                String[] lines = commands.split("\\r\\n|\\r|\\n");
                int i = 0;
                while (i < lines.length) {
                    this.execOneLine(lpexView, lines[i]);
                    ++i;
                }
            }
        }
    }

    private boolean execOneLine(LpexView lpexView, String text) {
        int i = 0;
        while (i < text.length() && (text.charAt(i) == ' ' || text.charAt(i) == '\t')) {
            ++i;
        }
        if (text.startsWith("//", i)) {
            return true;
        }
        if (i != 0) {
            text = text.substring(i);
        }
        return text.length() == 0 ? true : (lpexView != null ? lpexView.doCommand(text) : LpexView.doGlobalCommand(text));
    }
}

