/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.samples;

import com.ibm.lpex.core.LpexAction;
import com.ibm.lpex.core.LpexView;

public class BlockTransferAction
implements LpexAction {
    @Override
    public void doAction(LpexView lpexView) {
        String blockType = lpexView.query("block.type");
        if (blockType.equals("element")) {
            lpexView.doCommand("block copy");
            return;
        }
        int elements = 0;
        if (blockType.equals("rectangle")) {
            String blockText = lpexView.query("block.text");
            int i = blockText.indexOf(10);
            while (i >= 0) {
                ++elements;
                i = blockText.indexOf(10, i + 1);
            }
        }
        int position = lpexView.queryInt("displayPosition");
        int currentElement = lpexView.currentElement();
        int blockTopElement = lpexView.queryInt("block.topElement");
        int blockBottomElement = lpexView.queryInt("block.bottomElement");
        if (currentElement >= blockTopElement && currentElement < blockBottomElement) {
            lpexView.jump(blockBottomElement, position);
        }
        lpexView.doCommand("add");
        int element = lpexView.currentElement();
        if (elements > 0) {
            lpexView.doCommand("add " + elements);
        }
        lpexView.jump(element, position);
        lpexView.doCommand("block copy");
    }

    @Override
    public boolean available(LpexView lpexView) {
        return lpexView.currentElement() > 0 && !lpexView.queryOn("readonly") && lpexView.queryOn("block.anythingSelected");
    }
}

