/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.bidi.BidiFlag;
import com.ibm.lpex.bidi.BidiFlagSet;
import com.ibm.lpex.bidi.BidiText;
import com.ibm.lpex.bidi.BidiTransform;
import com.ibm.lpex.core.ActionHandler;
import com.ibm.lpex.core.ActionUtilities;
import com.ibm.lpex.core.Block;
import com.ibm.lpex.core.CommandHandler;
import com.ibm.lpex.core.Document;
import com.ibm.lpex.core.DocumentPosition;
import com.ibm.lpex.core.Element;
import com.ibm.lpex.core.EnterArabicDigitsParameter;
import com.ibm.lpex.core.FormatLine;
import com.ibm.lpex.core.LpexAction;
import com.ibm.lpex.core.LpexBaseAction;
import com.ibm.lpex.core.LpexDocumentListener;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexKeyListener;
import com.ibm.lpex.core.LpexNls;
import com.ibm.lpex.core.LpexResources;
import com.ibm.lpex.core.LpexUtilities;
import com.ibm.lpex.core.LpexView;
import com.ibm.lpex.core.LpexViewAdapter;
import com.ibm.lpex.core.LpexWindow;
import com.ibm.lpex.core.StatusLine;
import com.ibm.lpex.core.TabsParameter;
import com.ibm.lpex.core.Undo;
import com.ibm.lpex.core.View;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;

public final class VisualField {
    static final int FORMAT_LINE = 1;
    static final int MAIN_FORMAT_LINE = 2;
    private static final String editLineKeyActions = "a-backSpace.secondary undo a-i blockLowerCase a-k blockUpperCase a-l selectAll a-u blockUnmark backSpace backSpace c-7 insertLtrMark c-8 insertRtlMark c-a selectAll c-backSpace deleteLine c-c copy c-delete truncate c-end bottom c-home top c-insert.secondary copy c-j findLastChange c-n findNext c-pageDown pageRight c-pageUp pageLeft c-s-end blockMarkEnd c-s-home blockMarkHome c-s-z.secondary redo c-u findUp c-v paste c-x cut c-y redo c-z undo decimal enterDecimalSeparator delete delete down left end end enter enter escape esc f1 help home home insert toggleInsert left left numpadEnter enter right right s-backSpace.secondary backSpace s-delete.secondary cut s-down blockMarkLeft s-end blockMarkEnd s-enter nullAction s-f10 popupAtCursor s-home blockMarkHome s-insert.secondary paste s-left blockMarkLeft s-right blockMarkRight s-tab prevTabStop s-up blockMarkRight tab nextTabStop up right ";
    private static final String editLineMouseActions = "1-dragged blockMarkToMouse 1-pressed.1 cursorToMouse a-1-dragged blockMarkToMouse a-1-pressed.1 cursorToMouse c-a-1-pressed.1 blockUnmark c-a-s-1-pressed.1 blockUnmark c-1-dragged blockMarkToMouse c-1-pressed.1 cursorToMouse c-1-pressed.2 selectAll " + ActionHandler.LPEX_POPUP_DEFINITION + " popupAtMouse s-1-dragged blockMarkToMouse s-1-pressed.1 blockMarkToMouse ";
    private static final String HEADER_LRO = "\u202d";
    private static final int HEADER_LEN = 1;
    String HEADER = "\u202d";
    private static LpexBaseAction _arabicDigitsAction = new LpexBaseAction(){

        @Override
        public void doAction(LpexView lpexView) {
            EnterArabicDigitsParameter p = EnterArabicDigitsParameter.getParameter();
            p.setValue(lpexView._view, p.currentValue(lpexView._view) ? 0 : 1);
        }

        @Override
        public boolean checkable() {
            return true;
        }

        @Override
        public boolean checked(LpexView lpexView) {
            return EnterArabicDigitsParameter.getParameter().currentValue(lpexView._view);
        }

        @Override
        public boolean available(LpexView lpexView) {
            return !lpexView._view.readonly();
        }
    };
    private int _style;
    private LpexView _docLpexView;
    private boolean _smartLogical;
    private boolean _syntaxSmartLogical;
    private LpexView _lpexView;
    private View _view;
    private LpexWindow _lpexWindow;
    private boolean _editable;
    private boolean _pasting;
    boolean _autoPush = true;
    boolean _push;
    int _pushPosition;
    int _pushFieldStart;
    int _pushFieldEnd;
    boolean _insertAtStart;
    boolean _fieldReverse = false;
    private static final String FIELD_REVERSE_PERSISTENT = "FieldReversePersistent";
    private static final char ASTERISK = '*';
    private String _text;
    private String _committedText = null;
    private static BidiFlagSet bidiFlagsVisual = new BidiFlagSet(BidiFlag.TYPE_VISUAL, BidiFlag.ORIENTATION_LTR, BidiFlag.SWAP_NO, BidiFlag.NUMERALS_NOMINAL, BidiFlag.TEXT_NOMINAL);
    private static BidiFlagSet bidiFlagsLogical = new BidiFlagSet(BidiFlag.TYPE_IMPLICIT, BidiFlag.ORIENTATION_LTR, BidiFlag.SWAP_YES, BidiFlag.NUMERALS_ANY, BidiFlag.TEXT_NOMINAL);
    static final int FACTOR2_POS = 35;
    static final int EOLCOMMENT_POS = 80;
    static final int FIELDLEN_POS = 63;

    VisualField(Composite parent, int style) {
        this._style = style;
        this._lpexView = new LpexView(false);
        this._view = this._lpexView._view;
        this._lpexWindow = new LpexWindow(parent, 2048);
        this._lpexWindow.setForceNoScrollBars(true);
        this._lpexView.setWindow(this._lpexWindow);
        this._lpexView.setBlockInstance(this._lpexView);
        this._view.document().setVisual(true);
        this._view.screen().setNoEmphasisInBlock(true);
        if ((this._style & 1) != 0) {
            this._view.screen().setOwnerColumnInfo(true);
        }
        if ((this._style & 2) != 0) {
            this._lpexWindow.textWindow().addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                }

                public void focusLost(FocusEvent e) {
                    if (VisualField.this._docLpexView != null && VisualField.this._docLpexView._view != null) {
                        VisualField.this._docLpexView._view.screen().setOwnerColumnInfo(false);
                    }
                }
            });
        }
        this._lpexWindow.textWindow().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = VisualField.this.getNameText(LpexResources.message("popup.visualEditLine"));
            }
        });
        this._lpexView.addLpexViewListener(new LpexViewAdapter(){

            @Override
            public void updateProfile(LpexView view) {
                VisualField.this.handleUpdateProfile(view);
            }

            @Override
            public void showing(LpexView view) {
                VisualField.this.handleShowing();
            }
        });
        this._lpexView.addLpexKeyListener(new LpexKeyListener(){

            @Override
            public void keyPressed(Event event) {
                if (VisualField.this._fieldReverse && event.character >= ' ' && event.character != '\u007f' && ((event.stateMask & SWT.MODIFIER_MASK) == 0 || event.stateMask == 131072)) {
                    VisualField.this.handleFieldReverseInput(VisualField.this._lpexView, event);
                } else {
                    VisualField.this.handleKeyPressed(event);
                }
            }
        });
        this._lpexView.addLpexDocumentListener(new LpexDocumentListener(){

            @Override
            public void documentChanged(LpexView view, int type, int line, int position, int count) {
                VisualField.this.handleDocumentChanged(type, line, position, count);
            }
        });
        this.cmd("set updateProfile.baseProfile none");
        this.cmd("set updateProfile.palette white");
        this.cmd("set updateProfile.userActions");
        this.cmd("set updateProfile.userCommands");
        this.cmd("set updateProfile.userKeyActions a-backSpace.secondary undo a-i blockLowerCase a-k blockUpperCase a-l selectAll a-u blockUnmark backSpace backSpace c-7 insertLtrMark c-8 insertRtlMark c-a selectAll c-backSpace deleteLine c-c copy c-delete truncate c-end bottom c-home top c-insert.secondary copy c-j findLastChange c-n findNext c-pageDown pageRight c-pageUp pageLeft c-s-end blockMarkEnd c-s-home blockMarkHome c-s-z.secondary redo c-u findUp c-v paste c-x cut c-y redo c-z undo decimal enterDecimalSeparator delete delete down left end end enter enter escape esc f1 help home home insert toggleInsert left left numpadEnter enter right right s-backSpace.secondary backSpace s-delete.secondary cut s-down blockMarkLeft s-end blockMarkEnd s-enter nullAction s-f10 popupAtCursor s-home blockMarkHome s-insert.secondary paste s-left blockMarkLeft s-right blockMarkRight s-tab prevTabStop s-up blockMarkRight tab nextTabStop up right ");
        this.cmd("set updateProfile.userMouseActions " + editLineMouseActions);
        this.cmd("set updateProfile.userProfile");
        this.cmd("updateProfile");
        this.cmd("set statusLine off");
        this.cmd("set formatLine " + ((this._style & 1) != 0 ? "on" : "off"));
        this.cmd("set messageLine off");
        this.cmd("set prefixArea off");
        this.cmd("set highlightCurrentLine off");
        this.cmd("set block.defaultType stream");
    }

    LpexWindow getLpexWindow() {
        return this._lpexWindow;
    }

    LpexView getLpexView() {
        return this._lpexView;
    }

    String getLogicalText() {
        return this.visualToLogical(this.getText());
    }

    String getLogicalText(int[] position) {
        if (position != null && position.length != 0) {
            position[0] = this.getPosition();
        }
        return this.visualToLogical(this.getText(), position);
    }

    void setEditable(boolean editable) {
        this._editable = editable;
        if (this._view.readonly() == editable) {
            this._view.setReadonly(!editable);
        }
        String style = editable ? LpexView.globalQuery("current.updateProfile.paletteAttributes.default.white") : LpexView.globalQuery("current.updateProfile.paletteAttributes.default.gray");
        this.cmd("set styleAttributes.default " + style);
    }

    void initializeField(LpexView docLpexView) {
        String currentFontData;
        this._docLpexView = docLpexView;
        if (this._docLpexView.window().getData(FIELD_REVERSE_PERSISTENT) != null) {
            this.handleFieldReverse(null);
        }
        boolean setFont = (currentFontData = docLpexView.query("current.font.fontData")) != null && !currentFontData.equals(this._lpexView.query("current.font.fontData"));
        boolean editable = !docLpexView.show(docLpexView.currentElement()) && !docLpexView._view.readonly() && !docLpexView._view.markList().protect(docLpexView._view.documentPosition().element());
        this.cmd("set sourceEncoding " + docLpexView.query("current.sourceEncoding"));
        this.cmd("set sourceCcsid " + docLpexView.query("current.sourceCcsid"));
        this.cmd("set useSourceColumns " + docLpexView.query("current.useSourceColumns"));
        this.mirrorTabs(docLpexView);
        this.mirrorFields(docLpexView);
        this._smartLogical = docLpexView.nls().isSmartLogical();
        this._syntaxSmartLogical = docLpexView.nls().isSyntaxSmartLogical();
        this._push = false;
        this.showPushField();
        int[] position = new int[]{docLpexView.currentPosition()};
        String visualText = this.logicalToVisual(docLpexView.elementText(docLpexView.currentElement()), position);
        this.setVisualText(visualText, position[0]);
        this._view.screen().setScroll(0);
        this._view.document().undo().clear();
        this.setEditable(editable);
        if (setFont) {
            this.cmd("set font.fontData " + currentFontData);
        }
        this.setPopup();
        if ((this._style & 2) != 0) {
            docLpexView._view.screen().setOwnerColumnInfo(true);
        }
        this._lpexWindow.textWindow().setFocus();
    }

    void reinitializeField() {
        this.mirrorTabs(this._docLpexView);
        this.mirrorFields(this._docLpexView);
        boolean editable = !this._docLpexView.show(this._docLpexView.currentElement()) && !this._docLpexView._view.readonly() && !this._docLpexView._view.markList().protect(this._docLpexView._view.documentPosition().element());
        this._push = false;
        this.showPushField();
        String visualText = this.logicalToVisual(this._docLpexView.elementText(this._docLpexView.currentElement()), null);
        this.setVisualText(visualText);
        this._view.screen().setScroll(0);
        this._view.document().undo().clear();
        this.setEditable(editable);
    }

    void dispose() {
        if (this._lpexView != null) {
            this._lpexView.dispose();
            this._lpexView = null;
        }
    }

    void commit() {
        this.commit_RDz();
    }

    void commit_RDi() {
        if (this._committedText != null && this._committedText.length() > 0) {
            return;
        }
        LpexView mainLpexView = this._docLpexView;
        View mainView = mainLpexView._view;
        Element currentElement = mainView.documentPosition().element();
        int[] position = new int[1];
        Undo vUndo = this.getLpexView()._view.document().undo();
        String currentText = this.getText();
        if (!currentText.equals(this._committedText) && (vUndo.changes() != 0 || vUndo.dirty())) {
            this._committedText = currentText;
            mainView.document().undo().check(mainView);
            int scroll = mainLpexView._view.screen().scroll();
            position[0] = this.getPosition();
            if (currentElement._partOfList) {
                String textSSV = this._syntaxSmartLogical ? currentElement.text() : LpexNls.getSyntaxSmartText(currentElement.text(), currentElement.elementView(mainView).style());
                if (this._smartLogical) {
                    position[0] = LpexNls.adjustPositionForNewBidiMarks(this.getText(), textSSV, position[0]);
                }
                int e = mainView.document().elementList().ordinalOf(currentElement);
                VisualField.setElementText(mainView.lpexView(), e, VisualField.BidiV2L(currentText));
                VisualField.addBiDirectionalMarkers(mainView.lpexView(), e, 35, 80, 63);
                mainView.document().parse();
            }
            Document.screenShow(mainView.document());
            mainLpexView._view.screen().setScroll(scroll);
            mainView.documentPosition().jump(position[0]);
            return;
        }
        Block block = mainView.block();
        if (block.view() != mainView || block.type() != 1) {
            if (position[0] < 1) {
                if (this._smartLogical) {
                    position[0] = LpexNls.adjustPositionForNewBidiMarks(this.getText(), currentElement.text(), this.getPosition());
                    this.visualToLogical(currentElement.text(), position);
                } else {
                    this.getLogicalText(position);
                }
            }
            mainView.documentPosition().jump(position[0]);
        }
    }

    void commit_RDz() {
        LpexView mainLpexView = this._docLpexView;
        View mainView = mainLpexView._view;
        Element currentElement = mainView.documentPosition().element();
        int[] position = new int[1];
        Undo vUndo = this.getLpexView()._view.document().undo();
        String currentText = this.getText();
        if (!currentText.equals(this._committedText) && (vUndo.changes() != 0 || vUndo.dirty())) {
            this._committedText = currentText;
            mainView.document().undo().check(mainView);
            int scroll = mainLpexView._view.screen().scroll();
            String textV = this.getText();
            int e = mainView.document().elementList().ordinalOf(currentElement);
            mainLpexView.setElementText(e, textV);
            mainView.document().parse();
            position[0] = this.getPosition();
            if (currentElement._partOfList) {
                String textSSV = this._syntaxSmartLogical ? currentElement.text() : LpexNls.getSyntaxSmartText(currentElement.text(), currentElement.elementView(mainView).style());
                if (this._smartLogical) {
                    position[0] = LpexNls.adjustPositionForNewBidiMarks(textV, textSSV, position[0]);
                }
                String newText = this.visualToLogical(textSSV, position);
                e = mainView.document().elementList().ordinalOf(currentElement);
                mainLpexView.setElementText(e, newText);
                mainView.document().parse();
            }
            Document.screenShow(mainView.document());
            mainLpexView._view.screen().setScroll(scroll);
            mainView.documentPosition().jump(position[0]);
            return;
        }
        Block block = mainView.block();
        if (block.view() != mainView || block.type() != 1) {
            if (position[0] < 1) {
                if (this._smartLogical) {
                    position[0] = LpexNls.adjustPositionForNewBidiMarks(this.getText(), currentElement.text(), this.getPosition());
                    this.visualToLogical(currentElement.text(), position);
                } else {
                    this.getLogicalText(position);
                }
            }
            mainView.documentPosition().jump(position[0]);
        }
    }

    void abandon() {
        View mainView = this._docLpexView._view;
        Block block = mainView.block();
        if (block.view() != mainView || block.type() != 1) {
            Element currentElement = mainView.documentPosition().element();
            int[] position = new int[1];
            if (this._smartLogical) {
                position[0] = LpexNls.adjustPositionForNewBidiMarks(this.getText(), currentElement.text(), this.getPosition());
                this.visualToLogical(currentElement.text(), position);
            } else {
                this.getLogicalText(position);
            }
            mainView.documentPosition().jump(position[0]);
        }
    }

    private void mirrorTabs(LpexView docLpexView) {
        String tabsString = "2 every 8";
        TabsParameter.Settings tabs = new TabsParameter.Settings();
        TabsParameter.setTabs(null, null, docLpexView.query("current.tabs"), tabs);
        if (tabs._tabStops != null) {
            int i = 0;
            while (i < tabs._tabStops.length) {
                int n = i++;
                tabs._tabStops[n] = tabs._tabStops[n] + 1;
            }
            tabsString = TabsParameter.getTabsString(tabs);
        }
        this.cmd("set tabs " + tabsString);
    }

    private void mirrorFields(LpexView docLpexView) {
        String fieldsString = "";
        int[] fields = docLpexView._view.fields(docLpexView._view.documentPosition().element());
        if (fields != null) {
            StringBuilder buffer = new StringBuilder(120);
            int i = 0;
            while (i < fields.length) {
                buffer.append(' ').append(fields[i] + 1);
                ++i;
            }
            fieldsString = buffer.toString();
        }
        this.cmd("set fields " + fieldsString);
    }

    private void handleUpdateProfile(LpexView lpexView) {
        lpexView.doDefaultCommand("set commandLine off");
        this.setEditable(this._editable);
        this.scrollIntoView();
        if ((this._style & 1) != 0) {
            this.cmd("set styleAttributes.formatLine " + this._lpexView.query("styleAttributes.background"));
        }
        this.cmd("set styleAttributes.background 0 0 0 255 255 255");
        lpexView.defineAction("arabicDigits", _arabicDigitsAction);
        lpexView.defineAction("backSpace", new LpexBaseAction(){

            @Override
            public void doAction(LpexView view) {
                if (VisualField.this._fieldReverse) {
                    if (!view._view.insertMode()) {
                        VisualField.this.handleRight(view);
                    }
                    VisualField.this.handleDelete();
                    if (!view._view.insertMode()) {
                        VisualField.this.handleLeft(view);
                    }
                } else {
                    VisualField.this.handleBackSpace();
                }
            }

            @Override
            public boolean available(LpexView view) {
                return view.defaultActionAvailable(31);
            }
        });
        lpexView.defineAction("blockMarkHome", new LpexBaseAction(){

            @Override
            public void doAction(LpexView view) {
                VisualField.this.doBlockAction(44);
            }

            @Override
            public boolean available(LpexView view) {
                return view.defaultActionAvailable(44);
            }
        });
        lpexView.defineAction("blockMarkEnd", new LpexBaseAction(){

            @Override
            public void doAction(LpexView view) {
                VisualField.this.doBlockAction(43);
            }

            @Override
            public boolean available(LpexView view) {
                return view.defaultActionAvailable(43);
            }
        });
        lpexView.defineAction("blockMarkLeft", new LpexBaseAction(){

            @Override
            public void doAction(LpexView view) {
                VisualField.this.doBlockAction(45);
            }

            @Override
            public boolean available(LpexView view) {
                return view.defaultActionAvailable(45);
            }
        });
        lpexView.defineAction("blockMarkRight", new LpexBaseAction(){

            @Override
            public void doAction(LpexView view) {
                VisualField.this.doBlockAction(54);
            }

            @Override
            public boolean available(LpexView view) {
                return view.defaultActionAvailable(54);
            }
        });
        lpexView.defineAction("blockMarkToMouse", new LpexBaseAction(){

            @Override
            public void doAction(LpexView view) {
                VisualField.this.doBlockAction(55);
            }

            @Override
            public boolean available(LpexView view) {
                return view.defaultActionAvailable(55);
            }
        });
        lpexView.defineAction("bottom", new LpexBaseAction(){

            @Override
            public void doAction(LpexView view) {
                VisualField.this.endPush();
                view._view.documentPosition().jump(view.queryInt("length") + 1);
            }

            @Override
            public boolean available(LpexView view) {
                return true;
            }
        });
        lpexView.defineAction("cursorToMouse", new LpexBaseAction(){

            @Override
            public void doAction(LpexView view) {
                view.doDefaultAction(84);
                VisualField.this._pushPosition = view.currentPosition();
                if (VisualField.this._pushPosition < 2) {
                    VisualField.this._pushPosition = 2;
                    view._view.documentPosition().jump(VisualField.this._pushPosition);
                }
                VisualField.this.checkInsidePushField();
                VisualField.this._insertAtStart = false;
            }

            @Override
            public boolean available(LpexView view) {
                return true;
            }
        });
        lpexView.defineAction("delete", new LpexBaseAction(){

            @Override
            public void doAction(LpexView view) {
                if (VisualField.this._fieldReverse) {
                    if (!view._view.insertMode()) {
                        VisualField.this.handleRight(view);
                    }
                    VisualField.this.handleBackSpace();
                    if (!view._view.insertMode()) {
                        VisualField.this.handleLeft(view);
                    }
                } else {
                    VisualField.this.handleDelete();
                }
            }

            @Override
            public boolean available(LpexView view) {
                return view.defaultActionAvailable(86);
            }
        });
        lpexView.defineAction("deleteLine", new LpexBaseAction(){

            @Override
            public void doAction(LpexView view) {
                VisualField.this.endPush();
                view._view.documentPosition().jump(2);
                view.doDefaultAction(204);
            }

            @Override
            public boolean available(LpexView view) {
                return view.defaultActionAvailable(89);
            }
        });
        lpexView.defineAction("end", new LpexBaseAction(){

            @Override
            public void doAction(LpexView view) {
                if (VisualField.this._fieldReverse) {
                    VisualField.this.handleFieldHome(view);
                } else {
                    VisualField.this.handleFieldEnd(view);
                }
            }

            @Override
            public boolean available(LpexView view) {
                return true;
            }
        });
        lpexView.defineAction("home", new LpexBaseAction(){

            @Override
            public void doAction(LpexView view) {
                if (VisualField.this._fieldReverse) {
                    VisualField.this.handleFieldEnd(view);
                } else {
                    VisualField.this.handleFieldHome(view);
                }
            }

            @Override
            public boolean available(LpexView view) {
                return true;
            }
        });
        lpexView.defineAction("left", new LpexAction(){

            @Override
            public void doAction(LpexView view) {
                VisualField.this.handleLeft(view);
            }

            @Override
            public boolean available(LpexView view) {
                return true;
            }
        });
        lpexView.defineAction("nextTabStop", new LpexBaseAction(){

            @Override
            public void doAction(LpexView view) {
                view.doDefaultAction(144);
                VisualField.this._pushPosition = view.currentPosition();
                VisualField.this.checkInsidePushField();
                VisualField.this._insertAtStart = false;
            }

            @Override
            public boolean available(LpexView view) {
                return view.defaultActionAvailable(144);
            }
        });
        lpexView.defineAction("right", new LpexAction(){

            @Override
            public void doAction(LpexView view) {
                VisualField.this.handleRight(view);
            }

            @Override
            public boolean available(LpexView view) {
                return true;
            }
        });
        lpexView.defineAction("copy", new LpexBaseAction(){

            @Override
            public void doAction(LpexView view) {
                String text;
                if (view._view.block().view() == view._view && (text = view._view.block().selectedText()) != null) {
                    String textL = VisualField.this.visualToLogical(text, null, true);
                    LpexUtilities.setClipboardContents(textL, null);
                }
            }

            @Override
            public boolean available(LpexView view) {
                return view.defaultActionAvailable(83);
            }
        });
        lpexView.defineAction("cut", new LpexBaseAction(){

            @Override
            public void doAction(LpexView view) {
                String text;
                if (view._view.block().view() == view._view && view._view.changeAllowed() && (text = view._view.block().selectedText()) != null) {
                    String textL = VisualField.this.visualToLogical(text, null, true);
                    LpexUtilities.setClipboardContents(textL, null);
                    view._view.block().delete();
                }
            }

            @Override
            public boolean available(LpexView view) {
                return view.defaultActionAvailable(85);
            }
        });
        lpexView.defineAction("paste", new LpexBaseAction(){

            @Override
            public void doAction(LpexView view) {
                VisualField.this.handlePaste();
            }

            @Override
            public boolean available(LpexView view) {
                return view.defaultActionAvailable(153);
            }
        });
        lpexView.defineAction("prevTabStop", new LpexBaseAction(){

            @Override
            public void doAction(LpexView view) {
                view.doDefaultAction(166);
                VisualField.this._pushPosition = view.currentPosition();
                if (VisualField.this._pushPosition < 2) {
                    VisualField.this._pushPosition = 2;
                    view._view.documentPosition().jump(VisualField.this._pushPosition);
                }
                VisualField.this.checkInsidePushField();
                VisualField.this._insertAtStart = false;
            }

            @Override
            public boolean available(LpexView view) {
                return view.defaultActionAvailable(166);
            }
        });
        lpexView.defineAction("selectAll", new LpexBaseAction(){

            @Override
            public void doAction(LpexView view) {
                View v = view._view;
                Block block = v.block();
                block.clear();
                v.documentPosition().jump(2);
                block.set(1, v);
                VisualField.this._pushPosition = view.elementText(1).length() + 1;
                v.documentPosition().jump(VisualField.this._pushPosition);
                block.set(1, v);
                VisualField.this.checkInsidePushField();
            }

            @Override
            public boolean available(LpexView view) {
                return view.defaultActionAvailable(37);
            }
        });
        lpexView.defineAction("toggleInsert", new LpexBaseAction(){

            @Override
            public void doAction(LpexView view) {
                VisualField.this.handleToggleInsert();
            }

            @Override
            public boolean available(LpexView view) {
                return true;
            }
        });
        lpexView.defineAction("top", new LpexBaseAction(){

            @Override
            public void doAction(LpexView view) {
                VisualField.this.endPush();
                view._view.documentPosition().jump(2);
            }

            @Override
            public boolean available(LpexView view) {
                return true;
            }
        });
        lpexView.defineAction("redo", new LpexBaseAction(){

            @Override
            public void doAction(LpexView view) {
                view.doDefaultAction(171);
                if (VisualField.this._push) {
                    VisualField.this._pushPosition = view.currentPosition();
                }
            }

            @Override
            public boolean available(LpexView view) {
                return view.defaultActionAvailable(171);
            }
        });
        lpexView.defineAction("undo", new LpexBaseAction(){

            @Override
            public void doAction(LpexView view) {
                view.doDefaultAction(205);
                if (VisualField.this._push) {
                    VisualField.this._pushPosition = view.currentPosition();
                }
            }

            @Override
            public boolean available(LpexView view) {
                return view.defaultActionAvailable(205);
            }
        });
        lpexView.defineAction("autoPush", new LpexBaseAction(){

            @Override
            public void doAction(LpexView view) {
                boolean bl = VisualField.this._autoPush = !VisualField.this._autoPush;
                if (VisualField.this._autoPush) {
                    VisualField.this._docLpexView.window().setData(VisualField.FIELD_REVERSE_PERSISTENT, null);
                    VisualField.this._fieldReverse = false;
                }
            }

            @Override
            public boolean checkable() {
                return true;
            }

            @Override
            public boolean checked(LpexView view) {
                return VisualField.this._autoPush;
            }

            @Override
            public boolean available(LpexView view) {
                return !view._view.readonly();
            }
        });
        lpexView.doDefaultCommand("set keyAction.a-p autoPush");
        lpexView.doDefaultCommand("set keyAction.a-divide.secondary autoPush");
        lpexView.defineAction("push", new LpexBaseAction(){

            @Override
            public void doAction(LpexView view) {
                if (!VisualField.this._fieldReverse) {
                    VisualField.this.startPush();
                }
            }

            @Override
            public boolean available(LpexView view) {
                return !VisualField.this._push && !view._view.readonly();
            }
        });
        lpexView.doDefaultCommand("set keyAction.c-p push");
        lpexView.doDefaultCommand("set keyAction.s-numLock.secondary push");
        lpexView.defineAction("endPush", new LpexBaseAction(){

            @Override
            public void doAction(LpexView view) {
                VisualField.this.terminatePush();
            }

            @Override
            public boolean available(LpexView view) {
                return VisualField.this._push && !view._view.readonly();
            }
        });
        lpexView.doDefaultCommand("set keyAction.c-e endPush");
        lpexView.doDefaultCommand("set keyAction.s-divide.secondary endPush");
        lpexView.defineAction("fieldReverse", new LpexBaseAction(){

            @Override
            public void doAction(LpexView view) {
                VisualField.this.handleFieldReverse(view);
            }

            @Override
            public boolean checkable() {
                return true;
            }

            @Override
            public boolean checked(LpexView view) {
                return VisualField.this._fieldReverse;
            }

            @Override
            public boolean available(LpexView view) {
                return !view._view.readonly();
            }
        });
        lpexView.doDefaultCommand("set keyAction.a-f fieldReverse");
        lpexView.doDefaultCommand("set keyAction.a-numLock.secondary fieldReverse");
        this.setPopup();
    }

    void handleFieldReverse(LpexView view) {
        boolean bl = this._fieldReverse = !this._fieldReverse;
        if (this._fieldReverse) {
            this._autoPush = false;
        }
        this.endPush();
        if (!this._docLpexView.query("parser").startsWith("cobolZos")) {
            return;
        }
        if (this._fieldReverse) {
            int commentPos;
            String str = this._docLpexView._view.documentPosition().element().text();
            int n = str.charAt(0) == '*' ? 0 : (commentPos = str.charAt(6) == '*' ? 6 : -1);
            if (commentPos >= 0) {
                int jumpToPos = commentPos + 66;
                if (view != null) {
                    view._view.documentPosition().jump(jumpToPos + 1);
                } else {
                    this._docLpexView._view.documentPosition().jump(jumpToPos);
                }
            }
            this._docLpexView.window().setData(FIELD_REVERSE_PERSISTENT, new Object());
            if (view != null) {
                view._view.setInsertMode(false);
            } else {
                this._view.setInsertMode(false);
            }
        } else {
            this._docLpexView.window().setData(FIELD_REVERSE_PERSISTENT, null);
        }
    }

    protected void handleFieldEnd(LpexView view) {
        this._pushPosition = view.queryInt("length") + 1;
        if (this._fieldReverse) {
            String str = this._docLpexView._view.documentPosition().element().text();
            this._pushPosition = str.matches("\\d{6,}.*") ? 73 : 67;
        }
        view._view.documentPosition().jump(this._pushPosition);
        this.checkInsidePushField();
    }

    protected void handleFieldHome(LpexView view) {
        this._pushPosition = 2;
        view._view.documentPosition().jump(this._pushPosition);
        this.checkInsidePushField();
        this._insertAtStart = false;
    }

    void handleLeft(LpexView view) {
        this._pushPosition = view.currentPosition();
        this._pushPosition = this._pushPosition > 2 ? this._pushPosition - 1 : 2;
        view._view.documentPosition().jump(this._pushPosition);
        this.checkInsidePushField();
        this._insertAtStart = false;
    }

    void handleRight(LpexView view) {
        this._pushPosition = view.currentPosition() + 1;
        view._view.documentPosition().jump(this._pushPosition);
        this.checkInsidePushField();
        this._insertAtStart = false;
    }

    void handleFieldReverseInput(LpexView view, Event event) {
        Element currentElement;
        int len;
        event.doit = false;
        int column = this._view.documentPosition().position() - 1 - 1;
        if (column > (len = (currentElement = this._view.documentPosition().element()).text().length())) {
            this._view.insertText(String.valueOf(event.character));
        } else {
            char prev_char = currentElement.text().charAt(column);
            if (this._view.insertMode() && prev_char == ' ') {
                this.handleBackSpace();
            }
            this._view.receiveCharacter(event.character);
        }
        this._view.screen().show();
        this._pushPosition = this._view.documentPosition().position();
        if (!this._view.insertMode()) {
            --this._pushPosition;
        }
        this._pushPosition = this._pushPosition > 2 ? this._pushPosition - 1 : 2;
        this._view.documentPosition().jump(this._pushPosition);
        this._view.screen().show();
    }

    void handleKeyPressed(Event e) {
        if (this._push && e.character >= ' ' && e.character != '\u007f' && (e.stateMask & 0x50000) == 0) {
            if (this.isEndPushCharacter(e.character)) {
                if (this.hasSelection() || e.character >= '0' && e.character <= '9') {
                    this.endPush();
                } else {
                    this.terminatePush();
                }
                return;
            }
            if (this._pushPosition == this._pushFieldStart && !this._view.insertMode() && !this.hasSelection() && this._insertAtStart) {
                int textLimit;
                Element element = this._view.documentPosition().element();
                int textLength = element.length();
                if (textLength >= (textLimit = this._view.getFieldLimit(this._view.documentPosition().position(), element))) {
                    this._pushPosition = this._pushPosition > 2 ? this._pushPosition - 1 : 2;
                    this._pushFieldStart = this._pushPosition;
                    this._view.documentPosition().jump(this._pushPosition);
                    this.checkInsidePushField();
                } else {
                    e.doit = false;
                    this._view.insertText(String.valueOf(e.character));
                    this._view.screen().show();
                }
            }
        }
    }

    void handleDocumentChanged(int type, int line, int position, int count) {
        if (type == 4) {
            if (this._push) {
                String text = this._lpexView.elementText(1);
                int oldLen = this._text.length();
                int newLen = text.length();
                if (newLen > oldLen) {
                    int start = 0;
                    while (start < oldLen && start < newLen && this._text.charAt(start) == text.charAt(start)) {
                        ++start;
                    }
                    this._pushFieldEnd += newLen - oldLen;
                    this.showPushField();
                } else if (newLen < oldLen) {
                    int start = 0;
                    while (start < oldLen && start < newLen && this._text.charAt(start) == text.charAt(start)) {
                        ++start;
                    }
                    this.textRemovedInPush(start + 1, oldLen - newLen, true);
                }
            }
        } else if (type == 2 || type == 1) {
            if (!this._pasting && count == 1) {
                String newText;
                char c;
                if (this._push) {
                    if (type == 1) {
                        if (position == this._pushFieldStart && position == this._pushPosition) {
                            this._insertAtStart = true;
                        } else {
                            this._insertAtStart = false;
                            if (position > this._pushFieldStart && position == this._pushPosition) {
                                --this._pushPosition;
                            }
                        }
                    } else if (position <= this._pushFieldEnd) {
                        ++this._pushFieldEnd;
                        this.showPushField();
                    }
                } else if (this._autoPush && this.isStartPushCharacter(c = (newText = this._lpexView.elementText(1)).charAt(position - 1))) {
                    this.startPush(position);
                }
            }
        } else if (type == 0 && this._push) {
            this.textRemovedInPush(position, count, false);
        }
    }

    void textRemovedInPush(int position, int count, boolean undoing) {
        if (position > this._pushFieldEnd) {
            return;
        }
        if (position == this._pushFieldStart) {
            if (position + count > this._pushFieldEnd) {
                this.endPush();
                return;
            }
            this._pushFieldEnd -= count;
            if (!undoing) {
                this._pushPosition = this._lpexView.currentPosition();
            }
            this.showPushField();
            return;
        }
        if (position + count <= this._pushFieldEnd) {
            this._pushFieldEnd -= count;
            if (!undoing) {
                this._pushPosition = this._lpexView.currentPosition();
            }
            this.showPushField();
            return;
        }
        this._pushFieldEnd = position - 1;
        if (!undoing) {
            this._pushPosition = this._lpexView.currentPosition();
            this.checkInsidePushField();
        }
        this.showPushField();
    }

    void handleShowing() {
        this._view.document().undo().check(this._view);
        this._text = this._lpexView.elementText(1);
        if (this._push && this._pushPosition != this._lpexView.currentPosition()) {
            this._view.documentPosition().jump(this._pushPosition);
        }
        this._view.block().validate();
        int column = this._view.currentColumn(this._view.documentPosition().element().elementView(this._view));
        --column;
        if (this._push) {
            boolean selection = this.hasSelection();
            if (this._pushPosition >= this._pushFieldStart && (this._view.insertMode() || selection) || this._pushPosition == this._pushFieldStart && !this._view.insertMode() && !selection && this._insertAtStart) {
                --column;
            }
        }
        if ((this._style & 1) != 0) {
            ((FormatLine)this._lpexWindow.formatLine()).setColumn(column);
        }
        if (this._docLpexView != null && (this._style & 2) != 0) {
            ((FormatLine)this._docLpexView.window().formatLine()).setColumn(column);
            this._docLpexView.window().statusLineManager().setColumn(this._docLpexView, column);
            this._docLpexView.window().statusLineManager().setInputMode(this._view.insertMode() ? 1 : 2);
            int position = 0;
            if (this._push) {
                if (this._view.insertMode()) {
                    if (this._pushPosition > this._pushFieldStart) {
                        position = this._view.documentPosition().position() - 1;
                    }
                } else if (!this._insertAtStart) {
                    position = this._view.documentPosition().position();
                }
            } else {
                position = this._view.documentPosition().position();
            }
            String info = position > 0 && position <= this._text.length() ? LpexNls.specialCharacterInfo(this._text.charAt(position - 1)) : null;
            this._docLpexView.window().statusLineManager().setInfo(info);
            ((StatusLine)this._docLpexView.window().statusLine()).updateStatus();
        }
    }

    void handleBackSpace() {
        if (this._push) {
            if (this._pushPosition <= this._pushFieldEnd) {
                this._lpexView.doDefaultAction(86);
            }
        } else if (this._lpexView.currentPosition() > 2) {
            this._lpexView.doDefaultAction(31);
        }
    }

    void handleDelete() {
        if (this._push) {
            if (this._view.insertMode()) {
                if (this._pushPosition > this._pushFieldStart) {
                    --this._pushPosition;
                    this._view.documentPosition().jump(this._pushPosition);
                    this._lpexView.doDefaultAction(86);
                }
            } else if (!this._insertAtStart) {
                this._lpexView.doDefaultAction(86);
            }
        } else {
            this._lpexView.doDefaultAction(86);
        }
    }

    void handlePaste() {
        this._pasting = true;
        String pasteText = this.getPasteText(LpexUtilities.getClipboardContents());
        if (pasteText != null) {
            ActionUtilities.doPasteAction(this._view, pasteText);
            if (this._push) {
                this._pushFieldEnd += pasteText.length();
                this.showPushField();
            }
        }
        this._pasting = false;
    }

    void handleToggleInsert() {
        this._view.setInsertMode(!this._view.insertMode());
        if (this._push && !this.hasSelection()) {
            if (this._view.insertMode()) {
                if (!this._insertAtStart) {
                    ++this._pushPosition;
                }
            } else {
                if (this._pushFieldEnd < this._pushFieldStart) {
                    this.endPush();
                    return;
                }
                if (this._pushPosition > this._pushFieldStart) {
                    --this._pushPosition;
                }
                this._insertAtStart = false;
            }
        }
    }

    void doBlockAction(int lpexActionId) {
        this._lpexView.doDefaultAction(lpexActionId);
        this.checkSelection();
        this.checkInsidePushField();
        this._insertAtStart = false;
    }

    void startPush() {
        if (!this._push) {
            this._push = true;
            this.setPopup();
            if (this.hasSelection()) {
                int topPosition = this._view.block().topPosition();
                int bottomPosition = this._view.block().bottomPosition();
                this._pushFieldStart = this._pushPosition = this._view.block().anchorAtTop() ? bottomPosition : topPosition;
                this._pushFieldEnd = bottomPosition - 1;
                this._insertAtStart = false;
            } else {
                this._pushFieldStart = this._pushPosition = this._lpexView.currentPosition();
                if (this._view.insertMode()) {
                    this._pushFieldEnd = this._pushPosition - 1;
                    this._insertAtStart = true;
                } else {
                    this._pushFieldEnd = this._pushPosition;
                    this._insertAtStart = false;
                }
            }
            this.showPushField();
        }
    }

    void startPush(int position) {
        if (!this._push) {
            this._push = true;
            this.setPopup();
            this._pushPosition = position;
            this._pushFieldStart = this._pushFieldEnd = position;
            this.showPushField();
            this._insertAtStart = true;
        }
    }

    boolean endPush() {
        if (this._push) {
            this._push = false;
            this.setPopup();
            this.showPushField();
            return true;
        }
        return false;
    }

    void terminatePush() {
        int position = this._pushFieldEnd + 1;
        if (this.endPush()) {
            this._view.documentPosition().jump(position);
        }
    }

    void checkInsidePushField() {
        if (this._push && (this._pushPosition < this._pushFieldStart || this._pushPosition > this._pushFieldEnd + 1 || this._pushPosition == this._pushFieldEnd + 1 && !this._view.insertMode() && !this.hasSelection())) {
            this.endPush();
        }
    }

    void checkSelection() {
        if (this.hasSelection()) {
            Block block = this._view.block();
            int topPosition = block.topPosition();
            int bottomPosition = block.bottomPosition();
            boolean anchorAtTop = block.anchorAtTop();
            if (topPosition <= 1) {
                topPosition = 2;
                block.clear();
                this._view.documentPosition().jump(anchorAtTop ? topPosition : bottomPosition);
                block.set(1, this._view);
                this._view.documentPosition().jump(anchorAtTop ? bottomPosition : topPosition);
                block.set(1, this._view);
            }
            if (this._push) {
                this._pushPosition = anchorAtTop ? bottomPosition : topPosition;
            }
        }
    }

    void setPopup() {
        StringBuilder sb = new StringBuilder(256);
        sb.append("set popup");
        if (this._smartLogical) {
            sb.append(" popup.insertLrm insertLtrMark popup.insertRlm insertRtlMark");
        }
        if (this._view.document()._sourceArabic) {
            sb.append(" popup.arabicDigits arabicDigits");
        }
        sb.append(" separator").append(" popup.autoPush autoPush").append(this._push ? " popup.endPush endPush" : " popup.push push");
        sb.append(" popup.fieldReverse fieldReverse");
        sb.append(" separator").append(" popup.cut cut popup.copy copy popup.paste paste");
        this.cmd(sb.toString());
    }

    void setVisualText(String text, int position) {
        String newText = this.HEADER + ((text = text.replaceAll("\u0082", "")) != null ? text : "");
        if (position < 1) {
            position = 1;
        }
        ++position;
        boolean readonly = this._view.readonly();
        if (readonly) {
            this._view.setReadonly(false);
        }
        this.cmd("set text " + newText);
        this._view.documentPosition().jump(position);
        if (readonly) {
            this._view.setReadonly(true);
        }
    }

    void setVisualText(String text) {
        this.setVisualText(text, this.getPosition());
    }

    String getText() {
        String visualText = this._lpexView.elementText(1);
        if (visualText != null && visualText.startsWith(this.HEADER)) {
            visualText = visualText.substring(1);
        }
        return visualText;
    }

    int getPosition() {
        return this._view.documentPosition().position() - 1;
    }

    void showPushField() {
        DocumentPosition dp = this._view.documentPosition();
        if (this._push) {
            if (dp.emphasisPosition() != this._pushFieldStart) {
                dp.setEmphasisPosition(this._pushFieldStart);
            }
            dp.setEmphasisLength(this._pushFieldEnd - this._pushFieldStart + 1);
        } else {
            dp.setEmphasisLength(0);
        }
    }

    void cmd(String lpexCommand) {
        CommandHandler.doDefaultCommand(this._view, lpexCommand);
    }

    boolean hasSelection() {
        return this._view.block().view() == this._view && this._view.block().anythingSelected();
    }

    void scrollIntoView() {
        int scroll = this._view.screen().scroll();
        int position = this._lpexView.currentPosition();
        LpexDocumentLocation loc = new LpexDocumentLocation(1, position);
        int startPixelPosition = this._lpexView.queryInt("pixelPosition", loc);
        if (startPixelPosition - scroll < 0) {
            this._view.screen().setScroll(startPixelPosition);
        } else {
            loc.position = position;
            int endPixelPosition = this._lpexView.queryInt("pixelPosition", loc);
            int width = this._view.screen().textAreaWidth();
            if (width > 0 && endPixelPosition - scroll > width) {
                this._view.screen().setScroll(endPixelPosition - width);
            }
        }
    }

    String logicalToVisual(String text, int[] position) {
        if (text == null || text.length() == 0) {
            return text;
        }
        BidiFlagSet flags1 = bidiFlagsLogical;
        BidiFlagSet flags2 = bidiFlagsVisual;
        BidiTransform bdx = new BidiTransform();
        bdx.flags = flags2;
        if (position != null && position.length != 0 && position[0] <= text.length()) {
            bdx.srcToDstMapRequired = true;
        }
        bdx.removeMarkers = this._smartLogical;
        BidiText src = new BidiText(flags1, text);
        BidiText dst = src.transform(bdx);
        String visualText = dst.toString();
        if (position != null && position.length != 0) {
            int pos = position[0];
            if (bdx.removeMarkers) {
                while (pos <= text.length() && LpexNls.isBidiMark(text.charAt(pos - 1))) {
                    ++pos;
                }
            }
            position[0] = pos <= text.length() ? bdx.srcToDstMap[pos - 1] + 1 : visualText.length() + (pos - text.length());
        }
        return visualText;
    }

    String visualToLogical(String text) {
        return this.visualToLogical(text, null);
    }

    String visualToLogical(String text, int[] position) {
        return this.visualToLogical(text, position, this._smartLogical);
    }

    String visualToLogical(String text, int[] position, boolean smartLogical) {
        if (text == null || text.length() == 0) {
            return text;
        }
        BidiFlagSet flags1 = bidiFlagsVisual;
        BidiFlagSet flags2 = bidiFlagsLogical;
        BidiTransform bdx = new BidiTransform();
        bdx.flags = flags2;
        if (position != null && position.length != 0 && position[0] <= text.length()) {
            bdx.srcToDstMapRequired = true;
        }
        bdx.insertMarkers = smartLogical;
        bdx.removeMarkers = !smartLogical;
        bdx.winCompatible = true;
        BidiText src = new BidiText(flags1, text);
        BidiText dst = src.transform(bdx);
        String logicalText = dst.toString();
        if (position != null && position.length != 0) {
            position[0] = position[0] <= text.length() ? bdx.srcToDstMap[position[0] - 1] + 1 : logicalText.length() + (position[0] - text.length());
        }
        return logicalText;
    }

    static String unBidiText(String s) {
        if (s == null || s.length() == 0) {
            return "";
        }
        StringBuilder text = new StringBuilder(s.length() * 2 + 2);
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '\u200e') {
                c = '\u00bb';
            } else if (c == '\u200f') {
                c = '\u00ab';
            }
            if (Character.getDirectionality(c) == 1) {
                text.append("\\u" + String.valueOf((Object)c));
            } else {
                text.append(c);
            }
            ++i;
        }
        return text.toString();
    }

    boolean isStartPushCharacter(char c) {
        return c >= '\u05d0' && c <= '\u05ea' || c >= '\u0621' && c <= '\u0652';
    }

    boolean isEndPushCharacter(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9';
    }

    String getPasteText(String text) {
        if (text == null || text.length() == 0) {
            return text;
        }
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (c == '\n' || c == '\r') break;
            ++i;
        }
        if (i < text.length()) {
            text = text.substring(0, i);
        }
        return this.logicalToVisual(text, null);
    }

    String getNameText(String text) {
        int indexOfMnemonic;
        if (text != null && (indexOfMnemonic = ((String)text).indexOf(38)) >= 0 && indexOfMnemonic + 1 < ((String)text).length()) {
            text = ((String)text).substring(0, indexOfMnemonic) + ((String)text).substring(indexOfMnemonic + 1);
        }
        return text;
    }

    public static String BidiV2L(String text) {
        BidiTransform bdx = new BidiTransform();
        bdx.flags = bidiFlagsLogical;
        bdx.removeMarkers = true;
        BidiText src = new BidiText(bidiFlagsVisual, text);
        BidiText dst = src.transform(bdx);
        String result = dst.toString();
        return result;
    }

    public static String BidiL2V(String text) {
        BidiTransform bdx = new BidiTransform();
        bdx.flags = bidiFlagsVisual;
        BidiText src = new BidiText(bidiFlagsLogical, text);
        bdx.removeMarkers = false;
        BidiText dst = src.transform(bdx);
        String result = dst.toString();
        return result;
    }

    public static void BidiL2V(LpexView view, int iElement) {
        String strElement = view.elementText(iElement);
        strElement = VisualField.BidiL2V(strElement);
        VisualField.setElementText(view, iElement, strElement);
    }

    public static void BidiV2L(LpexView view, int iElement) {
        String strElement = view.elementText(iElement);
        if (strElement == null) {
            return;
        }
        if (strElement.trim().length() < 2) {
            return;
        }
        strElement = VisualField.BidiV2L(strElement);
        VisualField.setElementText(view, iElement, strElement);
    }

    public static String BidiV2LByColorStr(LpexView view, int iElement) {
        String strElement = view.elementText(iElement);
        String strStyles = view.elementStyle(iElement);
        if (strElement == null || strStyles == null) {
            return strElement;
        }
        if (strElement.trim().length() < 2) {
            return strElement;
        }
        if (strStyles.length() == 0) {
            return strElement;
        }
        StringBuffer result = new StringBuffer();
        StringBuffer tmp = new StringBuffer();
        char prev = '\uffff';
        int i = 0;
        while (i < strElement.length()) {
            char current = strStyles.charAt(i);
            if (current != prev) {
                result.append(VisualField.BidiV2L(tmp.toString()));
                tmp.delete(0, tmp.length());
                prev = current;
            }
            tmp.append(strElement.charAt(i));
            ++i;
        }
        result.append(VisualField.BidiV2L(tmp.toString()));
        return result.toString();
    }

    public static void BidiV2LByColor(LpexView view, int iElement) {
        VisualField.setElementText(view, iElement, VisualField.BidiV2LByColorStr(view, iElement));
    }

    public static void setElementText(LpexView view, int iElement, String str) {
        if (str == null) {
            return;
        }
        if (str.trim().length() < 2) {
            return;
        }
        String recordingChanges = view.query("recording");
        view.doCommand("set recording off");
        view.setElementText(iElement, str);
        view.doCommand("set recording " + recordingChanges);
    }

    public static void putVisualTextToLogicalView(LpexView _view, int iElement) {
        String strStyles = _view.elementStyle(iElement);
        VisualField.putVisualTextToLogicalView(_view, iElement, strStyles);
    }

    public static void putVisualTextToLogicalView(LpexView _view, int iElement, String strStyles) {
        VisualField.BidiV2LByColor(_view, iElement);
        VisualField.addBiDirectionalMarkers(_view, iElement, 35, 80, 63);
        _view.setElementStyle(iElement, strStyles);
    }

    public static boolean isTextHasBidi(LpexView _view, int iElement) {
        String strElement = _view.elementText(iElement);
        int i = 0;
        while (i < strElement.length()) {
            if (Character.getDirectionality(strElement.charAt(i)) == 1 || Character.getDirectionality(strElement.charAt(i)) == 2) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void addBiDirectionalMarkers(LpexView view, int iElement, int startRTLpos, int endRTLpos, int startNumberpos) {
        String strElement = view.elementText(iElement);
        int indexRTL = -1;
        int i = 0;
        while (i < strElement.length()) {
            if (Character.getDirectionality(strElement.charAt(i)) == 1 || Character.getDirectionality(strElement.charAt(i)) == 2) {
                indexRTL = i;
                break;
            }
            ++i;
        }
        if (indexRTL >= startRTLpos && indexRTL < endRTLpos && strElement.length() > startNumberpos) {
            StringBuffer strBuffer;
            int index = startNumberpos;
            boolean found = false;
            i = index;
            while (i < strElement.length() && !found) {
                if (strElement.charAt(i) != ' ') {
                    found = true;
                    index = i;
                }
                ++i;
            }
            if (Character.isDigit(strElement.charAt(index)) && (strBuffer = new StringBuffer(strElement)).charAt(index) != '\u200e') {
                strBuffer.insert(index, '\u200e');
                String recordingChanges = view.query("recording");
                view.doCommand("set recording off");
                view.setElementText(iElement, strBuffer.toString());
                view.doCommand("set recording " + recordingChanges);
            }
        }
    }
}

