/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.List;
import com.ibm.lpex.core.ListNode;
import com.ibm.lpex.core.LpexUtilities;
import com.ibm.lpex.core.LpexViewListener;
import com.ibm.lpex.core.View;

final class ViewListenerList
extends List {
    private View _view;
    private boolean _readonlyChangeAttempted;

    ViewListenerList(View view) {
        this._view = view;
    }

    void addListener(LpexViewListener listener) {
        if (this.find(listener) == null) {
            this.addAfter(null, new ListenerNode(listener));
        }
    }

    void removeListener(LpexViewListener listener) {
        ListenerNode node;
        if (listener != null && (node = this.find(listener)) != null) {
            this.remove(node);
        }
    }

    void showing() {
        this.beginScanning();
        ListenerNode node = (ListenerNode)this.first();
        while (node != null) {
            if (!node.isNotifying()) {
                node.setNotifying(true);
                node.listener().showing(this._view.lpexView());
                node.setNotifying(false);
            }
            node = (ListenerNode)node.next();
        }
        this.endScanning();
    }

    void shown() {
        this.beginScanning();
        ListenerNode node = (ListenerNode)this.first();
        while (node != null) {
            if (!node.isNotifying()) {
                node.setNotifying(true);
                node.listener().shown(this._view.lpexView());
                node.setNotifying(false);
            }
            node = (ListenerNode)node.next();
        }
        this.endScanning();
    }

    boolean saving() {
        boolean abort = false;
        this.beginScanning();
        ListenerNode node = (ListenerNode)this.first();
        while (node != null && !abort) {
            abort = node.listener().saving(this._view.lpexView());
            node = (ListenerNode)node.next();
        }
        this.endScanning();
        return abort;
    }

    void saved() {
        this.beginScanning();
        ListenerNode node = (ListenerNode)this.first();
        while (node != null) {
            node.listener().saved(this._view.lpexView());
            node = (ListenerNode)node.next();
        }
        this.endScanning();
    }

    boolean renaming() {
        boolean abort = false;
        this.beginScanning();
        ListenerNode node = (ListenerNode)this.first();
        while (node != null && !abort) {
            abort = node.listener().renaming(this._view.lpexView());
            node = (ListenerNode)node.next();
        }
        this.endScanning();
        return abort;
    }

    void renamed() {
        this.beginScanning();
        ListenerNode node = (ListenerNode)this.first();
        while (node != null) {
            node.listener().renamed(this._view.lpexView());
            node = (ListenerNode)node.next();
        }
        this.endScanning();
    }

    void setReadonlyChangeAttempted() {
        this._readonlyChangeAttempted = true;
    }

    void readonly() {
        if (this._readonlyChangeAttempted) {
            this.beginScanning();
            ListenerNode node = (ListenerNode)this.first();
            while (node != null) {
                node.listener().readonly(this._view.lpexView());
                node = (ListenerNode)node.next();
            }
            this.endScanning();
            this._readonlyChangeAttempted = false;
        }
    }

    void updateProfile() {
        LpexUtilities.viewListenerListUpdateProfile(this);
    }

    void fireUpdateProfile() {
        this.beginScanning();
        ListenerNode node = (ListenerNode)this.first();
        while (node != null) {
            node.listener().updateProfile(this._view.lpexView());
            node = (ListenerNode)node.next();
        }
        this.endScanning();
    }

    void disposed() {
        this.beginScanning();
        ListenerNode node = (ListenerNode)this.first();
        while (node != null) {
            node.listener().disposed(this._view.lpexView());
            node = (ListenerNode)node.next();
        }
        this.endScanning();
    }

    ListenerNode find(LpexViewListener listener) {
        ListenerNode node = (ListenerNode)this.first();
        while (node != null) {
            if (node.listener() == listener) {
                return node;
            }
            node = (ListenerNode)node.next();
        }
        return null;
    }

    static final class ListenerNode
    extends ListNode {
        private LpexViewListener _listener;
        private boolean _isNotifying;

        ListenerNode(LpexViewListener listener) {
            this._listener = listener;
        }

        LpexViewListener listener() {
            return this._listener;
        }

        boolean isNotifying() {
            return this._isNotifying;
        }

        void setNotifying(boolean isNotifying) {
            this._isNotifying = isNotifying;
        }
    }
}

