/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.alef.LpexAbstractTextEditor;
import com.ibm.lpex.core.Block;
import com.ibm.lpex.core.BlockCommand;
import com.ibm.lpex.core.Color;
import com.ibm.lpex.core.CommandLine;
import com.ibm.lpex.core.DisplayStyle;
import com.ibm.lpex.core.DisplayTextLayout;
import com.ibm.lpex.core.Document;
import com.ibm.lpex.core.DocumentPosition;
import com.ibm.lpex.core.Element;
import com.ibm.lpex.core.ElementView;
import com.ibm.lpex.core.Font;
import com.ibm.lpex.core.FormatLine;
import com.ibm.lpex.core.LpexLog;
import com.ibm.lpex.core.LpexUtilities;
import com.ibm.lpex.core.LpexView;
import com.ibm.lpex.core.LpexViewAdapter;
import com.ibm.lpex.core.LpexWindow;
import com.ibm.lpex.core.PopupParameter;
import com.ibm.lpex.core.PrefixAreaTextParameter;
import com.ibm.lpex.core.Screen;
import com.ibm.lpex.core.StyleAttributes;
import com.ibm.lpex.core.StyleAttributesList;
import com.ibm.lpex.core.TextFontMetrics;
import com.ibm.lpex.core.TextWindowDropTargetEffect;
import com.ibm.lpex.core.View;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModelEvent;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationAccessExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.IAnnotationModelExtension2;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.IAnnotationModelListenerExtension;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleTextAdapter;
import org.eclipse.swt.accessibility.AccessibleTextEvent;
import org.eclipse.swt.accessibility.AccessibleTextListener;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.dnd.IDragAndDropService;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.AnnotationPreferenceLookup;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.IDocumentProvider;

public final class TextWindow
extends Canvas {
    private LpexWindow _lpexWindow;
    private FocusListener _focusListener;
    private PaintListener _paintListener;
    private ControlListener _resizeListener;
    private Runnable _cursorBlinkTimer;
    private boolean _cursorBlinkTimerRunning;
    private Runnable _dragTimer;
    private Rectangle _bottomRect;
    private boolean _bottomValid;
    private StyleAttributes _bottomStyleAttributes;
    private Cursor _textCursor;
    private Cursor _arrowCursor;
    private Line _topLine;
    private Line _cachedLines;
    private SubLine _cachedSubLines;
    private boolean _doKeyEventActive;
    private Cursor _cursor;
    private boolean _focusGained;
    private MouseEvent _lastDragEvent;
    private boolean _cursorVisible;
    private Display _display;
    private static final int DRAGTIMER_INTERVAL = 40;
    private Caret _caret;
    private int _imeX;
    private int _imeY;
    private boolean _caretResizePending;
    private Menu _popupMenu;
    private int _dragAndDropParm = 2;
    private boolean _dragAndDropInstalled;
    private DragSource _dragSource;
    private DragSourceListener _dragSourceListener;
    private static View _dragSourceView;
    private static View _dropTargetView;
    private int _clickCount;
    private Event _lpexKeyEvent = new Event();
    private Rectangle _clipBounds = new Rectangle(0, 0, 0, 0);
    private String _eol = System.getProperty("line.separator");
    private int _eolLength = this._eol.length();
    private AccessibleListener _accessibleListener;
    private IAnnotationAccess _annotationAccess = new DefaultMarkerAnnotationAccess();
    private IAnnotationModel _model;
    private TextWindowModelListener _annotationListener = new TextWindowModelListener();
    private Map<RGB, org.eclipse.swt.graphics.Color> _colorMap = new HashMap<RGB, org.eclipse.swt.graphics.Color>();

    TextWindow(LpexWindow lpexWindow) {
        super((Composite)lpexWindow, 1311488);
        this._lpexWindow = lpexWindow;
        this._display = this.getDisplay();
        this._textCursor = this._display.getSystemCursor(19);
        this._arrowCursor = this._display.getSystemCursor(0);
        this.setDragDetect(false);
        this._focusListener = new FocusListener(){

            public void focusGained(FocusEvent e) {
                TextWindow.this.handleFocusGained(e);
            }

            public void focusLost(FocusEvent e) {
                TextWindow.this.handleFocusLost(e);
            }
        };
        this.addFocusListener(this._focusListener);
        this._paintListener = new PaintListener(){

            public void paintControl(PaintEvent e) {
                TextWindow.this.paintComponent(new LpexGC(e.gc), e.x, e.y, e.width, e.height);
            }
        };
        this.addPaintListener(this._paintListener);
        this.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                TextWindow.this.doMouseEvent(e, 12);
            }

            public void mouseDown(MouseEvent e) {
                TextWindow.this.doMouseEvent(e, 7);
            }

            public void mouseUp(MouseEvent e) {
                TextWindow.this.doMouseEvent(e, 8);
            }
        });
        this.addMouseTrackListener(new MouseTrackListener(){

            public void mouseEnter(MouseEvent e) {
                TextWindow.this.doMouseEvent(e, 3);
            }

            public void mouseExit(MouseEvent e) {
                TextWindow.this.doMouseEvent(e, 4);
            }

            public void mouseHover(MouseEvent e) {
                TextWindow.this.doMouseEvent(e, 11);
            }
        });
        this.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if ((e.stateMask & 0x380000) != 0) {
                    if (TextWindow.this._clickCount != 0) {
                        TextWindow.this.doMouseEvent(e, 2);
                    }
                } else {
                    TextWindow.this.doMouseEvent(e, 5);
                }
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            public void mouseScrolled(MouseEvent e) {
                TextWindow.this.doMouseEvent(e, e.count > 0 ? 10 : 9);
            }
        });
        this.addListener(1, new Listener(){

            public void handleEvent(Event e) {
                TextWindow.this.processKeyEvent(e);
            }
        });
        this.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                event.doit = false;
            }
        });
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                TextWindow.this.handleDispose();
            }
        });
        this._cursorBlinkTimer = new Runnable(){

            @Override
            public void run() {
                TextWindow.this.toggleCursor(false);
                TextWindow.this._display.timerExec(TextWindow.this.cursorBlinkTime(), (Runnable)this);
                TextWindow.this._cursorBlinkTimerRunning = true;
            }
        };
        this._dragTimer = new Runnable(){

            @Override
            public void run() {
                if (TextWindow.this._lastDragEvent != null) {
                    TextWindow.this.doMouseEvent(TextWindow.this._lastDragEvent, 2);
                }
            }
        };
        this.setCursor(this._textCursor);
        this._caret = new Caret((Canvas)this, 0);
        this._caret.setVisible(false);
        if (LpexUtilities.isBidi()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    TextWindow.this.bidiLanguageChanged();
                }
            };
            LpexUtilities.addLanguageListener((Control)this, runnable);
        }
        this._resizeListener = new ControlListener(){

            public void controlResized(ControlEvent e) {
                TextWindow.this.textWindowResized();
            }

            public void controlMoved(ControlEvent e) {
            }
        };
        this.initializeAccessible();
    }

    private boolean isDndDragStart(MouseEvent e) {
        if (this.isListening(29) && e.button == ("motif".equals(SWT.getPlatform()) ? 2 : 1)) {
            View view = this.view();
            if (BlockCommand.DragAndDropParameter.getParameter().currentValue(view) && view.block().partOfBlock(view, e.x, e.y)) {
                return this.dragDetect(e);
            }
        }
        return false;
    }

    private void installDnd() {
        if (this._dragAndDropInstalled || !this.dragAndDropEnabled()) {
            return;
        }
        this._dragAndDropInstalled = true;
        this.setData("DEFAULT_DROP_TARGET_EFFECT", (Object)new TextWindowDropTargetEffect(this));
        this._dragSourceListener = new DragSourceListener(){
            String selectedText;

            public void dragStart(DragSourceEvent e) {
                _dragSourceView = null;
                _dropTargetView = null;
                View view = TextWindow.this.view();
                if (view == null) {
                    e.doit = false;
                    return;
                }
                if (!TextWindow.this.dragAndDropEnabled()) {
                    e.doit = false;
                    e.image = null;
                    return;
                }
                this.selectedText = view.block().selectedText();
                if (this.selectedText == null || this.selectedText.length() == 0) {
                    e.doit = false;
                    return;
                }
                _dragSourceView = view;
            }

            public void dragSetData(DragSourceEvent e) {
                e.data = this.selectedText;
            }

            public void dragFinished(DragSourceEvent e) {
                View view;
                if (e.detail == 2 && (view = TextWindow.this.view()) != null && view.block().type() != 0 && view.block().view() == view && _dropTargetView != view && TextWindow.this.validateEditorInputState()) {
                    view.block().delete();
                    Document.screenShow(view.screen());
                }
                _dragSourceView = null;
                _dropTargetView = null;
            }
        };
        this.installDragSource();
        DropTargetAdapter dropTargetListener = new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent e) {
                if (!TextWindow.this.canDndDropInHere()) {
                    e.detail = 0;
                    e.feedback = 0;
                    return;
                }
                _dropTargetView = null;
                if (!TextWindow.this.dragAndDropEnabled()) {
                    e.detail = 0;
                    e.feedback = 0;
                    return;
                }
                if (e.detail == 16) {
                    if ((e.operations & 2) != 0) {
                        e.detail = 2;
                        if (!TextWindow.this.canDndMoveFromSource()) {
                            e.detail = 1;
                        }
                    } else {
                        e.detail = (e.operations & 1) != 0 ? 1 : 0;
                    }
                }
                TextWindow.this.view().screen().setKeepCursorVisible(false);
            }

            public void dragOperationChanged(DropTargetEvent e) {
                if (!TextWindow.this.dragAndDropEnabled() || !TextWindow.this.canDndDropInHere()) {
                    e.detail = 0;
                    e.feedback = 0;
                    return;
                }
                if (e.detail == 16) {
                    if ((e.operations & 2) != 0) {
                        e.detail = 2;
                        if (!TextWindow.this.canDndMoveFromSource()) {
                            e.detail = 1;
                        }
                    } else {
                        e.detail = (e.operations & 1) != 0 ? 1 : 0;
                    }
                }
            }

            public void dragOver(DropTargetEvent e) {
                if (!TextWindow.this.canDndDropInHere() || !TextWindow.this.dragAndDropEnabled()) {
                    e.feedback = 0;
                    return;
                }
                e.feedback |= 8;
            }

            public void drop(DropTargetEvent e) {
                _dropTargetView = null;
                if (!TextWindow.this.dragAndDropEnabled()) {
                    return;
                }
                if (!TextWindow.this.validateEditorInputState()) {
                    e.detail = 0;
                    return;
                }
                View view = TextWindow.this.view();
                if (view != null) {
                    Block block = view.block();
                    if (_dragSourceView != null && _dragSourceView.block() == block) {
                        if (e.detail == 2) {
                            block.move(view);
                            _dropTargetView = view;
                        } else {
                            block.copy(view);
                        }
                    } else {
                        String text = (String)e.data;
                        if (text != null) {
                            int textType;
                            int blockType = textType = _dragSourceView != null ? _dragSourceView.block().type() : 0;
                            if (blockType == 0 && ((blockType = BlockCommand.DefaultTypeParameter.getParameter().currentValue(view)) == 4 || blockType == 3)) {
                                blockType = 1;
                            }
                            block.insertText(view, text, textType, blockType);
                        }
                    }
                    LpexWindow lw = view.window();
                    if (lw != null && !lw.isDisposed()) {
                        lw.setFocus();
                    }
                    Document.screenShow();
                }
                _dragSourceView = null;
            }
        };
        LpexAbstractTextEditor textEditor = this.textEditor();
        if (textEditor != null) {
            IWorkbenchPartSite site = textEditor.getSite();
            IDragAndDropService dndService = (IDragAndDropService)site.getService(IDragAndDropService.class);
            if (dndService != null) {
                dndService.addMergedDropTarget((Control)this, 3, new Transfer[]{TextTransfer.getInstance()}, (DropTargetListener)dropTargetListener);
            }
        } else {
            DropTarget target = new DropTarget((Control)this, 3);
            target.setTransfer(new Transfer[]{TextTransfer.getInstance()});
            target.addDropListener((DropTargetListener)dropTargetListener);
        }
    }

    private boolean validateEditorInputState() {
        LpexAbstractTextEditor textEditor = this.textEditor();
        return textEditor == null || textEditor.validateEditorInputState();
    }

    private void installDragSource() {
        if (!this._dragAndDropInstalled) {
            return;
        }
        this.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                TextWindow.this.uiThreadInstallDragSource();
            }
        });
    }

    protected void uiThreadInstallDragSource() {
        int flags;
        View view = this.view();
        int n = flags = view != null && view.readonly() ? 1 : 3;
        if (this._dragSource != null) {
            if ((this._dragSource.getStyle() & 3) == flags) {
                return;
            }
            this._dragSource.removeDragListener(this._dragSourceListener);
            this._dragSource.dispose();
        }
        this._dragSource = new DragSource((Control)this, flags);
        this._dragSource.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        this._dragSource.addDragListener(this._dragSourceListener);
    }

    private boolean dragAndDropEnabled() {
        View view = this.view();
        return view != null && BlockCommand.DragAndDropParameter.getParameter().currentValue(view);
    }

    private boolean canDndMoveFromSource() {
        return _dragSourceView == null || _dragSourceView.block().view() != _dragSourceView || !_dragSourceView.readonly() && _dragSourceView.block().anythingNonshowUnprotectedSelected();
    }

    private boolean canDndDropInHere() {
        View view = this.view();
        return view != null && !view.readonly() && view.documentPosition().element() != null;
    }

    void setDragAndDrop(int dragAndDropParm) {
        this._dragAndDropParm = dragAndDropParm;
    }

    int dragAndDrop() {
        return this._dragAndDropParm;
    }

    void dragAndDropChanged() {
        if (this.dragAndDropEnabled()) {
            this.installDnd();
        }
    }

    private void handleFocusGained(FocusEvent e) {
        View view;
        this._focusGained = true;
        if (LpexUtilities.isBidi() && (view = this.view()) != null) {
            view.documentPosition().restoreKeyboardLanguage();
        }
        this._lpexWindow.setFocusWidget((Widget)this);
        this.setCursorVisible(true);
        if (this._caretResizePending) {
            this.resizeCaret();
        }
        CommandLine commandLine = (CommandLine)this._lpexWindow.commandLine();
        commandLine.setMode(0);
        commandLine.setForceVisible(false);
        Document.screenShow(this._lpexWindow);
        this.accessibleSetFocus();
    }

    private void handleFocusLost(FocusEvent e) {
        this._focusGained = false;
        this._lpexWindow.setFocusWidget(null);
        this.setCursorVisible(false);
        this.setImeFont();
        Document.screenShow(this._lpexWindow);
    }

    private void textWindowResized() {
        View view = this.view();
        if (view != null) {
            view.screen().resized(this.getClientArea().width, this.getClientArea().height);
            Document.screenShow(this._lpexWindow);
        }
    }

    void addResizeListener() {
        this.addControlListener(this._resizeListener);
        View view = this.view();
        if (view != null) {
            view.screen().resized(this.getClientArea().width, this.getClientArea().height);
        }
    }

    void removeResizeListener() {
        if (!this.isDisposed()) {
            this.removeControlListener(this._resizeListener);
        }
    }

    private void setImeLocation(int x, int y) {
        if (this._imeX != x || this._imeY != y) {
            this._imeX = x;
            this._imeY = y;
            this._caret.setLocation(this._imeX, this._imeY);
            this._caret.setVisible(true);
            this._caret.setVisible(false);
        }
    }

    void setImeFont() {
        View view = this.view();
        if (this._caret != null && view != null) {
            this._caret.setFont(view.screen().currentFont().getFont());
            this._caretResizePending = true;
            if (this.focusGained()) {
                this.resizeCaret();
            }
        }
    }

    private void resizeCaret() {
        int rowHeight;
        Point caretSize = this._caret.getSize();
        View view = this.view();
        if (view != null && caretSize.y != (rowHeight = view.screen().textFontMetrics().textHeight())) {
            this._caret.setSize(caretSize.x, rowHeight);
            this._caret.setVisible(true);
            this._caret.setVisible(false);
        }
        this._caretResizePending = false;
    }

    private void bidiLanguageChanged() {
        this.view().documentPosition().languageChanged();
    }

    Menu getPopupMenu() {
        Menu popup = this.getMenu();
        if (popup == null || popup.isDisposed()) {
            if (this._popupMenu == null) {
                this._popupMenu = new Menu((Control)this);
                this._popupMenu.addMenuListener((MenuListener)new MenuAdapter(){

                    public void menuShown(MenuEvent e) {
                        TextWindow.this.popupMenuAboutToShow();
                    }
                });
            }
            popup = this._popupMenu;
            this.setMenu(this._popupMenu);
        }
        return popup;
    }

    private void popupMenuAboutToShow() {
        Menu popup = this.getMenu();
        MenuItem[] mi = popup.getItems();
        int i = 0;
        while (i < mi.length) {
            mi[i].dispose();
            ++i;
        }
        this.view().actionHandler().populatePopupMenu(popup, PopupParameter.getParameter().currentPopupMenu(this.view()));
    }

    private void handleDispose() {
        this.removeResizeListener();
        if (this._paintListener != null) {
            this.removePaintListener(this._paintListener);
            this._paintListener = null;
        }
        if (this._focusListener != null) {
            this.removeFocusListener(this._focusListener);
            this._focusListener = null;
        }
        this.stopCursorBlinkTimer();
        if (LpexUtilities.isBidi()) {
            LpexUtilities.removeLanguageListener((Control)this);
        }
        if (this._popupMenu != null) {
            this._popupMenu.dispose();
            this._popupMenu = null;
        }
        Iterator<RGB> i = this._colorMap.keySet().iterator();
        while (i.hasNext()) {
            this._colorMap.get(i.next()).dispose();
        }
        if (this._model != null) {
            this._model.removeAnnotationModelListener((IAnnotationModelListener)this._annotationListener);
            EditorsPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this._annotationListener);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        TextFontMetrics textFontMetrics;
        int height = 0;
        int width = 0;
        View view = this.view();
        if (view != null && (textFontMetrics = view.screen().textFontMetrics()) != null) {
            int lineHeight = textFontMetrics.textHeight();
            int viewableElements = Math.min(view.document().elementList().count(), this.getDisplay().getBounds().height / lineHeight);
            height = viewableElements * lineHeight;
            int i = 0;
            Element e = view.document().elementList().firstVisible(view);
            while (i < viewableElements && e != null) {
                int elementWidth = e.elementView(view).width();
                if (width < elementWidth) {
                    width = elementWidth;
                }
                e = e.nextVisible(view);
                ++i;
            }
        }
        return new Point(width, height);
    }

    private void processKeyEvent(Event e) {
        View view;
        if (!this._doKeyEventActive && (view = this.view()) != null) {
            this._lpexKeyEvent.doit = true;
            if (view.lpexView().keyListenerList() != null) {
                this._lpexKeyEvent.widget = e.widget;
                this._lpexKeyEvent.character = e.character;
                this._lpexKeyEvent.keyCode = e.keyCode;
                this._lpexKeyEvent.stateMask = e.stateMask;
                view.lpexView().triggerKeyListeners(this._lpexKeyEvent);
            }
            if (view._traceKeys) {
                view.actionHandler().traceKeyEvent(e, true, this._lpexKeyEvent.doit);
                if (!this._lpexKeyEvent.doit) {
                    view.actionHandler().traceKey();
                }
            }
            if (!this._lpexKeyEvent.doit) {
                return;
            }
            this._doKeyEventActive = true;
            e.stateMask &= 0xFFF7FFFF;
            view.actionHandler().doKeyEvent(e);
            this._doKeyEventActive = false;
        }
    }

    public void setCursor(Cursor cursor) {
        if (this._cursor != cursor) {
            this._cursor = cursor != null ? cursor : this._textCursor;
            super.setCursor(this._cursor);
        }
    }

    private void setTextCursor() {
        if (this._cursor == this._arrowCursor) {
            this.setCursor(this._textCursor);
        }
    }

    View view() {
        return this._lpexWindow.getLpexView() != null ? this._lpexWindow.getLpexView()._view : null;
    }

    private LpexAbstractTextEditor textEditor() {
        try {
            return (LpexAbstractTextEditor)((Object)this._lpexWindow.getData("LPEX_ABSTRACT_TEXT_EDITOR"));
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private boolean cursorBlinking() {
        int interval;
        View view = this.view();
        int n = interval = view != null ? view.currentCursorBlinkTime() : 0;
        return interval != 0;
    }

    private int cursorBlinkTime() {
        View view = this.view();
        int interval = view != null ? view.currentCursorBlinkTime() : 500;
        return interval != 0 ? interval : 500;
    }

    void cursorBlinkTimeChanged() {
    }

    void readonlyChanged() {
        this.installDragSource();
    }

    void lpexViewChanged() {
        this.handleLpexViewChanged();
        this.cursorBlinkTimeChanged();
        this.installDnd();
        this.installDragSource();
    }

    private void paintComponent(LpexGC g, int x, int y, int width, int height) {
        this._clipBounds.x = x;
        this._clipBounds.y = y;
        this._clipBounds.width = width;
        this._clipBounds.height = height;
        this.invalidateText(this._clipBounds);
        this.invalidateBottom(this._clipBounds);
        if (this.view() != null) {
            Line line = this._topLine;
            while (line != null) {
                line.paint(g);
                line = line._next;
            }
        }
        this.paintBottom(g);
    }

    boolean focusGained() {
        return this._focusGained;
    }

    private void doMouseEvent(MouseEvent e, int eID) {
        View view = this.view();
        if (view == null) {
            return;
        }
        int newPointX = e.x;
        int newPointY = e.y;
        if (eID == 7) {
            this.setFocus();
            if (this.isDndDragStart(e)) {
                if (view._traceMouseEvents) {
                    view.actionHandler().traceMouseEvent(e, eID, "DND DRAG START");
                }
                return;
            }
            this._clickCount = e.count;
        } else if (eID == 8) {
            this._clickCount = 0;
        }
        if (eID == 2) {
            this.setTextCursor();
            Rectangle size = this.getClientArea();
            if (newPointX < 0 || newPointX > size.width || newPointY < 0 || newPointY > size.height) {
                this.setLastDragEvent(e);
            } else {
                this.setLastDragEvent(null);
            }
        } else if (eID != 11) {
            this.setLastDragEvent(null);
        }
        if (eID == 5) {
            if (newPointX < view.screen().expandHideAreaWidth()) {
                this.setCursor(this._arrowCursor);
            } else {
                this.setTextCursor();
            }
        }
        view.actionHandler().doMouseEvent(e, eID);
    }

    private void setLastDragEvent(MouseEvent e) {
        this._lastDragEvent = e;
        if (e != null) {
            this._display.timerExec(40, this._dragTimer);
        }
    }

    private void setCursorVisible(boolean visible) {
        if (visible) {
            this.startCursorBlinkTimer();
        } else {
            this.stopCursorBlinkTimer();
        }
    }

    private void startCursorBlinkTimer() {
        this._display.timerExec(this.cursorBlinkTime(), this._cursorBlinkTimer);
        this._cursorBlinkTimerRunning = true;
    }

    private void stopCursorBlinkTimer() {
        if (this._cursorBlinkTimerRunning) {
            this._display.timerExec(-1, this._cursorBlinkTimer);
        }
        this._cursorBlinkTimerRunning = false;
    }

    private void toggleCursor(boolean updatingText) {
        if (!this.focusGained()) {
            return;
        }
        if (!this.cursorBlinking() && this._cursorVisible) {
            return;
        }
        boolean bl = this._cursorVisible = !this._cursorVisible;
        if (this.view() != null) {
            Line line = this._topLine;
            while (line != null) {
                line.invalidateCursor();
                line = line._next;
            }
            if (!updatingText) {
                this.updateText(false);
            }
        }
    }

    private Line getNewLine() {
        if (this._cachedLines == null) {
            return new Line();
        }
        Line line = this._cachedLines;
        this._cachedLines = line._next;
        line._next = null;
        return line;
    }

    private void setLines(int rows) {
        Line currentLine = this._topLine;
        Line lastLine = null;
        int i = 0;
        while (i < rows) {
            if (currentLine == null) {
                currentLine = this.getNewLine();
                if (lastLine == null) {
                    this._topLine = currentLine;
                } else {
                    lastLine._next = currentLine;
                }
            }
            lastLine = currentLine;
            currentLine = currentLine._next;
            ++i;
        }
        if (lastLine != null) {
            lastLine._next = null;
        } else {
            this._topLine = null;
        }
        while (currentLine != null) {
            Line next = currentLine._next;
            currentLine.reset();
            currentLine._next = this._cachedLines;
            this._cachedLines = currentLine;
            currentLine = next;
        }
    }

    private Line line(int row) {
        int i = 1;
        Line line = this._topLine;
        while (line != null) {
            if (i == row) {
                return line;
            }
            ++i;
            line = line._next;
        }
        return null;
    }

    private void invalidateText(Rectangle invalidRect) {
        Line line = this._topLine;
        while (line != null) {
            if (line.intersects(invalidRect)) {
                line.invalidate(invalidRect.x, invalidRect.width);
            }
            line = line._next;
        }
    }

    void invalidateText() {
        while (this._topLine != null) {
            Line temp = this._topLine;
            this._topLine = this._topLine._next;
            temp.reset();
            temp._next = this._cachedLines;
            this._cachedLines = temp;
        }
    }

    private void invalidateBottom(Rectangle invalidRect) {
        if (this._bottomRect != null && this._bottomRect.intersects(invalidRect)) {
            this.invalidateBottom();
        }
    }

    private void invalidateBottom() {
        this._bottomValid = false;
    }

    private void setBottomHeight(int height) {
        if (height > 0) {
            Rectangle size = this.getClientArea();
            if (this._bottomRect == null) {
                this._bottomRect = new Rectangle(0, size.height - height, size.width, height);
                this.invalidateBottom();
            } else if (this._bottomRect.y != size.height - height || this._bottomRect.width != size.width || this._bottomRect.height != height) {
                this._bottomRect.y = size.height - height;
                this._bottomRect.width = size.width;
                this._bottomRect.height = height;
                this.invalidateBottom();
            }
        } else if (this._bottomRect != null) {
            this._bottomRect.height = 0;
        }
    }

    private void setBottomStyleAttributes(StyleAttributes bottomStyleAttributes) {
        if (this._bottomStyleAttributes == null || !this._bottomStyleAttributes.equals(bottomStyleAttributes)) {
            this._bottomStyleAttributes = bottomStyleAttributes;
            this.invalidateBottom();
        }
    }

    void updateBottom() {
        if (!this._bottomValid && this._bottomRect != null && this._bottomRect.height != 0) {
            this.redraw(this._bottomRect.x, this._bottomRect.y, this._bottomRect.width, this._bottomRect.height, false);
        }
    }

    private void paintBottom(LpexGC g) {
        if (!this._bottomValid && this._bottomRect != null && this._bottomStyleAttributes != null && this._bottomRect.height > 0) {
            g.gc.setBackground(this._bottomStyleAttributes.backgroundColor().getColor());
            g.gc.fillRectangle(this._bottomRect.x, this._bottomRect.y, this._bottomRect.width, this._bottomRect.height);
            this._bottomValid = true;
        }
    }

    void updateText(boolean forceCursor) {
        if (forceCursor && this._cursorBlinkTimerRunning) {
            this.startCursorBlinkTimer();
            if (!this._cursorVisible) {
                this.toggleCursor(true);
            }
        }
        if (this.view() != null) {
            Line line = this._topLine;
            while (line != null) {
                line.update();
                line = line._next;
            }
        }
    }

    void setShow() {
        View view = this.view();
        if (view == null) {
            return;
        }
        Screen screen = view.screen();
        int extraRow = screen.partialRow() ? 1 : 0;
        this.setLines(screen.rows() + extraRow);
        Element currentElement = view.documentPosition().element();
        if (currentElement == null) {
            this.setImeLocation(-1, -1);
        }
        int y = 0;
        StyleAttributesList styleAttributesList = view.styleAttributesList();
        StyleAttributes defaultStyle = screen.styleAttributes(4);
        StyleAttributes expandHideStyle = screen.styleAttributes(7);
        StyleAttributes prefixAreaStyle = screen.styleAttributes(12);
        StyleAttributes prefixTextStyle = screen.styleAttributes(13);
        StyleAttributes selectionStyle = screen.styleAttributes(14);
        StyleAttributes cursorStyle = screen.styleAttributes(3);
        StyleAttributes emphasisStyle = screen.styleAttributes(6);
        StyleAttributes backgroundStyle = screen.styleAttributes(1);
        StyleAttributes whiteSpaceStyle = screen.styleAttributes(18);
        Font currentFont = screen.currentFont();
        TextFontMetrics textFontMetrics = screen.textFontMetrics();
        int textHeight = textFontMetrics.textHeight();
        int blockLeftPixelPosition = -1;
        int blockRightPixelPosition = -1;
        int expandHideWidth = screen.expandHideAreaWidth();
        int prefixAreaTextValue = PrefixAreaTextParameter.getParameter().currentValue(view);
        int prefixAreaWidth = screen.prefixAreaWidth();
        int prefixAreaTextWidth = screen.prefixAreaTextWidth();
        FormatLine formatLine = (FormatLine)this._lpexWindow.formatLine();
        formatLine.setMargin(expandHideWidth + prefixAreaWidth);
        List<List<Annotation>> annotationList = this.retrieveAnnotations(extraRow);
        Element element = null;
        int i = 1;
        while (i <= screen.rows() + extraRow) {
            boolean hasElementBlock;
            boolean hasBlock;
            int styleLength;
            DisplayStyle style;
            String text;
            int prefixScroll;
            StyleAttributes prefixStyle;
            String prefixText;
            String expandHideText;
            StyleAttributes elementDefaultStyle;
            boolean hasPrefixCursor;
            boolean hasCursor;
            element = screen.element(i);
            int[] blockSegments = null;
            ElementView elementView = null;
            int cursorRow = screen.cursorRow();
            if (element != null) {
                hasCursor = i == cursorRow && this.focusGained() && !view.inPrefix();
                hasPrefixCursor = i == cursorRow && this.focusGained() && view.inPrefix();
                elementDefaultStyle = view.markList().defaultStyleAttributes(element);
                if (elementDefaultStyle == null) {
                    elementDefaultStyle = defaultStyle;
                }
                elementView = element.elementView(view);
                expandHideText = elementView.expandHideText();
                prefixText = elementView.prefixText();
                if (prefixText != null && prefixText.length() > 0) {
                    prefixStyle = prefixTextStyle;
                    prefixScroll = elementView.prefixScroll();
                } else {
                    prefixText = "";
                    if (prefixAreaTextValue != 3) {
                        if (prefixAreaTextValue == 2) {
                            prefixText = view.document().elementList().getSequenceNumbersDisplayString(element, view);
                        }
                        if (prefixText.length() == 0) {
                            prefixText = view.lineNumbersText(element);
                        }
                    }
                    prefixStyle = prefixAreaStyle;
                    prefixScroll = 0;
                }
                text = elementView.displayText();
                if (text == null) {
                    text = "";
                }
                style = elementView.displayStyle();
                styleLength = style.length();
                Block block = view.block();
                hasBlock = block.partOfBlock(view, element);
                boolean bl = hasBlock ? block.type() == 4 : (hasElementBlock = false);
                if (hasBlock) {
                    blockSegments = new int[2];
                    if (!hasElementBlock) {
                        Element topElement = block.topElement();
                        Element bottomElement = block.bottomElement();
                        int topPosition = block.topPosition();
                        int bottomPosition = block.bottomPosition();
                        if (block.type() == 1 || block.type() == 2) {
                            if (LpexUtilities.isBidi()) {
                                blockSegments = DisplayTextLayout.charBlockSegments(elementView);
                            } else {
                                blockSegments[0] = topElement == element ? elementView.pixelPosition(topPosition) : 0;
                                if (bottomElement == element) {
                                    if (block.type() == 1) {
                                        --bottomPosition;
                                    }
                                    blockSegments[1] = elementView.pixelCharPosition(bottomPosition + 1);
                                } else {
                                    blockSegments[1] = elementView.width();
                                }
                            }
                            if (blockSegments.length == 2 && blockSegments[1] <= blockSegments[0]) {
                                blockSegments[1] = blockSegments[0] + 2;
                            }
                        } else if (block.type() == 3) {
                            if (blockLeftPixelPosition == -1) {
                                blockLeftPixelPosition = block.leftPixelPosition();
                                blockRightPixelPosition = block.rightPixelPosition();
                            }
                            blockSegments[0] = blockLeftPixelPosition;
                            blockSegments[1] = blockRightPixelPosition;
                        }
                        if (i == cursorRow && blockSegments.length == 2 && blockSegments[0] == screen.cursorPosition() && blockSegments[1] == screen.cursorPosition() + screen.cursorWidth()) {
                            hasBlock = false;
                        }
                    }
                }
            } else {
                hasCursor = false;
                hasPrefixCursor = false;
                elementDefaultStyle = backgroundStyle;
                expandHideText = screen.expandHideText(i);
                if (expandHideText == null) {
                    expandHideText = "";
                }
                prefixText = "";
                prefixStyle = prefixAreaStyle;
                prefixScroll = 0;
                text = "";
                style = null;
                styleLength = 0;
                hasBlock = false;
                hasElementBlock = false;
            }
            Line line = this.line(i);
            line.setBidiSegments(elementView != null && LpexUtilities.isBidi() ? DisplayTextLayout.getSegments(elementView) : null);
            line.setSize(screen.width(), textHeight);
            line.setY(y);
            line.setFont(currentFont, textFontMetrics);
            line.setDefaultStyleAttributes(elementDefaultStyle);
            line.setWhiteSpaceStyleAttributes(whiteSpaceStyle);
            line.setExpandHideText(expandHideText);
            line.setExpandHideWidth(expandHideWidth);
            line.setExpandHideStyleAttributes(expandHideStyle);
            line.setPrefixText(prefixText);
            line.setPrefixWidth(prefixAreaWidth, prefixAreaTextWidth, screen.ownerDrawMargin());
            line.setPrefixStyleAttributes(prefixStyle, prefixAreaStyle);
            if (line.setText(text)) {
                int displayTextWidth = text.length() == 0 ? 0 : (LpexUtilities.isBidi() ? -1 : textFontMetrics.stringWidth(text));
                line.setTextWidth(displayTextWidth);
            }
            line.setTextStyleAttributesLength(styleLength);
            line.setTextStyleAttributes(style, styleAttributesList);
            line.setSelectionStyleAttributes(selectionStyle);
            line.setCursorStyleAttributes(cursorStyle);
            line.setEmphasisStyleAttributes(emphasisStyle);
            if (element != null && !element.show()) {
                List<Annotation> annotations = annotationList.get(i - 1);
                LpexAbstractTextEditor editor = this.textEditor();
                if (editor != null) {
                    IDocumentProvider dp = editor.getDocumentProvider();
                    IEditorInput input = editor.getEditorInput();
                    if (dp != null && input != null) {
                        try {
                            IDocument doc = dp.getDocument((Object)input);
                            int lineNum = this._lpexWindow.getLpexView().lineOfElement(element._ordinal);
                            if (lineNum > 0 && lineNum < doc.getNumberOfLines()) {
                                int lineOffset = doc.getLineOffset(lineNum - 1);
                                int nextLineOffset = doc.getLength();
                                if (lineNum < doc.getNumberOfLines()) {
                                    nextLineOffset = doc.getLineOffset(lineNum);
                                }
                                String docText = doc.get(lineOffset, nextLineOffset - lineOffset);
                                line.setAnnotations(annotations, lineOffset, docText);
                            }
                        }
                        catch (BadLocationException e) {
                            LpexLog.log(this.view(), "setShow", e);
                        }
                    }
                }
            }
            line.setCursorPosition(screen.cursorPosition());
            line.setCursorWidth(screen.cursorWidth());
            line.setHasCursor(hasCursor);
            line.setScroll(screen.scroll());
            line.setPrefixCursorPosition(screen.prefixCursorPosition());
            line.setPrefixCursorWidth(screen.prefixCursorWidth());
            line.setHasPrefixCursor(hasPrefixCursor);
            line.setPrefixScroll(prefixScroll);
            line.setBlock(hasBlock, blockSegments);
            line.setHasElementBlock(hasElementBlock);
            line.setEmphasis(i == cursorRow ? screen.emphasisSegments() : null, screen.noEmphasisInBlock());
            y += textHeight;
            ++i;
        }
        this.setBottomHeight(screen.height() - y);
        this.setBottomStyleAttributes(element == null && screen.rows() > 0 ? backgroundStyle : defaultStyle);
    }

    private void handleLpexViewChanged() {
        this._accessibleListener.setLpexView(this._lpexWindow.getLpexView());
    }

    private String getVisibleText() {
        View view = this.view();
        if (view == null) {
            return "";
        }
        StringBuilder text = new StringBuilder(1024);
        Element element = view.document().elementList().firstVisible(view);
        while (element != null) {
            if (element.length() != 0) {
                text.append(element.text());
            }
            text.append(this._eol);
            element = element.nextVisible(view);
        }
        return text.toString();
    }

    private int getVisibleCaretOffset() {
        View view = this.view();
        if (view == null) {
            return 0;
        }
        int caret = this.getVisibleCharOffset(view.documentPosition().element(), view.documentPosition().position());
        return caret;
    }

    public int getVisibleSelectionStart() {
        int index = 0;
        View view = this.view();
        if (view != null) {
            Block block = view.block();
            index = view == block.view() ? this.getVisibleCharOffset(block.topElement(), block.topPosition()) : this.getVisibleCaretOffset();
        }
        return index;
    }

    public int getVisibleSelectionEnd() {
        int index = 0;
        View view = this.view();
        if (view != null) {
            Block block = view.block();
            if (view == block.view()) {
                int bottomPosition = block.bottomPosition();
                if (block.type() != 1) {
                    ++bottomPosition;
                }
                index = this.getVisibleCharOffset(block.bottomElement(), bottomPosition);
            } else {
                index = this.getVisibleCaretOffset();
            }
        }
        return index;
    }

    private int getVisibleCharOffset(Element element, int position) {
        return this.view().visibleCharOffset(element, position, this._eolLength);
    }

    private void accessibleSetFocus() {
        this.getAccessible().setFocus(-1);
    }

    private void accessibleTextSelectionChanged() {
        this.getAccessible().textSelectionChanged();
    }

    void initializeAccessible() {
        Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener((org.eclipse.swt.accessibility.AccessibleListener)new AccessibleAdapter(){

            public void getHelp(AccessibleEvent e) {
                e.result = TextWindow.this.getToolTipText();
            }
        });
        accessible.addAccessibleTextListener((AccessibleTextListener)new AccessibleTextAdapter(){

            public void getCaretOffset(AccessibleTextEvent e) {
                e.offset = TextWindow.this.getVisibleCaretOffset();
            }

            public void getSelectionRange(AccessibleTextEvent e) {
                e.offset = TextWindow.this.getVisibleSelectionStart();
                e.length = TextWindow.this.getVisibleSelectionEnd() - e.offset;
            }
        });
        accessible.addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getRole(AccessibleControlEvent e) {
                e.detail = 42;
            }

            public void getState(AccessibleControlEvent e) {
                int state = 0;
                if (TextWindow.this.isEnabled()) {
                    state |= 0x100000;
                }
                if (TextWindow.this.isFocusControl()) {
                    state |= 4;
                }
                if (!TextWindow.this.isVisible()) {
                    state |= 0x8000;
                }
                if (TextWindow.this.view() == null || TextWindow.this.view().readonly()) {
                    state |= 0x40;
                }
                e.detail = state;
            }

            public void getValue(AccessibleControlEvent e) {
                e.result = TextWindow.this.getVisibleText();
            }
        });
        this._accessibleListener = new AccessibleListener();
    }

    /*
     * WARNING - void declaration
     */
    private List<List<Annotation>> retrieveAnnotations(int extra) {
        LpexAbstractTextEditor lpexAbstractTextEditor;
        void var4_5;
        Screen screen = this.view().screen();
        Vector<List<Annotation>> result = new Vector<List<Annotation>>(screen.rows() + extra);
        boolean bl = false;
        while (var4_5 < screen.rows() + extra) {
            result.add(null);
            ++var4_5;
        }
        if (this._model instanceof IAnnotationModelExtension && result.size() > 0 && (lpexAbstractTextEditor = this.textEditor()) != null) {
            IDocument doc;
            IDocumentProvider dp = lpexAbstractTextEditor.getDocumentProvider();
            IEditorInput input = lpexAbstractTextEditor.getEditorInput();
            if (dp != null && input != null && (doc = dp.getDocument((Object)input)) != null) {
                LpexView view = this._lpexWindow.getLpexView();
                int rowNum = 1;
                while (rowNum <= screen.rows() + extra) {
                    int startLine;
                    Element element = screen.element(rowNum);
                    if (element != null && !element.show() && (startLine = view.lineOfElement(element._ordinal) - 1) > -1 && startLine < doc.getNumberOfLines()) {
                        try {
                            int offset = doc.getLineOffset(startLine);
                            int length = element.fullText().length();
                            Iterator i2 = ((IAnnotationModelExtension2)this._model).getAnnotationIterator(offset, length, true, true);
                            while (i2.hasNext()) {
                                Position p;
                                Object item = i2.next();
                                if (!(item instanceof Annotation) || (p = this._model.getPosition((Annotation)item)) != null && p.isDeleted()) continue;
                                ArrayList<Annotation> list = (ArrayList<Annotation>)result.get(rowNum - 1);
                                if (list == null) {
                                    list = new ArrayList<Annotation>();
                                    result.set(rowNum - 1, list);
                                }
                                list.add((Annotation)item);
                            }
                        }
                        catch (BadLocationException e) {
                            LpexLog.log(this.view(), "retrieveAnnotations", e);
                        }
                    }
                    ++rowNum;
                }
            }
        }
        for (List list : result) {
            this.sort(list, this._model);
        }
        return result;
    }

    private void sort(List<Annotation> list, final IAnnotationModel model) {
        if (list != null) {
            Collections.sort(list, new Comparator<Annotation>(){

                @Override
                public int compare(Annotation o1, Annotation o2) {
                    int layer2;
                    int layer1 = ((IAnnotationAccessExtension)TextWindow.this._annotationAccess).getLayer(o1);
                    if (layer1 != (layer2 = ((IAnnotationAccessExtension)TextWindow.this._annotationAccess).getLayer(o2))) {
                        return layer1 - layer2;
                    }
                    if (o1.isMarkedDeleted() || o2.isMarkedDeleted() || model.getPosition(o1) == null || model.getPosition(o2) == null) {
                        return 0;
                    }
                    return model.getPosition((Annotation)o1).offset - model.getPosition((Annotation)o2).offset;
                }
            });
        }
    }

    public void setModel(IAnnotationModel model) {
        if (this._model != null) {
            this._model.removeAnnotationModelListener((IAnnotationModelListener)this._annotationListener);
            EditorsPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this._annotationListener);
        }
        this._model = model;
        if (this._model != null) {
            this._model.addAnnotationModelListener((IAnnotationModelListener)this._annotationListener);
            EditorsPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this._annotationListener);
            this.view().screen().show();
        }
    }

    public void cut() {
        this._lpexWindow.getLpexView().doAction(3);
        this.view().screen().show();
    }

    public void copy() {
        this._lpexWindow.getLpexView().doAction(4);
        this.view().screen().show();
    }

    public void paste() {
        this._lpexWindow.getLpexView().doAction(5);
        this.view().screen().show();
    }

    public void selectAll() {
        this._lpexWindow.getLpexView().doAction(216);
        this.view().screen().show();
    }

    final class AccessibleListener
    extends LpexViewAdapter {
        LpexView _lpexView;
        private Element _cursorElement;
        private int _cursorPosition;
        private int _visibleCaretOffset;
        private boolean _blockInView;
        private Element _blockTopElement;
        private Element _blockBottomElement;
        private int _blockTopPosition;
        private int _blockBottomPosition;

        AccessibleListener() {
            this.setLpexView(TextWindow.this._lpexWindow.getLpexView());
        }

        void setLpexView(LpexView newLpexView) {
            if (this._lpexView != null) {
                this._lpexView.removeLpexViewListener(this);
            }
            this._lpexView = newLpexView;
            if (this._lpexView != null) {
                this._cursorElement = null;
                this._visibleCaretOffset = -1;
                this._blockInView = this._lpexView._view != this._lpexView._view.block().view();
                this._lpexView.addLpexViewListener(this);
            }
        }

        @Override
        public void shown(LpexView lpexView) {
            if (lpexView != null && lpexView._view != null) {
                Block block;
                boolean blockInView;
                DocumentPosition documentPosition = lpexView._view.documentPosition();
                Element cursorElement = documentPosition.element();
                int cursorPosition = documentPosition.position();
                if (cursorElement != this._cursorElement || cursorPosition != this._cursorPosition) {
                    this._cursorElement = cursorElement;
                    this._cursorPosition = cursorPosition;
                    int visibleCaretOffset = TextWindow.this.getVisibleCaretOffset();
                    if (visibleCaretOffset != this._visibleCaretOffset) {
                        this._visibleCaretOffset = visibleCaretOffset;
                        TextWindow.this.getAccessible().textCaretMoved(visibleCaretOffset);
                    }
                }
                boolean bl = blockInView = lpexView._view == (block = lpexView._view.block()).view();
                if (blockInView) {
                    Element blockTopElement = block.topElement();
                    Element blockBottomElement = block.bottomElement();
                    int blockTopPosition = block.topPosition();
                    int blockBottomPosition = block.bottomPosition();
                    if (!this._blockInView || blockTopElement != this._blockTopElement || blockBottomElement != this._blockBottomElement || blockTopPosition != this._blockTopPosition || blockBottomPosition != this._blockBottomPosition) {
                        this._blockInView = true;
                        this._blockTopElement = blockTopElement;
                        this._blockBottomElement = blockBottomElement;
                        this._blockTopPosition = blockTopPosition;
                        this._blockBottomPosition = blockBottomPosition;
                        TextWindow.this.accessibleTextSelectionChanged();
                    }
                } else if (this._blockInView) {
                    this._blockInView = false;
                    TextWindow.this.accessibleTextSelectionChanged();
                }
            }
        }

        @Override
        public void disposed(LpexView lpexView) {
            this._lpexView = null;
        }
    }

    private static enum AnnotationModelEventType {
        CHANGED,
        ADDED,
        REMOVED;

    }

    final class Line {
        Line _next;
        private int x;
        private int y;
        private int width;
        private int height;
        private int[] _bidiSegments;
        private TextWindowString _text;
        private TextWindowString _prefixText;
        private TextWindowString _expandHideText;
        private int _styledTextWidth;
        private int _prefixWidth;
        private int _prefixTextWidth;
        private boolean _ownerDrawMargin;
        private int _expandHideWidth;
        private StyleAttributes[] _textStyleAttributes = new StyleAttributes[0];
        private int _textStyleAttributesLength;
        private StyleAttributes _defaultStyleAttributes;
        private StyleAttributes _prefixStyleAttributes;
        private StyleAttributes _marginStyleAttributes;
        private StyleAttributes _expandHideStyleAttributes;
        private StyleAttributes _selectionStyleAttributes;
        private StyleAttributes _cursorStyleAttributes;
        private StyleAttributes _emphasisStyleAttributes;
        private StyleAttributes _whiteSpaceStyleAttributes;
        private Font _font;
        private TextFontMetrics _textFontMetrics;
        private int _textPosition;
        private boolean _hasCursor;
        private int _cursorPosition;
        private int _cursorWidth;
        private boolean _hasPrefixCursor;
        private int _prefixCursorPosition;
        private int _prefixCursorWidth;
        private boolean _hasBlock;
        private int _blockPosition;
        private int _blockWidth;
        private int[] _blockSegments;
        private boolean _hasElementBlock;
        private int[] _emphasisSegments;
        private int _emphasisWidth;
        private int _emphasisPosition;
        private boolean _noEmphasisInBlock;
        private int _scroll;
        private int _prefixScroll;
        private int _invalidPosition;
        private int _invalidWidth;
        private SubLine _topSubLine;
        private boolean _subLinesValid;
        private Image _minusImg;
        private Image _plusImg;
        private List<Annotation> _annotations;
        private int _offset;
        private String _docText;

        Line() {
        }

        boolean intersects(Rectangle r) {
            return r.x + r.width > this.x && r.y + r.height > this.y && r.x < this.x + this.width && r.y < this.y + this.height;
        }

        void setAnnotations(List<Annotation> annotations, int lineOffset, String documentLineText) {
            this._annotations = annotations;
            this._offset = lineOffset;
            this._docText = documentLineText;
        }

        void reset() {
            this.height = 0;
            this.width = 0;
            this.y = 0;
            this.x = 0;
            if (this._text != null) {
                this._text._length = 0;
            }
            if (this._prefixText != null) {
                this._prefixText._length = 0;
            }
            if (this._expandHideText != null) {
                this._expandHideText._length = 0;
            }
            this._styledTextWidth = 0;
            this._prefixWidth = 0;
            this._prefixTextWidth = 0;
            this._ownerDrawMargin = false;
            this._expandHideWidth = 0;
            this._textStyleAttributesLength = 0;
            this._defaultStyleAttributes = null;
            this._prefixStyleAttributes = null;
            this._marginStyleAttributes = null;
            this._expandHideStyleAttributes = null;
            this._selectionStyleAttributes = null;
            this._cursorStyleAttributes = null;
            this._emphasisStyleAttributes = null;
            this._whiteSpaceStyleAttributes = null;
            this._font = null;
            this._textFontMetrics = null;
            this._textPosition = 0;
            this._hasCursor = false;
            this._cursorPosition = 0;
            this._cursorWidth = 0;
            this._hasPrefixCursor = false;
            this._prefixCursorPosition = 0;
            this._prefixCursorWidth = 0;
            this._hasBlock = false;
            this._blockPosition = 0;
            this._blockWidth = 0;
            this._blockSegments = null;
            this._hasElementBlock = false;
            this._emphasisSegments = null;
            this._emphasisWidth = 0;
            this._emphasisPosition = 0;
            this._noEmphasisInBlock = false;
            this._scroll = 0;
            this._prefixScroll = 0;
            this._invalidWidth = 0;
            this._invalidPosition = 0;
            this._bidiSegments = null;
            this.clearSubLines();
        }

        void clearSubLines() {
            while (this._topSubLine != null) {
                SubLine temp = this._topSubLine;
                this._topSubLine = this._topSubLine._next;
                temp.reset();
                temp._next = TextWindow.this._cachedSubLines;
                TextWindow.this._cachedSubLines = temp;
            }
            this._subLinesValid = false;
        }

        void setBidiSegments(int[] bidiSegments) {
            this._bidiSegments = bidiSegments;
        }

        void setSize(int w, int h) {
            if (w == this.width && h == this.height) {
                return;
            }
            this.width = w;
            this.height = h;
            this.invalidate(0, this.width);
        }

        void setY(int newY) {
            if (this.y != newY) {
                this._textPosition = this.y = newY;
                this.invalidate(0, this.width);
            }
        }

        void setFont(Font font, TextFontMetrics textFontMetrics) {
            if (this._font == null || !this._font.equals(font)) {
                this._font = font;
                this._textFontMetrics = textFontMetrics;
                this.clearSubLines();
                this.invalidate(0, this.width);
            }
        }

        void setDefaultStyleAttributes(StyleAttributes defaultStyleAttributes) {
            if (this._defaultStyleAttributes == null || !this._defaultStyleAttributes.equals(defaultStyleAttributes)) {
                this._defaultStyleAttributes = defaultStyleAttributes;
                this.clearSubLines();
                this.invalidate(this._expandHideWidth + this._prefixWidth, this.width);
            }
        }

        void setWhiteSpaceStyleAttributes(StyleAttributes whiteSpaceStyleAttributes) {
            if (this._whiteSpaceStyleAttributes == null || !this._whiteSpaceStyleAttributes.equals(whiteSpaceStyleAttributes)) {
                this._whiteSpaceStyleAttributes = whiteSpaceStyleAttributes;
                this.clearSubLines();
                this.invalidate(this._expandHideWidth + this._prefixWidth, this.width);
            }
        }

        void setExpandHideText(String expandHideText) {
            if (this._expandHideText == null) {
                if (expandHideText == null || expandHideText.length() == 0) {
                    return;
                }
                this._expandHideText = new TextWindowString(0, 1);
            }
            if (this._expandHideText.set(expandHideText)) {
                this.invalidate(0, this._expandHideWidth);
            }
        }

        void setExpandHideWidth(int expandHideWidth) {
            if (this._expandHideWidth != expandHideWidth) {
                this._expandHideWidth = expandHideWidth;
                this.invalidate(0, this.width);
            }
        }

        void setExpandHideStyleAttributes(StyleAttributes expandHideStyleAttributes) {
            if (this._expandHideStyleAttributes == null || !this._expandHideStyleAttributes.equals(expandHideStyleAttributes)) {
                this._expandHideStyleAttributes = expandHideStyleAttributes;
                this.invalidate(0, this._expandHideWidth);
            }
        }

        void setPrefixText(String prefixText) {
            if (this._prefixText == null) {
                if (prefixText == null || prefixText.length() == 0) {
                    return;
                }
                this._prefixText = new TextWindowString(0, 6);
            }
            if (this._prefixText.set(prefixText)) {
                this.invalidate(this._expandHideWidth, this._prefixTextWidth);
            }
        }

        void setPrefixWidth(int prefixWidth, int prefixTextWidth, boolean ownerDrawMargin) {
            if (this._prefixWidth != prefixWidth || this._prefixTextWidth != prefixTextWidth || this._ownerDrawMargin != ownerDrawMargin) {
                this._prefixWidth = prefixWidth;
                this._prefixTextWidth = prefixTextWidth;
                this._ownerDrawMargin = ownerDrawMargin;
                this.invalidate(this._expandHideWidth, this.width);
            }
        }

        void setPrefixStyleAttributes(StyleAttributes prefixStyleAttributes, StyleAttributes marginStyleAttributes) {
            if (this._prefixStyleAttributes == null || !this._prefixStyleAttributes.equals(prefixStyleAttributes)) {
                this._prefixStyleAttributes = prefixStyleAttributes;
                this.invalidate(this._expandHideWidth, this._prefixTextWidth);
            }
            if (this._marginStyleAttributes == null || !this._marginStyleAttributes.equals(marginStyleAttributes)) {
                this._marginStyleAttributes = marginStyleAttributes;
                this.invalidate(this._expandHideWidth + this._prefixTextWidth, this._prefixWidth - this._prefixTextWidth);
            }
        }

        boolean setText(String text) {
            if (this._text == null) {
                if (text == null || text.length() == 0) {
                    return false;
                }
                this._text = new TextWindowString(text.length(), 100);
            }
            return this._text.set(text);
        }

        void setTextWidth(int newStyledTextWidth) {
            this.clearSubLines();
            if (newStyledTextWidth == -1) {
                this._styledTextWidth = this.width;
                this.invalidate(this._expandHideWidth + this._prefixWidth, this.width);
                return;
            }
            if (this._textStyleAttributesLength > this._text._length) {
                newStyledTextWidth += this._textFontMetrics.spaceWidth() * (this._textStyleAttributesLength - this._text._length);
            }
            int invalidateWidth = Math.max(this._styledTextWidth, newStyledTextWidth);
            this._styledTextWidth = newStyledTextWidth;
            this.invalidate(this._expandHideWidth + this._prefixWidth - this._scroll, invalidateWidth);
        }

        void setTextStyleAttributesLength(int textStyleAttributesLength) {
            if (this._textStyleAttributesLength != textStyleAttributesLength) {
                int textLength;
                this._textStyleAttributesLength = textStyleAttributesLength;
                this.clearSubLines();
                int n = textLength = this._text != null ? this._text._length : 0;
                if (this._textStyleAttributesLength > textLength) {
                    this._styledTextWidth += this._textFontMetrics.spaceWidth() * (this._textStyleAttributesLength - textLength);
                }
                this.invalidate(this._expandHideWidth + this._prefixWidth - this._scroll, this._styledTextWidth);
                if (this._textStyleAttributesLength > 0 && (this._textStyleAttributes == null || this._textStyleAttributesLength > this._textStyleAttributes.length)) {
                    this._textStyleAttributes = new StyleAttributes[this._textStyleAttributesLength + 100];
                }
            }
        }

        void setTextStyleAttributes(DisplayStyle displayStyle, StyleAttributesList styleAttributesList) {
            if (this._textStyleAttributesLength == 0) {
                return;
            }
            String fground = displayStyle.foreground();
            String bground = displayStyle.background();
            int i = 0;
            while (i < this._textStyleAttributesLength) {
                StyleAttributes textStyleAttributes = bground == null || i >= bground.length() ? styleAttributesList.find(fground.charAt(i)) : styleAttributesList.find(fground.charAt(i), bground.charAt(i));
                if (!(this._textStyleAttributes[i] == null && textStyleAttributes == null || this._textStyleAttributes[i] != null && this._textStyleAttributes[i].equals(textStyleAttributes))) {
                    this._textStyleAttributes[i] = textStyleAttributes;
                    this.clearSubLines();
                    this.invalidate(this._expandHideWidth + this._prefixWidth - this._scroll, this._styledTextWidth);
                    if (!TextWindow.this._lpexWindow.getLpexView().nls().displayingWhitespaceChar() || fground.charAt(i) != '_') break;
                    this._textStyleAttributes[i] = this._whiteSpaceStyleAttributes;
                    break;
                }
                ++i;
            }
            if (bground == null) {
                ++i;
                while (i < this._textStyleAttributesLength) {
                    this._textStyleAttributes[i] = styleAttributesList.find(fground.charAt(i));
                    if (TextWindow.this._lpexWindow.getLpexView().nls().displayingWhitespaceChar() && fground.charAt(i) == '_') {
                        this._textStyleAttributes[i] = this._whiteSpaceStyleAttributes;
                    }
                    ++i;
                }
            } else {
                ++i;
                while (i < this._textStyleAttributesLength) {
                    this._textStyleAttributes[i] = styleAttributesList.find(fground.charAt(i), bground.charAt(i));
                    if (TextWindow.this._lpexWindow.getLpexView().nls().displayingWhitespaceChar() && fground.charAt(i) == '_') {
                        this._textStyleAttributes[i] = this._whiteSpaceStyleAttributes;
                    }
                    ++i;
                }
            }
        }

        void setSelectionStyleAttributes(StyleAttributes selectionStyleAttributes) {
            if (this._selectionStyleAttributes == null || !this._selectionStyleAttributes.equals(selectionStyleAttributes)) {
                this._selectionStyleAttributes = selectionStyleAttributes;
                if (this._hasBlock && !this._hasElementBlock) {
                    this.invalidate(this._expandHideWidth + this._prefixWidth + this._blockPosition - this._scroll, this._blockWidth);
                } else {
                    this.invalidate(this._expandHideWidth + this._prefixWidth, this.width);
                }
            }
        }

        void setCursorStyleAttributes(StyleAttributes cursorStyleAttributes) {
            if (this._cursorStyleAttributes == null || !this._cursorStyleAttributes.equals(cursorStyleAttributes)) {
                this._cursorStyleAttributes = cursorStyleAttributes;
                if (this._hasCursor) {
                    this.invalidate(this._expandHideWidth + this._prefixWidth + this._cursorPosition - this._scroll, this._cursorWidth);
                }
            }
        }

        void setEmphasisStyleAttributes(StyleAttributes emphasisStyleAttributes) {
            if (this._emphasisStyleAttributes == null || !this._emphasisStyleAttributes.equals(emphasisStyleAttributes)) {
                this._emphasisStyleAttributes = emphasisStyleAttributes;
                if (this._emphasisWidth > 0) {
                    this.invalidate(this._expandHideWidth + this._prefixWidth + this._emphasisPosition - this._scroll, this._emphasisWidth);
                }
            }
        }

        void setCursorPosition(int cursorPosition) {
            if (this._cursorPosition != cursorPosition) {
                if (this._hasCursor) {
                    this.invalidate(this._expandHideWidth + this._prefixWidth + cursorPosition - this._scroll, this._cursorWidth);
                    this.invalidate(this._expandHideWidth + this._prefixWidth + this._cursorPosition - this._scroll, this._cursorWidth);
                }
                this._cursorPosition = cursorPosition;
            }
        }

        void setCursorWidth(int cursorWidth) {
            if (this._cursorWidth != cursorWidth) {
                if (this._hasCursor) {
                    this.invalidate(this._expandHideWidth + this._prefixWidth + this._cursorPosition - this._scroll, this._cursorWidth > cursorWidth ? this._cursorWidth : cursorWidth);
                }
                this._cursorWidth = cursorWidth;
            }
        }

        void setHasCursor(boolean hasCursor) {
            if (this._hasCursor != hasCursor) {
                this._hasCursor = hasCursor;
                this.invalidate(this._expandHideWidth + this._prefixWidth + this._cursorPosition - this._scroll, this._cursorWidth);
            }
            if (this._hasCursor && !TextWindow.this._cursorVisible) {
                TextWindow.this.setCursorVisible(true);
                this.invalidate(this._expandHideWidth + this._prefixWidth + this._cursorPosition - this._scroll, this._cursorWidth);
            }
        }

        void setScroll(int scroll) {
            if (this._scroll != scroll) {
                this._scroll = scroll;
                this.invalidate(this._expandHideWidth + this._prefixWidth, this.width);
            }
        }

        void setPrefixCursorPosition(int prefixCursorPosition) {
            if (this._prefixCursorPosition != prefixCursorPosition) {
                if (this._hasPrefixCursor) {
                    this.invalidate(this._expandHideWidth + prefixCursorPosition - this._prefixScroll, this._prefixCursorWidth);
                    this.invalidate(this._expandHideWidth + this._prefixCursorPosition - this._prefixScroll, this._prefixCursorWidth);
                }
                this._prefixCursorPosition = prefixCursorPosition;
            }
        }

        void setPrefixCursorWidth(int prefixCursorWidth) {
            if (this._prefixCursorWidth != prefixCursorWidth) {
                if (this._hasPrefixCursor) {
                    this.invalidate(this._expandHideWidth + this._prefixCursorPosition - this._prefixScroll, this._prefixCursorWidth > prefixCursorWidth ? this._prefixCursorWidth : prefixCursorWidth);
                }
                this._prefixCursorWidth = prefixCursorWidth;
            }
        }

        void setHasPrefixCursor(boolean hasPrefixCursor) {
            if (this._hasPrefixCursor != hasPrefixCursor) {
                this._hasPrefixCursor = hasPrefixCursor;
                this.invalidate(this._expandHideWidth + this._prefixCursorPosition - this._prefixScroll, this._prefixCursorWidth);
            }
            if (this._hasPrefixCursor && !TextWindow.this._cursorVisible) {
                TextWindow.this.setCursorVisible(true);
                this.invalidate(this._expandHideWidth + this._prefixCursorPosition - this._prefixScroll, this._prefixCursorWidth);
            }
        }

        void invalidateCursor() {
            if (this._hasCursor) {
                this.invalidate(this._expandHideWidth + this._prefixWidth + this._cursorPosition - this._scroll, this._cursorWidth);
            }
            if (this._hasPrefixCursor) {
                this.invalidate(this._expandHideWidth + this._prefixCursorPosition - this._prefixScroll, this._prefixCursorWidth);
            }
        }

        void setPrefixScroll(int prefixScroll) {
            if (this._prefixScroll != prefixScroll) {
                this._prefixScroll = prefixScroll;
                this.invalidate(this._expandHideWidth, this._prefixTextWidth);
            }
        }

        void setBlock(boolean hasBlock, int[] blockSegments) {
            int blockWidth;
            if (this._hasBlock != hasBlock) {
                if (this._hasBlock && !this._hasElementBlock) {
                    this.invalidate(this._expandHideWidth + this._prefixWidth + this._blockPosition - this._scroll, this._blockWidth);
                }
                this._hasBlock = hasBlock;
            }
            if (this._blockSegments == null && blockSegments == null) {
                return;
            }
            int blockPosition = blockSegments != null ? blockSegments[0] : 0;
            int n = blockWidth = blockSegments != null ? blockSegments[blockSegments.length - 1] - blockPosition : 0;
            if (this._hasBlock && !this._hasElementBlock) {
                int startInvalid = -1;
                int endInvalid = -1;
                if (this._blockSegments == null || blockSegments == null) {
                    startInvalid = Math.max(this._blockPosition, blockPosition);
                    endInvalid = Math.max(this._blockPosition + this._blockWidth, blockPosition + blockWidth);
                } else {
                    int oldLen = this._blockSegments.length;
                    int newLen = blockSegments.length;
                    int i = 0;
                    while (true) {
                        int newStart;
                        int oldStart = i < oldLen ? this._blockSegments[i] : Integer.MAX_VALUE;
                        int n2 = newStart = i < newLen ? blockSegments[i] : Integer.MAX_VALUE;
                        if (oldStart != newStart) {
                            startInvalid = Math.min(oldStart, newStart);
                            break;
                        }
                        if (i >= oldLen || i >= newLen) break;
                        ++i;
                    }
                    i = 1;
                    while (true) {
                        int newEnd;
                        int oldEnd = i <= oldLen ? this._blockSegments[oldLen - i] : 0;
                        int n3 = newEnd = i <= newLen ? blockSegments[newLen - i] : 0;
                        if (oldEnd != newEnd) {
                            endInvalid = Math.max(oldEnd, newEnd);
                            break;
                        }
                        if (i > oldLen || i > newLen) break;
                        ++i;
                    }
                }
                if (startInvalid != -1) {
                    this.invalidate(this._expandHideWidth + this._prefixWidth + startInvalid - this._scroll, endInvalid - startInvalid);
                }
            }
            this._blockPosition = blockPosition;
            this._blockWidth = blockWidth;
            this._blockSegments = blockSegments;
        }

        void setHasElementBlock(boolean hasElementBlock) {
            if (this._hasElementBlock != hasElementBlock) {
                this._hasElementBlock = hasElementBlock;
                this.invalidate(this._expandHideWidth + this._prefixWidth, this.width);
            }
        }

        void setEmphasis(int[] emphasisSegments, boolean noEmphasisInBlock) {
            if (this._emphasisSegments == null && emphasisSegments == null) {
                return;
            }
            if (emphasisSegments == null) {
                this.invalidate(this._expandHideWidth + this._prefixWidth + this._emphasisPosition - this._scroll, this._emphasisWidth);
                this._emphasisPosition = 0;
                this._emphasisWidth = 0;
                this._emphasisSegments = null;
                return;
            }
            this._noEmphasisInBlock = noEmphasisInBlock;
            if (this.equalSegments(this._emphasisSegments, emphasisSegments)) {
                return;
            }
            int startInvalid = emphasisSegments[0];
            int endInvalid = emphasisSegments[emphasisSegments.length - 1];
            if (this._emphasisSegments != null) {
                startInvalid = Math.min(startInvalid, this._emphasisSegments[0]);
                endInvalid = Math.max(endInvalid, this._emphasisSegments[this._emphasisSegments.length - 1]);
            }
            this.invalidate(this._expandHideWidth + this._prefixWidth + startInvalid - this._scroll, endInvalid - startInvalid);
            this._emphasisPosition = emphasisSegments[0];
            this._emphasisWidth = emphasisSegments[emphasisSegments.length - 1] - this._emphasisPosition;
            this._emphasisSegments = emphasisSegments;
        }

        private boolean equalSegments(int[] seg0, int[] seg1) {
            if (seg0 == null || seg1 == null || seg0.length != seg1.length) {
                return false;
            }
            int i = 0;
            while (i < seg0.length) {
                if (seg0[i] != seg1[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        private void drawString(LpexGC g, StyleAttributes styleAttributes, int rectX, int rectWidth, int textX, TextWindowString text) {
            this.drawString(g, styleAttributes, rectX, rectWidth, textX, text != null ? text._string : null, 0, text != null ? text._length : 0, false);
        }

        private void initializeImages() {
            if (this._minusImg == null && TextWindow.this._display != null) {
                ImageDescriptor descriptor = ImageDescriptor.createFromFile(ProjectionAnnotation.class, (String)"images/expanded.png");
                this._minusImg = descriptor.createImage((Device)TextWindow.this._display);
                descriptor = ImageDescriptor.createFromFile(ProjectionAnnotation.class, (String)"images/collapsed.png");
                this._plusImg = descriptor.createImage((Device)TextWindow.this._display);
                TextWindow.this._display.disposeExec(new Runnable(){

                    @Override
                    public void run() {
                        if (Line.this._minusImg != null) {
                            Line.this._minusImg.dispose();
                            Line.this._minusImg = null;
                        }
                        if (Line.this._plusImg != null) {
                            Line.this._plusImg.dispose();
                            Line.this._plusImg = null;
                        }
                    }
                });
            }
        }

        private void drawExpandHide(LpexGC g, StyleAttributes styleAttributes, int rectX, int rectWidth, int textX, TextWindowString text) {
            this.drawExpandHide(g, styleAttributes, rectX, rectWidth, textX, text != null ? text._string : null, 0, text != null ? text._length : 0);
        }

        private void drawExpandHide(LpexGC g, StyleAttributes styleAttributes, int rectX, int rectWidth, int textX, char[] text, int index, int len) {
            this.initializeImages();
            g.gc.setBackground(styleAttributes.backgroundColor().getColor());
            g.gc.fillRectangle(rectX, this.y, rectWidth, this.height);
            g.gc.setForeground(styleAttributes.foregroundColor().getColor());
            if (len > 0) {
                if (text[index] == '+') {
                    g.gc.drawImage(this._plusImg, textX, this._textPosition);
                } else {
                    g.gc.drawImage(this._minusImg, textX, this._textPosition);
                }
            }
        }

        private void drawString(LpexGC g, StyleAttributes styleAttributes, int rectX, int rectWidth, int textX, char[] text, int index, int len, boolean drawAnnotations) {
            boolean hasAnnotations = false;
            if (drawAnnotations) {
                hasAnnotations = this.hasAnnotations(index, len);
            }
            g.gc.setBackground(styleAttributes.backgroundColor().getColor());
            g.gc.fillRectangle(rectX, this.y, rectWidth, this.height);
            if (hasAnnotations) {
                this.drawAnnotationBackgrounds(g, text, index, len, rectX);
            }
            g.gc.setForeground(styleAttributes.foregroundColor().getColor());
            Color effectsColor = styleAttributes.effectsColor();
            if (effectsColor == null) {
                effectsColor = styleAttributes.foregroundColor();
            }
            if (len > 0) {
                g.gc.drawString(new String(text, index, len), textX, this._textPosition, true);
                if (styleAttributes.outline()) {
                    int w = this._textFontMetrics.substringWidth(g.gc, text, index, index + len);
                    g.gc.setForeground(effectsColor.getColor());
                    g.gc.drawRoundRectangle(textX, this.y, w - 1, this.height - 1, this._textFontMetrics.spaceWidth() / 3, this._textFontMetrics.spaceWidth() / 3);
                }
            }
            if (styleAttributes.strikeout()) {
                g.gc.setForeground(effectsColor.getColor());
                g.gc.drawLine(rectX, this.y + this.height / 2 + 1, rectX + rectWidth, this.y + this.height / 2 + 1);
            }
            if (styleAttributes.squiggle()) {
                g.gc.setForeground(effectsColor.getColor());
                this.drawSquiggle(g, rectX, rectX + rectWidth);
            } else if (styleAttributes.underline()) {
                g.gc.setForeground(effectsColor.getColor());
                g.gc.drawLine(rectX, this.y + this.height - 1, rectX + rectWidth, this.y + this.height - 1);
            }
            if (hasAnnotations && text != null) {
                this.drawAnnotationDecorations(g, text, index, len, rectX);
            }
        }

        private int getDelta() {
            int delta = 0;
            if (this._text == null || this._docText == null) {
                return delta;
            }
            if (this._docText.length() != this._text._length + TextWindow.this._eolLength) {
                String prefixString = new String(this._prefixText._string);
                if ((prefixString = prefixString.replaceAll("[\\s/\\x00]", "")).length() != 0 && this._docText.startsWith(prefixString)) {
                    delta = this._docText.length() - TextWindow.this._eolLength - this._text._length;
                }
            }
            return delta;
        }

        private void drawAnnotationDecorations(LpexGC g, char[] text, int index, int len, int rectX) {
            if (this._text == null || this._docText == null) {
                return;
            }
            String noSeqNumText = new String(this._text._string, 0, this._text._length);
            if (!this._docText.contains(noSeqNumText)) {
                return;
            }
            int delta = this.getDelta();
            int indexOffset = this._offset + delta + index;
            for (Annotation a : this._annotations) {
                Position apos;
                String style;
                AnnotationPreference p = this.getAnnotationPreference(a.getType());
                if (p == null || !this.getAnnotationText(p) || (style = this.getAnnotationStyle(p)) == null || style.equals("NONE") || (apos = TextWindow.this._model.getPosition(a)) == null || apos.isDeleted()) continue;
                int aOffset = this.getAdjustedIndex(apos.offset);
                int eOffset = this.getAdjustedIndex(apos.offset + apos.length);
                if (!(indexOffset <= aOffset && aOffset <= indexOffset + len || indexOffset <= eOffset && eOffset <= indexOffset + len || indexOffset >= aOffset && indexOffset + len <= eOffset)) continue;
                int adjustedStartOffset = Math.max(indexOffset, aOffset);
                int adjustedEndOffset = Math.min(indexOffset + len, eOffset);
                int skipLength = 0;
                if (adjustedStartOffset != indexOffset) {
                    skipLength = this.textFontMetrics().substringWidth(g.gc, text, index, adjustedStartOffset - this._offset - delta);
                }
                int textLength = this.textFontMetrics().substringWidth(g.gc, text, adjustedStartOffset - this._offset - delta, adjustedEndOffset - this._offset - delta);
                RGB rgb = this.getColorPreferenceValue(p);
                org.eclipse.swt.graphics.Color color = this.getColor(rgb);
                g.gc.setForeground(color);
                boolean isDashedBox = this.getAnnotationStyle(p).equals("DASHED_BOX");
                if (this.getAnnotationStyle(p).equals("BOX") || isDashedBox) {
                    int oldStyle = g.gc.getLineStyle();
                    if (isDashedBox) {
                        g.gc.setLineStyle(3);
                    }
                    g.gc.drawRectangle(rectX + skipLength, this.y, textLength, this.height - 1);
                    if (!isDashedBox) continue;
                    g.gc.setLineStyle(oldStyle);
                    continue;
                }
                if (this.getAnnotationStyle(p).equals("IBEAM") && this._offset + index == aOffset) {
                    g.gc.drawLine(rectX + skipLength, this.y, rectX + skipLength, this.y + this.height);
                    continue;
                }
                if (this.getAnnotationStyle(p).equals("UNDERLINE")) {
                    g.gc.drawLine(rectX + skipLength, this.y + this.height - 1, rectX + skipLength + textLength, this.y + this.height - 1);
                    continue;
                }
                if (!this.getAnnotationStyle(p).equals("PROBLEM_UNDERLINE") && !this.getAnnotationStyle(p).equals("SQUIGGLES")) continue;
                this.drawSquiggle(g, rectX + skipLength, rectX + skipLength + textLength);
            }
        }

        private RGB getColorPreferenceValue(AnnotationPreference p) {
            IPreferenceStore store = EditorsPlugin.getDefault().getPreferenceStore();
            String key = p.getColorPreferenceKey();
            if (key == null) {
                return null;
            }
            return PreferenceConverter.getColor((IPreferenceStore)store, (String)key);
        }

        private boolean getAnnotationText(AnnotationPreference p) {
            IPreferenceStore store = EditorsPlugin.getDefault().getPreferenceStore();
            String key = p.getTextPreferenceKey();
            if (key == null) {
                return false;
            }
            return store.getBoolean(key);
        }

        private String getAnnotationStyle(AnnotationPreference p) {
            IPreferenceStore store = EditorsPlugin.getDefault().getPreferenceStore();
            String key = p.getTextStylePreferenceKey();
            if (key == null) {
                return "NONE";
            }
            return store.getString(key);
        }

        private AnnotationPreference getAnnotationPreference(String type) {
            AnnotationPreferenceLookup lookup = new AnnotationPreferenceLookup();
            return lookup.getAnnotationPreference(type);
        }

        private void drawAnnotationBackgrounds(LpexGC g, char[] text, int index, int len, int rectX) {
            if (this._text == null || this._docText == null) {
                return;
            }
            String noSeqNumText = new String(this._text._string, 0, this._text._length);
            if (!this._docText.contains(noSeqNumText)) {
                return;
            }
            int delta = this.getDelta();
            int indexOffset = this._offset + delta + index;
            for (Annotation a : this._annotations) {
                Position apos;
                AnnotationPreference p = this.getAnnotationPreference(a.getType());
                if (p == null || !this.isHighlightDisplayed(p) || (apos = TextWindow.this._model.getPosition(a)) == null || apos.isDeleted()) continue;
                int aOffset = this.getAdjustedIndex(apos.offset);
                int eOffset = this.getAdjustedIndex(apos.offset + apos.length);
                if (!(indexOffset <= aOffset && aOffset <= indexOffset + len || indexOffset <= eOffset && eOffset <= indexOffset + len) && (indexOffset < aOffset || indexOffset + len > eOffset)) continue;
                int adjustedStartOffset = Math.max(indexOffset, aOffset);
                int adjustedEndOffset = Math.min(indexOffset + len, eOffset);
                int skipLength = 0;
                if (adjustedStartOffset != indexOffset) {
                    skipLength = this.textFontMetrics().substringWidth(g.gc, text, index, adjustedStartOffset - this._offset - delta);
                }
                int textLength = this.textFontMetrics().substringWidth(g.gc, text, adjustedStartOffset - this._offset - delta, adjustedEndOffset - this._offset - delta);
                RGB rgb = this.getColorPreferenceValue(p);
                g.gc.setBackground(this.getColor(rgb));
                g.gc.fillRectangle(rectX + skipLength, this.y, textLength, this.height);
            }
        }

        private boolean isHighlightDisplayed(AnnotationPreference p) {
            IPreferenceStore store = EditorsPlugin.getDefault().getPreferenceStore();
            String key = p.getHighlightPreferenceKey();
            if (key == null) {
                return false;
            }
            return store.getBoolean(key);
        }

        private org.eclipse.swt.graphics.Color getColor(RGB rgb) {
            if (TextWindow.this._colorMap.containsKey(rgb)) {
                return TextWindow.this._colorMap.get(rgb);
            }
            org.eclipse.swt.graphics.Color result = new org.eclipse.swt.graphics.Color((Device)Display.getCurrent(), rgb);
            TextWindow.this._colorMap.put(rgb, result);
            return result;
        }

        private boolean hasAnnotations(int index, int len) {
            if (this._annotations != null) {
                int delta = this.getDelta();
                int indexOffset = this._offset + delta + index;
                for (Annotation a : this._annotations) {
                    Position apos = TextWindow.this._model.getPosition(a);
                    if (apos == null || apos.isDeleted()) continue;
                    int aOffset = this.getAdjustedIndex(apos.offset);
                    int eOffset = this.getAdjustedIndex(apos.offset + apos.length);
                    if (!(indexOffset <= aOffset && aOffset <= indexOffset + len || indexOffset <= eOffset && eOffset <= indexOffset + len) && (indexOffset < aOffset || indexOffset + len > eOffset)) continue;
                    return true;
                }
            }
            return false;
        }

        private int getAdjustedIndex(int index) {
            int end = index - this._offset;
            if (end < 0) {
                return index;
            }
            String text = this._docText;
            if (text.indexOf(9) != -1) {
                text = text.substring(0, Math.min(text.length(), end));
                text = TextWindow.this.view().expandTextTabs(text);
                index = TextWindow.this.view().nls().emulationCharIndex(text, text.length());
                return this._offset + index;
            }
            index = TextWindow.this.view().nls().emulationCharIndex(text, Math.min(end, this._docText.length()));
            return this._offset + index;
        }

        private void drawSquiggle(LpexGC g, int left, int right) {
            int WIDTH = 4;
            int HEIGHT = 3;
            int ascents = (right - left) / 4;
            int len = 4 * ascents + 2;
            int[] segments = new int[len];
            int top = this.y + Math.min(this.height - 3, this._textFontMetrics.baseline() + 1);
            int bottom = top + 3 - 1;
            int i = 0;
            int a = 0;
            while (a < ascents) {
                segments[i] = left + 4 * a;
                segments[i + 1] = bottom;
                segments[i + 2] = segments[i] + 2;
                segments[i + 3] = top;
                ++a;
                i += 4;
            }
            segments[i] = left + 4 * ascents;
            segments[i + 1] = bottom;
            g.gc.drawPolyline(segments);
        }

        private void drawExpandHide(LpexGC g) {
            this.drawExpandHide(g, this._expandHideStyleAttributes, this.x, this._expandHideWidth, Screen.EXPAND_HIDE_MARGIN, this._expandHideText);
        }

        private void drawPrefix(LpexGC g) {
            this.drawString(g, this._prefixStyleAttributes, this.x + this._expandHideWidth, this._prefixTextWidth - 1, this._expandHideWidth - this._prefixScroll, this._prefixText);
            g.gc.setForeground(TextWindow.this.getBackground());
            g.gc.drawLine(this.x + this._expandHideWidth + this._prefixTextWidth - 1, this.y, this.x + this._expandHideWidth + this._prefixTextWidth - 1, this.y + this.height);
        }

        private void drawSelectedPrefixText(LpexGC g) {
            this.drawString(g, this._cursorStyleAttributes, this.x + this._expandHideWidth, this._prefixTextWidth - 1, this._expandHideWidth - this._prefixScroll, this._prefixText);
            g.gc.setForeground(TextWindow.this.getBackground());
            g.gc.drawLine(this.x + this._expandHideWidth + this._prefixTextWidth - 1, this.y, this.x + this._expandHideWidth + this._prefixTextWidth - 1, this.y + this.height);
        }

        private void drawSelectedText(LpexGC g) {
            int startClip = this.x + this._expandHideWidth + this._prefixWidth;
            int clipWidth = this.width - this._prefixWidth - this._expandHideWidth;
            this.drawText(g, startClip, clipWidth, this._selectionStyleAttributes);
        }

        private void drawEmphasis(LpexGC g) {
            int startClip = this.x + this._expandHideWidth + this._prefixWidth + this._emphasisPosition - this._scroll;
            int clipWidth = this._emphasisWidth;
            this.drawText(g, startClip, clipWidth, this._emphasisStyleAttributes);
        }

        private void drawCursorText(LpexGC g) {
            int startClip = this.x + this._expandHideWidth + this._prefixWidth + this._cursorPosition - this._scroll;
            int clipWidth = this._cursorWidth;
            this.drawText(g, startClip, clipWidth, this._cursorStyleAttributes);
        }

        private SubLine getNewSubLine() {
            if (TextWindow.this._cachedSubLines == null) {
                return new SubLine();
            }
            SubLine subLine = TextWindow.this._cachedSubLines;
            TextWindow.this._cachedSubLines = subLine._next;
            subLine._next = null;
            return subLine;
        }

        void validateSubLines(LpexGC g) {
            if (this._subLinesValid) {
                return;
            }
            int textLength = this._text != null ? this._text._length : 0;
            int length = this._textStyleAttributesLength > textLength ? this._textStyleAttributesLength : textLength;
            SubLine lastSubLine = null;
            int i = 0;
            while (i < length) {
                int left;
                StyleAttributes styleAttributes;
                StyleAttributes styleAttributes2 = styleAttributes = i < this._textStyleAttributesLength ? this._textStyleAttributes[i] : null;
                if (styleAttributes == null) {
                    styleAttributes = this._defaultStyleAttributes;
                }
                int subTextLength = 1;
                int nextIndex = i + 1;
                while (nextIndex < length) {
                    StyleAttributes styleAttributesNext;
                    if (this._bidiSegments != null) {
                        boolean newSegment = false;
                        int q = 0;
                        while (q < this._bidiSegments.length) {
                            if (this._bidiSegments[q] == nextIndex) {
                                newSegment = true;
                                break;
                            }
                            if (this._bidiSegments[q] > nextIndex) break;
                            ++q;
                        }
                        if (newSegment) break;
                    }
                    StyleAttributes styleAttributes3 = styleAttributesNext = nextIndex < this._textStyleAttributesLength ? this._textStyleAttributes[nextIndex] : null;
                    if (styleAttributesNext == null) {
                        styleAttributesNext = this._defaultStyleAttributes;
                    }
                    if (!styleAttributes.equals(styleAttributesNext) && (nextIndex >= textLength || this._text._string[nextIndex] != ' ' || !styleAttributes.equalsInPainting(styleAttributesNext))) break;
                    ++subTextLength;
                    ++nextIndex;
                }
                subTextLength = Math.min(subTextLength, 1000);
                SubLine subLine = this.getNewSubLine();
                if (lastSubLine != null) {
                    lastSubLine._next = subLine;
                    left = lastSubLine.right();
                } else {
                    this._topSubLine = subLine;
                    left = 0;
                }
                lastSubLine = subLine;
                subLine.set(g, this, left, i, subTextLength, styleAttributes);
                i += subTextLength;
            }
            this._subLinesValid = true;
        }

        private void drawText(LpexGC g, int startClip, int clipWidth) {
            int textEnd;
            int padRectangleStart;
            this.validateSubLines(g);
            SubLine lastSubLine = null;
            SubLine subLine = this._topSubLine;
            while (subLine != null) {
                subLine.draw(g, startClip, clipWidth);
                lastSubLine = subLine;
                subLine = subLine._next;
            }
            int n = padRectangleStart = startClip > this._expandHideWidth + this._prefixWidth ? startClip : this._expandHideWidth + this._prefixWidth;
            if (lastSubLine != null && (textEnd = this._expandHideWidth + this._prefixWidth + lastSubLine.right() - this._scroll) > padRectangleStart) {
                padRectangleStart = textEnd;
            }
            if (padRectangleStart <= startClip + clipWidth) {
                g.gc.setBackground(this._defaultStyleAttributes.backgroundColor().getColor());
                g.gc.fillRectangle(padRectangleStart, this.y, startClip + clipWidth - padRectangleStart, this.height);
            }
        }

        private void drawText(LpexGC g, int startClip, int clipWidth, StyleAttributes styleAttributes) {
            int textEnd;
            int padRectangleStart;
            this.validateSubLines(g);
            SubLine lastSubLine = null;
            SubLine subLine = this._topSubLine;
            while (subLine != null) {
                subLine.draw(g, startClip, clipWidth, styleAttributes);
                lastSubLine = subLine;
                subLine = subLine._next;
            }
            int n = padRectangleStart = startClip > this._expandHideWidth + this._prefixWidth ? startClip : this._expandHideWidth + this._prefixWidth;
            if (lastSubLine != null && (textEnd = this._expandHideWidth + this._prefixWidth + lastSubLine.right() - this._scroll) > padRectangleStart) {
                padRectangleStart = textEnd;
            }
            if (padRectangleStart <= startClip + clipWidth) {
                g.gc.setBackground(styleAttributes.backgroundColor().getColor());
                g.gc.fillRectangle(padRectangleStart, this.y, startClip + clipWidth - padRectangleStart, this.height);
            }
        }

        private void paint(LpexGC g) {
            if (this.valid()) {
                return;
            }
            boolean regularCursor = !this._hasElementBlock;
            g.setFont(this._font);
            GC gc = g.gc;
            Rectangle originalClip = gc.getClipping();
            if (this._expandHideWidth > 0 && this._expandHideWidth >= this._invalidPosition) {
                gc.setClipping(this._invalidPosition, this.y, this._expandHideWidth - this._invalidPosition, this.height);
                this.drawExpandHide(g);
                this._invalidWidth -= this._expandHideWidth - this._invalidPosition;
                if (this._invalidWidth < 0) {
                    this._invalidWidth = 0;
                }
                this._invalidPosition = this._expandHideWidth;
            }
            int marginWidth = this._expandHideWidth + this._prefixWidth;
            if (this._prefixWidth > 0 && this._invalidWidth > 0 && marginWidth >= this._invalidPosition) {
                if (this._expandHideWidth + this._prefixTextWidth >= this._invalidPosition) {
                    gc.setClipping(this._invalidPosition, this.y, this._expandHideWidth + this._prefixTextWidth - this._invalidPosition, this.height);
                    this.drawPrefix(g);
                    if (TextWindow.this._cursorVisible && this._hasPrefixCursor && this._expandHideWidth + this._prefixCursorPosition - this._prefixScroll <= this._invalidPosition + this._invalidWidth && this._expandHideWidth + this._prefixCursorPosition - this._prefixScroll + this._prefixCursorWidth >= this._invalidPosition) {
                        gc.setClipping(this._expandHideWidth + this._prefixCursorPosition - this._prefixScroll, this.y, this._prefixCursorWidth, this.height);
                        this.drawSelectedPrefixText(g);
                        TextWindow.this.setImeLocation(this._expandHideWidth + this._prefixCursorPosition - this._prefixScroll, this.y);
                    }
                }
                if (!this._ownerDrawMargin && this._invalidPosition < this._expandHideWidth + this._prefixWidth && this._invalidPosition + this._invalidWidth > this._expandHideWidth + this._prefixTextWidth) {
                    gc.setClipping(this._invalidPosition, this.y, this._invalidWidth, this.height);
                    gc.setBackground(this._marginStyleAttributes.backgroundColor().getColor());
                    gc.fillRectangle(this._expandHideWidth + this._prefixTextWidth, this.y, this._prefixWidth - this._prefixTextWidth, this.height);
                }
                this._invalidWidth -= marginWidth - this._invalidPosition;
                if (this._invalidWidth < 0) {
                    this._invalidWidth = 0;
                }
                this._invalidPosition = marginWidth;
            }
            if (this._invalidWidth > 0) {
                int[] emphasis;
                Rectangle partClip;
                int segmentPosition;
                int segmentWidth;
                Rectangle invalidTextClip = new Rectangle(this._invalidPosition, this.y, this._invalidWidth, this.height);
                if (this._hasElementBlock) {
                    gc.setClipping(invalidTextClip);
                    this.drawSelectedText(g);
                } else if (!this._hasBlock || this._blockWidth == 0 || marginWidth + this._blockPosition - this._scroll > this._invalidPosition + this._invalidWidth || marginWidth + this._blockPosition - this._scroll + this._blockWidth < this._invalidPosition) {
                    gc.setClipping(invalidTextClip);
                    this.drawText(g, this._invalidPosition, this._invalidWidth);
                } else {
                    int count = 0;
                    int remainingTextStart = this._invalidPosition;
                    do {
                        segmentPosition = this._blockSegments[count];
                        segmentWidth = this._blockSegments[count + 1] - segmentPosition;
                        if (marginWidth + segmentPosition - this._scroll > remainingTextStart) {
                            partClip = invalidTextClip.intersection(new Rectangle(remainingTextStart, this.y, marginWidth + segmentPosition - this._scroll - remainingTextStart, this.height));
                            gc.setClipping(partClip);
                            this.drawText(g, remainingTextStart, marginWidth + segmentPosition - this._scroll - remainingTextStart);
                        }
                        if ((remainingTextStart = marginWidth + segmentPosition - this._scroll) >= this._invalidPosition + this._invalidWidth) break;
                        partClip = invalidTextClip.intersection(new Rectangle(marginWidth + segmentPosition - this._scroll, this.y, segmentWidth, this.height));
                        gc.setClipping(partClip);
                        this.drawSelectedText(g);
                    } while ((remainingTextStart += segmentWidth) < this._invalidPosition + this._invalidWidth && (count += 2) < this._blockSegments.length);
                    if (remainingTextStart < this._invalidPosition + this._invalidWidth) {
                        gc.setClipping(remainingTextStart, this.y, this._invalidPosition + this._invalidWidth - remainingTextStart, this.height);
                        this.drawText(g, remainingTextStart, this._invalidPosition + this._invalidWidth - remainingTextStart);
                    }
                    if (regularCursor) {
                        int i = 0;
                        while (i < this._blockSegments.length) {
                            if (this._cursorPosition >= this._blockSegments[i] && this._cursorPosition < this._blockSegments[i + 1]) {
                                regularCursor = false;
                                break;
                            }
                            i += 2;
                        }
                    }
                }
                int[] nArray = emphasis = this._noEmphasisInBlock ? this.excludeBlockFromEmphasis() : this._emphasisSegments;
                if (emphasis != null) {
                    int count = 0;
                    do {
                        segmentPosition = emphasis[count];
                        segmentWidth = emphasis[count + 1] - segmentPosition;
                        if (marginWidth + segmentPosition - this._scroll > this._invalidPosition + this._invalidWidth || marginWidth + segmentPosition - this._scroll + segmentWidth < this._invalidPosition) continue;
                        partClip = invalidTextClip.intersection(new Rectangle(marginWidth + segmentPosition - this._scroll, this.y, segmentWidth, this.height));
                        gc.setClipping(partClip);
                        this.drawEmphasis(g);
                    } while ((count += 2) < emphasis.length);
                }
                if (TextWindow.this._cursorVisible && this._hasCursor && marginWidth + this._cursorPosition - this._scroll <= this._invalidPosition + this._invalidWidth && marginWidth + this._cursorPosition - this._scroll + this._cursorWidth >= this._invalidPosition) {
                    partClip = invalidTextClip.intersection(new Rectangle(marginWidth + this._cursorPosition - this._scroll, this.y, this._cursorWidth, this.height));
                    gc.setClipping(partClip);
                    if (regularCursor) {
                        this.drawCursorText(g);
                    } else {
                        this.drawText(g, marginWidth + this._cursorPosition - this._scroll, this._cursorWidth);
                    }
                    TextWindow.this.setImeLocation(marginWidth + this._cursorPosition - this._scroll, this.y);
                }
            }
            gc.setClipping(originalClip);
            this.validate();
        }

        private int[] excludeBlockFromEmphasis() {
            if (this._emphasisSegments == null || this._hasElementBlock) {
                return null;
            }
            if (!this._hasBlock || this._blockSegments == null) {
                return this._emphasisSegments;
            }
            int bStart = this._blockSegments[0];
            int bEnd = this._blockSegments[1];
            if (bEnd <= this._emphasisSegments[0] || bStart >= this._emphasisSegments[1]) {
                return this._emphasisSegments;
            }
            if (bStart <= this._emphasisSegments[0] && bEnd >= this._emphasisSegments[1]) {
                return null;
            }
            if (bStart <= this._emphasisSegments[0] && bEnd < this._emphasisSegments[1]) {
                return new int[]{bEnd, this._emphasisSegments[1]};
            }
            if (bStart > this._emphasisSegments[0] && bEnd >= this._emphasisSegments[1]) {
                return new int[]{this._emphasisSegments[0], bStart};
            }
            return new int[]{this._emphasisSegments[0], bStart, bEnd, this._emphasisSegments[1]};
        }

        void invalidate(int invalidPosition, int invalidWidth) {
            if (invalidPosition < 0) {
                invalidWidth -= -invalidPosition;
                invalidPosition = 0;
            }
            if (invalidPosition + invalidWidth > this.width) {
                invalidWidth = this.width - invalidPosition;
            }
            if (invalidWidth > 0) {
                if (this.valid()) {
                    this._invalidPosition = invalidPosition;
                    this._invalidWidth = invalidWidth;
                } else {
                    if (invalidPosition < this._invalidPosition) {
                        this._invalidWidth += this._invalidPosition - invalidPosition;
                        this._invalidPosition = invalidPosition;
                    }
                    if (invalidPosition + invalidWidth > this._invalidPosition + this._invalidWidth) {
                        this._invalidWidth = invalidPosition + invalidWidth - this._invalidPosition;
                    }
                }
            }
        }

        void validate() {
            this._invalidWidth = 0;
        }

        boolean valid() {
            return this._invalidWidth == 0;
        }

        void update() {
            if (!this.valid()) {
                TextWindow.this.redraw(this._invalidPosition, this.y, this._invalidWidth, this.height, false);
            }
        }

        TextFontMetrics textFontMetrics() {
            return this._textFontMetrics;
        }

        TextWindowString text() {
            return this._text;
        }

        int expandHideWidth() {
            return this._expandHideWidth;
        }

        int prefixWidth() {
            return this._prefixWidth;
        }

        int scroll() {
            return this._scroll;
        }
    }

    static final class LpexGC {
        GC gc;
        private Font _font;

        LpexGC(GC g) {
            this.gc = g;
        }

        void setFont(Font newFont) {
            if (this._font == null || !this._font.equals(newFont)) {
                this._font = newFont;
                this.gc.setFont(this._font.getFont());
            }
        }
    }

    static final class SubLine {
        SubLine _next;
        private Line _line;
        private int _left;
        private int _index;
        private int _length;
        private int _width;
        private StyleAttributes _styleAttributes;

        SubLine() {
        }

        void set(LpexGC g, Line line, int left, int index, int len, StyleAttributes styleAttributes) {
            int textLength;
            this._line = line;
            this._left = left;
            this._index = index;
            this._styleAttributes = styleAttributes;
            TextWindowString text = line.text();
            int n = textLength = text == null ? 0 : text._length;
            if (index + len <= textLength) {
                this._width = this._line.textFontMetrics().substringWidth(g.gc, text == null ? null : text._string, index, index + len);
                this._length = len;
            } else if (index < textLength) {
                this._width = this._line.textFontMetrics().substringWidth(g.gc, text == null ? null : text._string, index, textLength) + (index + len - textLength) * this._line.textFontMetrics().spaceWidth();
                this._length = textLength - index;
            } else {
                this._width = len * this._line.textFontMetrics().spaceWidth();
                this._length = 0;
            }
        }

        void reset() {
            this._line = null;
            this._left = 0;
            this._index = 0;
            this._length = 0;
            this._width = 0;
            this._styleAttributes = null;
        }

        int left() {
            return this._left;
        }

        int right() {
            return this._left + this._width;
        }

        int width() {
            return this._width;
        }

        void draw(LpexGC g, int startClip, int clipWidth) {
            this.draw(g, startClip, clipWidth, this._styleAttributes);
        }

        void draw(LpexGC g, int startClip, int clipWidth, StyleAttributes styleAttributes) {
            int endClip = startClip + clipWidth;
            if (this._line.expandHideWidth() + this._line.prefixWidth() + this.right() - this._line.scroll() >= startClip && this._line.expandHideWidth() + this._line.prefixWidth() + this._left - this._line.scroll() <= endClip) {
                int x = this._line.expandHideWidth() + this._line.prefixWidth() + this._left - this._line.scroll();
                TextWindowString text = this._line.text();
                this._line.drawString(g, styleAttributes, x, this._width, x, text != null ? text._string : null, this._index, this._length, true);
            }
        }
    }

    private class TextWindowModelListener
    implements IAnnotationModelListener,
    IAnnotationModelListenerExtension,
    IPropertyChangeListener {
        private TextWindowModelListener() {
        }

        public void modelChanged(IAnnotationModel model) {
            if (!TextWindow.this.isDisposed()) {
                this.invalidateAllLines();
            }
        }

        public void modelChanged(AnnotationModelEvent event) {
            if (!event.isValid() || TextWindow.this.isDisposed()) {
                return;
            }
            if (event.isWorldChange()) {
                this.invalidateAllLines();
            } else {
                this.invalidateSpecificLines(event);
            }
        }

        private boolean isAnnotationContainLine(Line line, Annotation[] annotations, IDocument doc, AnnotationModelEvent event, AnnotationModelEventType type) {
            if (annotations == null) {
                LpexLog.log(TextWindow.this.view(), "Bad information at isAnnotationContainLine() with null annotations");
                return false;
            }
            int lineOffset = line._offset;
            Annotation[] annotationArray = annotations;
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation annotation = annotationArray[n2];
                if (annotation == null) {
                    LpexLog.log(TextWindow.this.view(), "Bad information at isAnnotationContainLine() with a null annotation in annotations.... skipping.");
                } else {
                    Position annotationPos;
                    Position position = annotationPos = type == AnnotationModelEventType.REMOVED ? event.getPositionOfRemovedAnnotation(annotation) : TextWindow.this._model.getPosition(annotation);
                    if (annotationPos != null && annotationPos.offset <= doc.getLength()) {
                        try {
                            int startOffset = doc.getLineOffset(doc.getLineOfOffset(annotationPos.offset));
                            if (lineOffset >= startOffset && lineOffset <= startOffset + annotationPos.getLength()) {
                                return true;
                            }
                        }
                        catch (BadLocationException e) {
                            LpexLog.log(TextWindow.this.view(), "Bad location at isAnnotationContainLine() for " + String.valueOf((Object)type) + " annotations", e);
                        }
                    }
                }
                ++n2;
            }
            return false;
        }

        private void invalidateAllLines() {
            Display display = Display.getDefault();
            if (display != null && !display.isDisposed()) {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!TextWindow.this.isDisposed()) {
                            Line line = ((TextWindowModelListener)TextWindowModelListener.this).TextWindow.this._topLine;
                            while (line != null) {
                                line.invalidate(0, line.width);
                                line = line._next;
                            }
                            TextWindowModelListener.this.windowRedraw();
                        }
                    }
                });
            }
        }

        private boolean isLineHaveUpdatedAnnotation(Line line, IDocument doc, AnnotationModelEvent event) {
            if (line == null) {
                LpexLog.log(TextWindow.this.view(), "Bad information at isLineHaveUpdatedAnnotation() with null line");
                return false;
            }
            if (doc == null) {
                LpexLog.log(TextWindow.this.view(), "Bad information at isLineHaveUpdatedAnnotation() with null doc");
                return false;
            }
            if (event == null) {
                LpexLog.log(TextWindow.this.view(), "Bad information at isLineHaveUpdatedAnnotation() with null event");
                return false;
            }
            Annotation[] annotations = event.getChangedAnnotations();
            boolean hasChanged = this.isAnnotationContainLine(line, annotations, doc, event, AnnotationModelEventType.CHANGED);
            if (hasChanged) {
                return true;
            }
            annotations = event.getAddedAnnotations();
            boolean hasAdded = this.isAnnotationContainLine(line, annotations, doc, event, AnnotationModelEventType.ADDED);
            if (hasAdded) {
                return true;
            }
            annotations = event.getRemovedAnnotations();
            boolean hasRemoved = this.isAnnotationContainLine(line, annotations, doc, event, AnnotationModelEventType.REMOVED);
            return hasRemoved;
        }

        private IDocument getDocumentFromEditor() {
            final IDocument[] doc = new IDocument[]{null};
            Display display = Display.getDefault();
            if (display != null && !display.isDisposed()) {
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        LpexAbstractTextEditor editor;
                        if (!TextWindow.this.isDisposed() && (editor = TextWindow.this.textEditor()) != null) {
                            IDocumentProvider dp = editor.getDocumentProvider();
                            IEditorInput input = editor.getEditorInput();
                            if (dp != null && input != null) {
                                doc[0] = dp.getDocument((Object)input);
                            }
                        }
                    }
                });
            }
            return doc[0];
        }

        private void invalidateSpecificLines(final AnnotationModelEvent event) {
            Display display;
            if (TextWindow.this._topLine == null) {
                return;
            }
            final IDocument doc = this.getDocumentFromEditor();
            if (doc != null && (display = Display.getDefault()) != null && !display.isDisposed()) {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!TextWindow.this.isDisposed()) {
                            boolean invalidatedALine = false;
                            Line line = ((TextWindowModelListener)TextWindowModelListener.this).TextWindow.this._topLine;
                            while (line != null) {
                                if (TextWindowModelListener.this.isLineHaveUpdatedAnnotation(line, doc, event)) {
                                    line.invalidate(0, line.width);
                                    invalidatedALine = true;
                                }
                                line = line._next;
                            }
                            if (invalidatedALine) {
                                TextWindowModelListener.this.windowRedraw();
                            }
                        }
                    }
                });
            }
        }

        private void windowRedraw() {
            if (TextWindow.this._lpexWindow != null && !TextWindow.this._lpexWindow.isDisposed()) {
                Document.screenShow(TextWindow.this._lpexWindow);
            }
        }

        private void causeWindowRedraw() {
            Display display = Display.getDefault();
            if (display != null && !display.isDisposed()) {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!TextWindow.this.isDisposed()) {
                            TextWindowModelListener.this.windowRedraw();
                        }
                    }
                });
            }
        }

        public void propertyChange(PropertyChangeEvent event) {
            this.invalidateAllLines();
            this.causeWindowRedraw();
        }
    }

    static final class TextWindowString {
        char[] _string;
        int _length;
        int _incrementSize;

        TextWindowString(int minimumLength, int incrementSize) {
            this._string = new char[minimumLength + incrementSize];
            this._incrementSize = incrementSize;
        }

        boolean set(String string) {
            if (string == null) {
                this._length = 0;
                return true;
            }
            boolean different = false;
            if (this._length != string.length()) {
                this._length = string.length();
                different = true;
            }
            if (this._length > 0) {
                if (this._length > this._string.length) {
                    different = true;
                    this._string = new char[this._length + this._incrementSize];
                }
                int i = 0;
                while (i < this._length) {
                    char c = string.charAt(i);
                    if (c != this._string[i]) {
                        this._string[i] = c;
                        different = true;
                    }
                    ++i;
                }
            }
            return different;
        }
    }
}

