/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.CommandHandler;
import com.ibm.lpex.core.Document;
import com.ibm.lpex.core.Install;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.ParameterDefault;
import com.ibm.lpex.core.Profile;
import com.ibm.lpex.core.View;

final class TabsParameter
extends ParameterDefault {
    private static TabsParameter _parameter;
    private Settings _installValue;
    private Settings _defaultValue;

    static TabsParameter getParameter() {
        if (_parameter == null) {
            _parameter = new TabsParameter();
        }
        return _parameter;
    }

    private TabsParameter() {
        super("tabs");
        Install.addProfileChangedListener(new Install.ProfileChangedListener(){

            @Override
            public void profileChanged() {
                TabsParameter.this._installValue = null;
                TabsParameter.this.currentValueChanged();
            }
        });
        Profile.addProfileChangedListener(new Profile.ProfileChangedListener(){

            @Override
            public void profileChanged() {
                TabsParameter.this._defaultValue = null;
                TabsParameter.this.currentValueChanged();
            }
        });
    }

    Settings installValue() {
        if (this._installValue == null) {
            String value = Install.getString("install." + this.name());
            if (value == null) {
                value = "1 every 8";
            }
            this._installValue = new Settings();
            TabsParameter.setTabs(null, "load install." + this.name(), value, this._installValue);
        }
        return this._installValue;
    }

    Settings defaultValue() {
        if (this._defaultValue == null) {
            String value = Profile.getString("default." + this.name());
            this._defaultValue = new Settings();
            TabsParameter.setTabs(null, "load default." + this.name(), value, this._defaultValue);
        }
        return this._defaultValue;
    }

    Settings currentValue(View view) {
        Settings value;
        Settings settings = value = view != null ? view.tabs() : null;
        if (value == null || value._tabStops == null && value._tabIncrement == 0) {
            value = this.defaultValue();
            if (value._tabStops == null && value._tabIncrement == 0) {
                value = this.installValue();
            }
        }
        return value;
    }

    @Override
    boolean set(View view, String qualifier, String parameters) {
        Settings value = new Settings();
        LpexStringTokenizer st = new LpexStringTokenizer(parameters);
        if (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (!token.equalsIgnoreCase("default")) {
                if (!TabsParameter.setTabs(view, "set " + this.name(), parameters, value)) {
                    return false;
                }
            } else if (st.hasMoreTokens()) {
                return CommandHandler.invalidParameter(view, st.nextToken(), "set " + this.name());
            }
        }
        if (view != null) {
            view.setTabs(value);
        }
        return true;
    }

    @Override
    boolean setDefault(View view, String qualifier, String parameters) {
        LpexStringTokenizer st = new LpexStringTokenizer(parameters);
        Settings value = new Settings();
        if (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (!token.equalsIgnoreCase("install")) {
                if (!TabsParameter.setTabs(view, "set default." + this.name(), parameters, value)) {
                    return false;
                }
            } else if (st.hasMoreTokens()) {
                return CommandHandler.invalidParameter(view, st.nextToken(), "set default." + this.name());
            }
        }
        this._defaultValue = value;
        Profile.putString("default." + this.name(), TabsParameter.getTabsString(this._defaultValue));
        this.currentValueChanged();
        return true;
    }

    private void currentValueChanged() {
        Document document = Document._firstDocument;
        while (document != null) {
            View view = document._firstView;
            while (view != null) {
                Settings value = view.tabs();
                if (value._tabStops == null && value._tabIncrement == 0) {
                    view.tabsChanged();
                }
                view = view._next;
            }
            document = document._next;
        }
    }

    @Override
    String query(View view, LpexDocumentLocation documentLocation, String qualifier) {
        if (view == null) {
            return null;
        }
        Settings value = view.tabs();
        return value._tabStops == null && value._tabIncrement == 0 ? "default" : TabsParameter.getTabsString(value);
    }

    @Override
    String queryInstall(String qualifier) {
        return TabsParameter.getTabsString(this.installValue());
    }

    @Override
    String queryDefault(String qualifier) {
        Settings value = this.defaultValue();
        return value._tabStops == null && value._tabIncrement == 0 ? "install" : TabsParameter.getTabsString(value);
    }

    @Override
    String queryCurrent(View view, String qualifier) {
        return TabsParameter.getTabsString(this.currentValue(view));
    }

    static String getTabsString(Settings settings) {
        if (settings == null || settings._tabStops == null && settings._tabIncrement == 0) {
            return null;
        }
        StringBuilder tabsString = new StringBuilder(120);
        tabsString.append('1');
        if (settings._tabStops != null) {
            int i = 0;
            while (i < settings._tabStops.length) {
                int tabStop = settings._tabStops[i];
                if (tabStop != 1) {
                    tabsString.append(' ').append(tabStop);
                }
                ++i;
            }
        }
        if (settings._tabIncrement > 0) {
            tabsString.append(" every ").append(settings._tabIncrement);
        }
        return tabsString.toString();
    }

    static boolean setTabs(View view, String command, String tabsString, Settings settings) {
        int[] tabStops = null;
        int tabIncrement = 0;
        if (tabsString != null) {
            String token = null;
            int lastTabStop = 0;
            int count = 1;
            LpexStringTokenizer st = new LpexStringTokenizer(tabsString);
            try {
                while (st.hasMoreTokens()) {
                    token = st.nextToken();
                    int tabStop = Integer.parseInt(token);
                    if (tabStop <= lastTabStop) {
                        return CommandHandler.invalidParameter(view, token, command);
                    }
                    if (tabStop != 1) {
                        ++count;
                    }
                    lastTabStop = tabStop;
                    token = null;
                }
            }
            catch (NumberFormatException tabStop) {
                // empty catch block
            }
            if (token != null) {
                if (!token.equalsIgnoreCase("every")) {
                    return CommandHandler.invalidParameter(view, token, command);
                }
                if (!st.hasMoreTokens()) {
                    return CommandHandler.incomplete(view, command);
                }
                token = st.nextToken();
                try {
                    tabIncrement = Integer.parseInt(token);
                    if (tabIncrement < 1) {
                        return CommandHandler.invalidParameter(view, token, command);
                    }
                }
                catch (NumberFormatException e) {
                    return CommandHandler.invalidParameter(view, token, command);
                }
                if (st.hasMoreTokens()) {
                    return CommandHandler.invalidParameter(view, st.nextToken(), command);
                }
            }
            tabStops = new int[count];
            tabStops[0] = 1;
            st = new LpexStringTokenizer(tabsString);
            int i = 1;
            while (st.hasMoreTokens() && i < count) {
                int tabStop = Integer.parseInt(st.nextToken());
                if (tabStop == 1) continue;
                tabStops[i] = tabStop;
                ++i;
            }
        }
        settings._tabStops = tabStops;
        settings._tabIncrement = tabIncrement;
        return true;
    }

    static class Settings {
        int[] _tabStops = null;
        int _tabIncrement;

        Settings() {
        }
    }
}

