/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.alef.LpexTextViewer;
import com.ibm.lpex.core.LpexView;
import com.ibm.lpex.core.LpexWindow;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextPresentationListener;
import org.eclipse.jface.text.ITextViewerExtension4;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.custom.TextChangeListener;
import org.eclipse.swt.custom.TextChangedEvent;
import org.eclipse.swt.custom.TextChangingEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class StyledTextContentLpexViewWrapper
implements StyledTextContent,
ITextViewerExtension4,
IDocumentListener {
    private StyledText styledText;
    private LpexTextViewer parent;
    private Set<TextChangeListener> textChangeListeners = ConcurrentHashMap.newKeySet();
    private Set<ITextPresentationListener> textPresentationListeners = ConcurrentHashMap.newKeySet();
    boolean waitingForDocumentChangeSettling = false;

    public StyledTextContentLpexViewWrapper(LpexTextViewer textViewer) {
        this.parent = textViewer;
    }

    public void connect() {
        if (this.document() != null) {
            this.document().addPrenotifiedDocumentListener((IDocumentListener)this);
            this.document().addDocumentListener((IDocumentListener)this);
        }
    }

    public void disconnect() {
        if (this.document() != null) {
            this.document().removePrenotifiedDocumentListener((IDocumentListener)this);
            this.document().removeDocumentListener((IDocumentListener)this);
        }
    }

    public StyledText styledText() {
        if (this.styledText != null && !this.styledText.isDisposed()) {
            return this.styledText;
        }
        this.disconnect();
        if (this.lpexWindow() != null) {
            this.styledText = new StyledTextExtension(this.lpexWindow(), 0);
            this.styledText.setContent((StyledTextContent)this);
            if (this.lpexView() != null) {
                this.styledText.setFont(this.lpexView().getFont());
            } else {
                this.styledText.setFont(this.lpexWindow().getFont());
            }
            this.styledText.setBackground(this.lpexWindow().getBackground());
            this.styledText.setForeground(this.lpexWindow().getForeground());
            this.styledText.setVisible(false);
            this.styledText.setEnabled(false);
            this.styledText.setEditable(false);
            this.styledText.setTopIndex(this.lpexTextViewer().getTopIndex());
            this.styledText.setBounds(this.lpexTextViewer().getLpexWindow().getBounds());
        }
        this.connect();
        return this.styledText;
    }

    private LpexWindow lpexWindow() {
        LpexTextViewer viewer = this.lpexTextViewer();
        return viewer == null ? null : viewer.getActiveLpexWindow();
    }

    private LpexView lpexView() {
        LpexTextViewer viewer = this.lpexTextViewer();
        return viewer == null ? null : viewer.getActiveLpexView();
    }

    private LpexTextViewer lpexTextViewer() {
        return this.parent;
    }

    private IDocument document() {
        LpexTextViewer viewer = this.lpexTextViewer();
        return viewer == null ? null : viewer.getVisibleDocument();
    }

    public void setText(String text) {
        IDocument doc = this.document();
        if (doc != null) {
            doc.set(text);
        }
        TextChangedEvent set = new TextChangedEvent((StyledTextContent)this);
        this.sendTextSetEvent(set);
    }

    private TextChangedEvent dupe(TextChangedEvent tce) {
        TextChangedEvent tce2 = new TextChangedEvent((StyledTextContent)this);
        tce2.data = tce.data;
        tce2.display = tce.display;
        tce2.time = tce.time;
        tce2.widget = tce.widget;
        return tce2;
    }

    private void sendTextSetEvent(TextChangedEvent event) {
        this.textChangeListeners.forEach(tcl -> {
            try {
                tcl.textSet(this.dupe(event));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        });
    }

    private void sendTextChangedEvent(TextChangedEvent event) {
        this.textChangeListeners.forEach(tcl -> {
            try {
                tcl.textChanged(this.dupe(event));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        });
    }

    private void sendTextChangingEvent(TextChangingEvent event) {
        this.textChangeListeners.forEach(tcl -> {
            try {
                tcl.textChanging(this.dupe(event));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        });
    }

    private TextChangingEvent dupe(TextChangingEvent tce) {
        TextChangingEvent tce2 = new TextChangingEvent((StyledTextContent)this);
        tce2.newCharCount = tce.newCharCount;
        tce2.newLineCount = tce.newLineCount;
        tce2.newText = tce.newText;
        tce2.replaceLineCount = tce.replaceLineCount;
        tce2.replaceCharCount = tce.replaceCharCount;
        tce2.start = tce.start;
        tce2.data = tce.data;
        tce2.display = tce.display;
        tce2.time = tce.time;
        tce2.widget = tce.widget;
        return tce2;
    }

    public void replaceTextRange(int offset, int length, String text) {
        IDocument doc = this.document();
        if (doc == null) {
            return;
        }
        int charCount = doc.getLength();
        if (offset > charCount || length > charCount || offset + length > charCount) {
            return;
        }
        try {
            doc.replace(offset, length, text);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public String getTextRange(int offset, int length) {
        IDocument doc = this.document();
        if (doc == null) {
            return "";
        }
        int charCount = doc.getLength();
        if (offset > charCount || length > charCount || offset + length > charCount) {
            return "";
        }
        if (offset == 0 && length == charCount) {
            String all = doc.get();
            return all;
        }
        try {
            String range = doc.get(offset, length);
            return range;
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return "";
        }
    }

    public int getOffsetAtLine(int line) {
        IDocument doc = this.document();
        if (doc == null) {
            return 0;
        }
        int numOfLines = doc.getNumberOfLines();
        if (line > numOfLines) {
            return 0;
        }
        try {
            int offset = doc.getLineOffset(line);
            return offset;
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public String getLineDelimiter() {
        return System.lineSeparator();
    }

    public int getLineCount() {
        IDocument doc = this.document();
        int lines = doc == null ? 0 : doc.getNumberOfLines();
        return lines;
    }

    public int getLineAtOffset(int offset) {
        IDocument doc = this.document();
        if (doc == null) {
            return 0;
        }
        try {
            int line = doc.getLineOfOffset(offset);
            return line;
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public String getLine(int line) {
        int line1based = line + 1;
        String value = this.lpexView() == null ? null : this.lpexView().lineFullText(line1based);
        value = value == null ? "" : value;
        return value;
    }

    public int getCharCount() {
        return this.getCharCount(this.document());
    }

    private int getCharCount(IDocument doc) {
        if (doc == null) {
            return 0;
        }
        int charcount = doc.getLength();
        return charcount;
    }

    public void addTextChangeListener(TextChangeListener textChangeListener) {
        this.textChangeListeners.add(textChangeListener);
    }

    public void removeTextChangeListener(TextChangeListener textChangeListener) {
        try {
            this.textChangeListeners.remove(textChangeListener);
        }
        catch (ClassCastException | NullPointerException runtimeException) {
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void addTextPresentationListener(ITextPresentationListener presentationListener) {
        this.textPresentationListeners.add(presentationListener);
    }

    public void removeTextPresentationListener(ITextPresentationListener presentationListener) {
        try {
            this.textPresentationListeners.remove(presentationListener);
        }
        catch (ClassCastException | NullPointerException runtimeException) {
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public boolean moveFocusToWidgetToken() {
        return this.parent.moveFocusToWidgetToken();
    }

    public void documentAboutToBeChanged(DocumentEvent documentEvent) {
    }

    public void documentChanged(DocumentEvent documentEvent) {
        if (this.waitingForDocumentChangeSettling) {
            return;
        }
        final TextChangedEvent set = new TextChangedEvent((StyledTextContent)this);
        this.waitingForDocumentChangeSettling = true;
        Job job = new Job(""){

            protected IStatus run(IProgressMonitor monitor) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        StyledTextContentLpexViewWrapper.this.sendTextSetEvent(set);
                        (this).StyledTextContentLpexViewWrapper.this.waitingForDocumentChangeSettling = false;
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.schedule(500L);
    }

    private final class StyledTextExtension
    extends StyledText {
        private StyledTextExtension(Composite parentComposite, int style) {
            super(parentComposite, style);
        }

        public Rectangle getClientArea() {
            return StyledTextContentLpexViewWrapper.this.lpexWindow().getClientArea();
        }

        public int getLineIndex(int y) {
            return StyledTextContentLpexViewWrapper.this.lpexTextViewer().getLineIndex(y);
        }

        public int getLineHeight() {
            return StyledTextContentLpexViewWrapper.this.lpexTextViewer().getLineHeight();
        }

        public int getTopIndex() {
            return StyledTextContentLpexViewWrapper.this.lpexTextViewer().getTopIndex();
        }

        public void setTopIndex(int topIndex) {
            StyledTextContentLpexViewWrapper.this.lpexTextViewer().setTopIndex(topIndex);
        }

        public void addControlListener(ControlListener listener) {
            StyledTextContentLpexViewWrapper.this.lpexWindow().addControlListener(listener);
        }

        public void removeControlListener(ControlListener listener) {
            StyledTextContentLpexViewWrapper.this.lpexWindow().addControlListener(listener);
        }
    }
}

