/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.LpexUtilities;
import com.ibm.lpex.core.Parameter;
import com.ibm.lpex.core.ParameterOnOffDefault;
import com.ibm.lpex.core.ParameterWordDefault;
import com.ibm.lpex.core.TableNode;
import com.ibm.lpex.core.View;

final class SplitWindowParameters {
    private static final int ORIENTATION = 1;
    private static TableNode[] _parameters = new TableNode[]{new TableNode("orientation", 1)};

    SplitWindowParameters() {
    }

    static Parameter getParameter(String qualifier) {
        if (qualifier == null) {
            return SplitWindowParameter.getParameter();
        }
        TableNode p = TableNode.binarySearch(_parameters, qualifier);
        if (p != null) {
            switch (p.id()) {
                case 1: {
                    return OrientationParameter.getParameter();
                }
            }
        }
        return null;
    }

    static final class OrientationParameter
    extends ParameterWordDefault {
        private static OrientationParameter _parameter;

        static OrientationParameter getParameter() {
            if (_parameter == null) {
                _parameter = new OrientationParameter();
            }
            return _parameter;
        }

        private OrientationParameter() {
            super("splitWindow.orientation", "vertical");
        }

        @Override
        String name(String qualifier) {
            return this.name();
        }

        @Override
        boolean isAcceptableValue(String value) {
            return "horizontal".equalsIgnoreCase(value) || "vertical".equalsIgnoreCase(value);
        }

        @Override
        boolean setValue(View view, String value) {
            if (view != null) {
                if ("null".equalsIgnoreCase(value)) {
                    value = null;
                }
                LpexUtilities.setSplitWindowOrientationParm(view, value);
                this.currentValueChanged(view);
            }
            return true;
        }

        @Override
        void currentValueChanged(View view) {
            LpexUtilities.splitWindowOrientationChanged(view);
        }

        @Override
        String value(View view) {
            return view != null ? LpexUtilities.splitWindowOrientationParm(view) : null;
        }

        @Override
        boolean setDefaultValue(String value) {
            return super.setDefaultValue("null".equalsIgnoreCase(value) ? null : value);
        }
    }

    static final class SplitWindowParameter
    extends ParameterOnOffDefault {
        private static SplitWindowParameter _parameter;

        static SplitWindowParameter getParameter() {
            if (_parameter == null) {
                _parameter = new SplitWindowParameter();
            }
            return _parameter;
        }

        private SplitWindowParameter() {
            super("splitWindow", true);
        }

        @Override
        boolean setValue(View view, int value) {
            if (view != null) {
                view.setSplitWindow(value);
            }
            return true;
        }

        @Override
        int value(View view) {
            return view != null ? view.splitWindow() : 2;
        }
    }
}

