/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.CommandHandler;
import com.ibm.lpex.core.Element;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.ParameterIntegerOnly;
import com.ibm.lpex.core.View;

final class SequenceNumberParameter
extends ParameterIntegerOnly {
    private static SequenceNumberParameter _parameter;

    static SequenceNumberParameter getParameter() {
        if (_parameter == null) {
            _parameter = new SequenceNumberParameter();
        }
        return _parameter;
    }

    private SequenceNumberParameter() {
        super("sequenceNumber");
    }

    @Override
    boolean setValue(View view, String qualifier, int value) {
        Element element;
        if (value < 0) {
            return CommandHandler.invalidParameter(view, String.valueOf(value), "set " + this.name());
        }
        if (view != null && (element = view.documentPosition().element()) != null) {
            view.document().elementList().setSequenceNumber(view, element, value);
        }
        return true;
    }

    @Override
    String query(View view, LpexDocumentLocation documentLocation, String qualifier) {
        Object sequenceNumber = super.query(view, documentLocation, qualifier);
        if (sequenceNumber != null) {
            int width = view.document().elementList().sequenceNumbersNumWidth();
            while (((String)sequenceNumber).length() < width) {
                sequenceNumber = "0" + (String)sequenceNumber;
            }
            if (((String)sequenceNumber).length() > width) {
                sequenceNumber = ((String)sequenceNumber).substring(((String)sequenceNumber).length() - width);
            }
        }
        return sequenceNumber;
    }

    @Override
    boolean isQueryAvailable(View view, LpexDocumentLocation documentLocation, String qualifier) {
        return view != null && documentLocation != null && view.document().elementList().elementAt(documentLocation.element) != null;
    }

    @Override
    int value(View view, LpexDocumentLocation documentLocation, String qualifier) {
        Element element;
        if (view != null && documentLocation != null && (element = view.document().elementList().elementAt(documentLocation.element)) != null) {
            return element.sequenceNumber();
        }
        return 0;
    }
}

