/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.BeepParameter;
import com.ibm.lpex.core.CommandLine;
import com.ibm.lpex.core.CommandLineOnTopParameter;
import com.ibm.lpex.core.CommandLineParameter;
import com.ibm.lpex.core.DisplayTextLayout;
import com.ibm.lpex.core.Element;
import com.ibm.lpex.core.ElementList;
import com.ibm.lpex.core.ElementView;
import com.ibm.lpex.core.ExpandHideParameter;
import com.ibm.lpex.core.Font;
import com.ibm.lpex.core.FontParameter;
import com.ibm.lpex.core.FormatLine;
import com.ibm.lpex.core.FormatLineParameter;
import com.ibm.lpex.core.HighlightCurrentLineParameter;
import com.ibm.lpex.core.HorizontalScrollBar;
import com.ibm.lpex.core.LpexLog;
import com.ibm.lpex.core.LpexNls;
import com.ibm.lpex.core.LpexResources;
import com.ibm.lpex.core.LpexUtilities;
import com.ibm.lpex.core.LpexWindow;
import com.ibm.lpex.core.MarkList;
import com.ibm.lpex.core.MessageLine;
import com.ibm.lpex.core.MessageLineParameter;
import com.ibm.lpex.core.PrefixAreaMarginParameter;
import com.ibm.lpex.core.PrefixAreaParameter;
import com.ibm.lpex.core.Separator;
import com.ibm.lpex.core.StatusLine;
import com.ibm.lpex.core.StatusLineManager;
import com.ibm.lpex.core.StatusLineParameter;
import com.ibm.lpex.core.StyleAttributes;
import com.ibm.lpex.core.TableNode;
import com.ibm.lpex.core.TextFontMetrics;
import com.ibm.lpex.core.TextWindow;
import com.ibm.lpex.core.UpdateProfileCommand;
import com.ibm.lpex.core.VerticalScrollBar;
import com.ibm.lpex.core.View;
import org.eclipse.swt.widgets.Display;

final class Screen {
    boolean _processingPendingJump;
    static final int STYLE_INVALID = -1;
    static final int STYLE_FIRST = 0;
    static final int STYLE_ADDED_LINES = 0;
    static final int STYLE_BACKGROUND = 1;
    static final int STYLE_CURRENT_LINE = 2;
    static final int STYLE_CURSOR = 3;
    static final int STYLE_DEFAULT = 4;
    static final int STYLE_DELETED_LINES = 5;
    static final int STYLE_EMPHASIS = 6;
    static final int STYLE_EXPAND_HIDE = 7;
    static final int STYLE_FORMAT_LINE = 8;
    static final int STYLE_MESSAGE_LINE = 9;
    static final int STYLE_PARSER_DEFAULT = 10;
    static final int STYLE_PARSER_MESSAGE = 11;
    static final int STYLE_PREFIX_AREA = 12;
    static final int STYLE_PREFIX_TEXT = 13;
    static final int STYLE_SELECTION = 14;
    static final int STYLE_SEQUENCE_NUMBER = 15;
    static final int STYLE_SEQUENCE_TEXT = 16;
    static final int STYLE_STATUS_LINE = 17;
    static final int STYLE_WHITE_SPACE = 18;
    static final int STYLE_HOST_CHAR = 19;
    static final int STYLE_LAST = 19;
    private static final TableNode[] _styles = new TableNode[]{new TableNode("addedLines", 0), new TableNode("background", 1), new TableNode("currentLine", 2), new TableNode("cursor", 3), new TableNode("default", 4), new TableNode("deletedLines", 5), new TableNode("emphasis", 6), new TableNode("expandHide", 7), new TableNode("formatLine", 8), new TableNode("messageLine", 9), new TableNode("parserDefault", 10), new TableNode("parserMessage", 11), new TableNode("prefixArea", 12), new TableNode("prefixText", 13), new TableNode("selection", 14), new TableNode("sequenceNumber", 15), new TableNode("sequenceText", 16), new TableNode("statusLine", 17), new TableNode("whiteSpace", 18), new TableNode("hostChar", 19)};
    static final char CHAR_STYLE_DEFAULT = '!';
    static final char CHAR_STYLE_SEQUENCE_NUMBER = '\u0001';
    static final char CHAR_STYLE_SEQUENCE_TEXT = '\u0002';
    static final char CHAR_STYLE_ADDED_LINES = '\u0003';
    static final char CHAR_STYLE_DELETED_LINES = '\u0004';
    static final char CHAR_STYLE_CURRENT_LINE = '\u0005';
    protected View _view;
    private int _rows;
    private int _cursorRow;
    private int _cursorPosition;
    private int _cursorWidth;
    private int _scroll;
    private int[] _emphasisSegments;
    private boolean _noEmphasisInBlock;
    private int _prefixCursorPosition;
    private int _prefixCursorWidth;
    private int _prefixScroll;
    private Row _topRow;
    private Row _cachedRows;
    private Font _font;
    private TextFontMetrics _textFontMetrics;
    private int _width;
    private int _height;
    private HorizontalScrollBar _horizontalScrollBar;
    private VerticalScrollBar _verticalScrollBar;
    protected LpexWindow _lpexWindow;
    protected String _messageText;
    private String _messageKey;
    private boolean _newMessage;
    private Element _pendingElement;
    private String _pendingCommand;
    private String _formatLineText;
    private String _palette;
    private int _expandHideWidth;
    private int _prefixArea = 2;
    private int _expandHide = 2;
    private int _statusLine = 2;
    private int _formatLine = 2;
    private int _messageLine = 2;
    private int _commandLine = 2;
    private int _commandLineOnTop = 2;
    private int _highlightCurrentLine = 2;
    private int _keepVisible = 2;
    private boolean _keepCursorVisible = true;
    private boolean _ownerDrawMargin;
    private boolean _ownerColumnInfo;
    boolean _needsScreenShow;
    private StyleAttributes[] _styleAttributes = new StyleAttributes[20];
    private boolean[] _backgroundOnly = new boolean[20];
    static int EXPAND_HIDE_MARGIN;
    private ScreenShow _show = new ScreenShow();
    private boolean _partialRow = false;

    static {
        TableNode.sort(_styles);
        EXPAND_HIDE_MARGIN = 2;
    }

    static int styleId(String styleName) {
        TableNode tableNode = TableNode.binarySearch(_styles, styleName.trim());
        return tableNode != null ? tableNode.id() : -1;
    }

    static String styleName(int styleId) {
        TableNode tableNode = TableNode.sequentialSearch(_styles, styleId);
        return tableNode != null ? tableNode.string() : null;
    }

    Screen(View view) {
        this._view = view;
        this._cursorRow = 1;
    }

    HorizontalScrollBar horizontalScrollBar() {
        if (this._horizontalScrollBar == null) {
            this._horizontalScrollBar = new HorizontalScrollBar(this);
        }
        return this._horizontalScrollBar;
    }

    VerticalScrollBar verticalScrollBar() {
        if (this._verticalScrollBar == null) {
            this._verticalScrollBar = new VerticalScrollBar(this);
        }
        return this._verticalScrollBar;
    }

    void setFont(Font font) {
        this._font = font;
        this.newFont();
    }

    void newFont() {
        this._view.setElementWidthsInvalid();
        this._view.setPrefixAreaWidthsInvalid();
        this._view.resetDisplayTextFont();
        this._textFontMetrics = new TextFontMetrics(this);
        this.setRows();
        this._expandHideWidth = 0;
        TextWindow textWindow = this.textWindow();
        if (textWindow != null) {
            textWindow.setImeFont();
        }
    }

    private void validateFontMetrics() {
        if (this._textFontMetrics == null) {
            this._textFontMetrics = new TextFontMetrics(this);
            this._view.setElementWidthsInvalid();
            this._view.setPrefixAreaWidthsInvalid();
            this.setRows();
        }
    }

    Font font() {
        return this._font;
    }

    Font currentFont() {
        return FontParameter.getParameter().currentValue(this._view);
    }

    TextFontMetrics textFontMetrics() {
        this.validateFontMetrics();
        return this._textFontMetrics;
    }

    void setWindow(LpexWindow lpexWindow) {
        if (this._lpexWindow != null) {
            ((TextWindow)this._lpexWindow.textWindow()).removeResizeListener();
        }
        this.horizontalScrollBar().changeLpexWindow(this._lpexWindow, lpexWindow);
        this.verticalScrollBar().changeLpexWindow(this._lpexWindow, lpexWindow);
        this._lpexWindow = lpexWindow;
        if (this._lpexWindow != null) {
            this._textFontMetrics = null;
            ((TextWindow)this._lpexWindow.textWindow()).addResizeListener();
        }
    }

    int width() {
        return this._width;
    }

    int height() {
        return this._height;
    }

    int expandHideAreaWidth() {
        if (this._view.hiddenElements() && this.currentExpandHide()) {
            if (this._expandHideWidth == 0 && this._textFontMetrics != null) {
                int w2;
                int w1 = this._textFontMetrics.stringWidth("+ ");
                this._expandHideWidth = EXPAND_HIDE_MARGIN + (w1 > (w2 = this._textFontMetrics.stringWidth("- ")) ? w1 : w2);
            }
            return this._expandHideWidth;
        }
        return 0;
    }

    int prefixAreaWidth() {
        if (!this.currentPrefixArea()) {
            return 0;
        }
        return this._view.maxPrefixAreaWidth() + PrefixAreaMarginParameter.getParameter().currentValue(this._view);
    }

    int prefixAreaTextWidth() {
        if (!this.currentPrefixArea()) {
            return 0;
        }
        return this._view.maxPrefixAreaWidth();
    }

    int textAreaWidth() {
        int textAreaWidth = this.width();
        if ((textAreaWidth -= this.prefixAreaWidth() + this.expandHideAreaWidth()) < 0) {
            textAreaWidth = 0;
        }
        return textAreaWidth;
    }

    void setOwnerDrawMargin(boolean ownerDraw) {
        this._ownerDrawMargin = ownerDraw;
    }

    boolean ownerDrawMargin() {
        return this._ownerDrawMargin;
    }

    void setOwnerColumnInfo(boolean ownerColumnInfo) {
        this._ownerColumnInfo = ownerColumnInfo;
    }

    int cursorX() {
        int cursorX = this.expandHideAreaWidth();
        cursorX = this._view.inPrefix() ? (cursorX += this._prefixCursorPosition - this._prefixScroll) : (cursorX += this.prefixAreaWidth() + this._cursorPosition - this._scroll);
        return cursorX;
    }

    int cursorY() {
        int cursorY = 0;
        if (this.textFontMetrics() != null) {
            cursorY = this._cursorRow * this._textFontMetrics.textHeight();
        }
        return cursorY;
    }

    void resized(int width, int height) {
        this._width = width;
        this._height = height;
        this.validateFontMetrics();
        this.setRows();
    }

    private void clearRows() {
        while (this._topRow != null) {
            Row temp = this._topRow;
            this._topRow = this._topRow._next;
            temp.reset();
            temp._next = this._cachedRows;
            this._cachedRows = temp;
        }
    }

    private void setRows() {
        if (this._textFontMetrics != null && this._textFontMetrics.textHeight() != 0) {
            this.clearRows();
            this._rows = this._height / this._textFontMetrics.textHeight();
            this._partialRow = this._height > 0 && this._height % this._textFontMetrics.textHeight() > 0;
            TextWindow textWindow = this.textWindow();
            if (textWindow != null) {
                textWindow.invalidateText();
            }
        }
    }

    int rows() {
        return this._rows;
    }

    boolean partialRow() {
        return this._partialRow;
    }

    int cursorPosition() {
        return this._cursorPosition;
    }

    int cursorWidth() {
        return this._cursorWidth;
    }

    int[] emphasisSegments() {
        return this._emphasisSegments;
    }

    void setNoEmphasisInBlock(boolean noEmphasisInBlock) {
        this._noEmphasisInBlock = noEmphasisInBlock;
    }

    boolean noEmphasisInBlock() {
        return this._noEmphasisInBlock;
    }

    int prefixCursorPosition() {
        return this._prefixCursorPosition;
    }

    int prefixCursorWidth() {
        return this._prefixCursorWidth;
    }

    TextWindow textWindow() {
        return this._view.window() != null && this._lpexWindow != null ? (TextWindow)this._view.window().textWindow() : null;
    }

    void setCursorRow(int cursorRow) {
        if (this.keepingCursorVisible()) {
            if (cursorRow < 1) {
                cursorRow = 1;
            }
            if (cursorRow > this.rows() && this.rows() != 0) {
                cursorRow = this.rows();
            }
        }
        this._cursorRow = cursorRow;
        this._view.documentPosition().resetJumpPending();
    }

    private Row rowNode(int row) {
        if (row > 0) {
            int i = 1;
            Row rowNode = this._topRow;
            while (rowNode != null) {
                if (i == row) {
                    return rowNode;
                }
                ++i;
                rowNode = rowNode._next;
            }
        }
        return null;
    }

    Element element(int row) {
        Row rowNode = this.rowNode(row);
        return rowNode != null ? rowNode._element : null;
    }

    int row(Element element) {
        if (element != null) {
            int i = 1;
            Row rowNode = this._topRow;
            while (rowNode != null) {
                if (rowNode._element == element) {
                    return i;
                }
                ++i;
                rowNode = rowNode._next;
            }
        }
        return 0;
    }

    String expandHideText(int row) {
        Row rowNode = this.rowNode(row);
        return rowNode != null ? rowNode._expandHideText : null;
    }

    boolean inTopExpandHideHeader(int x, int y) {
        return this._topRow != null && this._topRow._expandHideText != null && x >= 0 && x <= this._width && y >= 0 && this._textFontMetrics != null && y < this._textFontMetrics.textHeight();
    }

    int cursorRow() {
        return this._cursorRow;
    }

    int scroll() {
        return this._scroll;
    }

    void setScroll(int scroll) {
        this._scroll = scroll;
        if (this._scroll < 0) {
            this._scroll = 0;
        }
    }

    String palette() {
        return this._palette;
    }

    void setStyleAttributes(int id, StyleAttributes styleAttributes, boolean backgroundOnly) {
        if (id >= 0 && id <= 19) {
            this._styleAttributes[id] = styleAttributes;
            this._backgroundOnly[id] = backgroundOnly;
            if (id == 4) {
                this._view.styleAttributesList().set('!', styleAttributes);
            }
        }
    }

    StyleAttributes styleAttributes(int id) {
        if (id >= 0 && id <= 19) {
            if (this._styleAttributes[id] == null) {
                UpdateProfileCommand.PaletteAttributesParameter parm = UpdateProfileCommand.PaletteAttributesParameter.getParameter();
                String styleName = Screen.styleName(id);
                this._styleAttributes[id] = parm.currentValue(this._view, styleName, this._palette);
                this._backgroundOnly[id] = parm.currentValueBackgroundOnly(this._view, styleName, this._palette);
            }
            return this._styleAttributes[id];
        }
        return null;
    }

    boolean backgroundOnly(int id) {
        if (id >= 0 && id <= 19) {
            if (this._styleAttributes[id] == null) {
                this.styleAttributes(id);
            }
            return this._backgroundOnly[id];
        }
        return false;
    }

    void setMessageText(String messageText) {
        if (!this._view.tracing()) {
            this._messageText = messageText;
            this._messageKey = null;
            this._newMessage = true;
            if (this._view.currentLogMessages()) {
                LpexLog.logMessageText(this._view, this._messageText);
            }
        }
    }

    void setMessageKey(String messageKey) {
        if (!this._view.tracing()) {
            this._messageText = LpexResources.message(messageKey);
            this._messageKey = messageKey;
            this._newMessage = true;
            if (this._view.currentLogMessages()) {
                LpexLog.logMessageText(this._view, this._messageText);
            }
        }
    }

    void setMessageKey(String messageKey, String argument) {
        if (!this._view.tracing()) {
            this._messageText = LpexResources.message(messageKey, argument);
            this._messageKey = messageKey;
            this._newMessage = true;
            if (this._view.currentLogMessages()) {
                LpexLog.logMessageText(this._view, this._messageText);
            }
        }
    }

    void setMessageKey(String messageKey, String arg1, String arg2) {
        if (!this._view.tracing()) {
            this._messageText = LpexResources.message(messageKey, arg1, arg2);
            this._messageKey = messageKey;
            this._newMessage = true;
            if (this._view.currentLogMessages()) {
                LpexLog.logMessageText(this._view, this._messageText);
            }
        }
    }

    void setMessageTraceText(String messageText) {
        this._messageText = messageText;
        this._messageKey = null;
        this._newMessage = true;
        if (this._view.window() != null && this._lpexWindow != null) {
            MessageLine messageLine = (MessageLine)this._lpexWindow.messageLine();
            messageLine.setText(this._messageText);
            messageLine.updateMessage();
        }
    }

    void clearMessageKey(String messageKey) {
        if (messageKey != null && messageKey.equalsIgnoreCase(this._messageKey)) {
            this.setMessageText(null);
        }
    }

    String messageText() {
        return this._messageText;
    }

    boolean newMessage() {
        return this._newMessage;
    }

    void resetNewMessage() {
        this._newMessage = false;
    }

    void setPendingCommand(Element element, String pendingCommand) {
        this._pendingElement = element;
        this._pendingCommand = pendingCommand;
    }

    private String statusLineInfo(Element element) {
        if (element != null) {
            String info;
            String text = element.text();
            int position = this._view.documentPosition().position();
            if (position > 0 && position <= text.length() && (info = LpexNls.specialCharacterInfo(text.charAt(position - 1))) != null) {
                return info;
            }
        }
        return this._pendingCommand == null ? null : LpexResources.message("status.pending", this._pendingCommand);
    }

    Element pendingElement() {
        return this._pendingElement;
    }

    void setFormatLineText(String formatLineText) {
        this._formatLineText = formatLineText;
    }

    String formatLineText() {
        return this._formatLineText;
    }

    void setPrefixArea(int prefixArea) {
        this._prefixArea = prefixArea;
    }

    int prefixArea() {
        return this._prefixArea;
    }

    boolean currentPrefixArea() {
        return PrefixAreaParameter.getParameter().currentValue(this._view);
    }

    void setExpandHide(int expandHide) {
        this._expandHide = expandHide;
        this._view.setVisibleElementOrdinalsInvalid();
    }

    int expandHide() {
        return this._expandHide;
    }

    boolean currentExpandHide() {
        return ExpandHideParameter.getParameter().currentValue(this._view);
    }

    void setStatusLine(int statusLine) {
        this._statusLine = statusLine;
    }

    int statusLine() {
        return this._statusLine;
    }

    void setFormatLine(int formatLine) {
        this._formatLine = formatLine;
    }

    int formatLine() {
        return this._formatLine;
    }

    void setMessageLine(int messageLine) {
        this._messageLine = messageLine;
    }

    int messageLine() {
        return this._messageLine;
    }

    void setCommandLine(int commandLine) {
        this._commandLine = commandLine;
    }

    int commandLine() {
        return this._commandLine;
    }

    void setCommandLineOnTop(int commandLineOnTop) {
        this._commandLineOnTop = commandLineOnTop;
    }

    int commandLineOnTop() {
        return this._commandLineOnTop;
    }

    void setHighlightCurrentLine(int highlightCurrentLine) {
        this._highlightCurrentLine = highlightCurrentLine;
    }

    int highlightCurrentLine() {
        return this._highlightCurrentLine;
    }

    void updateHighlightCurrentLine() {
        if (HighlightCurrentLineParameter.getParameter().currentValue(this._view)) {
            MarkList.Mark mark;
            Element e = this._view.documentPosition().element();
            if (e != null && (mark = this._view.markList().set("@CORE-CURRENTLINE", e, e, false)) != null) {
                mark.setStyleCharacter('\u0005');
                mark.setHighlight(true);
            }
        } else {
            MarkList.Mark mark = this._view.markList().find("@CORE-CURRENTLINE");
            if (mark != null) {
                mark.clear();
            }
        }
    }

    void setKeepVisibleParm(int keepVisible) {
        this._keepVisible = keepVisible;
    }

    int keepVisibleParm() {
        return this._keepVisible;
    }

    void setKeepCursorVisible(boolean keepCursorVisible) {
        if (this._keepCursorVisible != keepCursorVisible) {
            this._keepCursorVisible = keepCursorVisible;
            if (this._keepCursorVisible) {
                this.setCursorRow(this._cursorRow);
            }
        }
    }

    private boolean keepingCursorVisible() {
        return this._keepCursorVisible;
    }

    void updateProfile() {
        this._palette = UpdateProfileCommand.PaletteParameter.getParameter().currentValue(this._view);
        UpdateProfileCommand.PaletteAttributesParameter parm = UpdateProfileCommand.PaletteAttributesParameter.getParameter();
        int id = 0;
        while (id <= 19) {
            String styleName = Screen.styleName(id);
            this.setStyleAttributes(id, parm.currentValue(this._view, styleName, this._palette), parm.currentValueBackgroundOnly(this._view, styleName, this._palette));
            ++id;
        }
    }

    protected void buildTextWindow() {
        Element currentElement;
        if (this.rows() <= 0) {
            return;
        }
        if (!this._processingPendingJump) {
            this._processingPendingJump = true;
            this._view.documentPosition().processPendingJump();
            this._processingPendingJump = false;
        }
        this.clearRows();
        int extraRow = this.partialRow() ? 1 : 0;
        int i = 0;
        while (i < this.rows() + extraRow) {
            Row rowNode;
            if (this._cachedRows != null) {
                rowNode = this._cachedRows;
                this._cachedRows = rowNode._next;
            } else {
                rowNode = new Row();
            }
            rowNode._next = this._topRow;
            this._topRow = rowNode;
            ++i;
        }
        this.setCursorRow(this._cursorRow);
        if (!this._processingPendingJump) {
            this._view.block().validate();
            this._view.markList().validate();
        }
        if ((currentElement = this._view.documentPosition().element()) != null) {
            this.setupViewport(currentElement);
            if (!this._processingPendingJump) {
                int position;
                if (this.prefixAreaWidth() == 0) {
                    this._view.setInPrefix(false);
                }
                if ((position = this._view.documentPosition().position()) > 0) {
                    this._cursorPosition = DisplayTextLayout.cursorPixelDrawPosition(this._view);
                    this._cursorWidth = this._view.cursorPixelWidth(currentElement, position);
                    if (this.keepingCursorVisible()) {
                        int currentCharWidth;
                        int textAreaWidth = this.textAreaWidth();
                        if (this._cursorPosition > this._scroll + textAreaWidth - (currentCharWidth = this._view.charWidth(currentElement, position))) {
                            this._scroll = this._cursorPosition - textAreaWidth + currentCharWidth;
                        }
                        if (this._cursorPosition < this._scroll) {
                            this._scroll = this._cursorPosition;
                        }
                    }
                } else {
                    this._cursorWidth = 2;
                }
                ElementView elementView = currentElement.elementView(this._view);
                int emphasisLength = this._view.documentPosition().emphasisLength();
                if (emphasisLength == 0) {
                    this._emphasisSegments = null;
                } else if (LpexUtilities.isBidi()) {
                    this._emphasisSegments = DisplayTextLayout.emphasisSegments(elementView);
                } else {
                    int end;
                    int start;
                    int emphasisPosition = this._view.documentPosition().emphasisPosition();
                    if (emphasisPosition == 0) {
                        start = this._cursorPosition;
                        end = elementView.pixelPosition(position + emphasisLength);
                    } else {
                        start = elementView.pixelPosition(emphasisPosition);
                        end = elementView.pixelPosition(emphasisPosition + emphasisLength);
                    }
                    this._emphasisSegments = new int[]{start, end};
                }
                position = this._view.documentPosition().prefixPosition();
                int currentCharWidth = this._view.prefixCharWidth(elementView, position);
                this._prefixCursorPosition = this._view.prefixPixelPosition(elementView, position);
                if (currentCharWidth == 0) {
                    currentCharWidth = this._view.cursorWidth() == 1 ? 1 : 2;
                }
                this._prefixScroll = elementView.prefixScroll();
                int prefixAreaTextWidth = this.prefixAreaTextWidth();
                if (this._prefixCursorPosition > this._prefixScroll + prefixAreaTextWidth - currentCharWidth) {
                    this._prefixScroll = this._prefixCursorPosition - prefixAreaTextWidth + currentCharWidth;
                }
                if (this._prefixCursorPosition < this._prefixScroll) {
                    this._prefixScroll = this._prefixCursorPosition;
                }
                elementView.setPrefixScroll(this._prefixScroll);
                int n = this._prefixCursorWidth = this._view.insertMode() ? this._view.cursorWidth() : currentCharWidth;
            }
        }
        if (this._topRow._element == null && this.currentExpandHide()) {
            this._topRow._expandHideText = this._view.topExpandHideText();
        }
    }

    private void setupViewport(Element currentElement) {
        int extraRow;
        int n = extraRow = this.partialRow() ? 1 : 0;
        if (this.keepingCursorVisible()) {
            Row rowNode;
            int elementsAboveCurrent = this._view.visibleElementOrdinalOf(currentElement) - 1;
            int elementsBelowCurrent = this._view.visibleElementCount() - elementsAboveCurrent - 1;
            if (elementsBelowCurrent < this.rows() - this._cursorRow) {
                this._cursorRow = this.rows() - elementsBelowCurrent;
            }
            if (elementsAboveCurrent < this._cursorRow - 1) {
                this._cursorRow = elementsAboveCurrent + 1;
            }
            if (this._cursorRow < 1) {
                this._cursorRow = 1;
            }
            if (this._cursorRow > this.rows()) {
                this._cursorRow = this.rows();
            }
            int i = this._cursorRow;
            Element e = currentElement;
            while (i > 0 && e != null) {
                rowNode = this.rowNode(i);
                if (rowNode != null) {
                    rowNode._element = e;
                }
                --i;
                e = e.prevVisible(this._view);
            }
            i = this._cursorRow + 1;
            e = currentElement.nextVisible(this._view);
            while (i <= this.rows() + extraRow && e != null) {
                rowNode = this.rowNode(i);
                if (rowNode != null) {
                    rowNode._element = e;
                }
                ++i;
                e = e.nextVisible(this._view);
            }
        } else {
            Element e;
            int highestTopElementForFullScreen;
            int nCurrentElement = this._view.visibleElementOrdinalOf(currentElement);
            int nTopRowElement = nCurrentElement + 1 - this._cursorRow;
            if (nTopRowElement > (highestTopElementForFullScreen = this._view.visibleElementCount() + 1 - this.rows())) {
                nTopRowElement = highestTopElementForFullScreen;
            }
            if (nTopRowElement < 1) {
                nTopRowElement = 1;
            }
            if (!this._processingPendingJump) {
                this._cursorRow = nCurrentElement + 1 - nTopRowElement;
            }
            this.rowNode((int)1)._element = e = this._view.visibleElementAt(nTopRowElement);
            e = e != null ? e.nextVisible(this._view) : this._view.visibleElementAt(nTopRowElement + 1);
            int i = 2;
            while (i <= this.rows() + extraRow && e != null) {
                this.rowNode((int)i)._element = e;
                ++i;
                e = e.nextVisible(this._view);
            }
        }
    }

    void build() {
        if (this._lpexWindow != null) {
            this.validateFontMetrics();
            this.buildTextWindow();
            this.horizontalScrollBar().build();
            this.verticalScrollBar().build();
        }
    }

    void show() {
        this._needsScreenShow = false;
        this._show.show();
    }

    protected void uiThreadShow() {
        if (this._view.vi()) {
            this._view.viHandler().verifyMode();
        }
        if (BeepParameter.getParameter().value()) {
            BeepParameter.getParameter().setValue(false);
            LpexUtilities.beep();
        }
        if (HighlightCurrentLineParameter.getParameter().currentValue(this._view)) {
            this.updateHighlightCurrentLine();
        }
        this._view.markList().triggerListeners();
        this._view.listenerList().readonly();
        this._view.triggerCursorListeners();
        this._view.listenerList().showing();
        if (this._view.window() != null && this._lpexWindow != null) {
            Display current;
            boolean currentCommandLineOnTop;
            CommandLine commandLine;
            boolean currentMessageLine;
            boolean currentFormatLine;
            boolean currentStatusLine;
            int column;
            int row;
            this.build();
            boolean layoutRequired = false;
            StyleAttributes backgroundStyle = this.styleAttributes(1);
            Font font = this.currentFont();
            Element currentElement = this._view.documentPosition().element();
            ElementList elementList = this._view.document().elementList();
            if (currentElement == null) {
                row = 0;
                column = -1;
            } else {
                ElementView elementView = currentElement.elementView(this._view);
                row = elementList.nonShowOrdinalOf(currentElement) + this._view.document().linesBeforeStart();
                column = this._view.currentColumn(elementView);
            }
            StatusLineManager statusLineManager = this._lpexWindow.statusLineManager();
            StatusLine statusLine = (StatusLine)this._lpexWindow.statusLine();
            statusLineManager.setLine(row);
            if (!this._ownerColumnInfo) {
                statusLineManager.setColumn(this._lpexWindow.getLpexView(), column);
                int inputMode = 1;
                if (this._view.vi()) {
                    int mode = this._view.viHandler().mode();
                    if (mode == 7) {
                        inputMode = 2;
                    } else if (mode != 1) {
                        inputMode = 3;
                    }
                } else if (!this._view.insertMode()) {
                    inputMode = 2;
                }
                statusLineManager.setInputMode(inputMode);
                statusLineManager.setInfo(this.statusLineInfo(currentElement));
            }
            statusLineManager.setChanges(this._view.document().undo().changes());
            statusLineManager.setBrowseMode(this._view.readonly());
            if (statusLine.setFont(font, this.styleAttributes(17))) {
                layoutRequired = true;
            }
            if ((currentStatusLine = StatusLineParameter.getParameter().currentValue(this._view)) != statusLine.isVisible()) {
                statusLine.setVisible(currentStatusLine);
                layoutRequired = true;
            }
            Separator separator0 = (Separator)this._lpexWindow.separator0();
            separator0.setColor(backgroundStyle.backgroundColor());
            FormatLine formatLine = (FormatLine)this._lpexWindow.formatLine();
            if (!this._ownerColumnInfo) {
                formatLine.setColumn(column);
            }
            if (formatLine.setFont(font, this.styleAttributes(8))) {
                layoutRequired = true;
            }
            if ((currentFormatLine = FormatLineParameter.getParameter().currentValue(this._view)) != formatLine.isVisible()) {
                formatLine.setVisible(currentFormatLine);
                layoutRequired = true;
            }
            formatLine.showing(this._view);
            Separator separator1 = (Separator)this._lpexWindow.separator1();
            separator1.setColor(backgroundStyle.backgroundColor());
            Separator separator2 = (Separator)this._lpexWindow.separator2();
            separator2.setColor(backgroundStyle.backgroundColor());
            MessageLine messageLine = (MessageLine)this._lpexWindow.messageLine();
            messageLine.setText(this._messageText);
            if (messageLine.setFont(font, this.styleAttributes(9))) {
                layoutRequired = true;
            }
            if ((currentMessageLine = MessageLineParameter.getParameter().currentValue(this._view)) != messageLine.isVisible()) {
                messageLine.setVisible(currentMessageLine);
                layoutRequired = true;
            }
            if ((commandLine = (CommandLine)this._lpexWindow.commandLine()).forceVisible()) {
                if (!commandLine.isVisible()) {
                    commandLine.setVisible(true);
                    layoutRequired = true;
                }
            } else {
                boolean currentCommandLine = CommandLineParameter.getParameter().currentValue(this._view);
                if (currentCommandLine != commandLine.isVisible()) {
                    commandLine.setVisible(currentCommandLine);
                    layoutRequired = true;
                }
            }
            if ((currentCommandLineOnTop = CommandLineOnTopParameter.getParameter().currentValue(this._view)) != this._lpexWindow.isCommandLineOnTop()) {
                this._lpexWindow.setCommandLineOnTop(currentCommandLineOnTop);
                layoutRequired = true;
            }
            TextWindow textWindow = this.textWindow();
            textWindow.setShow();
            statusLine.updateStatus();
            separator0.updateSeparator();
            formatLine.updateFormat();
            separator1.updateSeparator();
            textWindow.updateText(true);
            textWindow.updateBottom();
            messageLine.updateMessage();
            separator2.updateSeparator();
            if (this.verticalScrollBar().update()) {
                layoutRequired = true;
            }
            if (this.horizontalScrollBar().update()) {
                layoutRequired = true;
            }
            if (layoutRequired) {
                this._lpexWindow.updateLayout();
            }
            if ((current = Display.getCurrent()) != null && !current.isDisposed()) {
                current.update();
            }
        }
        this._view.listenerList().shown();
    }

    static final class Row {
        Element _element;
        String _expandHideText;
        Row _next;

        Row() {
        }

        void reset() {
            this._element = null;
            this._expandHideText = null;
        }
    }

    private final class ScreenShow
    implements Runnable {
        int nesting;

        private ScreenShow() {
        }

        @Override
        public void run() {
            Screen.this.uiThreadShow();
        }

        public void show() {
            if (this.nesting < 10) {
                ++this.nesting;
                try {
                    if (Display.getCurrent() != null && !Display.getCurrent().isDisposed()) {
                        this.run();
                    } else if (Display.getDefault() != null && !Display.getDefault().isDisposed()) {
                        Display.getDefault().syncExec((Runnable)this);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                --this.nesting;
            }
        }
    }
}

