/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.Color;
import com.ibm.lpex.core.DisplayStyle;
import com.ibm.lpex.core.Element;
import com.ibm.lpex.core.Font;
import com.ibm.lpex.core.LpexUtilities;
import com.ibm.lpex.core.StyleAttributes;
import com.ibm.lpex.core.StyleAttributesList;
import com.ibm.lpex.core.View;
import java.awt.Toolkit;
import java.util.Vector;

final class RtfWriter {
    private View _view;
    private StringBuilder _buffer;
    private boolean _isClosed;
    private Vector<Color> _colorTable;
    private StyleAttributes _defaultStyle;
    private boolean _defaultWhiteBackground;
    private static final int DEFAULT_FOREGROUND = 0;
    private static final int DEFAULT_BACKGROUND = 1;
    private String _eol;
    private boolean _writeUnicode;

    RtfWriter(View view, int len) {
        this._view = view;
        this._buffer = new StringBuilder(len + len / 3);
        this._colorTable = new Vector();
        this._defaultStyle = this._view.screen().styleAttributes(4);
        this._defaultWhiteBackground = this._defaultStyle.backgroundColor().isWhite();
        this._colorTable.addElement(this._defaultStyle.foregroundColor());
        this._colorTable.addElement(this._defaultStyle.backgroundColor());
        this._eol = System.getProperty("line.separator");
        this.setWriteUnicode();
    }

    private void setWriteUnicode() {
        this._writeUnicode = true;
    }

    void writeLine(Element element, int startPosition, int endPosition) {
        if (this._isClosed || element == null) {
            return;
        }
        int startPosition2 = startPosition;
        if (startPosition2 < 1) {
            startPosition2 = 1;
        }
        DisplayStyle displayStyle = new DisplayStyle(element.elementView(this._view));
        this.doWriteLine(element.text(), displayStyle.foreground(), displayStyle.background(), startPosition2, endPosition);
    }

    void writeLine(String text, String foregroundStyle, String backgroundStyle) {
        if (this._isClosed) {
            return;
        }
        String foregroundStyle2 = foregroundStyle;
        if (foregroundStyle2 == null) {
            foregroundStyle2 = "";
        }
        this.doWriteLine(text, foregroundStyle2, backgroundStyle, 1, text.length());
    }

    private void doWriteLine(String text, String foregroundStyle, String backgroundStyle, int startPosition, int endPosition) {
        int textLength = text.length();
        int styleLength = foregroundStyle.length();
        StyleAttributesList styleAttributesList = this._view.styleAttributesList();
        int i = startPosition - 1;
        while (i < endPosition) {
            String subText;
            StyleAttributes styleAttributes = null;
            if (styleLength > i) {
                styleAttributes = backgroundStyle != null ? styleAttributesList.find(foregroundStyle.charAt(i), backgroundStyle.charAt(i)) : styleAttributesList.find(foregroundStyle.charAt(i));
            }
            if (styleAttributes == null) {
                styleAttributes = this._defaultStyle;
            }
            int subTextLength = 1;
            while (i + subTextLength < endPosition) {
                StyleAttributes styleAttributesNext = null;
                if (styleLength > i + subTextLength) {
                    styleAttributesNext = backgroundStyle != null ? styleAttributesList.find(foregroundStyle.charAt(i + subTextLength), backgroundStyle.charAt(i + subTextLength)) : styleAttributesList.find(foregroundStyle.charAt(i + subTextLength));
                }
                if (styleAttributesNext == null) {
                    styleAttributesNext = this._defaultStyle;
                }
                if (!styleAttributes.equals(styleAttributesNext)) break;
                ++subTextLength;
            }
            if (i + subTextLength <= textLength) {
                subText = text.substring(i, i + subTextLength);
            } else {
                subText = i < textLength ? text.substring(i) : "";
                StringBuilder buffer = new StringBuilder(subText);
                int j = subTextLength - subText.length();
                while (j > 0) {
                    buffer.append(' ');
                    --j;
                }
                subText = buffer.toString();
            }
            this.write("{\\cf");
            this.write(this.getColorIndex(styleAttributes.foregroundColor(), 0));
            int colorIndex = this.getColorIndex(styleAttributes.backgroundColor(), 1);
            if (!this._defaultWhiteBackground || colorIndex != 1) {
                this.write("\\highlight");
                this.write(colorIndex);
            }
            if (styleAttributes.underline()) {
                this.write("\\ul");
            }
            if (styleAttributes.strikeout()) {
                this.write("\\strike");
            }
            if (styleAttributes.bold()) {
                this.write("\\b");
            }
            if (styleAttributes.italic()) {
                this.write("\\i");
            }
            this.write(" ");
            this.writeText(subText);
            if (styleAttributes.italic()) {
                this.write("\\i0");
            }
            if (styleAttributes.bold()) {
                this.write("\\b0");
            }
            if (styleAttributes.strikeout()) {
                this.write("\\strike0");
            }
            if (styleAttributes.underline()) {
                this.write("\\ul0");
            }
            this.write("}");
            i += subTextLength;
        }
    }

    void newLine() {
        if (!this._isClosed) {
            this.writeText(this._eol);
            this.write("\\par ");
        }
    }

    void close() {
        if (!this._isClosed) {
            this.writeHeader();
            this.write("\n}}\u0000");
            this._isClosed = true;
        }
    }

    private int getColorIndex(Color color, int defaultIndex) {
        if (color == null) {
            return defaultIndex;
        }
        int index = this._colorTable.indexOf(color);
        if (index == -1) {
            index = this._colorTable.size();
            this._colorTable.addElement(color);
        }
        return index;
    }

    private void writeText(String string) {
        int len = string.length();
        int i = 0;
        while (i < len) {
            char c = string.charAt(i);
            if (c > '\u00ff' && this._writeUnicode) {
                this.write("\\u");
                this.write(Integer.toString((short)c));
                this.write(' ');
            } else if (c == '}' || c == '{' || c == '\\') {
                this.write("\\");
                this.write(c);
            } else {
                this.write(c);
            }
            ++i;
        }
    }

    private void write(String string) {
        this._buffer.append(string);
    }

    private void write(int i) {
        this._buffer.append(i);
    }

    private void write(char c) {
        this._buffer.append(c);
    }

    private void write(String string, int offset) {
        this._buffer.insert(offset, string);
    }

    private void writeHeader() {
        int points;
        StringBuilder header = new StringBuilder(192);
        header.append("{\\rtf1\\ansi");
        String cpg = System.getProperty("file.encoding").toLowerCase();
        if (cpg.startsWith("cp") || cpg.startsWith("ms")) {
            header.append("\\ansicpg").append(cpg.substring(2));
        }
        header.append("\\uc0\\deff0{\\fonttbl{\\f0\\fnil ");
        Font font = this._view.screen().currentFont();
        header.append(font.getName());
        header.append(";}}\n{\\colortbl");
        int i = 0;
        while (i < this._colorTable.size()) {
            Color color = this._colorTable.elementAt(i);
            header.append("\\red").append(color.getRed()).append("\\green").append(color.getGreen()).append("\\blue").append(color.getBlue()).append(";");
            ++i;
        }
        header.append("}\n{\\f0\\fs");
        int fontSize = font.getSize();
        if (LpexUtilities.getPlatform() == 1) {
            points = fontSize;
        } else {
            int res = Toolkit.getDefaultToolkit().getScreenResolution();
            points = Math.round((float)(fontSize * 72) / (float)res);
        }
        header.append(points * 2).append(" ");
        this.write(header.toString(), 0);
    }

    public String toString() {
        return this._buffer.toString();
    }
}

