/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.CommandHandler;
import com.ibm.lpex.core.Font;
import com.ibm.lpex.core.Install;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexPrinter;
import com.ibm.lpex.core.LpexResources;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.Parameter;
import com.ibm.lpex.core.ParameterFontDefault;
import com.ibm.lpex.core.ParameterIntegerDefault;
import com.ibm.lpex.core.ParameterOnOffDefault;
import com.ibm.lpex.core.ParameterStringDefault;
import com.ibm.lpex.core.Parameters;
import com.ibm.lpex.core.Profile;
import com.ibm.lpex.core.TableNode;
import com.ibm.lpex.core.View;

final class PrintCommand {
    static final int INVALID = 0;
    static final int BOTTOM_MARGIN = 1;
    static final int FONT = 2;
    static final int FOOTER = 3;
    static final int HEADER = 4;
    static final int LEFT_MARGIN = 5;
    static final int LINE_NUMBERS = 6;
    static final int RIGHT_MARGIN = 7;
    static final int SEQUENCE_NUMBERS = 8;
    static final int TOKENIZED = 9;
    static final int TOP_MARGIN = 10;
    private static TableNode[] _parameters = new TableNode[]{new TableNode("bottomMargin", 1), new TableNode("font", 2), new TableNode("footer", 3), new TableNode("header", 4), new TableNode("leftMargin", 5), new TableNode("lineNumbers", 6), new TableNode("rightMargin", 7), new TableNode("sequenceNumbers", 8), new TableNode("tokenized", 9), new TableNode("topMargin", 10)};

    static {
        TableNode.sort(_parameters);
    }

    PrintCommand() {
    }

    static Parameter getParameter(String parameter) {
        TableNode p = TableNode.binarySearch(_parameters, Parameters.getParameterString(parameter));
        if (p != null) {
            switch (p.id()) {
                case 1: {
                    return BottomMarginParameter.getParameter();
                }
                case 2: {
                    return FontParameter.getParameter();
                }
                case 3: {
                    return FooterParameter.getParameter();
                }
                case 4: {
                    return HeaderParameter.getParameter();
                }
                case 5: {
                    return LeftMarginParameter.getParameter();
                }
                case 6: {
                    return LineNumbersParameter.getParameter();
                }
                case 7: {
                    return RightMarginParameter.getParameter();
                }
                case 8: {
                    return SequenceNumbersParameter.getParameter();
                }
                case 9: {
                    return TokenizedParameter.getParameter();
                }
                case 10: {
                    return TopMarginParameter.getParameter();
                }
            }
        }
        return null;
    }

    static boolean doCommand(View view, String parameters) {
        return view == null ? true : new LpexPrinter(view).print(parameters);
    }

    static final class BottomMarginParameter
    extends ParameterIntegerDefault {
        private static BottomMarginParameter _parameter;

        static BottomMarginParameter getParameter() {
            if (_parameter == null) {
                _parameter = new BottomMarginParameter();
            }
            return _parameter;
        }

        private BottomMarginParameter() {
            super("print.bottomMargin", 50);
        }

        @Override
        String name(String qualifier) {
            return this.name();
        }

        @Override
        boolean setValue(View view, int value, boolean useDefaultValue) {
            if (view != null) {
                Settings settings = view.printCommandSettings();
                settings._bottomMargin = value;
                settings._useDefaultBottomMargin = useDefaultValue;
            }
            return true;
        }

        @Override
        boolean useDefaultValue(View view) {
            return view != null ? view.printCommandSettings()._useDefaultBottomMargin : true;
        }

        @Override
        int value(View view) {
            return view != null ? view.printCommandSettings()._bottomMargin : 0;
        }
    }

    static final class FontParameter
    extends ParameterFontDefault {
        private static FontParameter _parameter;
        private boolean _useScreenFontAsDefault;

        static FontParameter getParameter() {
            if (_parameter == null) {
                _parameter = new FontParameter();
            }
            return _parameter;
        }

        private FontParameter() {
            super("print.font", null);
        }

        @Override
        protected Font installValue() {
            if (!this._installValueLoaded) {
                String value = Install.getString("install." + this.name());
                if ("screen".equalsIgnoreCase(value)) {
                    this._installValue = null;
                    this._installValueLoaded = true;
                } else {
                    super.installValue();
                }
            }
            return this._installValue;
        }

        @Override
        protected void loadDefaultValue() {
            if (!this._defaultValueLoaded) {
                String value = Profile.getString("default." + this.name());
                if ("screen".equalsIgnoreCase(value)) {
                    this._defaultValue = null;
                    this._useScreenFontAsDefault = true;
                    this._defaultValueLoaded = true;
                } else {
                    super.loadDefaultValue();
                    this._useScreenFontAsDefault = false;
                }
            }
        }

        boolean useScreenFontAsDefault() {
            this.loadDefaultValue();
            return this._useScreenFontAsDefault;
        }

        @Override
        Font currentValue(View view) {
            Font value = null;
            if (view != null && this.useScreenFont(view)) {
                value = view.screen().currentFont();
            } else {
                value = this.value(view);
                if (value == null) {
                    if (view != null && this.useScreenFontAsDefault()) {
                        value = view.screen().currentFont();
                    } else {
                        value = this.defaultValue();
                        if (value == null && (value = this.installValue()) == null && view != null) {
                            value = view.screen().currentFont();
                        }
                    }
                }
            }
            return value;
        }

        @Override
        boolean set(View view, String qualifier, String parameters) {
            String token;
            boolean useScreenFont = false;
            Font value = null;
            LpexStringTokenizer st = new LpexStringTokenizer(parameters);
            if (st.hasMoreTokens() && (token = st.nextToken()).equalsIgnoreCase("screen")) {
                useScreenFont = true;
                if (st.hasMoreTokens()) {
                    return CommandHandler.invalidParameter(view, st.nextToken(), "set " + this.name());
                }
            }
            if (!useScreenFont) {
                if (!super.set(view, qualifier = Parameters.getQualifierString(qualifier), parameters)) {
                    return false;
                }
                value = this.value(view);
            }
            return this.setValue(view, value, useScreenFont);
        }

        @Override
        boolean setValue(View view, Font value) {
            if (view != null) {
                view.printCommandSettings()._font = value;
            }
            return true;
        }

        boolean setValue(View view, Font value, boolean useScreenFont) {
            if (view != null) {
                view.printCommandSettings()._useScreenFont = useScreenFont;
                return this.setValue(view, value);
            }
            return true;
        }

        @Override
        boolean setDefault(View view, String qualifier, String parameters) {
            String token;
            boolean useScreenFont = false;
            LpexStringTokenizer st = new LpexStringTokenizer(parameters);
            if (st.hasMoreTokens() && (token = st.nextToken()).equalsIgnoreCase("screen")) {
                useScreenFont = true;
                if (st.hasMoreTokens()) {
                    return CommandHandler.invalidParameter(view, st.nextToken(), "set default." + this.name());
                }
            }
            if (!useScreenFont) {
                if (!super.setDefault(view, qualifier = Parameters.getQualifierString(qualifier), parameters)) {
                    return false;
                }
                this._useScreenFontAsDefault = false;
            } else {
                this._defaultValue = null;
                this._useScreenFontAsDefault = true;
                this._defaultValueLoaded = true;
                Profile.putString("default." + this.name(), "screen");
            }
            return true;
        }

        @Override
        String query(View view, LpexDocumentLocation documentLocation, String qualifier) {
            if (view != null) {
                if (this.useScreenFont(view)) {
                    return "screen";
                }
                qualifier = Parameters.getQualifierString(qualifier);
                return super.query(view, documentLocation, qualifier);
            }
            return null;
        }

        boolean useScreenFont(View view) {
            return view != null ? view.printCommandSettings()._useScreenFont : false;
        }

        @Override
        Font value(View view) {
            return view != null ? view.printCommandSettings()._font : null;
        }

        @Override
        String queryInstall(String qualifier) {
            Font value = this.installValue();
            if (value == null) {
                return "screen";
            }
            qualifier = Parameters.getQualifierString(qualifier);
            return super.queryInstall(qualifier);
        }

        @Override
        String queryDefault(String qualifier) {
            if (this.useScreenFontAsDefault()) {
                return "screen";
            }
            qualifier = Parameters.getQualifierString(qualifier);
            return super.queryDefault(qualifier);
        }

        @Override
        String queryCurrent(View view, String qualifier) {
            qualifier = Parameters.getQualifierString(qualifier);
            return super.queryCurrent(view, qualifier);
        }
    }

    static final class FooterParameter
    extends ParameterStringDefault {
        private static FooterParameter _parameter;

        static FooterParameter getParameter() {
            if (_parameter == null) {
                _parameter = new FooterParameter();
            }
            return _parameter;
        }

        private FooterParameter() {
            super("print.footer", null);
        }

        @Override
        String name(String qualifier) {
            return this.name();
        }

        @Override
        boolean setValue(View view, String value) {
            if (view != null) {
                view.printCommandSettings()._footer = value;
            }
            return true;
        }

        @Override
        String value(View view) {
            return view != null ? view.printCommandSettings()._footer : null;
        }

        @Override
        String currentValue(View view) {
            String current = super.currentValue(view);
            return "none".equalsIgnoreCase(current) ? null : current;
        }
    }

    static final class HeaderParameter
    extends ParameterStringDefault {
        private static HeaderParameter _parameter;

        static HeaderParameter getParameter() {
            if (_parameter == null) {
                _parameter = new HeaderParameter();
            }
            return _parameter;
        }

        private HeaderParameter() {
            super("print.header", LpexResources.message("install.print.header"));
        }

        @Override
        String name(String qualifier) {
            return this.name();
        }

        @Override
        boolean setValue(View view, String value) {
            if (view != null) {
                view.printCommandSettings()._header = value;
            }
            return true;
        }

        @Override
        String value(View view) {
            return view != null ? view.printCommandSettings()._header : null;
        }

        @Override
        String currentValue(View view) {
            String current = super.currentValue(view);
            return "none".equalsIgnoreCase(current) ? null : current;
        }
    }

    static final class LeftMarginParameter
    extends ParameterIntegerDefault {
        private static LeftMarginParameter _parameter;

        static LeftMarginParameter getParameter() {
            if (_parameter == null) {
                _parameter = new LeftMarginParameter();
            }
            return _parameter;
        }

        private LeftMarginParameter() {
            super("print.leftMargin", 50);
        }

        @Override
        String name(String qualifier) {
            return this.name();
        }

        @Override
        boolean setValue(View view, int value, boolean useDefaultValue) {
            if (view != null) {
                Settings settings = view.printCommandSettings();
                settings._leftMargin = value;
                settings._useDefaultLeftMargin = useDefaultValue;
            }
            return true;
        }

        @Override
        boolean useDefaultValue(View view) {
            return view != null ? view.printCommandSettings()._useDefaultLeftMargin : true;
        }

        @Override
        int value(View view) {
            return view != null ? view.printCommandSettings()._leftMargin : 0;
        }
    }

    static final class LineNumbersParameter
    extends ParameterOnOffDefault {
        private static LineNumbersParameter _parameter;

        static LineNumbersParameter getParameter() {
            if (_parameter == null) {
                _parameter = new LineNumbersParameter();
            }
            return _parameter;
        }

        private LineNumbersParameter() {
            super("print.lineNumbers", false);
        }

        @Override
        String name(String qualifier) {
            return this.name();
        }

        @Override
        boolean setValue(View view, int value) {
            if (view != null) {
                view.printCommandSettings()._lineNumbers = value;
            }
            return true;
        }

        @Override
        int value(View view) {
            return view != null ? view.printCommandSettings()._lineNumbers : 2;
        }
    }

    static final class RightMarginParameter
    extends ParameterIntegerDefault {
        private static RightMarginParameter _parameter;

        static RightMarginParameter getParameter() {
            if (_parameter == null) {
                _parameter = new RightMarginParameter();
            }
            return _parameter;
        }

        private RightMarginParameter() {
            super("print.rightMargin", 50);
        }

        @Override
        String name(String qualifier) {
            return this.name();
        }

        @Override
        boolean setValue(View view, int value, boolean useDefaultValue) {
            if (view != null) {
                Settings settings = view.printCommandSettings();
                settings._rightMargin = value;
                settings._useDefaultRightMargin = useDefaultValue;
            }
            return true;
        }

        @Override
        boolean useDefaultValue(View view) {
            return view != null ? view.printCommandSettings()._useDefaultRightMargin : true;
        }

        @Override
        int value(View view) {
            return view != null ? view.printCommandSettings()._rightMargin : 0;
        }
    }

    static final class SequenceNumbersParameter
    extends ParameterOnOffDefault {
        private static SequenceNumbersParameter _parameter;

        static SequenceNumbersParameter getParameter() {
            if (_parameter == null) {
                _parameter = new SequenceNumbersParameter();
            }
            return _parameter;
        }

        private SequenceNumbersParameter() {
            super("print.sequenceNumbers", false);
        }

        @Override
        String name(String qualifier) {
            return this.name();
        }

        @Override
        boolean setValue(View view, int value) {
            if (view != null) {
                view.printCommandSettings()._sequenceNumbers = value;
            }
            return true;
        }

        @Override
        int value(View view) {
            return view != null ? view.printCommandSettings()._sequenceNumbers : 2;
        }
    }

    static final class Settings {
        int _bottomMargin;
        boolean _useDefaultBottomMargin = true;
        Font _font;
        boolean _useScreenFont;
        int _leftMargin;
        boolean _useDefaultLeftMargin = true;
        int _lineNumbers = 2;
        int _rightMargin;
        boolean _useDefaultRightMargin = true;
        int _sequenceNumbers = 2;
        int _tokenized = 2;
        int _topMargin;
        boolean _useDefaultTopMargin = true;
        String _header;
        String _footer;

        Settings() {
        }
    }

    static final class TokenizedParameter
    extends ParameterOnOffDefault {
        private static TokenizedParameter _parameter;

        static TokenizedParameter getParameter() {
            if (_parameter == null) {
                _parameter = new TokenizedParameter();
            }
            return _parameter;
        }

        private TokenizedParameter() {
            super("print.tokenized", false);
        }

        @Override
        String name(String qualifier) {
            return this.name();
        }

        @Override
        boolean setValue(View view, int value) {
            if (view != null) {
                view.printCommandSettings()._tokenized = value;
            }
            return true;
        }

        @Override
        int value(View view) {
            return view != null ? view.printCommandSettings()._tokenized : 2;
        }
    }

    static final class TopMarginParameter
    extends ParameterIntegerDefault {
        private static TopMarginParameter _parameter;

        static TopMarginParameter getParameter() {
            if (_parameter == null) {
                _parameter = new TopMarginParameter();
            }
            return _parameter;
        }

        private TopMarginParameter() {
            super("print.topMargin", 50);
        }

        @Override
        String name(String qualifier) {
            return this.name();
        }

        @Override
        boolean setValue(View view, int value, boolean useDefaultValue) {
            if (view != null) {
                Settings settings = view.printCommandSettings();
                settings._topMargin = value;
                settings._useDefaultTopMargin = useDefaultValue;
            }
            return true;
        }

        @Override
        boolean useDefaultValue(View view) {
            return view != null ? view.printCommandSettings()._useDefaultTopMargin : true;
        }

        @Override
        int value(View view) {
            return view != null ? view.printCommandSettings()._topMargin : 0;
        }
    }
}

