/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.CommandHandler;
import com.ibm.lpex.core.Install;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.ParameterDefault;
import com.ibm.lpex.core.Profile;
import com.ibm.lpex.core.View;

final class PrefixAreaTextParameter
extends ParameterDefault {
    private static PrefixAreaTextParameter _parameter;
    private boolean _installValueLoaded;
    private int _installValue;
    private boolean _defaultValueLoaded;
    private int _defaultValue;

    static PrefixAreaTextParameter getParameter() {
        if (_parameter == null) {
            _parameter = new PrefixAreaTextParameter();
        }
        return _parameter;
    }

    private PrefixAreaTextParameter() {
        super("prefixAreaText");
        Install.addProfileChangedListener(new Install.ProfileChangedListener(){

            @Override
            public void profileChanged() {
                PrefixAreaTextParameter.this._installValueLoaded = false;
            }
        });
        Profile.addProfileChangedListener(new Profile.ProfileChangedListener(){

            @Override
            public void profileChanged() {
                PrefixAreaTextParameter.this._defaultValueLoaded = false;
            }
        });
    }

    private int installValue() {
        if (!this._installValueLoaded) {
            this._installValue = 2;
            String value = Install.getString("install." + this.name());
            if (value != null) {
                if (value.equalsIgnoreCase("lineNumbers")) {
                    this._installValue = 1;
                } else if (value.equalsIgnoreCase("none")) {
                    this._installValue = 3;
                }
            }
            this._installValueLoaded = true;
        }
        return this._installValue;
    }

    private int defaultValue() {
        if (!this._defaultValueLoaded) {
            String value = Profile.getString("default." + this.name());
            this._defaultValue = value == null ? 0 : (value.equalsIgnoreCase("sequenceNumbers") ? 2 : (value.equalsIgnoreCase("lineNumbers") ? 1 : 3));
            this._defaultValueLoaded = true;
        }
        return this._defaultValue;
    }

    int currentValue(View view) {
        int value = this.value(view);
        if (value == 0 && (value = this.defaultValue()) == 0) {
            value = this.installValue();
        }
        return value;
    }

    @Override
    boolean set(View view, String qualifier, String parameters) {
        int value = 0;
        LpexStringTokenizer st = new LpexStringTokenizer(parameters);
        if (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equalsIgnoreCase("lineNumbers")) {
                value = 1;
            } else if (token.equalsIgnoreCase("sequenceNumbers")) {
                value = 2;
            } else if (token.equalsIgnoreCase("none")) {
                value = 3;
            } else if (token.equalsIgnoreCase("default")) {
                value = 0;
            } else {
                return CommandHandler.invalidParameter(view, token, "set " + this.name());
            }
            if (st.hasMoreTokens()) {
                return CommandHandler.invalidParameter(view, st.nextToken(), "set " + this.name());
            }
        }
        return this.setValue(view, value);
    }

    private boolean setValue(View view, int value) {
        if (view != null && view._prefixAreaTextParm != value) {
            view._prefixAreaTextParm = value;
            view.setPrefixAreaWidthsInvalid();
        }
        return true;
    }

    @Override
    boolean setDefault(View view, String qualifier, String parameters) {
        int value = 0;
        String token = null;
        LpexStringTokenizer st = new LpexStringTokenizer(parameters);
        if (st.hasMoreTokens()) {
            token = st.nextToken();
            if (token.equalsIgnoreCase("lineNumbers")) {
                value = 1;
            } else if (token.equalsIgnoreCase("sequenceNumbers")) {
                value = 2;
            } else if (token.equalsIgnoreCase("none")) {
                value = 3;
            } else if (token.equalsIgnoreCase("install")) {
                value = 0;
            } else {
                return CommandHandler.invalidParameter(view, token, "set default." + this.name());
            }
            if (st.hasMoreTokens()) {
                return CommandHandler.invalidParameter(view, st.nextToken(), "set default." + this.name());
            }
        }
        this._defaultValue = value;
        this._defaultValueLoaded = true;
        if (this._defaultValue != 0) {
            Profile.putString("default." + this.name(), token);
        } else {
            Profile.remove("default." + this.name());
        }
        return true;
    }

    @Override
    String query(View view, LpexDocumentLocation documentLocation, String qualifier) {
        if (view != null) {
            int value = this.value(view);
            return value == 0 ? "default" : PrefixAreaTextParameter.getTypeName(value);
        }
        return null;
    }

    int value(View view) {
        return view == null ? 0 : view._prefixAreaTextParm;
    }

    @Override
    String queryInstall(String qualifier) {
        return PrefixAreaTextParameter.getTypeName(this.installValue());
    }

    @Override
    String queryDefault(String qualifier) {
        int value = this.defaultValue();
        return value == 0 ? "install" : PrefixAreaTextParameter.getTypeName(value);
    }

    @Override
    String queryCurrent(View view, String qualifier) {
        return PrefixAreaTextParameter.getTypeName(this.currentValue(view));
    }

    private static String getTypeName(int type) {
        switch (type) {
            case 1: {
                return "lineNumbers";
            }
            case 2: {
                return "sequenceNumbers";
            }
            case 3: {
                return "none";
            }
        }
        return null;
    }
}

