/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.CommandHandler;
import com.ibm.lpex.core.Element;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.ParameterIntegerOnly;
import com.ibm.lpex.core.View;

final class PositionParameter
extends ParameterIntegerOnly {
    private static PositionParameter _parameter;

    static PositionParameter getParameter() {
        if (_parameter == null) {
            _parameter = new PositionParameter();
        }
        return _parameter;
    }

    private PositionParameter() {
        super("position");
    }

    @Override
    boolean setValue(View view, String qualifier, int value) {
        Element element;
        if (value <= 0) {
            return CommandHandler.invalidParameter(view, String.valueOf(value), "set " + this.name());
        }
        if (view != null && (element = view.documentPosition().element()) != null) {
            view.documentPosition().jump(element, value, true, false);
        }
        return true;
    }

    @Override
    boolean isQueryAvailable(View view, LpexDocumentLocation documentLocation, String qualifier) {
        return view != null && documentLocation != null && view.document().elementList().elementAt(documentLocation.element) != null;
    }

    @Override
    int value(View view, LpexDocumentLocation documentLocation, String qualifier) {
        return documentLocation != null ? documentLocation.position : 0;
    }
}

