/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.CommandHandler;
import com.ibm.lpex.core.Document;
import com.ibm.lpex.core.Install;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.ParameterDefault;
import com.ibm.lpex.core.Profile;
import com.ibm.lpex.core.View;

abstract class ParameterIntegerDefault
extends ParameterDefault {
    private int _hardCodedValue;
    private int _installValue;
    private boolean _installValueLoaded;
    private int _defaultValue;
    private boolean _useInstallValue;
    private boolean _defaultValueLoaded;

    ParameterIntegerDefault(String name, int hardCodedValue) {
        super(name);
        this._hardCodedValue = hardCodedValue;
        Install.addProfileChangedListener(new Install.ProfileChangedListener(){

            @Override
            public void profileChanged() {
                ParameterIntegerDefault.this._installValueLoaded = false;
                if (ParameterIntegerDefault.this.useInstallValue()) {
                    Document document = Document._firstDocument;
                    while (document != null) {
                        View view = document._firstView;
                        while (view != null) {
                            if (ParameterIntegerDefault.this.useDefaultValue(view)) {
                                ParameterIntegerDefault.this.currentValueChanged(view);
                            }
                            view = view._next;
                        }
                        document = document._next;
                    }
                }
            }
        });
        Profile.addProfileChangedListener(new Profile.ProfileChangedListener(){

            @Override
            public void profileChanged() {
                ParameterIntegerDefault.this._defaultValueLoaded = false;
                Document document = Document._firstDocument;
                while (document != null) {
                    View view = document._firstView;
                    while (view != null) {
                        if (ParameterIntegerDefault.this.useDefaultValue(view)) {
                            ParameterIntegerDefault.this.currentValueChanged(view);
                        }
                        view = view._next;
                    }
                    document = document._next;
                }
            }
        });
    }

    int installValue() {
        if (!this._installValueLoaded) {
            this._installValue = Install.getInteger("install." + this.name(), this._hardCodedValue);
            if (this._installValue < 0 || !this.isAcceptableValue(this._installValue)) {
                this._installValue = this._hardCodedValue;
            }
            this._installValueLoaded = true;
        }
        return this._installValue;
    }

    private void loadDefaultValue() {
        if (!this._defaultValueLoaded) {
            this._useInstallValue = true;
            String value = Profile.getString("default." + this.name());
            if (value != null) {
                try {
                    this._defaultValue = Integer.parseInt(value);
                    if (this._defaultValue >= 0 && this.isAcceptableValue(this._defaultValue)) {
                        this._useInstallValue = false;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this._defaultValueLoaded = true;
        }
    }

    boolean useInstallValue() {
        this.loadDefaultValue();
        return this._useInstallValue;
    }

    int defaultValue() {
        this.loadDefaultValue();
        return this._defaultValue;
    }

    boolean setDefaultValue(int value, boolean useInstallValue) {
        this._defaultValue = value;
        if (this._defaultValue < 0) {
            this._defaultValue = 0;
        }
        this._useInstallValue = useInstallValue;
        this._defaultValueLoaded = true;
        if (!this._useInstallValue) {
            Profile.putString("default." + this.name(), String.valueOf(this._defaultValue));
        } else {
            Profile.remove("default." + this.name());
        }
        Document document = Document._firstDocument;
        while (document != null) {
            View view = document._firstView;
            while (view != null) {
                if (this.useDefaultValue(view)) {
                    this.currentValueChanged(view);
                }
                view = view._next;
            }
            document = document._next;
        }
        return true;
    }

    int currentValue(View view) {
        if (this.useDefaultValue(view)) {
            return this.useInstallValue() ? this.installValue() : this.defaultValue();
        }
        return this.value(view);
    }

    @Override
    boolean set(View view, String qualifier, String parameters) {
        boolean useDefaultValue = true;
        int value = 0;
        LpexStringTokenizer st = new LpexStringTokenizer(parameters);
        if (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equalsIgnoreCase("default")) {
                useDefaultValue = true;
            } else {
                useDefaultValue = false;
                try {
                    value = Integer.parseInt(token);
                }
                catch (NumberFormatException e) {
                    return CommandHandler.invalidParameter(view, token, "set " + this.name());
                }
                if (value < 0 || !this.isAcceptableValue(value)) {
                    return CommandHandler.invalidParameter(view, token, "set " + this.name());
                }
            }
            if (st.hasMoreTokens()) {
                return CommandHandler.invalidParameter(view, st.nextToken(), "set " + this.name());
            }
        }
        return this.setValue(view, value, useDefaultValue);
    }

    abstract boolean setValue(View var1, int var2, boolean var3);

    @Override
    boolean setDefault(View view, String qualifier, String parameters) {
        boolean useInstallValue = true;
        int value = 0;
        LpexStringTokenizer st = new LpexStringTokenizer(parameters);
        if (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equalsIgnoreCase("install")) {
                useInstallValue = true;
            } else {
                useInstallValue = false;
                try {
                    value = Integer.parseInt(token);
                }
                catch (NumberFormatException e) {
                    return CommandHandler.invalidParameter(view, token, "set default." + this.name());
                }
                if (value < 0 || !this.isAcceptableValue(value)) {
                    return CommandHandler.invalidParameter(view, token, "set default." + this.name());
                }
            }
            if (st.hasMoreTokens()) {
                return CommandHandler.invalidParameter(view, st.nextToken(), "set default." + this.name());
            }
        }
        return this.setDefaultValue(value, useInstallValue);
    }

    void currentValueChanged(View view) {
    }

    boolean isAcceptableValue(int value) {
        return true;
    }

    @Override
    String query(View view, LpexDocumentLocation documentLocation, String qualifier) {
        if (view != null) {
            return this.useDefaultValue(view) ? "default" : String.valueOf(this.value(view));
        }
        return null;
    }

    abstract boolean useDefaultValue(View var1);

    abstract int value(View var1);

    @Override
    String queryInstall(String qualifier) {
        return String.valueOf(this.installValue());
    }

    @Override
    String queryDefault(String qualifier) {
        return this.useInstallValue() ? "install" : String.valueOf(this.defaultValue());
    }

    @Override
    String queryCurrent(View view, String qualifier) {
        return String.valueOf(this.currentValue(view));
    }
}

