/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.CommandHandler;
import com.ibm.lpex.core.Document;
import com.ibm.lpex.core.Font;
import com.ibm.lpex.core.Install;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.LpexUtilities;
import com.ibm.lpex.core.ParameterDefault;
import com.ibm.lpex.core.Profile;
import com.ibm.lpex.core.View;

abstract class ParameterFontDefault
extends ParameterDefault {
    protected Font _hardCodedValue;
    protected Font _installValue;
    protected boolean _installValueLoaded;
    protected Font _defaultValue;
    protected boolean _defaultValueLoaded;
    private String _PARM_INSTALL;
    private String _PARM_DEFAULT;
    private String _PARM_DEFAULT_FONT_DATA;
    private static final String QUALIFIER_FONT_DATA = "fontData";

    ParameterFontDefault(String name, Font hardCodedValue) {
        super(name);
        if (LpexUtilities.getPlatform() == 1) {
            this._PARM_INSTALL = "install.swt." + this.name();
            this._PARM_DEFAULT = "default.swt." + this.name();
            this._PARM_DEFAULT_FONT_DATA = this._PARM_DEFAULT + ".fontData";
        } else {
            this._PARM_INSTALL = "install." + this.name();
            this._PARM_DEFAULT = "default." + this.name();
        }
        this._hardCodedValue = hardCodedValue;
        Install.addProfileChangedListener(new Install.ProfileChangedListener(){

            @Override
            public void profileChanged() {
                ParameterFontDefault.this._installValueLoaded = false;
                if (ParameterFontDefault.this.defaultValue() == null) {
                    Document document = Document._firstDocument;
                    while (document != null) {
                        View view = document._firstView;
                        while (view != null) {
                            if (ParameterFontDefault.this.value(view) == null) {
                                ParameterFontDefault.this.currentValueChanged(view);
                            }
                            view = view._next;
                        }
                        document = document._next;
                    }
                }
            }
        });
        Profile.addProfileChangedListener(new Profile.ProfileChangedListener(){

            @Override
            public void profileChanged() {
                ParameterFontDefault.this._defaultValueLoaded = false;
                Document document = Document._firstDocument;
                while (document != null) {
                    View view = document._firstView;
                    while (view != null) {
                        if (ParameterFontDefault.this.value(view) == null) {
                            ParameterFontDefault.this.currentValueChanged(view);
                        }
                        view = view._next;
                    }
                    document = document._next;
                }
            }
        });
    }

    Font installValue() {
        if (!this._installValueLoaded) {
            String value = Install.getString(this._PARM_INSTALL);
            this._installValue = value == null ? this._hardCodedValue : Font.decodeFont(LpexStringTokenizer.removeQuotes(value));
            this._installValueLoaded = true;
        }
        return this._installValue;
    }

    protected void loadDefaultValue() {
        if (!this._defaultValueLoaded) {
            String value = null;
            if (LpexUtilities.getPlatform() == 1 && (value = Profile.getString(this._PARM_DEFAULT_FONT_DATA)) != null) {
                this._defaultValue = Font.decodeFontData(LpexStringTokenizer.removeQuotes(value));
            }
            if (value == null) {
                value = Profile.getString(this._PARM_DEFAULT);
                this._defaultValue = value == null ? null : Font.decodeFont(LpexStringTokenizer.removeQuotes(value));
            }
            this._defaultValueLoaded = true;
        }
    }

    Font defaultValue() {
        this.loadDefaultValue();
        return this._defaultValue;
    }

    boolean setDefaultValue(Font value) {
        this._defaultValue = value;
        this._defaultValueLoaded = true;
        if (this._defaultValue != null) {
            Profile.putString(this._PARM_DEFAULT, LpexStringTokenizer.addQuotes(Font.nameString(this._defaultValue)));
            if (LpexUtilities.getPlatform() == 1) {
                Profile.putString(this._PARM_DEFAULT_FONT_DATA, LpexStringTokenizer.addQuotes(Font.fontDataString(this._defaultValue)));
            }
        } else {
            Profile.remove(this._PARM_DEFAULT);
            if (LpexUtilities.getPlatform() == 1) {
                Profile.remove(this._PARM_DEFAULT_FONT_DATA);
            }
        }
        Document document = Document._firstDocument;
        while (document != null) {
            View view = document._firstView;
            while (view != null) {
                if (this.value(view) == null) {
                    this.currentValueChanged(view);
                }
                view = view._next;
            }
            document = document._next;
        }
        return true;
    }

    Font currentValue(View view) {
        Font value = this.value(view);
        if (value == null && (value = this.defaultValue()) == null) {
            value = this.installValue();
        }
        return value;
    }

    @Override
    boolean set(View view, String qualifier, String parameters) {
        Font value = null;
        LpexStringTokenizer st = new LpexStringTokenizer(parameters);
        if (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (!token.equalsIgnoreCase("default")) {
                if (LpexStringTokenizer.isInvalidQuotedString(token)) {
                    return CommandHandler.invalidQuotedParameter(view, token, "set " + this.name());
                }
                token = LpexStringTokenizer.removeQuotes(token);
                value = QUALIFIER_FONT_DATA.equalsIgnoreCase(qualifier) ? Font.decodeFontData(token) : Font.decodeFont(token);
            }
            if (st.hasMoreTokens()) {
                return CommandHandler.invalidParameter(view, st.nextToken(), "set " + this.name());
            }
        }
        return this.setValue(view, value);
    }

    abstract boolean setValue(View var1, Font var2);

    @Override
    boolean setDefault(View view, String qualifier, String parameters) {
        Font value = null;
        LpexStringTokenizer st = new LpexStringTokenizer(parameters);
        if (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (!token.equalsIgnoreCase("install")) {
                if (LpexStringTokenizer.isInvalidQuotedString(token)) {
                    return CommandHandler.invalidQuotedParameter(view, token, "set default." + this.name());
                }
                token = LpexStringTokenizer.removeQuotes(token);
                value = QUALIFIER_FONT_DATA.equalsIgnoreCase(qualifier) ? Font.decodeFontData(token) : Font.decodeFont(token);
            }
            if (st.hasMoreTokens()) {
                return CommandHandler.invalidParameter(view, st.nextToken(), "set default." + this.name());
            }
        }
        return this.setDefaultValue(value);
    }

    void currentValueChanged(View view) {
    }

    @Override
    String query(View view, LpexDocumentLocation documentLocation, String qualifier) {
        if (view != null) {
            Font value = this.value(view);
            if (qualifier != null) {
                if (qualifier.equalsIgnoreCase(QUALIFIER_FONT_DATA)) {
                    if (value == null) {
                        return this.queryDefault(qualifier);
                    }
                    return LpexStringTokenizer.addQuotes(Font.fontDataString(value));
                }
                return null;
            }
            return value == null ? "default" : LpexStringTokenizer.addQuotes(Font.nameString(value));
        }
        return null;
    }

    abstract Font value(View var1);

    @Override
    String queryInstall(String qualifier) {
        Font value = this.installValue();
        if (qualifier != null) {
            if (qualifier.equalsIgnoreCase(QUALIFIER_FONT_DATA)) {
                return LpexStringTokenizer.addQuotes(Font.fontDataString(value));
            }
            return null;
        }
        return LpexStringTokenizer.addQuotes(Font.nameString(value));
    }

    @Override
    String queryDefault(String qualifier) {
        Font value = this.defaultValue();
        if (qualifier != null) {
            if (qualifier.equalsIgnoreCase(QUALIFIER_FONT_DATA)) {
                if (value == null) {
                    return this.queryInstall(qualifier);
                }
                return LpexStringTokenizer.addQuotes(Font.fontDataString(value));
            }
            return null;
        }
        return value == null ? "install" : LpexStringTokenizer.addQuotes(Font.nameString(value));
    }

    @Override
    String queryCurrent(View view, String qualifier) {
        Font value = this.currentValue(view);
        if (qualifier != null) {
            if (qualifier.equalsIgnoreCase(QUALIFIER_FONT_DATA)) {
                return LpexStringTokenizer.addQuotes(Font.fontDataString(value));
            }
            return null;
        }
        return LpexStringTokenizer.addQuotes(Font.nameString(value));
    }
}

