/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.CommandHandler;
import com.ibm.lpex.core.Document;
import com.ibm.lpex.core.Install;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.ParameterDefault;
import com.ibm.lpex.core.Profile;
import com.ibm.lpex.core.View;

abstract class ParameterCharacterDefault
extends ParameterDefault {
    private char _hardCodedValue;
    private char _installValue;
    private boolean _installValueLoaded;
    private char _defaultValue;
    private boolean _defaultValueLoaded;

    ParameterCharacterDefault(String name, char hardCodedValue) {
        super(name);
        this._hardCodedValue = hardCodedValue;
        Install.addProfileChangedListener(new Install.ProfileChangedListener(){

            @Override
            public void profileChanged() {
                ParameterCharacterDefault.this._installValueLoaded = false;
                if (ParameterCharacterDefault.this.defaultValue() == '\u0000') {
                    Document document = Document._firstDocument;
                    while (document != null) {
                        View view = document._firstView;
                        while (view != null) {
                            if (ParameterCharacterDefault.this.value(view) == '\u0000') {
                                ParameterCharacterDefault.this.currentValueChanged(view);
                            }
                            view = view._next;
                        }
                        document = document._next;
                    }
                }
            }
        });
        Profile.addProfileChangedListener(new Profile.ProfileChangedListener(){

            @Override
            public void profileChanged() {
                ParameterCharacterDefault.this._defaultValueLoaded = false;
                Document document = Document._firstDocument;
                while (document != null) {
                    View view = document._firstView;
                    while (view != null) {
                        if (ParameterCharacterDefault.this.value(view) == '\u0000') {
                            ParameterCharacterDefault.this.currentValueChanged(view);
                        }
                        view = view._next;
                    }
                    document = document._next;
                }
            }
        });
    }

    char installValue() {
        if (!this._installValueLoaded) {
            char value = '\u0000';
            String install = Install.getString("install." + this.name());
            if (install != null) {
                try {
                    value = (char)Integer.decode(install).intValue();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this._installValue = value == '\u0000' ? this._hardCodedValue : value;
            this._installValueLoaded = true;
        }
        return this._installValue;
    }

    protected void loadDefaultValue() {
        if (!this._defaultValueLoaded) {
            this._defaultValue = '\u0000';
            String value = Profile.getString("default." + this.name());
            if (value != null) {
                try {
                    this._defaultValue = (char)Integer.decode(value).intValue();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this._defaultValueLoaded = true;
        }
    }

    char defaultValue() {
        this.loadDefaultValue();
        return this._defaultValue;
    }

    boolean setDefaultValue(char value) {
        this._defaultValue = value;
        this._defaultValueLoaded = true;
        if (this._defaultValue != '\u0000') {
            Profile.putString("default." + this.name(), String.valueOf(this._defaultValue));
        } else {
            Profile.remove("default." + this.name());
        }
        Document document = Document._firstDocument;
        while (document != null) {
            View view = document._firstView;
            while (view != null) {
                if (this.value(view) == '\u0000') {
                    this.currentValueChanged(view);
                }
                view = view._next;
            }
            document = document._next;
        }
        return true;
    }

    char currentValue(View view) {
        char value = this.value(view);
        if (value == '\u0000' && (value = this.defaultValue()) == '\u0000') {
            value = this.installValue();
        }
        return value;
    }

    @Override
    boolean set(View view, String qualifier, String parameters) {
        char value = '\u0000';
        LpexStringTokenizer st = new LpexStringTokenizer(parameters);
        if (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (!token.equalsIgnoreCase("default")) {
                if (token.length() > 1) {
                    try {
                        value = (char)Integer.decode(token).intValue();
                    }
                    catch (NumberFormatException e) {
                        return CommandHandler.invalidParameter(view, token, "set " + this.name(qualifier));
                    }
                } else {
                    value = token.charAt(0);
                }
            }
            if (st.hasMoreTokens()) {
                return CommandHandler.invalidParameter(view, st.nextToken(), "set " + this.name(qualifier));
            }
        }
        return this.setValue(view, qualifier, value);
    }

    abstract boolean setValue(View var1, String var2, char var3);

    @Override
    boolean setDefault(View view, String qualifier, String parameters) {
        char value = '\u0000';
        LpexStringTokenizer st = new LpexStringTokenizer(parameters);
        if (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (!token.equalsIgnoreCase("install")) {
                if (token.length() > 1) {
                    try {
                        value = (char)Integer.decode(token).intValue();
                    }
                    catch (NumberFormatException e) {
                        return CommandHandler.invalidParameter(view, token, "set " + this.name(qualifier));
                    }
                } else {
                    value = token.charAt(0);
                }
            }
            if (st.hasMoreTokens()) {
                return CommandHandler.invalidParameter(view, st.nextToken(), "set default." + this.name(qualifier));
            }
        }
        return this.setDefaultValue(value);
    }

    void currentValueChanged(View view) {
    }

    @Override
    String query(View view, LpexDocumentLocation documentLocation, String qualifier) {
        if (view != null) {
            char value = this.value(view);
            return value == '\u0000' ? "default" : String.valueOf(value);
        }
        return "0";
    }

    abstract char value(View var1);

    @Override
    String queryInstall(String qualifier) {
        return String.valueOf(this.installValue());
    }

    @Override
    String queryDefault(String qualifier) {
        char value = this.defaultValue();
        return value == '\u0000' ? "install" : String.valueOf(value);
    }

    @Override
    String queryCurrent(View view, String qualifier) {
        return String.valueOf(this.currentValue(view));
    }
}

