/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.Color;
import com.ibm.lpex.core.CompareCommand;
import com.ibm.lpex.core.Document;
import com.ibm.lpex.core.Element;
import com.ibm.lpex.core.ElementList;
import com.ibm.lpex.core.ElementView;
import com.ibm.lpex.core.List;
import com.ibm.lpex.core.ListNode;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexMarkListener;
import com.ibm.lpex.core.LpexResources;
import com.ibm.lpex.core.MarkListenerNode;
import com.ibm.lpex.core.StyleAttributes;
import com.ibm.lpex.core.View;

final class MarkList
extends List {
    protected View _view;
    private boolean _ignoreChanges;
    protected boolean _includedMarks;
    protected int _lastMarkId;
    private List _changedMarks;
    private List _deletedMarks;

    MarkList(View view) {
        this._view = view;
    }

    @Override
    List.Node remove(List.Node node) {
        super.remove(node);
        Mark mark = ((MarkNode)node).mark();
        mark.clear();
        return node;
    }

    void setIgnoreChanges(boolean ignoreChanges) {
        this._ignoreChanges = ignoreChanges;
    }

    static int id(String name) {
        if (name == null || name.length() == 0 || name.charAt(0) != '#') {
            return 0;
        }
        int id = 0;
        try {
            id = Integer.parseInt(name.substring(1));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return id;
    }

    Mark find(String name) {
        if (name == null || name.length() == 0) {
            return this.find(this._lastMarkId);
        }
        int id = MarkList.id(name);
        if (id != 0) {
            return this.find(id);
        }
        MarkNode markNode = (MarkNode)this.first();
        while (markNode != null) {
            Mark mark = markNode.mark();
            String currentName = mark.name();
            if (currentName == null) break;
            if (currentName.equalsIgnoreCase(name)) {
                return mark;
            }
            markNode = (MarkNode)markNode.next();
        }
        return null;
    }

    Mark find(int id) {
        MarkNode markNode = (MarkNode)this.last();
        while (markNode != null) {
            Mark mark = markNode.mark();
            if (mark.id() == id) {
                return mark;
            }
            markNode = (MarkNode)markNode.prev();
        }
        return null;
    }

    Mark firstNamed() {
        MarkNode markNode = (MarkNode)this.first();
        if (markNode != null && markNode.mark().name() != null) {
            return markNode.mark();
        }
        return null;
    }

    Mark nextNamed(Mark mark) {
        MarkNode markNode = (MarkNode)this.first();
        while (markNode != null) {
            if (mark == markNode.mark()) {
                if ((markNode = (MarkNode)markNode.next()) == null || markNode.mark().name() == null) break;
                return markNode.mark();
            }
            markNode = (MarkNode)markNode.next();
        }
        return null;
    }

    Mark prevNamed(Mark mark) {
        MarkNode markNode = (MarkNode)this.first();
        while (markNode != null) {
            if (mark == markNode.mark()) {
                if ((markNode = (MarkNode)markNode.prev()) == null || markNode.mark().name() == null) break;
                return markNode.mark();
            }
            markNode = (MarkNode)markNode.next();
        }
        return null;
    }

    Mark set(String name, Element element1, Element element2, boolean sticky) {
        Mark mark;
        int id = MarkList.id(name);
        if ((id != 0 || name != null && name.length() != 0) && (mark = this.find(name)) != null) {
            id = mark.id();
            mark.clear();
        }
        if (id <= this._lastMarkId) {
            return new ElementMark(name, id, element1, element2, sticky);
        }
        return null;
    }

    Mark set(String name, Element element1, int position1, Element element2, int position2, boolean sticky) {
        Mark mark;
        int id = MarkList.id(name);
        if ((id != 0 || name != null && name.length() != 0) && (mark = this.find(name)) != null) {
            id = mark.id();
            mark.clear();
        }
        if (id <= this._lastMarkId) {
            return new CharacterMark(name, id, element1, position1, element2, position2, sticky);
        }
        return null;
    }

    void checkIncludedMarks() {
        MarkNode markNode = (MarkNode)this.first();
        while (markNode != null) {
            if (markNode.mark()._included) {
                return;
            }
            markNode = (MarkNode)markNode.next();
        }
        this._includedMarks = false;
    }

    void elementRemoved(Element element) {
        if (!this._ignoreChanges) {
            ElementView.MarkNode next = null;
            ElementView.MarkNode markNode = element.elementView((View)this._view)._firstMarkNode;
            while (markNode != null) {
                next = markNode._next;
                markNode.mark().elementRemoved(element);
                markNode = next;
            }
        }
    }

    void elementInserted(Element element) {
        if (!this._ignoreChanges) {
            Element nextElement;
            Element previousElement = element.prev();
            if (previousElement != null) {
                ElementView.MarkNode next = null;
                ElementView.MarkNode markNode = previousElement.elementView((View)this._view)._firstMarkNode;
                while (markNode != null) {
                    next = markNode._next;
                    markNode.mark().elementInserted(element);
                    markNode = next;
                }
            }
            if ((nextElement = element.next()) != null) {
                ElementView.MarkNode next = null;
                ElementView.MarkNode markNode = nextElement.elementView((View)this._view)._firstMarkNode;
                while (markNode != null) {
                    next = markNode._next;
                    markNode.mark().elementInserted(element);
                    markNode = next;
                }
            }
        }
    }

    void textDeleted(Element element, int position, int length) {
        if (!this._ignoreChanges) {
            ElementView.MarkNode next = null;
            ElementView.MarkNode markNode = element.elementView((View)this._view)._firstMarkNode;
            while (markNode != null) {
                next = markNode._next;
                markNode.mark().textDeleted(element, position, length);
                markNode = next;
            }
        }
    }

    void textReplaced(Element element, int position, int length) {
        if (!this._ignoreChanges) {
            ElementView.MarkNode next = null;
            ElementView.MarkNode markNode = element.elementView((View)this._view)._firstMarkNode;
            while (markNode != null) {
                next = markNode._next;
                markNode.mark().textReplaced(element, position, length);
                markNode = next;
            }
        }
    }

    void textInserted(Element element, int position, int length) {
        if (!this._ignoreChanges) {
            ElementView.MarkNode next = null;
            ElementView.MarkNode markNode = element.elementView((View)this._view)._firstMarkNode;
            while (markNode != null) {
                next = markNode._next;
                markNode.mark().textInserted(element, position, length);
                markNode = next;
            }
        }
    }

    void joinElements(Element element1, Element element2) {
        if (!this._ignoreChanges) {
            ElementView.MarkNode next = null;
            ElementView.MarkNode markNode = element1.elementView((View)this._view)._firstMarkNode;
            while (markNode != null) {
                next = markNode._next;
                markNode.mark().joinElements(element1, element2);
                markNode = next;
            }
            if (element2 != null) {
                next = null;
                markNode = element2.elementView((View)this._view)._firstMarkNode;
                while (markNode != null) {
                    next = markNode._next;
                    markNode.mark().joinElements(element1, element2);
                    markNode = next;
                }
            }
        }
    }

    void splitElement(Element element, int position) {
        if (!this._ignoreChanges) {
            Element nextElement;
            ElementView.MarkNode next = null;
            ElementView.MarkNode markNode = element.elementView((View)this._view)._firstMarkNode;
            while (markNode != null) {
                next = markNode._next;
                markNode.mark().splitElement(element, position);
                markNode = next;
            }
            if ((element = element.next()) != null && (nextElement = element.next()) != null) {
                next = null;
                ElementView.MarkNode markNode2 = nextElement.elementView((View)this._view)._firstMarkNode;
                while (markNode2 != null) {
                    next = markNode2._next;
                    markNode2.mark().elementInserted(element);
                    markNode2 = next;
                }
            }
        }
    }

    void validate() {
        MarkNode markNode = (MarkNode)this.first();
        while (markNode != null) {
            markNode.mark().updateExcludedHeader();
            markNode = (MarkNode)markNode.next();
        }
    }

    /*
     * Unable to fully structure code
     */
    void updateStyle(ElementView elementView, StringBuilder foregroundStyle, StringBuilder backgroundStyle) {
        elementMarksFound = false;
        currentLineMark = null;
        markNode = elementView._firstMarkNode;
        while (markNode != null) {
            mark = markNode.mark();
            if (!(mark instanceof ElementMark)) ** GOTO lbl12
            if ("@CORE-CURRENTLINE".equals(mark.name())) {
                currentLineMark = mark;
            } else {
                if (mark._highlight) {
                    elementMarksFound = true;
                }
lbl12:
                // 4 sources

                mark.updateStyle(elementView.element(), foregroundStyle, backgroundStyle);
            }
            markNode = markNode._next;
        }
        if (currentLineMark != null && !elementMarksFound) {
            currentLineMark.updateStyle(elementView.element(), foregroundStyle, backgroundStyle);
        }
    }

    StyleAttributes defaultStyleAttributes(Element element) {
        StyleAttributes styleAttributes = null;
        ElementView.MarkNode markNode = element.elementView((View)this._view)._firstMarkNode;
        while (markNode != null) {
            StyleAttributes defaultStyleAttributes = markNode.mark().defaultStyleAttributes();
            if (defaultStyleAttributes != null) {
                styleAttributes = defaultStyleAttributes;
            }
            markNode = markNode._next;
        }
        return styleAttributes;
    }

    boolean visible(Element element) {
        if (this._includedMarks) {
            ElementView.MarkNode markNode = element.elementView((View)this._view)._firstMarkNode;
            while (markNode != null) {
                if (markNode.mark().included()) {
                    return true;
                }
                markNode = markNode._next;
            }
            return false;
        }
        ElementView.MarkNode markNode = element.elementView((View)this._view)._firstMarkNode;
        while (markNode != null) {
            if (markNode.mark().excluded()) {
                return false;
            }
            markNode = markNode._next;
        }
        return true;
    }

    boolean namedMarks() {
        MarkNode markNode = (MarkNode)this.first();
        return markNode != null && markNode.mark().name() != null;
    }

    Mark headerMark(Element element) {
        if (element != null && element.show()) {
            MarkNode markNode = (MarkNode)this.first();
            while (markNode != null) {
                if (markNode.mark().excludedHeaderElement() == element) {
                    return markNode.mark();
                }
                markNode = (MarkNode)markNode.next();
            }
        }
        return null;
    }

    void removePrefixExcludeMarks() {
        MarkNode markNode = (MarkNode)this.first();
        while (markNode != null) {
            MarkNode nextMarkNode = (MarkNode)markNode.next();
            if (markNode.mark().excluded() && markNode.mark().name().startsWith("ProcessPrefix")) {
                markNode.mark().clear();
            }
            markNode = nextMarkNode;
        }
    }

    boolean compareDeletedLine(Element element) {
        if (element != null) {
            ElementView.MarkNode markNode = element.elementView((View)this._view)._firstMarkNode;
            while (markNode != null) {
                if (markNode.mark() instanceof CompareCommand.DeletedLines) {
                    return true;
                }
                markNode = markNode._next;
            }
        }
        return false;
    }

    boolean protect(Element element) {
        if (element != null) {
            ElementView.MarkNode markNode = element.elementView((View)this._view)._firstMarkNode;
            while (markNode != null) {
                if (markNode.mark().protect()) {
                    return true;
                }
                markNode = markNode._next;
            }
        }
        return false;
    }

    boolean insertElementProtect(Element element) {
        if (element != null) {
            ElementView.MarkNode markNode = element.elementView((View)this._view)._firstMarkNode;
            while (markNode != null) {
                if (markNode.mark().protect() && markNode.mark().element2() != element) {
                    return true;
                }
                markNode = markNode._next;
            }
        }
        return false;
    }

    boolean insertElementBeforeProtect(Element element) {
        if (element != null) {
            ElementView.MarkNode markNode = element.elementView((View)this._view)._firstMarkNode;
            while (markNode != null) {
                if (markNode.mark().protect() && markNode.mark().element1() != element) {
                    return true;
                }
                markNode = markNode._next;
            }
        }
        return false;
    }

    List changedMarks() {
        if (this._changedMarks == null) {
            this._changedMarks = new List();
        }
        return this._changedMarks;
    }

    List deletedMarks() {
        if (this._deletedMarks == null) {
            this._deletedMarks = new List();
        }
        return this._deletedMarks;
    }

    void triggerListeners() {
        MarkNode markNode;
        if (this._changedMarks != null) {
            markNode = (MarkNode)this._changedMarks.first();
            while (markNode != null) {
                markNode.mark().markChanged();
                markNode = (MarkNode)markNode.next();
            }
            this._changedMarks = null;
        }
        if (this._deletedMarks != null) {
            markNode = (MarkNode)this._deletedMarks.first();
            while (markNode != null) {
                markNode.mark().markDeleted();
                markNode = (MarkNode)markNode.next();
            }
            this._deletedMarks = null;
        }
    }

    String deletedMarkName(int id) {
        if (this._deletedMarks != null) {
            MarkNode markNode = (MarkNode)this._deletedMarks.first();
            while (markNode != null) {
                Mark mark = markNode.mark();
                if (mark.id() == id) {
                    return mark.name();
                }
                markNode = (MarkNode)markNode.next();
            }
        }
        return null;
    }

    void removeListener(int id, LpexMarkListener listener) {
        if (listener != null) {
            Mark mark;
            MarkNode markNode = (MarkNode)this.first();
            while (markNode != null) {
                mark = markNode.mark();
                if (mark.id() == id) {
                    mark.removeListener(listener);
                }
                markNode = (MarkNode)markNode.next();
            }
            if (this._deletedMarks != null) {
                markNode = (MarkNode)this._deletedMarks.first();
                while (markNode != null) {
                    mark = markNode.mark();
                    if (mark.id() == id) {
                        mark.removeListener(listener);
                    }
                    markNode = (MarkNode)markNode.next();
                }
            }
        }
    }

    void removeListener(LpexMarkListener listener) {
        if (listener != null) {
            MarkNode markNode = (MarkNode)this.first();
            while (markNode != null) {
                markNode.mark().removeListener(listener);
                markNode = (MarkNode)markNode.next();
            }
            if (this._deletedMarks != null) {
                markNode = (MarkNode)this._deletedMarks.first();
                while (markNode != null) {
                    markNode.mark().removeListener(listener);
                    markNode = (MarkNode)markNode.next();
                }
            }
        }
    }

    class CharacterMark
    extends Mark {
        private int _position1;
        private int _position2;

        CharacterMark(String name, int id, Element element1, int position1, Element element2, int position2, boolean sticky) {
            super(name, id, element1, element2, sticky);
            this._position1 = position1;
            this._position2 = position2;
            if (this._element1 == this._element2 && this._position2 < this._position1) {
                this._position2 = this._position1;
            }
        }

        @Override
        int position1() {
            return this._position1;
        }

        @Override
        int position2() {
            return this._position2;
        }

        @Override
        void elementRemoved(Element element) {
            if (element == this._element1 && element == this._element2) {
                this.deleted();
                return;
            }
            if (element == this._element1) {
                this._element1 = element.next();
                this._position1 = 1;
                if (this._highlight) {
                    this._element1.elementView(MarkList.this._view).resetDisplayStyle();
                }
            }
            if (element == this._element2) {
                this._element2 = element.prev();
                this._position2 = this._element2.end();
                if (this._element1 == this._element2 && this._position2 < this._position1) {
                    this._position2 = this._position1;
                }
                if (this._highlight) {
                    this._element2.elementView(MarkList.this._view).resetDisplayStyle();
                }
            }
            this.dirtied();
        }

        @Override
        void elementInserted(Element element) {
            if (element == this._element1.prev()) {
                if (this._topSticky && !element.show() && this._position1 == 1) {
                    this._element1 = element;
                } else {
                    return;
                }
            }
            if (element == this._element2.next()) {
                if (this._bottomSticky && !element.show() && this._position2 >= this._element2.length()) {
                    this._element2 = element;
                    this._position2 = element.length();
                } else {
                    return;
                }
            }
            this.addElement(element);
            this.dirtied();
        }

        @Override
        void textDeleted(Element element, int position, int length) {
            boolean changed = true;
            boolean deleted = false;
            int position2 = position + length - 1;
            if (this._element1 == this._element2) {
                changed = this._position1 <= position && this._position2 >= position || this._position1 <= position2 && this._position2 >= position2;
                boolean bl = deleted = this._position1 >= position && this._position2 <= position2;
                if (!deleted) {
                    if (this._position1 > position2) {
                        this._position1 -= length;
                    } else if (this._position1 > position) {
                        this._position1 = position;
                    }
                    if (this._position2 > position2) {
                        this._position2 -= length;
                    } else if (this._position2 >= position) {
                        this._position2 = position - 1;
                    }
                }
            } else if (element == this._element1) {
                boolean bl = changed = this._position1 <= position2;
                if (this._position1 > position2) {
                    this._position1 -= length;
                } else if (this._position1 > position) {
                    this._position1 = position;
                }
            } else if (element == this._element2) {
                boolean bl = changed = this._position2 >= position;
                if (this._position2 > position2) {
                    this._position2 -= length;
                } else if (this._position2 >= position) {
                    this._position2 = position - 1;
                    if (this._position2 == 0) {
                        this._position2 = 1;
                    }
                }
            }
            if (deleted) {
                this.deleted();
            } else if (changed) {
                this.dirtied();
            }
        }

        @Override
        void textReplaced(Element element, int position, int length) {
            boolean changed = true;
            int position2 = position + length - 1;
            if (this._element1 == this._element2) {
                changed = position >= this._position1 && position <= this._position2 || position2 >= this._position1 && position2 <= this._position2;
            } else if (element == this._element1) {
                changed = this._position1 <= position2;
            } else if (element == this._element2) {
                boolean bl = changed = this._position2 >= position;
            }
            if (changed) {
                this.dirtied();
            }
        }

        @Override
        void textInserted(Element element, int position, int length) {
            boolean changed = true;
            if (element == this._element1 && element == this._element2) {
                boolean topChanged;
                boolean bl = this._topSticky ? this._position1 <= position : (topChanged = this._position1 < position);
                boolean bottomChanged = this._bottomSticky ? this._position2 + 1 >= position : this._position2 >= position;
                boolean bl2 = changed = topChanged || bottomChanged;
                if (!this._topSticky && this._position1 >= position || this._topSticky && this._position1 > position) {
                    this._position1 += length;
                }
                if (!this._bottomSticky && this._position2 >= position || this._bottomSticky && this._position2 + 1 >= position) {
                    this._position2 += length;
                }
            } else if (element == this._element1) {
                boolean bl = this._topSticky ? this._position1 <= position : (changed = this._position1 < position);
                if (!this._topSticky && this._position1 >= position || this._topSticky && this._position1 > position) {
                    this._position1 += length;
                }
            } else if (element == this._element2) {
                boolean bl = this._bottomSticky ? this._position2 + 1 >= position : (changed = this._position2 >= position);
                if (!this._bottomSticky && this._position2 >= position || this._bottomSticky && this._position2 + 1 >= position) {
                    this._position2 += length;
                }
            }
            if (changed) {
                this.dirtied();
            }
        }

        @Override
        void joinElements(Element element1, Element element2) {
            boolean changed = true;
            if (this._element2 == element1) {
                boolean bl = changed = this._position2 > element1.length();
            }
            if (element2 == this._element1) {
                changed = false;
                this._element1 = element1;
                this._position1 += element1.length();
                if (this._highlight) {
                    this._element1.elementView(MarkList.this._view).resetDisplayStyle();
                }
            }
            if (element2 == this._element2) {
                changed = element2 != this._element1;
                this._element2 = element1;
                this._position2 += element1.length();
                if (this._element1 == this._element2 && this._position2 < this._position1) {
                    this._position2 = this._position1;
                }
                if (this._highlight) {
                    this._element2.elementView(MarkList.this._view).resetDisplayStyle();
                }
            }
            this.clearElement(element2);
            this.addElement(element1);
            if (changed) {
                this.dirtied();
            }
        }

        @Override
        void splitElement(Element element, int position) {
            Element newElement = element.next();
            if (newElement != null) {
                boolean changed = true;
                if (this._element1 == this._element2) {
                    changed = this._position1 < position && this._position2 >= position;
                } else if (this._element1 == element) {
                    changed = this._position1 < position;
                } else if (this._element2 == element) {
                    boolean bl = changed = this._position2 >= position;
                }
                if (this._element1 == element && position <= this._position1) {
                    this._position1 -= position - 1;
                    this._element1 = newElement;
                    this.clearElement(element);
                    if (this._highlight) {
                        this._element1.elementView(MarkList.this._view).resetDisplayStyle();
                    }
                }
                if (this._element2 == element && position <= this._position2) {
                    this._position2 -= position - 1;
                    this._element2 = newElement;
                    if (this._highlight) {
                        this._element2.elementView(MarkList.this._view).resetDisplayStyle();
                    }
                }
                if (this._element2 != element) {
                    this.addElement(newElement);
                }
                if (changed) {
                    this.dirtied();
                }
            }
        }

        @Override
        void updateStyle(Element element, StringBuilder foreground, StringBuilder background) {
            if (!this._highlight) {
                return;
            }
            int highlightStart = 0;
            int highlightLength = 0;
            if (this._element1 == element && this._element2 == element) {
                highlightStart = this._position1 - 1;
                highlightLength = this._position2 - this._position1 + 1;
            } else if (this._element1 == element) {
                highlightStart = this._position1 - 1;
                highlightLength = element.length() - this._position1 + 1;
                if (highlightLength < 1) {
                    highlightLength = 1;
                }
            } else {
                highlightLength = this._element2 == element ? this._position2 : element.length();
            }
            int oldLength = foreground.length();
            if (oldLength < highlightStart + highlightLength) {
                foreground.setLength(highlightStart + highlightLength);
                int i = oldLength;
                while (i < highlightStart) {
                    foreground.setCharAt(i, '!');
                    ++i;
                }
            }
            boolean backgroundOnly = MarkList.this._view.styleAttributesList().backgroundOnly(this._styleCharacter);
            if ((background.length() != 0 || backgroundOnly) && background.length() < foreground.length()) {
                background.setLength(foreground.length());
            }
            StringBuilder buffer = backgroundOnly ? background : foreground;
            int i = highlightStart;
            while (i < highlightStart + highlightLength) {
                buffer.setCharAt(i, this._styleCharacter);
                ++i;
            }
        }

        @Override
        String query() {
            Document document = MarkList.this._view.document();
            ElementList elementList = document.elementList();
            int element1 = elementList.ordinalOf(this._element1) + document.linesBeforeStart();
            int element2 = elementList.ordinalOf(this._element2) + document.linesBeforeStart();
            StringBuilder queryString = new StringBuilder(32);
            if (this._topSticky || this._bottomSticky) {
                queryString.append("sticky ");
            }
            queryString.append(element1).append(' ').append(this._position1).append(' ').append(element2).append(' ').append(this._position2);
            return queryString.toString();
        }

        @Override
        StyleAttributes defaultStyleAttributes() {
            return null;
        }
    }

    class ElementMark
    extends Mark {
        ElementMark(String name, int id, Element element1, Element element2, boolean sticky) {
            super(name, id, element1, element2, sticky);
        }

        @Override
        int position1() {
            return 1;
        }

        @Override
        int position2() {
            return this._element1 != null ? this._element1.end() : 1;
        }

        @Override
        void elementRemoved(Element element) {
            this.clearElement(element);
            if (element == this._element1 && element == this._element2) {
                this.deleted();
                return;
            }
            if (element == this._element1) {
                this._element1 = element.next();
            }
            if (element == this._element2) {
                this._element2 = element.prev();
            }
            this.dirtied();
        }

        @Override
        void elementInserted(Element element) {
            if (element == this._element1.prev()) {
                if (this._topSticky && !element.show()) {
                    this._element1 = element;
                } else {
                    return;
                }
            }
            if (element == this._element2.next()) {
                if (this._bottomSticky && !element.show()) {
                    this._element2 = element;
                } else {
                    return;
                }
            }
            this.addElement(element);
            this.dirtied();
        }

        @Override
        void textDeleted(Element element, int position, int length) {
            this.dirtied();
        }

        @Override
        void textReplaced(Element element, int position, int length) {
            this.dirtied();
        }

        @Override
        void textInserted(Element element, int position, int length) {
            this.dirtied();
        }

        @Override
        void joinElements(Element element1, Element element2) {
            if (element2 == this._element1) {
                this._element1 = element1;
            }
            if (element2 == this._element2) {
                this._element2 = element1;
            }
            this.clearElement(element2);
            this.addElement(element1);
            this.dirtied();
        }

        @Override
        void splitElement(Element element, int position) {
            if (!this._protect || this._bottomSticky || element != this._element2) {
                Element newElement = element.next();
                if (element == this._element2) {
                    this._element2 = newElement;
                }
                this.addElement(newElement);
                this.dirtied();
            }
        }

        @Override
        void updateStyle(Element element, StringBuilder foreground, StringBuilder background) {
            int oldLength;
            if (!this._highlight) {
                return;
            }
            int highlightLength = element.length();
            if (highlightLength < (oldLength = foreground.length())) {
                highlightLength = oldLength;
            }
            if (oldLength < highlightLength) {
                foreground.setLength(highlightLength);
            }
            boolean backgroundOnly = MarkList.this._view.styleAttributesList().backgroundOnly(this._styleCharacter);
            if ((background.length() != 0 || backgroundOnly) && background.length() < foreground.length()) {
                background.setLength(foreground.length());
            }
            if (backgroundOnly) {
                Color defaultBackground = MarkList.this._view.screen().styleAttributes(4).backgroundColor();
                int i = 0;
                while (i < highlightLength) {
                    char c = foreground.charAt(i);
                    if (c == '!' || c == '\u0000') {
                        background.setCharAt(i, this._styleCharacter);
                    } else {
                        StyleAttributes fgAttributes = MarkList.this._view.styleAttributesList().find(c);
                        if (fgAttributes == null || fgAttributes.backgroundColor().equals(defaultBackground)) {
                            background.setCharAt(i, this._styleCharacter);
                        }
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i < highlightLength) {
                    foreground.setCharAt(i, this._styleCharacter);
                    ++i;
                }
            }
        }

        @Override
        String query() {
            Document document = MarkList.this._view.document();
            ElementList elementList = document.elementList();
            int element1 = elementList.ordinalOf(this._element1) + document.linesBeforeStart();
            int element2 = elementList.ordinalOf(this._element2) + document.linesBeforeStart();
            StringBuilder queryString = new StringBuilder(32);
            if (this._topSticky || this._bottomSticky) {
                queryString.append("sticky ");
            }
            queryString.append("element ").append(element1).append(' ').append(element2);
            return queryString.toString();
        }

        @Override
        StyleAttributes defaultStyleAttributes() {
            return this._highlight ? MarkList.this._view.styleAttributesList().find(this._styleCharacter) : null;
        }
    }

    abstract class Mark
    extends List {
        protected String _name;
        protected Element _element1;
        protected Element _element2;
        protected int _id;
        protected boolean _dirty;
        protected boolean _included;
        protected boolean _excluded;
        protected boolean _highlight;
        protected char _styleCharacter;
        protected boolean _topSticky;
        protected boolean _bottomSticky;
        protected boolean _excludedHeader;
        protected boolean _protect;
        private Element _excludedHeaderElement;
        private int _excludedLineCount;
        private boolean _cleared;

        Mark(String name, int id, Element element1, Element element2, boolean sticky) {
            if (name != null && name.length() == 0) {
                name = null;
            }
            this._name = name;
            this._element1 = element1;
            this._element2 = element2;
            Element element = element1;
            while (element != null && element != element2.next()) {
                this.addElement(element);
                element = element.next();
            }
            if (id == 0) {
                ++MarkList.this._lastMarkId;
                this._id = MarkList.this._lastMarkId;
            } else {
                this._id = id;
            }
            this._styleCharacter = (char)33;
            this._topSticky = sticky;
            this._bottomSticky = sticky;
            MarkNode markNode = new MarkNode(this);
            if (name == null) {
                MarkList.this.addBefore(null, markNode);
            } else {
                MarkList.this.addAfter(null, markNode);
            }
            this._cleared = false;
        }

        View view() {
            return MarkList.this._view;
        }

        MarkList markList() {
            return MarkList.this;
        }

        String name() {
            return this._name != null ? this._name : "#" + this._id;
        }

        Element element1() {
            return this._element1;
        }

        abstract int position1();

        Element element2() {
            return this._element2;
        }

        abstract int position2();

        int id() {
            return this._id;
        }

        boolean dirty() {
            return this._dirty;
        }

        void setIncluded(boolean included) {
            if (this._included != included) {
                this._included = included;
                if (!included) {
                    MarkList.this.checkIncludedMarks();
                } else {
                    MarkList.this._includedMarks = true;
                }
                MarkList.this._view.setVisibleElementOrdinalsInvalid();
                MarkList.this._view.setMaxElementWidthInvalid();
                MarkList.this._view.setMaxPrefixAreaWidthInvalid();
                MarkList.this._view.expandAll(false);
            }
        }

        boolean included() {
            return this._included;
        }

        void setExcluded(boolean excluded) {
            if (this._excluded != excluded) {
                this._excluded = excluded;
                MarkList.this._view.setVisibleElementOrdinalsInvalid();
                MarkList.this._view.setMaxElementWidthInvalid();
                MarkList.this._view.setMaxPrefixAreaWidthInvalid();
                MarkList.this._view.expandAll(false);
            }
        }

        boolean excluded() {
            return this._excluded;
        }

        void setHighlight(boolean highlight) {
            if (this._highlight != highlight) {
                this._highlight = highlight;
                this.resetDisplayStyle();
            }
        }

        boolean highlight() {
            return this._highlight;
        }

        void setStyleCharacter(char styleCharacter) {
            if (this._styleCharacter != styleCharacter) {
                this._styleCharacter = styleCharacter;
                if (this._highlight) {
                    this.resetDisplayStyle();
                }
            }
        }

        char styleCharacter() {
            return this._styleCharacter;
        }

        void setExcludedHeader(boolean excludedHeader) {
            if (excludedHeader != this._excludedHeader) {
                this._excludedHeader = excludedHeader;
            }
        }

        boolean excludedHeader() {
            return this._excludedHeader;
        }

        void setProtect(boolean protect) {
            this._protect = protect;
        }

        boolean protect() {
            return this._protect;
        }

        Element excludedHeaderElement() {
            return this._excludedHeaderElement;
        }

        LpexDocumentLocation documentLocation() {
            return new LpexDocumentLocation(MarkList.this._view.document().elementList().ordinalOf(this.element1()), this.position1());
        }

        abstract void elementRemoved(Element var1);

        abstract void elementInserted(Element var1);

        abstract void textDeleted(Element var1, int var2, int var3);

        abstract void textReplaced(Element var1, int var2, int var3);

        abstract void textInserted(Element var1, int var2, int var3);

        abstract void joinElements(Element var1, Element var2);

        abstract void splitElement(Element var1, int var2);

        abstract void updateStyle(Element var1, StringBuilder var2, StringBuilder var3);

        abstract String query();

        abstract StyleAttributes defaultStyleAttributes();

        void markChanged() {
            this.beginScanning();
            MarkListenerNode node = (MarkListenerNode)this.first();
            while (node != null) {
                node.listener().markChanged(MarkList.this._view.lpexView(), this._id);
                node = (MarkListenerNode)node.next();
            }
            this.endScanning();
        }

        void markDeleted() {
            this.beginScanning();
            MarkListenerNode node = (MarkListenerNode)this.first();
            while (node != null) {
                node.listener().markDeleted(MarkList.this._view.lpexView(), this._id);
                node = (MarkListenerNode)node.next();
            }
            this.endScanning();
        }

        protected void deleted() {
            this.clear();
            MarkList.this.deletedMarks().addBefore(null, new MarkNode(this));
        }

        protected void dirtied() {
            if (!this._dirty) {
                this._dirty = true;
                MarkList.this.changedMarks().addBefore(null, new MarkNode(this));
            }
        }

        @Override
        void clear() {
            if (!this._cleared) {
                Element element = this._element1;
                while (element != null && element != this._element2.next()) {
                    this.clearElement(element);
                    element = element.next();
                }
                this._element1 = null;
                this._element2 = null;
                this._cleared = true;
                if (this._excludedHeaderElement != null && this._excludedHeaderElement._partOfList) {
                    MarkList.this._view.deleteElement(this._excludedHeaderElement);
                }
                this._excludedHeaderElement = null;
                this._excludedLineCount = 0;
                MarkNode markNode = (MarkNode)MarkList.this.first();
                while (markNode != null) {
                    if (markNode.mark() == this) {
                        MarkList.this.remove(markNode);
                    }
                    markNode = (MarkNode)markNode.next();
                }
                if (this._included) {
                    MarkList.this.checkIncludedMarks();
                }
                if (this._highlight) {
                    this.resetDisplayStyle();
                }
            }
        }

        void clearElement(Element element) {
            ElementView elementView = element.elementView(MarkList.this._view);
            ElementView.MarkNode prevNode = null;
            ElementView.MarkNode markNode = elementView._firstMarkNode;
            while (markNode != null) {
                if (markNode.mark() == this) {
                    if (prevNode == null) {
                        elementView._firstMarkNode = markNode._next;
                    } else {
                        prevNode._next = markNode._next;
                    }
                } else {
                    prevNode = markNode;
                }
                markNode = markNode._next;
            }
            if (this._highlight) {
                elementView.resetDisplayStyle();
            }
        }

        final void addElement(Element element) {
            ElementView elementView = element.elementView(MarkList.this._view);
            ElementView.MarkNode markNode = elementView._firstMarkNode;
            while (markNode != null) {
                if (markNode.mark() == this) {
                    return;
                }
                markNode = markNode._next;
            }
            markNode = new ElementView.MarkNode(this);
            markNode._next = elementView._firstMarkNode;
            elementView._firstMarkNode = markNode;
            if (this._highlight) {
                elementView.resetDisplayStyle();
            }
            if (this._included || this._excluded) {
                MarkList.this._view.setVisibleElementOrdinalsInvalid();
            }
        }

        void resetDisplayStyle() {
            Element element = this._element1;
            while (element != null && element != this._element2.next()) {
                element.elementView(MarkList.this._view).resetDisplayStyle();
                element = element.next();
            }
        }

        void addListener(LpexMarkListener listener) {
            this.addAfter(null, new MarkListenerNode(listener));
        }

        void removeListener(LpexMarkListener listener) {
            MarkListenerNode node = this.find(listener);
            if (node != null) {
                super.remove(node);
            }
        }

        MarkListenerNode find(LpexMarkListener listener) {
            MarkListenerNode node = (MarkListenerNode)this.first();
            while (node != null) {
                if (node.listener() == listener) {
                    return node;
                }
                node = (MarkListenerNode)node.next();
            }
            return null;
        }

        void updateExcludedHeader() {
            if (this._excluded && this._excludedHeader && this._element1 != null) {
                if (this._excludedHeaderElement != null && this._excludedHeaderElement._partOfList) {
                    ElementList elementList;
                    Element nextVisible = this._excludedHeaderElement.next();
                    while (nextVisible != null && (!nextVisible.elementView(MarkList.this._view).expandHideVisible() || nextVisible.show())) {
                        nextVisible = nextVisible.next();
                    }
                    if (nextVisible != null && (elementList = MarkList.this._view.document().elementList()).ordinalOf(nextVisible) < elementList.ordinalOf(this._element1)) {
                        MarkList.this._view.deleteElement(this._excludedHeaderElement);
                    }
                }
                if (this._excludedHeaderElement == null) {
                    this._excludedHeaderElement = new Element(MarkList.this._view);
                }
                if (!this._excludedHeaderElement._partOfList) {
                    MarkList.this._view.document().elementList().addBefore(MarkList.this._view, this._element1, this._excludedHeaderElement);
                }
                int startLine = MarkList.this._view.document().elementList().nonShowOrdinalOf(this._element1);
                int endLine = MarkList.this._view.document().elementList().nonShowOrdinalOf(this._element2);
                int lines = endLine - startLine + 1;
                if (this._excludedLineCount != lines) {
                    this._excludedLineCount = lines;
                    if (lines == 1) {
                        this._excludedHeaderElement.setText(MarkList.this._view, LpexResources.message("mark.1LineExcluded"));
                    } else {
                        this._excludedHeaderElement.setText(MarkList.this._view, LpexResources.message("mark.nLinesExcluded", lines));
                    }
                }
            } else if (this._excludedHeaderElement != null) {
                MarkList.this._view.deleteElement(this._excludedHeaderElement);
                this._excludedHeaderElement = null;
                this._excludedLineCount = 0;
            }
        }
    }

    static final class MarkNode
    extends ListNode {
        Mark _mark;

        MarkNode(Mark mark) {
            this._mark = mark;
        }

        Mark mark() {
            return this._mark;
        }
    }
}

