/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.BidiCommentElement;
import com.ibm.lpex.core.CommandLine;
import com.ibm.lpex.core.CompareLine;
import com.ibm.lpex.core.FormatLine;
import com.ibm.lpex.core.LpexUtilities;
import com.ibm.lpex.core.LpexView;
import com.ibm.lpex.core.LpexWindowLayout;
import com.ibm.lpex.core.MessageLine;
import com.ibm.lpex.core.Separator;
import com.ibm.lpex.core.StatusLine;
import com.ibm.lpex.core.StatusLineManager;
import com.ibm.lpex.core.TextWindow;
import com.ibm.lpex.core.TitleLine;
import com.ibm.lpex.core.VisualElement;
import java.util.UUID;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Widget;

public class LpexWindow
extends Composite {
    private LpexView _lpexView;
    private TitleLine _titleLine;
    private StatusLine _statusLine;
    private Separator _separator0;
    private FormatLine _formatLine;
    private Separator _separator1;
    private TextWindow _textWindow;
    private Separator _separator2;
    private MessageLine _messageLine;
    private CommandLine _commandLine;
    private CompareLine _compareLine;
    private UUID _lpexWindowId = UUID.randomUUID();
    private StatusLineManager _statusLineManager;
    private VisualElement _visualElement;
    private BidiCommentElement _bidiCommentElement;
    private Widget _lastFocusWidget;
    private boolean _forceNoScrollBars;
    private boolean _commandLineOnTop;
    private boolean _forceScrollBars = false;
    private Event _focusEvent = new Event();

    public LpexWindow(Composite parent) {
        this(parent, 0);
    }

    public LpexWindow(Composite parent, int swtStyles) {
        super(parent, swtStyles | 0x40000);
        this._statusLineManager = new StatusLineManager();
        this._titleLine = new TitleLine(this, 0x4000 | swtStyles & 0x40);
        this._titleLine.setVisible(false);
        this._textWindow = new TextWindow(this);
        this._statusLine = new StatusLine(this);
        this._statusLine.setVisible(false);
        this._separator0 = new Separator(this);
        this._formatLine = new FormatLine(this);
        this._formatLine.setVisible(false);
        this._separator1 = new Separator(this);
        this._textWindow.getVerticalBar().setVisible(false);
        this._textWindow.getHorizontalBar().setVisible(false);
        this._separator2 = new Separator(this);
        this._messageLine = new MessageLine(this);
        this._messageLine.setVisible(false);
        this._commandLine = new CommandLine(this);
        this._commandLine.setVisible(false);
        MouseListener mouseListener = new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                LpexWindow.this.handleMouseDoubleClick(e);
            }

            public void mouseDown(MouseEvent e) {
                LpexWindow.this.setFocus();
            }

            public void mouseUp(MouseEvent e) {
            }
        };
        this._formatLine.addMouseListener(mouseListener);
        this._messageLine.messageLineText().addMouseListener(mouseListener);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                LpexWindow.this.handleDispose();
            }
        });
        this.addListener(27, new Listener(){

            public void handleEvent(Event event) {
                LpexWindow.this._textWindow.view().screen().setKeepCursorVisible(false);
            }
        });
        this.addListener(26, new Listener(){

            public void handleEvent(Event event) {
                LpexWindow.this._textWindow.view().screen().setKeepCursorVisible(true);
            }
        });
        this.setLayout(this.createLayoutManager());
    }

    public long generateId() {
        try {
            Thread.sleep(25L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        long id = System.currentTimeMillis();
        try {
            Thread.sleep(25L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return id;
    }

    private void handleMouseDoubleClick(MouseEvent e) {
        this.setFocus();
        if (e.button == 1 && e.widget == this._messageLine.messageLineText() && (e.stateMask & 0x40000) != 0) {
            this._commandLine.doEnter();
        }
    }

    public Composite titleLine() {
        return this._titleLine;
    }

    public Composite statusLine() {
        return this._statusLine;
    }

    StatusLineManager statusLineManager() {
        return this._statusLineManager;
    }

    public Composite separator0() {
        return this._separator0;
    }

    public Composite formatLine() {
        return this._formatLine;
    }

    public Composite separator1() {
        return this._separator1;
    }

    public Composite textWindow() {
        return this._textWindow;
    }

    public ScrollBar horizontalScrollBar() {
        return this._textWindow.getHorizontalBar();
    }

    public ScrollBar verticalScrollBar() {
        return this._textWindow.getVerticalBar();
    }

    public Composite separator2() {
        return this._separator2;
    }

    public UUID getLpexWindowId() {
        return this._lpexWindowId;
    }

    public Composite messageLine() {
        return this._messageLine;
    }

    public Composite commandLine() {
        return this._commandLine;
    }

    public Composite compareLine() {
        return this._compareLine;
    }

    CompareLine getCompareLine() {
        if (this._compareLine == null) {
            this._compareLine = new CompareLine(this);
        }
        return this._compareLine;
    }

    VisualElement getVisualElement() {
        if (this._visualElement == null) {
            this._visualElement = new VisualElement(this);
        }
        return this._visualElement;
    }

    BidiCommentElement getBidiCommentElement() {
        if (this._bidiCommentElement == null) {
            this._bidiCommentElement = new BidiCommentElement(this);
        }
        return this._bidiCommentElement;
    }

    void commandLineRequestFocus() {
        this._commandLine.requestFocus();
    }

    void textWindowRequestFocus() {
        this.resetBlockType();
        this.setControlFocus((Control)this._textWindow);
    }

    void resetBlockType() {
        this._commandLine.resetBlockType(this.getLpexView());
    }

    public void setForceNoScrollBars(boolean forceNoScrollBars) {
        this._forceNoScrollBars = forceNoScrollBars;
    }

    public void setForceScrollBars(boolean forceScrollBars) {
        if (!this._forceNoScrollBars) {
            this._forceScrollBars = forceScrollBars;
        }
    }

    public boolean getForceNoScrollBars() {
        return this._forceNoScrollBars;
    }

    public boolean getForceScrollBars() {
        return this._forceScrollBars;
    }

    protected Layout createLayoutManager() {
        return new LpexWindowLayout();
    }

    void updateLayout() {
        this.layout();
        this.getParent().getParent().layout(true);
    }

    public LpexView getLpexView() {
        return this._lpexView;
    }

    void setLpexView(LpexView lpexView) {
        this._lpexView = lpexView;
        ((TextWindow)this.textWindow()).lpexViewChanged();
    }

    void setFocusWidget(Widget widget) {
        if (widget != null) {
            this._lastFocusWidget = widget;
        }
        this._focusEvent.widget = this;
        this.notifyListeners(widget != null ? 15 : 16, this._focusEvent);
    }

    public boolean setFocus() {
        if (this._commandLine.inputFocusWidget() != null) {
            return true;
        }
        if (LpexUtilities.okToUse(this._lastFocusWidget)) {
            return this.setControlFocus((Control)this._lastFocusWidget);
        }
        if (this.setControlFocus((Control)this._textWindow)) {
            return true;
        }
        return true;
    }

    private boolean setControlFocus(Control control) {
        boolean[] rc = new boolean[1];
        if (LpexUtilities.okToUse((Widget)control)) {
            Display display = Display.getCurrent();
            if (display != null && !display.isDisposed()) {
                rc[0] = control.setFocus();
            } else {
                display = this.getDisplay();
                if (display != null && !display.isDisposed()) {
                    display.syncExec((Runnable)new SetFocus(control, rc));
                }
            }
        }
        return rc[0];
    }

    private void handleDispose() {
        this._statusLineManager.clear();
    }

    void dissociate() {
        if (!this.isDisposed()) {
            if (!this.commandLine().isDisposed()) {
                ((CommandLine)this.commandLine()).setInput(null, null, null, null);
                this.commandLine().setVisible(false);
            }
            if (!this.statusLine().isDisposed()) {
                this.statusLine().setVisible(false);
            }
            if (!this.formatLine().isDisposed()) {
                this.formatLine().setVisible(false);
            }
            if (!this.messageLine().isDisposed()) {
                this.messageLine().setVisible(false);
            }
            if (this.compareLine() != null && !this.compareLine().isDisposed()) {
                this.compareLine().setVisible(false);
            }
            if (!this.textWindow().isDisposed()) {
                this.textWindow().redraw();
            }
        }
    }

    protected void setCommandLineOnTop(boolean _commandLineOnTop) {
        this._commandLineOnTop = _commandLineOnTop;
    }

    protected boolean isCommandLineOnTop() {
        return this._commandLineOnTop;
    }

    public void setModel(IAnnotationModel annotationModel) {
        this._textWindow.setModel(annotationModel);
    }

    static class SetFocus
    implements Runnable {
        Control _control;
        boolean[] _rc;

        SetFocus(Control control, boolean[] rc) {
            this._control = control;
            this._rc = rc;
        }

        @Override
        public void run() {
            this._rc[0] = LpexUtilities.okToUse((Widget)this._control) ? this._control.setFocus() : this._rc[0];
        }
    }
}

