/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.Color;
import com.ibm.lpex.core.CommandHandler;
import com.ibm.lpex.core.Element;
import com.ibm.lpex.core.ElementList;
import com.ibm.lpex.core.Font;
import com.ibm.lpex.core.LpexResources;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.PrintCommand;
import com.ibm.lpex.core.PrintLine;
import com.ibm.lpex.core.Screen;
import com.ibm.lpex.core.StyleAttributes;
import com.ibm.lpex.core.StyleAttributesList;
import com.ibm.lpex.core.View;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;

final class LpexPrinter {
    View view;
    GC g;
    Printer printer;
    Font _font;
    int textHeight;
    org.eclipse.swt.graphics.Color _white;
    org.eclipse.swt.graphics.Color _black;
    Hashtable<Color, org.eclipse.swt.graphics.Color> _colors;
    int _pageNumber;
    String _printDate;
    String _printTime;
    String _docName;
    String _docBaseName;

    LpexPrinter(View view) {
        this.view = view;
    }

    boolean print(String parameters) {
        PrinterData printerData;
        boolean block = false;
        boolean pageRange = false;
        int startElement = 1;
        int endElement = this.view == null ? 1 : this.view.document().elementList().count();
        boolean visible = false;
        boolean compare = false;
        int bottomMargin = PrintCommand.BottomMarginParameter.getParameter().currentValue(this.view);
        Font font = PrintCommand.FontParameter.getParameter().currentValue(this.view);
        int leftMargin = PrintCommand.LeftMarginParameter.getParameter().currentValue(this.view);
        boolean lineNumbers = PrintCommand.LineNumbersParameter.getParameter().currentValue(this.view);
        int rightMargin = PrintCommand.RightMarginParameter.getParameter().currentValue(this.view);
        boolean sequenceNumbers = PrintCommand.SequenceNumbersParameter.getParameter().currentValue(this.view);
        boolean tokenized = PrintCommand.TokenizedParameter.getParameter().currentValue(this.view);
        int topMargin = PrintCommand.TopMarginParameter.getParameter().currentValue(this.view);
        LpexStringTokenizer st = new LpexStringTokenizer(parameters);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equalsIgnoreCase("block") || token.equalsIgnoreCase("selection")) {
                block = true;
                continue;
            }
            if (token.equalsIgnoreCase("bottomMargin")) {
                if (st.hasMoreTokens()) {
                    token = st.nextToken();
                    try {
                        bottomMargin = Integer.parseInt(token);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        return CommandHandler.invalidParameter(this.view, token, "print");
                    }
                }
                return CommandHandler.integerMissing(this.view, "bottomMargin", "print");
            }
            if (token.equalsIgnoreCase("endElement")) {
                if (st.hasMoreTokens()) {
                    token = st.nextToken();
                    try {
                        endElement = Integer.parseInt(token);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        return CommandHandler.invalidParameter(this.view, token, "print");
                    }
                }
                return CommandHandler.integerMissing(this.view, "endElement", "print");
            }
            if (token.equalsIgnoreCase("font")) {
                if (st.hasMoreTokens()) {
                    token = st.nextToken();
                    if (token.equalsIgnoreCase("screen")) {
                        if (this.view == null) continue;
                        font = this.view.screen().currentFont();
                        continue;
                    }
                    font = Font.decodeFont(token);
                    continue;
                }
                if (this.view != null) {
                    this.view.setLpexMessageText("printCommand.fontMissing");
                }
                return false;
            }
            if (token.equalsIgnoreCase("leftMargin")) {
                if (st.hasMoreTokens()) {
                    token = st.nextToken();
                    try {
                        leftMargin = Integer.parseInt(token);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        return CommandHandler.invalidParameter(this.view, token, "print");
                    }
                }
                return CommandHandler.integerMissing(this.view, "leftMargin", "print");
            }
            if (token.equalsIgnoreCase("lineNumbers")) {
                if (st.hasMoreTokens()) {
                    token = st.nextToken();
                    if (token.equalsIgnoreCase("on")) {
                        lineNumbers = true;
                        continue;
                    }
                    if (token.equalsIgnoreCase("off")) {
                        lineNumbers = false;
                        continue;
                    }
                    return CommandHandler.invalidParameter(this.view, token, "print");
                }
                return CommandHandler.incomplete(this.view, "print");
            }
            if (token.equalsIgnoreCase("rightMargin")) {
                if (st.hasMoreTokens()) {
                    token = st.nextToken();
                    try {
                        rightMargin = Integer.parseInt(token);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        return CommandHandler.invalidParameter(this.view, token, "print");
                    }
                }
                return CommandHandler.integerMissing(this.view, "rightMargin", "print");
            }
            if (token.equalsIgnoreCase("sequenceNumbers")) {
                if (st.hasMoreTokens()) {
                    token = st.nextToken();
                    if (token.equalsIgnoreCase("on")) {
                        sequenceNumbers = true;
                        continue;
                    }
                    if (token.equalsIgnoreCase("off")) {
                        sequenceNumbers = false;
                        continue;
                    }
                    return CommandHandler.invalidParameter(this.view, token, "print");
                }
                return CommandHandler.incomplete(this.view, "print");
            }
            if (token.equalsIgnoreCase("startElement")) {
                if (st.hasMoreTokens()) {
                    token = st.nextToken();
                    try {
                        startElement = Integer.parseInt(token);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        return CommandHandler.invalidParameter(this.view, token, "print");
                    }
                }
                return CommandHandler.integerMissing(this.view, "startElement", "print");
            }
            if (token.equalsIgnoreCase("tokenized")) {
                if (st.hasMoreTokens()) {
                    token = st.nextToken();
                    if (token.equalsIgnoreCase("on")) {
                        tokenized = true;
                        continue;
                    }
                    if (token.equalsIgnoreCase("off")) {
                        tokenized = false;
                        continue;
                    }
                    return CommandHandler.invalidParameter(this.view, token, "print");
                }
                return CommandHandler.incomplete(this.view, "print");
            }
            if (token.equalsIgnoreCase("topMargin")) {
                if (st.hasMoreTokens()) {
                    token = st.nextToken();
                    try {
                        topMargin = Integer.parseInt(token);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        return CommandHandler.invalidParameter(this.view, token, "print");
                    }
                }
                return CommandHandler.integerMissing(this.view, "topMargin", "print");
            }
            if (token.equalsIgnoreCase("visible")) {
                visible = true;
                continue;
            }
            if (token.equalsIgnoreCase("compare")) {
                compare = true;
                continue;
            }
            return CommandHandler.invalidParameter(this.view, token, "print");
        }
        if (this.view == null || this.view.window() == null) {
            return true;
        }
        if (sequenceNumbers && this.view.document().elementList().sequenceNumbersWidth() == 0) {
            sequenceNumbers = false;
        }
        PrintDialog printDialog = new PrintDialog(this.view.window().getShell(), 32768);
        if (block) {
            printDialog.setScope(2);
        }
        if ((printerData = printDialog.open()) == null) {
            return true;
        }
        block = (printerData.scope & 2) != 0;
        pageRange = printerData.scope == 1;
        String jobName = this.view.document().sourceName();
        if (jobName == null) {
            jobName = this.view.document().name();
            jobName = jobName != null ? LpexStringTokenizer.addQuotes(jobName) : LpexResources.message("untitledDocument", this.view.document().id());
        }
        this.printer = new Printer(printerData);
        if (!this.printer.startJob(jobName)) {
            this.printer.dispose();
            return true;
        }
        Rectangle clientArea = this.printer.getClientArea();
        int pageHeight = clientArea.height;
        int pageWidth = clientArea.width;
        int y = 0;
        this._font = new Font((Device)this.printer, font.getName(), font.getStyle(), font.getSize());
        this.g = new GC((Drawable)this.printer);
        this.g.setFont(this._font.getFont());
        this.textHeight = this.g.getFontMetrics().getHeight();
        int linesPerPage = Math.max(1, (pageHeight - topMargin - bottomMargin) / this.textHeight);
        if (linesPerPage < 1) {
            this.cleanUp();
            return true;
        }
        this._colors = new Hashtable();
        String footer = PrintCommand.FooterParameter.getParameter().currentValue(this.view);
        String header = PrintCommand.HeaderParameter.getParameter().currentValue(this.view);
        if (linesPerPage < 6) {
            footer = null;
            header = null;
        }
        this._white = this.printer.getSystemColor(1);
        this._black = this.printer.getSystemColor(2);
        ElementList elementList = this.view.document().elementList();
        if (block) {
            if (this.view.block().view() == this.view) {
                int bottomElementNumber;
                Element bottomElement;
                int topElementNumber;
                Element topElement = this.view.block().topElement();
                if (topElement != null && (topElementNumber = elementList.ordinalOf(topElement)) > startElement) {
                    startElement = topElementNumber;
                }
                if ((bottomElement = this.view.block().bottomElement()) != null && (bottomElementNumber = elementList.ordinalOf(bottomElement)) < endElement) {
                    endElement = bottomElementNumber;
                }
            }
        } else if (pageRange) {
            int startPage = printerData.startPage;
            int endPage = printerData.endPage;
            int pageSize = linesPerPage - (header != null ? 2 : 0) - (footer != null ? 2 : 0);
            startElement = (startPage - 1) * pageSize + 1;
            endElement = Math.min(this.view.document().elementList().count(), endPage * pageSize);
        }
        boolean startedPage = false;
        if (startElement <= endElement) {
            int w;
            Element stopElement = elementList.elementAt(endElement);
            if (stopElement != null) {
                stopElement = stopElement.next();
            }
            Screen screen = this.view.screen();
            StyleAttributes defaultStyle = screen.styleAttributes(4);
            StyleAttributes lineNumberStyle = screen.styleAttributes(12);
            StyleAttributesList styleAttributesList = this.view.styleAttributesList();
            int lineNumberWidth = 0;
            if (lineNumbers) {
                Element e = elementList.elementAt(startElement);
                while (e != stopElement) {
                    if ((!visible && (compare || !e.show()) || visible && e.visible(this.view)) && (w = this.stringWidth(this.view.lineNumbersText(e))) > lineNumberWidth) {
                        lineNumberWidth = w;
                    }
                    e = e.next();
                }
            }
            int sequenceNumberWidth = 0;
            if (sequenceNumbers) {
                Element e = elementList.elementAt(startElement);
                while (e != stopElement) {
                    if (!visible && (compare || !e.show()) || visible && e.visible(this.view)) {
                        sequenceNumberWidth = this.stringWidth(this.view.document().elementList().getSequenceNumbersDisplayString(e, this.view));
                        break;
                    }
                    e = e.next();
                }
            }
            int lineNumberPadWidth = this.stringWidth(" ");
            String text = null;
            String style = null;
            String comparePrefix = null;
            PrintLine printLine = new PrintLine(this.view, elementList.elementAt(startElement), stopElement, visible, compare);
            while (printLine.next()) {
                do {
                    int x = leftMargin;
                    if (!startedPage) {
                        ++this._pageNumber;
                        this.printer.startPage();
                        startedPage = true;
                        y = topMargin;
                        y += this.printHeader(header, x, y, pageWidth - leftMargin - rightMargin);
                    }
                    if (lineNumbers) {
                        String lineNumbersText;
                        if (text == null && (lineNumbersText = printLine.lineNumbersText()) != null) {
                            if (!tokenized) {
                                this.drawString(lineNumbersText, x, y);
                            } else {
                                this.drawTokenizedString(lineNumberStyle, x, lineNumberWidth, y, this.textHeight, lineNumbersText);
                            }
                        }
                        x += lineNumberWidth;
                        x += lineNumberPadWidth;
                    }
                    if (sequenceNumbers) {
                        String sequenceNumbersText;
                        if (text == null && (sequenceNumbersText = printLine.sequenceNumbersText()) != null) {
                            int seqw = this.stringWidth(sequenceNumbersText);
                            if (sequenceNumberWidth < seqw) {
                                sequenceNumberWidth = seqw;
                            }
                            if (!tokenized) {
                                this.drawString(sequenceNumbersText, x, y);
                            } else {
                                this.drawTokenizedString(lineNumberStyle, x, sequenceNumberWidth, y, this.textHeight, sequenceNumbersText);
                            }
                        }
                        x += sequenceNumberWidth;
                        x += lineNumberPadWidth;
                    }
                    if (compare) {
                        String string = comparePrefix = text == null ? printLine.comparePrefix() : "  ";
                    }
                    if (text == null) {
                        text = printLine.text();
                        if (tokenized) {
                            style = printLine.style();
                        }
                    }
                    if (text != null) {
                        if (comparePrefix != null) {
                            this.setBlackOnWhite();
                            this.drawString(comparePrefix, x, y);
                            x += this.stringWidth(comparePrefix);
                        }
                        int l = text.length();
                        while (l > 0) {
                            w = this.stringWidth(text.substring(0, l));
                            if (x + w <= pageWidth - rightMargin) break;
                            --l;
                        }
                        String remainingText = null;
                        String remainingStyle = "";
                        if (l > 0 && l < text.length()) {
                            remainingText = text.substring(l);
                            text = text.substring(0, l);
                            if (tokenized && style != null && l < style.length()) {
                                remainingStyle = style.substring(l);
                                style = style.substring(0, l);
                            }
                        }
                        if (!tokenized) {
                            this.drawString(text, x, y);
                        } else if (style == null) {
                            this.setBlackOnWhite();
                            this.drawString(text, x, y);
                        } else {
                            int textLength = text.length();
                            int length = style.length() > text.length() ? style.length() : text.length();
                            int i = 0;
                            while (i < length) {
                                String subText;
                                StyleAttributes styleAttributes = null;
                                if (style.length() > i) {
                                    styleAttributes = styleAttributesList.find(style.charAt(i));
                                }
                                if (styleAttributes == null) {
                                    styleAttributes = defaultStyle;
                                }
                                int subTextLength = 1;
                                while (i + subTextLength < length) {
                                    StyleAttributes styleAttributesNext = null;
                                    if (style.length() > i + subTextLength) {
                                        styleAttributesNext = styleAttributesList.find(style.charAt(i + subTextLength));
                                    }
                                    if (styleAttributesNext == null) {
                                        styleAttributesNext = defaultStyle;
                                    }
                                    if (!styleAttributes.equals(styleAttributesNext)) break;
                                    ++subTextLength;
                                }
                                if (i + subTextLength <= textLength) {
                                    subText = text.substring(i, i + subTextLength);
                                } else {
                                    subText = i < textLength ? text.substring(i) : "";
                                    StringBuilder buffer = new StringBuilder(subText);
                                    int originalLength = buffer.length();
                                    buffer.setLength(length);
                                    int j = originalLength;
                                    while (j < length) {
                                        buffer.setCharAt(j, ' ');
                                        ++j;
                                    }
                                    subText = buffer.toString();
                                }
                                w = this.stringWidth(subText);
                                this.drawTokenizedString(styleAttributes, x, w, y, this.textHeight, subText);
                                i += subTextLength;
                                x += w;
                            }
                        }
                        text = remainingText;
                        style = remainingStyle;
                    }
                    int bot = (y += this.textHeight) + this.textHeight;
                    if (footer != null) {
                        bot += this.textHeight * 2;
                    }
                    if (bot <= pageHeight - bottomMargin && (bot != pageHeight - bottomMargin || footer == null)) continue;
                    if (footer != null) {
                        this.setBlackOnWhite();
                        this.drawString(this.getHeaderFooter(footer), leftMargin, y + this.textHeight);
                    }
                    this.printer.endPage();
                    startedPage = false;
                } while (text != null);
            }
        }
        if (startedPage && footer != null) {
            this.setBlackOnWhite();
            this.drawString(this.getHeaderFooter(footer), leftMargin, topMargin + (linesPerPage - 1) * this.textHeight);
        }
        this.cleanUp();
        return true;
    }

    private void cleanUp() {
        this.g.dispose();
        this._font.dispose();
        if (this._colors != null) {
            Enumeration<org.eclipse.swt.graphics.Color> enumeration = this._colors.elements();
            while (enumeration.hasMoreElements()) {
                org.eclipse.swt.graphics.Color color = enumeration.nextElement();
                color.dispose();
            }
            this._colors = null;
        }
        this.printer.endJob();
        this.printer.dispose();
    }

    private int printHeader(String header, int x, int y, int maxWidth) {
        String remainingText;
        if (header == null) {
            return 0;
        }
        header = this.getHeaderFooter(header);
        this.setBlackOnWhite();
        int linesPrinted = 0;
        do {
            int l = header.length();
            while (l > 0) {
                int w = this.stringWidth(header.substring(0, l));
                if (w <= maxWidth) break;
                --l;
            }
            remainingText = null;
            if (l > 0 && l < header.length()) {
                remainingText = header.substring(l);
                header = header.substring(0, l);
            }
            this.drawString(header, x, y);
            y += this.textHeight;
        } while ((header = remainingText) != null && ++linesPrinted < 2);
        return this.textHeight * (linesPrinted + 1);
    }

    private void drawString(String text, int x, int y) {
        this.g.drawString(text, x, y);
    }

    private void drawTokenizedString(StyleAttributes styleAttributes, int rectX, int rectWidth, int rectY, int rectHeight, String text) {
        if (this.setBackground(styleAttributes)) {
            this.g.fillRectangle(rectX, rectY, rectWidth, rectHeight);
        }
        this.setForeground(styleAttributes);
        this.drawString(text, rectX, rectY);
        if (styleAttributes.underline()) {
            this.g.drawLine(rectX, rectY + rectHeight - 1, rectX + rectWidth, rectY + rectHeight - 1);
        }
        if (styleAttributes.strikeout()) {
            this.g.drawLine(rectX, rectY + rectHeight / 2 + 1, rectX + rectWidth, rectY + rectHeight / 2 + 1);
        }
    }

    private boolean setBackground(StyleAttributes styleAttributes) {
        Color background = styleAttributes.backgroundColor();
        this.g.setBackground(this.getPrinterColor(background));
        return !background.isWhite();
    }

    private void setForeground(StyleAttributes styleAttributes) {
        this.g.setForeground(this.getPrinterColor(styleAttributes.foregroundColor()));
    }

    private void setBlackOnWhite() {
        this.g.setForeground(this._black);
        this.g.setBackground(this._white);
    }

    private org.eclipse.swt.graphics.Color getPrinterColor(Color color) {
        org.eclipse.swt.graphics.Color printerColor = this._colors.get(color);
        if (printerColor == null) {
            printerColor = new Color((Device)this.printer, color).getColor();
            this._colors.put(color, printerColor);
        }
        return printerColor;
    }

    private int stringWidth(String s) {
        return this.g.stringExtent((String)s).x;
    }

    private String getHeaderFooter(String text) {
        if (text.indexOf(37) < 0) {
            return text;
        }
        StringBuilder sb = new StringBuilder(text.length() + 60);
        int i = 0;
        while (i < text.length()) {
            char c;
            if ((c = text.charAt(i++)) == '%' && i < text.length()) {
                c = text.charAt(i++);
                switch (c) {
                    case 'f': {
                        sb.append(this.getDocName());
                        break;
                    }
                    case 'n': {
                        sb.append(this.getBaseDocName());
                        break;
                    }
                    case 'p': {
                        sb.append(this._pageNumber);
                        break;
                    }
                    case 'd': {
                        sb.append(this.getPrintDate());
                        break;
                    }
                    case 't': {
                        sb.append(this.getPrintTime());
                        break;
                    }
                    default: {
                        sb.append('%');
                        sb.append(c);
                        break;
                    }
                }
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private String getDocName() {
        if (this._docName == null) {
            this._docName = this.view.document().name();
            if (this._docName == null) {
                this._docName = LpexResources.message("untitledDocument", this.view.document().id());
            }
        }
        return this._docName;
    }

    private String getBaseDocName() {
        if (this._docBaseName == null) {
            this._docBaseName = this.view.document().sourceName();
            if (this._docBaseName == null) {
                this._docBaseName = this.getDocName();
                int i = this._docBaseName.lastIndexOf(System.getProperty("file.separator"));
                if (i >= 0 && i < this._docBaseName.length() - 1) {
                    this._docBaseName = this._docBaseName.substring(i + 1);
                }
            }
        }
        return this._docBaseName;
    }

    private String getPrintDate() {
        if (this._printDate == null) {
            this._printDate = DateFormat.getDateInstance(2).format(new Date());
        }
        return this._printDate;
    }

    private String getPrintTime() {
        if (this._printTime == null) {
            this._printTime = DateFormat.getTimeInstance(2).format(new Date());
        }
        return this._printTime;
    }
}

