/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.View;

final class KillRing {
    private static final int MAX = 30;
    private static String[] _killStrings = new String[30];
    private static int _currentKill = -1;
    private static int _newestKill = -1;
    private static View _lastKillView;
    private static int _lastKillActionId;

    static {
        _lastKillActionId = 0;
    }

    private KillRing() {
    }

    static String currentKillString() {
        return _currentKill >= 0 ? _killStrings[_currentKill] : null;
    }

    static String previousKillString(int count) {
        if (_currentKill >= 0) {
            int previousKill = _currentKill;
            if (count > 0) {
                int i = 0;
                while (i < count) {
                    previousKill = _currentKill - 1;
                    if (previousKill < 0) {
                        previousKill = 29;
                        while (previousKill > 0 && _killStrings[previousKill] == null) {
                            --previousKill;
                        }
                    }
                    ++i;
                }
            } else {
                int i = count;
                while (i < 0) {
                    if (++previousKill >= 30 || _killStrings[previousKill] == null) {
                        previousKill = 0;
                    }
                    ++i;
                }
            }
            _currentKill = previousKill;
            return _killStrings[previousKill];
        }
        return null;
    }

    static void appendKillString(View view, String killString) {
        if (killString != null && killString.length() > 0) {
            if (KillRing.isNewKill(view)) {
                KillRing.saveNewKillString(view, killString);
            } else {
                int n = _newestKill;
                _killStrings[n] = String.valueOf(_killStrings[n]) + killString;
                _currentKill = _newestKill;
            }
        }
        _lastKillView = view;
        _lastKillActionId = view.actionHandler().userActionId();
    }

    static void prefaceKillString(View view, String killString) {
        if (killString != null && killString.length() > 0) {
            if (KillRing.isNewKill(view)) {
                KillRing.saveNewKillString(view, killString);
            } else {
                KillRing._killStrings[KillRing._newestKill] = killString + _killStrings[_newestKill];
                _currentKill = _newestKill;
            }
        }
        _lastKillView = view;
        _lastKillActionId = view.actionHandler().userActionId();
    }

    static void disposeView(View view) {
        if (view == _lastKillView) {
            _lastKillView = null;
            _lastKillActionId = 0;
        }
    }

    static boolean killStringAvailable() {
        return _currentKill != -1;
    }

    private static void saveNewKillString(View view, String killString) {
        if (killString != null && killString.length() > 0) {
            if (++_newestKill >= 30) {
                _newestKill = 0;
            }
            KillRing._killStrings[KillRing._newestKill] = killString;
            _currentKill = _newestKill;
        }
    }

    private static boolean isNewKill(View view) {
        return _newestKill == -1 || _lastKillActionId == 0 || _lastKillView != view || _lastKillActionId != view.actionHandler().lastUserActionId();
    }
}

