/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.CommandHandler;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.Parameter;
import com.ibm.lpex.core.View;

final class IncludedClassesParameter
extends Parameter {
    private static IncludedClassesParameter _parameter;

    static IncludedClassesParameter getParameter() {
        if (_parameter == null) {
            _parameter = new IncludedClassesParameter();
        }
        return _parameter;
    }

    private IncludedClassesParameter() {
        super("includedClasses");
    }

    @Override
    boolean set(View view, String qualifier, String parameters) {
        if (view != null) {
            long classes = 0L;
            LpexStringTokenizer st = new LpexStringTokenizer(parameters);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                long mask = view.classes().mask(token);
                if (mask == 0L) {
                    return CommandHandler.invalidParameter(view, token, "set " + this.name(qualifier));
                }
                classes |= mask;
            }
            if (classes == 0L) {
                classes = -1L;
            }
            view.setIncludedClasses(classes);
        }
        return true;
    }

    @Override
    String query(View view, LpexDocumentLocation documentLocation, String qualifier) {
        return view != null ? view.queryIncludedClassesString() : null;
    }
}

