/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.CommandHandler;
import com.ibm.lpex.core.HelpCommand;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.Parameter;
import com.ibm.lpex.core.Profile;
import com.ibm.lpex.core.View;

final class HelpTopicParameter
extends Parameter {
    private static HelpTopicParameter _parameter;

    static HelpTopicParameter getParameter() {
        if (_parameter == null) {
            _parameter = new HelpTopicParameter();
        }
        return _parameter;
    }

    private HelpTopicParameter() {
        super("helpTopic.");
    }

    @Override
    boolean set(View view, String qualifier, String parameter) {
        if (qualifier.length() == 0) {
            return CommandHandler.incomplete(view, "set " + this.name() + qualifier);
        }
        return this.setValue(view, qualifier, parameter.trim().length() != 0 ? parameter : null);
    }

    private boolean setValue(View view, String qualifier, String value) {
        Profile.putString("helpTopic." + qualifier, value);
        HelpCommand.updateHelpCommandHelpTopic(qualifier, value);
        return true;
    }

    @Override
    String query(View view, LpexDocumentLocation documentLocation, String qualifier) {
        String topic = Profile.getString("helpTopic." + qualifier);
        if (topic == null) {
            topic = HelpCommand.getLpexHelpTopic(qualifier);
        }
        return topic;
    }
}

